/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.serialization;

import com.intellij.openapi.util.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.ClassBuilderMode;
import org.jetbrains.kotlin.codegen.serialization.JvmSerializationBindings;
import org.jetbrains.kotlin.codegen.serialization.JvmStringTable;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.load.java.lazy.types.RawTypeImpl;
import org.jetbrains.kotlin.load.kotlin.JavaFlexibleTypeDeserializer;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.serialization.AnnotationSerializer;
import org.jetbrains.kotlin.serialization.ProtoBuf;
import org.jetbrains.kotlin.serialization.SerializerExtension;
import org.jetbrains.kotlin.serialization.StringTable;
import org.jetbrains.kotlin.serialization.jvm.ClassMapperLite;
import org.jetbrains.kotlin.serialization.jvm.JvmProtoBuf;
import org.jetbrains.kotlin.types.FlexibleType;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.Method;

public class JvmSerializerExtension
extends SerializerExtension {
    private final JvmSerializationBindings bindings;
    private final StringTable stringTable;
    private final AnnotationSerializer annotationSerializer;
    private final boolean useTypeTable;
    private final String moduleName;
    private final ClassBuilderMode classBuilderMode;

    public JvmSerializerExtension(@NotNull JvmSerializationBindings bindings, @NotNull GenerationState state) {
        if (bindings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindings", "org/jetbrains/kotlin/codegen/serialization/JvmSerializerExtension", "<init>"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "org/jetbrains/kotlin/codegen/serialization/JvmSerializerExtension", "<init>"));
        }
        this.bindings = bindings;
        this.stringTable = new JvmStringTable(state.getTypeMapper());
        this.annotationSerializer = new AnnotationSerializer(this.stringTable);
        this.useTypeTable = state.getUseTypeTableInSerializer();
        this.moduleName = state.getModuleName();
        this.classBuilderMode = state.getClassBuilderMode();
    }

    @Override
    @NotNull
    public StringTable getStringTable() {
        StringTable stringTable = this.stringTable;
        if (stringTable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/serialization/JvmSerializerExtension", "getStringTable"));
        }
        return stringTable;
    }

    @Override
    public boolean shouldUseTypeTable() {
        return this.useTypeTable;
    }

    @Override
    public void serializeClass(@NotNull ClassDescriptor descriptor2, @NotNull ProtoBuf.Class.Builder proto) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/serialization/JvmSerializerExtension", "serializeClass"));
        }
        if (proto == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "proto", "org/jetbrains/kotlin/codegen/serialization/JvmSerializerExtension", "serializeClass"));
        }
        if (!this.moduleName.equals("main")) {
            proto.setExtension(JvmProtoBuf.classModuleName, this.stringTable.getStringIndex(this.moduleName));
        }
    }

    @Override
    public void serializePackage(@NotNull ProtoBuf.Package.Builder proto) {
        if (proto == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "proto", "org/jetbrains/kotlin/codegen/serialization/JvmSerializerExtension", "serializePackage"));
        }
        if (!this.moduleName.equals("main")) {
            proto.setExtension(JvmProtoBuf.packageModuleName, this.stringTable.getStringIndex(this.moduleName));
        }
    }

    @Override
    public void serializeFlexibleType(@NotNull FlexibleType flexibleType, @NotNull ProtoBuf.Type.Builder lowerProto, @NotNull ProtoBuf.Type.Builder upperProto) {
        if (flexibleType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "flexibleType", "org/jetbrains/kotlin/codegen/serialization/JvmSerializerExtension", "serializeFlexibleType"));
        }
        if (lowerProto == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lowerProto", "org/jetbrains/kotlin/codegen/serialization/JvmSerializerExtension", "serializeFlexibleType"));
        }
        if (upperProto == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "upperProto", "org/jetbrains/kotlin/codegen/serialization/JvmSerializerExtension", "serializeFlexibleType"));
        }
        lowerProto.setFlexibleTypeCapabilitiesId(this.getStringTable().getStringIndex(JavaFlexibleTypeDeserializer.INSTANCE.getId()));
        if (flexibleType instanceof RawTypeImpl) {
            lowerProto.setExtension(JvmProtoBuf.isRaw, true);
            upperProto.setExtension(JvmProtoBuf.isRaw, true);
        }
    }

    @Override
    public void serializeType(@NotNull KotlinType type2, @NotNull ProtoBuf.Type.Builder proto) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/serialization/JvmSerializerExtension", "serializeType"));
        }
        if (proto == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "proto", "org/jetbrains/kotlin/codegen/serialization/JvmSerializerExtension", "serializeType"));
        }
        for (AnnotationDescriptor annotation2 : type2.getAnnotations()) {
            proto.addExtension(JvmProtoBuf.typeAnnotation, this.annotationSerializer.serializeAnnotation(annotation2));
        }
    }

    @Override
    public void serializeTypeParameter(@NotNull TypeParameterDescriptor typeParameter, @NotNull ProtoBuf.TypeParameter.Builder proto) {
        if (typeParameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameter", "org/jetbrains/kotlin/codegen/serialization/JvmSerializerExtension", "serializeTypeParameter"));
        }
        if (proto == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "proto", "org/jetbrains/kotlin/codegen/serialization/JvmSerializerExtension", "serializeTypeParameter"));
        }
        for (AnnotationDescriptor annotation2 : typeParameter.getAnnotations()) {
            proto.addExtension(JvmProtoBuf.typeParameterAnnotation, this.annotationSerializer.serializeAnnotation(annotation2));
        }
    }

    @Override
    public void serializeConstructor(@NotNull ConstructorDescriptor descriptor2, @NotNull ProtoBuf.Constructor.Builder proto) {
        JvmProtoBuf.JvmMethodSignature signature;
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/serialization/JvmSerializerExtension", "serializeConstructor"));
        }
        if (proto == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "proto", "org/jetbrains/kotlin/codegen/serialization/JvmSerializerExtension", "serializeConstructor"));
        }
        Method method = this.bindings.get(JvmSerializationBindings.METHOD_FOR_FUNCTION, descriptor2);
        if (method != null && (signature = new SignatureSerializer().methodSignature(descriptor2, method)) != null) {
            proto.setExtension(JvmProtoBuf.constructorSignature, signature);
        }
    }

    @Override
    public void serializeFunction(@NotNull FunctionDescriptor descriptor2, @NotNull ProtoBuf.Function.Builder proto) {
        JvmProtoBuf.JvmMethodSignature signature;
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/serialization/JvmSerializerExtension", "serializeFunction"));
        }
        if (proto == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "proto", "org/jetbrains/kotlin/codegen/serialization/JvmSerializerExtension", "serializeFunction"));
        }
        Method method = this.bindings.get(JvmSerializationBindings.METHOD_FOR_FUNCTION, descriptor2);
        if (method != null && (signature = new SignatureSerializer().methodSignature(descriptor2, method)) != null) {
            proto.setExtension(JvmProtoBuf.methodSignature, signature);
        }
    }

    @Override
    public void serializeProperty(@NotNull PropertyDescriptor descriptor2, @NotNull ProtoBuf.Property.Builder proto) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/serialization/JvmSerializerExtension", "serializeProperty"));
        }
        if (proto == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "proto", "org/jetbrains/kotlin/codegen/serialization/JvmSerializerExtension", "serializeProperty"));
        }
        SignatureSerializer signatureSerializer = new SignatureSerializer();
        PropertyGetterDescriptor getter = descriptor2.getGetter();
        PropertySetterDescriptor setter = descriptor2.getSetter();
        Method getterMethod = getter == null ? null : this.bindings.get(JvmSerializationBindings.METHOD_FOR_FUNCTION, getter);
        Method setterMethod = setter == null ? null : this.bindings.get(JvmSerializationBindings.METHOD_FOR_FUNCTION, setter);
        Pair<Type, String> field2 = this.bindings.get(JvmSerializationBindings.FIELD_FOR_PROPERTY, descriptor2);
        Method syntheticMethod = this.bindings.get(JvmSerializationBindings.SYNTHETIC_METHOD_FOR_PROPERTY, descriptor2);
        JvmProtoBuf.JvmPropertySignature signature = signatureSerializer.propertySignature(descriptor2, field2 != null ? (String)field2.second : null, field2 != null ? ((Type)field2.first).getDescriptor() : null, syntheticMethod != null ? signatureSerializer.methodSignature(null, syntheticMethod) : null, getterMethod != null ? signatureSerializer.methodSignature(null, getterMethod) : null, setterMethod != null ? signatureSerializer.methodSignature(null, setterMethod) : null);
        proto.setExtension(JvmProtoBuf.propertySignature, signature);
    }

    @Override
    public void serializeErrorType(@NotNull KotlinType type2, @NotNull ProtoBuf.Type.Builder builder) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/serialization/JvmSerializerExtension", "serializeErrorType"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "org/jetbrains/kotlin/codegen/serialization/JvmSerializerExtension", "serializeErrorType"));
        }
        if (this.classBuilderMode == ClassBuilderMode.KAPT || this.classBuilderMode == ClassBuilderMode.KAPT3) {
            builder.setClassName(this.stringTable.getStringIndex("error/NonExistentClass"));
            return;
        }
        super.serializeErrorType(type2, builder);
    }

    private class SignatureSerializer {
        private SignatureSerializer() {
        }

        @Nullable
        public JvmProtoBuf.JvmMethodSignature methodSignature(@Nullable FunctionDescriptor descriptor2, @NotNull Method method) {
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/kotlin/codegen/serialization/JvmSerializerExtension$SignatureSerializer", "methodSignature"));
            }
            JvmProtoBuf.JvmMethodSignature.Builder builder = JvmProtoBuf.JvmMethodSignature.newBuilder();
            if (descriptor2 == null || !descriptor2.getName().asString().equals(method.getName())) {
                builder.setName(JvmSerializerExtension.this.stringTable.getStringIndex(method.getName()));
            }
            if (descriptor2 == null || this.requiresSignature(descriptor2, method.getDescriptor())) {
                builder.setDesc(JvmSerializerExtension.this.stringTable.getStringIndex(method.getDescriptor()));
            }
            return builder.hasName() || builder.hasDesc() ? builder.build() : null;
        }

        private boolean requiresSignature(@NotNull FunctionDescriptor descriptor2, @NotNull String desc) {
            String returnTypeDesc;
            if (descriptor2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/serialization/JvmSerializerExtension$SignatureSerializer", "requiresSignature"));
            }
            if (desc == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "desc", "org/jetbrains/kotlin/codegen/serialization/JvmSerializerExtension$SignatureSerializer", "requiresSignature"));
            }
            StringBuilder sb = new StringBuilder();
            sb.append("(");
            ReceiverParameterDescriptor receiverParameter = descriptor2.getExtensionReceiverParameter();
            if (receiverParameter != null) {
                String receiverDesc = this.mapTypeDefault(receiverParameter.getValue().getType());
                if (receiverDesc == null) {
                    return true;
                }
                sb.append(receiverDesc);
            }
            for (ValueParameterDescriptor valueParameter : descriptor2.getValueParameters()) {
                String paramDesc = this.mapTypeDefault(valueParameter.getType());
                if (paramDesc == null) {
                    return true;
                }
                sb.append(paramDesc);
            }
            sb.append(")");
            KotlinType returnType2 = descriptor2.getReturnType();
            String string = returnTypeDesc = returnType2 == null ? "V" : this.mapTypeDefault(returnType2);
            if (returnTypeDesc == null) {
                return true;
            }
            sb.append(returnTypeDesc);
            return !sb.toString().equals(desc);
        }

        private boolean requiresSignature(@NotNull PropertyDescriptor descriptor2, @NotNull String desc) {
            if (descriptor2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/serialization/JvmSerializerExtension$SignatureSerializer", "requiresSignature"));
            }
            if (desc == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "desc", "org/jetbrains/kotlin/codegen/serialization/JvmSerializerExtension$SignatureSerializer", "requiresSignature"));
            }
            return !desc.equals(this.mapTypeDefault(descriptor2.getType()));
        }

        @Nullable
        private String mapTypeDefault(@NotNull KotlinType type2) {
            if (type2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/serialization/JvmSerializerExtension$SignatureSerializer", "mapTypeDefault"));
            }
            ClassifierDescriptor classifier = type2.getConstructor().getDeclarationDescriptor();
            if (!(classifier instanceof ClassDescriptor)) {
                return null;
            }
            ClassId classId = this.classId((ClassDescriptor)classifier);
            return classId == null ? null : ClassMapperLite.mapClass(classId);
        }

        @Nullable
        private ClassId classId(@NotNull ClassDescriptor descriptor2) {
            if (descriptor2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/serialization/JvmSerializerExtension$SignatureSerializer", "classId"));
            }
            DeclarationDescriptor container2 = descriptor2.getContainingDeclaration();
            if (container2 instanceof PackageFragmentDescriptor) {
                return ClassId.topLevel(((PackageFragmentDescriptor)container2).getFqName().child(descriptor2.getName()));
            }
            if (container2 instanceof ClassDescriptor) {
                ClassId outerClassId = this.classId((ClassDescriptor)container2);
                return outerClassId == null ? null : outerClassId.createNestedClassId(descriptor2.getName());
            }
            return null;
        }

        @NotNull
        public JvmProtoBuf.JvmPropertySignature propertySignature(@NotNull PropertyDescriptor descriptor2, @Nullable String fieldName, @Nullable String fieldDesc, @Nullable JvmProtoBuf.JvmMethodSignature syntheticMethod, @Nullable JvmProtoBuf.JvmMethodSignature getter, @Nullable JvmProtoBuf.JvmMethodSignature setter) {
            if (descriptor2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/serialization/JvmSerializerExtension$SignatureSerializer", "propertySignature"));
            }
            JvmProtoBuf.JvmPropertySignature.Builder signature = JvmProtoBuf.JvmPropertySignature.newBuilder();
            if (fieldDesc != null) {
                assert (fieldName != null) : "Field name shouldn't be null when there's a field type: " + fieldDesc;
                signature.setField(this.fieldSignature(descriptor2, fieldName, fieldDesc));
            }
            if (syntheticMethod != null) {
                signature.setSyntheticMethod(syntheticMethod);
            }
            if (getter != null) {
                signature.setGetter(getter);
            }
            if (setter != null) {
                signature.setSetter(setter);
            }
            JvmProtoBuf.JvmPropertySignature jvmPropertySignature = signature.build();
            if (jvmPropertySignature == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/serialization/JvmSerializerExtension$SignatureSerializer", "propertySignature"));
            }
            return jvmPropertySignature;
        }

        @NotNull
        public JvmProtoBuf.JvmFieldSignature fieldSignature(@NotNull PropertyDescriptor descriptor2, @NotNull String name2, @NotNull String desc) {
            if (descriptor2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/serialization/JvmSerializerExtension$SignatureSerializer", "fieldSignature"));
            }
            if (name2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/codegen/serialization/JvmSerializerExtension$SignatureSerializer", "fieldSignature"));
            }
            if (desc == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "desc", "org/jetbrains/kotlin/codegen/serialization/JvmSerializerExtension$SignatureSerializer", "fieldSignature"));
            }
            JvmProtoBuf.JvmFieldSignature.Builder builder = JvmProtoBuf.JvmFieldSignature.newBuilder();
            if (!descriptor2.getName().asString().equals(name2)) {
                builder.setName(JvmSerializerExtension.this.stringTable.getStringIndex(name2));
            }
            if (this.requiresSignature(descriptor2, desc)) {
                builder.setDesc(JvmSerializerExtension.this.stringTable.getStringIndex(desc));
            }
            JvmProtoBuf.JvmFieldSignature jvmFieldSignature = builder.build();
            if (jvmFieldSignature == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/serialization/JvmSerializerExtension$SignatureSerializer", "fieldSignature"));
            }
            return jvmFieldSignature;
        }
    }
}

