/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.state;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.BuiltInsPackageFragment;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.functions.FunctionClassDescriptor;
import org.jetbrains.kotlin.codegen.AccessorForCallableDescriptor;
import org.jetbrains.kotlin.codegen.AccessorForConstructorDescriptor;
import org.jetbrains.kotlin.codegen.AccessorForPropertyDescriptor;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.CallableMethod;
import org.jetbrains.kotlin.codegen.ClassBuilderMode;
import org.jetbrains.kotlin.codegen.CodegenUtilKt;
import org.jetbrains.kotlin.codegen.JvmCodegenUtil;
import org.jetbrains.kotlin.codegen.OwnerKind;
import org.jetbrains.kotlin.codegen.SamCodegenUtil;
import org.jetbrains.kotlin.codegen.SamType;
import org.jetbrains.kotlin.codegen.StackValue;
import org.jetbrains.kotlin.codegen.binding.CodegenBinding;
import org.jetbrains.kotlin.codegen.binding.MutableClosure;
import org.jetbrains.kotlin.codegen.coroutines.CoroutineCodegenUtilKt;
import org.jetbrains.kotlin.codegen.signature.AsmTypeFactory;
import org.jetbrains.kotlin.codegen.signature.BothSignatureWriter;
import org.jetbrains.kotlin.codegen.signature.JvmSignatureWriter;
import org.jetbrains.kotlin.codegen.state.IncompatibleClassTracker;
import org.jetbrains.kotlin.codegen.state.ReceiverTypeAndTypeParameters;
import org.jetbrains.kotlin.codegen.state.TypeMapperUtilsKt;
import org.jetbrains.kotlin.codegen.state.TypeMappingUtil;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptorWithTypeParameters;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PossiblyInnerType;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ScriptDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterUtilsKt;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.descriptors.impl.LocalVariableAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.impl.LocalVariableDescriptor;
import org.jetbrains.kotlin.descriptors.impl.TypeAliasConstructorDescriptor;
import org.jetbrains.kotlin.fileClasses.FileClasses;
import org.jetbrains.kotlin.fileClasses.JvmFileClassInfo;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtil;
import org.jetbrains.kotlin.fileClasses.JvmFileClassesProvider;
import org.jetbrains.kotlin.ir.descriptors.IrBuiltinsPackageFragmentDescriptor;
import org.jetbrains.kotlin.load.java.BuiltinMethodsWithSpecialGenericSignature;
import org.jetbrains.kotlin.load.java.JvmAbi;
import org.jetbrains.kotlin.load.java.JvmBytecodeBinaryVersion;
import org.jetbrains.kotlin.load.java.SpecialBuiltinMembers;
import org.jetbrains.kotlin.load.java.descriptors.JavaCallableMemberDescriptor;
import org.jetbrains.kotlin.load.java.descriptors.JavaClassDescriptor;
import org.jetbrains.kotlin.load.java.lazy.descriptors.LazyJavaPackageFragment;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryClass;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinaryPackageSourceElement;
import org.jetbrains.kotlin.load.kotlin.KotlinJvmBinarySourceElement;
import org.jetbrains.kotlin.load.kotlin.MethodSignatureMappingKt;
import org.jetbrains.kotlin.load.kotlin.TypeMappingConfiguration;
import org.jetbrains.kotlin.load.kotlin.TypeMappingMode;
import org.jetbrains.kotlin.load.kotlin.TypeSignatureMappingKt;
import org.jetbrains.kotlin.load.kotlin.incremental.IncrementalPackageFragmentProvider;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.NameUtils;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.platform.JavaToKotlinClassMap;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.FunctionImportedFromObject;
import org.jetbrains.kotlin.resolve.ImportedFromObjectCallableDescriptor;
import org.jetbrains.kotlin.resolve.calls.model.DefaultValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodGenericSignature;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodParameterKind;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodParameterSignature;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodSignature;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedCallableMemberDescriptor;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedClassDescriptor;
import org.jetbrains.kotlin.types.CommonSupertypes;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.UtilsKt;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingUtils;
import org.jetbrains.kotlin.util.OperatorNameConventions;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.Method;

public class KotlinTypeMapper {
    private final BindingContext bindingContext;
    private final ClassBuilderMode classBuilderMode;
    private final JvmFileClassesProvider fileClassesProvider;
    private final IncompatibleClassTracker incompatibleClassTracker;
    private final String moduleName;
    private final boolean isJvm8Target;
    private final boolean isJvm8TargetWithDefaults;
    private final TypeMappingConfiguration<Type> typeMappingConfiguration;
    private static final ClassId FAKE_CLASS_ID_FOR_BUILTINS = ClassId.topLevel(new FqName("kotlin.KotlinPackage"));

    public KotlinTypeMapper(@NotNull BindingContext bindingContext2, @NotNull ClassBuilderMode classBuilderMode, @NotNull JvmFileClassesProvider fileClassesProvider, @NotNull IncompatibleClassTracker incompatibleClassTracker, @NotNull String moduleName, boolean isJvm8Target, boolean isJvm8TargetWithDefaults) {
        if (bindingContext2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bindingContext", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "<init>"));
        }
        if (classBuilderMode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classBuilderMode", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "<init>"));
        }
        if (fileClassesProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileClassesProvider", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "<init>"));
        }
        if (incompatibleClassTracker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "incompatibleClassTracker", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "<init>"));
        }
        if (moduleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleName", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "<init>"));
        }
        this.typeMappingConfiguration = new TypeMappingConfiguration<Type>(){
            private final Function2<String, String, String> defaultClassNameFactory = TypeMappingConfiguration.Companion.getDEFAULT_INNER_CLASS_NAME_FACTORY();
            private final Function2<String, String, String> innerClassNameFactory = new Function2<String, String, String>(){

                public String invoke(String outer, String inner) {
                    if (KotlinTypeMapper.this.classBuilderMode == ClassBuilderMode.KAPT3) {
                        return outer + '/' + inner;
                    }
                    return (String)defaultClassNameFactory.invoke((Object)outer, (Object)inner);
                }
            };

            @Override
            @NotNull
            public KotlinType commonSupertype(@NotNull Collection<KotlinType> types) {
                if (types == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "types", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper$1", "commonSupertype"));
                }
                KotlinType kotlinType = CommonSupertypes.commonSupertype(types);
                if (kotlinType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper$1", "commonSupertype"));
                }
                return kotlinType;
            }

            @Override
            @NotNull
            public Function2<String, String, String> getInnerClassNameFactory() {
                Function2<String, String, String> function2 = this.innerClassNameFactory;
                if (function2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper$1", "getInnerClassNameFactory"));
                }
                return function2;
            }

            @Override
            @Nullable
            public Type getPredefinedTypeForClass(@NotNull ClassDescriptor classDescriptor) {
                if (classDescriptor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper$1", "getPredefinedTypeForClass"));
                }
                return KotlinTypeMapper.this.bindingContext.get(CodegenBinding.ASM_TYPE, classDescriptor);
            }

            @Override
            @Nullable
            public String getPredefinedInternalNameForClass(@NotNull ClassDescriptor classDescriptor) {
                if (classDescriptor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper$1", "getPredefinedInternalNameForClass"));
                }
                Type type2 = this.getPredefinedTypeForClass(classDescriptor);
                return type2 == null ? null : type2.getInternalName();
            }

            @Override
            public void processErrorType(@NotNull KotlinType kotlinType, @NotNull ClassDescriptor descriptor2) {
                if (kotlinType == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kotlinType", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper$1", "processErrorType"));
                }
                if (descriptor2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper$1", "processErrorType"));
                }
                if (((KotlinTypeMapper)KotlinTypeMapper.this).classBuilderMode.generateBodies) {
                    throw new IllegalStateException(KotlinTypeMapper.generateErrorMessageForErrorType(kotlinType, descriptor2));
                }
            }
        };
        this.bindingContext = bindingContext2;
        this.classBuilderMode = classBuilderMode;
        this.fileClassesProvider = fileClassesProvider;
        this.incompatibleClassTracker = incompatibleClassTracker;
        this.moduleName = moduleName;
        this.isJvm8Target = isJvm8Target;
        this.isJvm8TargetWithDefaults = isJvm8TargetWithDefaults;
    }

    @NotNull
    public TypeMappingConfiguration<Type> getTypeMappingConfiguration() {
        TypeMappingConfiguration<Type> typeMappingConfiguration = this.typeMappingConfiguration;
        if (typeMappingConfiguration == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "getTypeMappingConfiguration"));
        }
        return typeMappingConfiguration;
    }

    @NotNull
    public BindingContext getBindingContext() {
        BindingContext bindingContext2 = this.bindingContext;
        if (bindingContext2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "getBindingContext"));
        }
        return bindingContext2;
    }

    @NotNull
    public Type mapOwner(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapOwner"));
        }
        Type type2 = this.mapOwner(descriptor2, true);
        if (type2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapOwner"));
        }
        return type2;
    }

    public Type mapImplementationOwner(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapImplementationOwner"));
        }
        return this.mapOwner(descriptor2, false);
    }

    @NotNull
    private Type mapOwner(@NotNull DeclarationDescriptor descriptor2, boolean publicFacade) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapOwner"));
        }
        if (ExpressionTypingUtils.isLocalFunction(descriptor2)) {
            Type type2 = CodegenBinding.asmTypeForAnonymousClass(this.bindingContext, (FunctionDescriptor)descriptor2);
            if (type2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapOwner"));
            }
            return type2;
        }
        DeclarationDescriptor container2 = descriptor2.getContainingDeclaration();
        if (container2 instanceof PackageFragmentDescriptor) {
            String packageMemberOwner = this.internalNameForPackageMemberOwner((CallableMemberDescriptor)descriptor2, publicFacade);
            Type type3 = Type.getObjectType((String)packageMemberOwner);
            if (type3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapOwner"));
            }
            return type3;
        }
        if (container2 instanceof ClassDescriptor) {
            Type type4 = this.mapClass((ClassDescriptor)container2);
            if (type4 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapOwner"));
            }
            return type4;
        }
        throw new UnsupportedOperationException("Don't know how to map owner for " + descriptor2);
    }

    @NotNull
    private String internalNameForPackageMemberOwner(@NotNull CallableMemberDescriptor descriptor2, boolean publicFacade) {
        String facadeFqName;
        KtFile file2;
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "internalNameForPackageMemberOwner"));
        }
        boolean isAccessor = descriptor2 instanceof AccessorForCallableDescriptor;
        if (isAccessor) {
            descriptor2 = ((AccessorForCallableDescriptor)((Object)descriptor2)).getCalleeDescriptor();
        }
        if ((file2 = DescriptorToSourceUtils.getContainingFile(descriptor2)) != null) {
            Visibility visibility = descriptor2.getVisibility();
            if (!publicFacade || KotlinTypeMapper.isNonConstProperty(descriptor2) || Visibilities.isPrivate(visibility) || isAccessor) {
                String string = FileClasses.getFileClassInternalName(this.fileClassesProvider, file2);
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "internalNameForPackageMemberOwner"));
                }
                return string;
            }
            String string = FileClasses.getFacadeClassInternalName(this.fileClassesProvider, file2);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "internalNameForPackageMemberOwner"));
            }
            return string;
        }
        CallableMemberDescriptor directMember = DescriptorUtils.getDirectMember(descriptor2);
        if (directMember instanceof DeserializedCallableMemberDescriptor && (facadeFqName = this.getPackageMemberOwnerInternalName((DeserializedCallableMemberDescriptor)directMember, publicFacade)) != null) {
            String string = facadeFqName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "internalNameForPackageMemberOwner"));
            }
            return string;
        }
        if (descriptor2.getContainingDeclaration() instanceof IrBuiltinsPackageFragmentDescriptor) {
            String string = descriptor2.getContainingDeclaration().getName().asString();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "internalNameForPackageMemberOwner"));
            }
            return string;
        }
        throw new RuntimeException("Could not find package member for " + descriptor2 + " in package fragment " + descriptor2.getContainingDeclaration());
    }

    private static boolean isNonConstProperty(@NotNull CallableMemberDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "isNonConstProperty"));
        }
        if (!(descriptor2 instanceof PropertyDescriptor)) {
            return false;
        }
        PropertyDescriptor propertyDescriptor = (PropertyDescriptor)descriptor2;
        return !propertyDescriptor.isConst();
    }

    @NotNull
    public ContainingClassesInfo getContainingClassesForDeserializedCallable(@NotNull DeserializedCallableMemberDescriptor deserializedDescriptor) {
        ContainingClassesInfo containingClassesInfo;
        if (deserializedDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deserializedDescriptor", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "getContainingClassesForDeserializedCallable"));
        }
        DeclarationDescriptor parentDeclaration = deserializedDescriptor.getContainingDeclaration();
        if (parentDeclaration instanceof PackageFragmentDescriptor) {
            containingClassesInfo = KotlinTypeMapper.getPackageMemberContainingClassesInfo(deserializedDescriptor);
        } else {
            ClassId classId = this.getContainerClassIdForClassDescriptor((ClassDescriptor)parentDeclaration);
            containingClassesInfo = ContainingClassesInfo.forClassMember(classId);
        }
        if (containingClassesInfo == null) {
            throw new IllegalStateException("Couldn't find container for " + deserializedDescriptor.getName());
        }
        ContainingClassesInfo containingClassesInfo2 = containingClassesInfo;
        if (containingClassesInfo2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "getContainingClassesForDeserializedCallable"));
        }
        return containingClassesInfo2;
    }

    @NotNull
    private ClassId getContainerClassIdForClassDescriptor(@NotNull ClassDescriptor classDescriptor) {
        if (classDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classDescriptor", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "getContainerClassIdForClassDescriptor"));
        }
        ClassId classId = DescriptorUtilsKt.getClassId(classDescriptor);
        assert (classId != null) : "Deserialized class should have a ClassId: " + classDescriptor;
        if (DescriptorUtils.isInterface(classDescriptor)) {
            FqName relativeClassName2 = classId.getRelativeClassName();
            String defaultImplsClassName = (String)this.typeMappingConfiguration.getInnerClassNameFactory().invoke((Object)relativeClassName2.shortName().asString(), (Object)"DefaultImpls");
            ClassId classId2 = new ClassId(classId.getPackageFqName(), Name.identifier(defaultImplsClassName));
            if (classId2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "getContainerClassIdForClassDescriptor"));
            }
            return classId2;
        }
        ClassId classId3 = classId;
        if (classId3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "getContainerClassIdForClassDescriptor"));
        }
        return classId3;
    }

    @Nullable
    private String getPackageMemberOwnerInternalName(@NotNull DeserializedCallableMemberDescriptor descriptor2, boolean publicFacade) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "getPackageMemberOwnerInternalName"));
        }
        DeclarationDescriptor containingDeclaration = descriptor2.getContainingDeclaration();
        assert (containingDeclaration instanceof PackageFragmentDescriptor) : "Not a top-level member: " + descriptor2;
        ContainingClassesInfo containingClasses = KotlinTypeMapper.getPackageMemberContainingClassesInfo(descriptor2);
        if (containingClasses == null) {
            return null;
        }
        ClassId ownerClassId = publicFacade ? containingClasses.getFacadeClassId() : containingClasses.getImplClassId();
        return JvmClassName.byClassId(ownerClassId, this.typeMappingConfiguration).getInternalName();
    }

    @Nullable
    private static ContainingClassesInfo getPackageMemberContainingClassesInfo(@NotNull DeserializedCallableMemberDescriptor descriptor2) {
        String facadeSimpleName;
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "getPackageMemberContainingClassesInfo"));
        }
        DeclarationDescriptor containingDeclaration = descriptor2.getContainingDeclaration();
        if (containingDeclaration instanceof BuiltInsPackageFragment) {
            return new ContainingClassesInfo(FAKE_CLASS_ID_FOR_BUILTINS, FAKE_CLASS_ID_FOR_BUILTINS);
        }
        Name implClassName = JvmFileClassUtil.getImplClassName(descriptor2);
        assert (implClassName != null) : "No implClassName for " + descriptor2;
        String implSimpleName = implClassName.asString();
        if (containingDeclaration instanceof LazyJavaPackageFragment) {
            facadeSimpleName = ((LazyJavaPackageFragment)containingDeclaration).getFacadeSimpleNameForPartSimpleName(implSimpleName);
            if (facadeSimpleName == null) {
                return null;
            }
        } else if (containingDeclaration instanceof IncrementalPackageFragmentProvider.IncrementalMultifileClassPackageFragment) {
            facadeSimpleName = ((IncrementalPackageFragmentProvider.IncrementalMultifileClassPackageFragment)containingDeclaration).getMultifileClassName().asString();
        } else {
            throw new AssertionError((Object)("Unexpected package fragment for " + descriptor2 + ": " + containingDeclaration + " (" + containingDeclaration.getClass().getSimpleName() + ")"));
        }
        return ContainingClassesInfo.forPackageMember(((PackageFragmentDescriptor)containingDeclaration).getFqName(), facadeSimpleName, implSimpleName);
    }

    @NotNull
    public Type mapReturnType(@NotNull CallableDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapReturnType"));
        }
        Type type2 = this.mapReturnType(descriptor2, null);
        if (type2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapReturnType"));
        }
        return type2;
    }

    @NotNull
    private Type mapReturnType(@NotNull CallableDescriptor descriptor2, @Nullable JvmSignatureWriter sw) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapReturnType"));
        }
        KotlinType returnType2 = descriptor2.getReturnType();
        assert (returnType2 != null) : "Function has no return type: " + descriptor2;
        if (descriptor2 instanceof ConstructorDescriptor) {
            Type type2 = Type.VOID_TYPE;
            if (type2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapReturnType"));
            }
            return type2;
        }
        if (CoroutineCodegenUtilKt.isSuspendFunctionNotSuspensionView(descriptor2)) {
            Type type3 = this.mapReturnType(CoroutineCodegenUtilKt.getOrCreateJvmSuspendFunctionView((SimpleFunctionDescriptor)descriptor2), sw);
            if (type3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapReturnType"));
            }
            return type3;
        }
        if (TypeSignatureMappingKt.hasVoidReturnType(descriptor2)) {
            if (sw != null) {
                sw.writeAsmType(Type.VOID_TYPE);
            }
            Type type4 = Type.VOID_TYPE;
            if (type4 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapReturnType"));
            }
            return type4;
        }
        if (descriptor2 instanceof FunctionDescriptor && KotlinTypeMapper.forceBoxedReturnType((FunctionDescriptor)descriptor2)) {
            Type type5 = this.mapType(descriptor2.getReturnType(), sw, TypeMappingMode.GENERIC_ARGUMENT);
            if (type5 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapReturnType"));
            }
            return type5;
        }
        Type type6 = this.mapReturnType(descriptor2, sw, returnType2);
        if (type6 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapReturnType"));
        }
        return type6;
    }

    @NotNull
    private Type mapReturnType(@NotNull CallableDescriptor descriptor2, @Nullable JvmSignatureWriter sw, @NotNull KotlinType returnType2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapReturnType"));
        }
        if (returnType2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "returnType", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapReturnType"));
        }
        boolean isAnnotationMethod = DescriptorUtils.isAnnotationClass(descriptor2.getContainingDeclaration());
        if (sw == null || sw.skipGenericSignature()) {
            Type type2 = this.mapType(returnType2, sw, TypeMappingMode.getModeForReturnTypeNoGeneric(isAnnotationMethod));
            if (type2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapReturnType"));
            }
            return type2;
        }
        TypeMappingMode typeMappingModeFromAnnotation = TypeMappingUtil.extractTypeMappingModeFromAnnotation(descriptor2, returnType2, isAnnotationMethod);
        if (typeMappingModeFromAnnotation != null) {
            Type type3 = this.mapType(returnType2, sw, typeMappingModeFromAnnotation);
            if (type3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapReturnType"));
            }
            return type3;
        }
        TypeMappingMode mappingMode = TypeMappingMode.getOptimalModeForReturnType(returnType2, isAnnotationMethod);
        Type type4 = this.mapType(returnType2, sw, mappingMode);
        if (type4 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapReturnType"));
        }
        return type4;
    }

    @NotNull
    public Type mapSupertype(@NotNull KotlinType jetType, @Nullable JvmSignatureWriter signatureVisitor) {
        if (jetType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jetType", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapSupertype"));
        }
        Type type2 = this.mapType(jetType, signatureVisitor, TypeMappingMode.SUPER_TYPE);
        if (type2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapSupertype"));
        }
        return type2;
    }

    @NotNull
    public Type mapTypeParameter(@NotNull KotlinType jetType, @Nullable JvmSignatureWriter signatureVisitor) {
        if (jetType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jetType", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapTypeParameter"));
        }
        Type type2 = this.mapType(jetType, signatureVisitor, TypeMappingMode.GENERIC_ARGUMENT);
        if (type2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapTypeParameter"));
        }
        return type2;
    }

    @NotNull
    public Type mapClass(@NotNull ClassifierDescriptor classifier) {
        if (classifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classifier", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapClass"));
        }
        Type type2 = this.mapType(classifier.getDefaultType(), null, TypeMappingMode.DEFAULT);
        if (type2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapClass"));
        }
        return type2;
    }

    @NotNull
    public Type mapType(@NotNull KotlinType jetType) {
        if (jetType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jetType", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapType"));
        }
        Type type2 = this.mapType(jetType, null, TypeMappingMode.DEFAULT);
        if (type2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapType"));
        }
        return type2;
    }

    @NotNull
    public Type mapType(@NotNull CallableDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapType"));
        }
        Type type2 = this.mapType(descriptor2.getReturnType());
        if (type2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapType"));
        }
        return type2;
    }

    @NotNull
    public JvmMethodGenericSignature mapAnnotationParameterSignature(@NotNull PropertyDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapAnnotationParameterSignature"));
        }
        BothSignatureWriter sw = new BothSignatureWriter(BothSignatureWriter.Mode.METHOD);
        ((JvmSignatureWriter)sw).writeReturnType();
        this.mapType(descriptor2.getType(), sw, TypeMappingMode.VALUE_FOR_ANNOTATION);
        ((JvmSignatureWriter)sw).writeReturnTypeEnd();
        JvmMethodGenericSignature jvmMethodGenericSignature = sw.makeJvmMethodSignature(descriptor2.getName().asString());
        if (jvmMethodGenericSignature == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapAnnotationParameterSignature"));
        }
        return jvmMethodGenericSignature;
    }

    @NotNull
    public Type mapType(@NotNull ClassifierDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapType"));
        }
        Type type2 = this.mapType(descriptor2.getDefaultType());
        if (type2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapType"));
        }
        return type2;
    }

    @NotNull
    public Type mapType(@NotNull KotlinType kotlinType, final @Nullable JvmSignatureWriter signatureVisitor, @NotNull TypeMappingMode mode) {
        if (kotlinType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kotlinType", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapType"));
        }
        if (mode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapType"));
        }
        Type type2 = TypeSignatureMappingKt.mapType(kotlinType, AsmTypeFactory.INSTANCE, mode, this.typeMappingConfiguration, signatureVisitor, new Function3<KotlinType, Type, TypeMappingMode, Unit>(){

            public Unit invoke(KotlinType kotlinType, Type type2, TypeMappingMode mode) {
                KotlinTypeMapper.this.writeGenericType(kotlinType, type2, signatureVisitor, mode);
                return Unit.INSTANCE;
            }
        });
        if (type2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapType"));
        }
        return type2;
    }

    @NotNull
    public Type mapDefaultImpls(@NotNull ClassDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapDefaultImpls"));
        }
        String defaultImplsClassName = (String)this.typeMappingConfiguration.getInnerClassNameFactory().invoke((Object)this.mapType(descriptor2).getInternalName(), (Object)"DefaultImpls");
        Type type2 = Type.getObjectType((String)defaultImplsClassName);
        if (type2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapDefaultImpls"));
        }
        return type2;
    }

    @NotNull
    private static String generateErrorMessageForErrorType(@NotNull KotlinType type2, @NotNull DeclarationDescriptor descriptor2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "generateErrorMessageForErrorType"));
        }
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "generateErrorMessageForErrorType"));
        }
        PsiElement declarationElement = DescriptorToSourceUtils.descriptorToDeclaration(descriptor2);
        if (declarationElement == null) {
            String string = String.format("Error type encountered: %s (%s).", type2, type2.getClass().getSimpleName());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "generateErrorMessageForErrorType"));
            }
            return string;
        }
        DeclarationDescriptor containingDeclaration = descriptor2.getContainingDeclaration();
        PsiElement parentDeclarationElement = containingDeclaration != null ? DescriptorToSourceUtils.descriptorToDeclaration(containingDeclaration) : null;
        String string = String.format("Error type encountered: %s (%s). Descriptor: %s. For declaration %s:%s in %s:%s", type2, type2.getClass().getSimpleName(), descriptor2, declarationElement, declarationElement.getText(), parentDeclarationElement, parentDeclarationElement != null ? parentDeclarationElement.getText() : "null");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "generateErrorMessageForErrorType"));
        }
        return string;
    }

    private void writeGenericType(@NotNull KotlinType type2, @NotNull Type asmType, @Nullable JvmSignatureWriter signatureVisitor, @NotNull TypeMappingMode mode) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "writeGenericType"));
        }
        if (asmType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "asmType", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "writeGenericType"));
        }
        if (mode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "writeGenericType"));
        }
        if (signatureVisitor == null) {
            return;
        }
        if (signatureVisitor.skipGenericSignature() || KotlinTypeMapper.hasNothingInNonContravariantPosition(type2) || type2.getArguments().isEmpty()) {
            signatureVisitor.writeAsmType(asmType);
            return;
        }
        PossiblyInnerType possiblyInnerType = TypeParameterUtilsKt.buildPossiblyInnerType(type2);
        assert (possiblyInnerType != null) : "possiblyInnerType with arguments should not be null";
        List<PossiblyInnerType> innerTypesAsList = possiblyInnerType.segments();
        if (innerTypesAsList.size() == 1) {
            signatureVisitor.writeClassBegin(asmType);
        } else {
            ClassDescriptor outermostClass = innerTypesAsList.get(0).getClassDescriptor();
            signatureVisitor.writeOuterClassBegin(asmType, this.mapType(outermostClass.getDefaultType()).getInternalName());
        }
        for (int i = 0; i < innerTypesAsList.size(); ++i) {
            PossiblyInnerType innerPart = innerTypesAsList.get(i);
            if (i > 0) {
                signatureVisitor.writeInnerClass(KotlinTypeMapper.getJvmShortName(innerPart.getClassDescriptor()));
            }
            this.writeGenericArguments(signatureVisitor, innerPart, mode);
        }
        signatureVisitor.writeClassEnd();
    }

    @Nullable
    private static String getJvmShortName(@NotNull ClassDescriptor klass2) {
        if (klass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "klass", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "getJvmShortName"));
        }
        ClassId classId = JavaToKotlinClassMap.INSTANCE.mapKotlinToJava(DescriptorUtils.getFqName(klass2));
        if (classId != null) {
            return classId.getShortClassName().asString();
        }
        return SpecialNames.safeIdentifier(klass2.getName()).getIdentifier();
    }

    private void writeGenericArguments(@NotNull JvmSignatureWriter signatureVisitor, @NotNull PossiblyInnerType type2, @NotNull TypeMappingMode mode) {
        if (signatureVisitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signatureVisitor", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "writeGenericArguments"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "writeGenericArguments"));
        }
        if (mode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "writeGenericArguments"));
        }
        ClassDescriptor classDescriptor = type2.getClassDescriptor();
        List<TypeParameterDescriptor> parameters2 = classDescriptor.getDeclaredTypeParameters();
        List<TypeProjection> arguments2 = type2.getArguments();
        if (classDescriptor instanceof FunctionClassDescriptor && ((FunctionClassDescriptor)classDescriptor).getFunctionKind() == FunctionClassDescriptor.Kind.KFunction) {
            this.writeGenericArguments(signatureVisitor, Collections.singletonList(CollectionsKt.last(arguments2)), Collections.singletonList(CollectionsKt.last(parameters2)), mode);
            return;
        }
        this.writeGenericArguments(signatureVisitor, arguments2, parameters2, mode);
    }

    private void writeGenericArguments(@NotNull JvmSignatureWriter signatureVisitor, @NotNull List<? extends TypeProjection> arguments2, @NotNull List<? extends TypeParameterDescriptor> parameters2, @NotNull TypeMappingMode mode) {
        if (signatureVisitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "signatureVisitor", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "writeGenericArguments"));
        }
        if (arguments2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "writeGenericArguments"));
        }
        if (parameters2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "writeGenericArguments"));
        }
        if (mode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "writeGenericArguments"));
        }
        for (Pair item : CollectionsKt.zip(parameters2, arguments2)) {
            TypeParameterDescriptor parameter = (TypeParameterDescriptor)item.getFirst();
            TypeProjection argument2 = (TypeProjection)item.getSecond();
            if (argument2.isStarProjection() || KotlinBuiltIns.isNothing(argument2.getType()) && parameter.getVariance() == Variance.IN_VARIANCE) {
                signatureVisitor.writeUnboundedWildcard();
                continue;
            }
            TypeMappingMode argumentMode = TypeMappingUtil.updateArgumentModeFromAnnotations(mode, argument2.getType());
            Variance projectionKind = KotlinTypeMapper.getVarianceForWildcard(parameter, argument2, argumentMode);
            signatureVisitor.writeTypeArgument(projectionKind);
            this.mapType(argument2.getType(), signatureVisitor, argumentMode.toGenericArgumentMode(UtilsKt.getEffectiveVariance(parameter.getVariance(), argument2.getProjectionKind())));
            signatureVisitor.writeTypeArgumentEnd();
        }
    }

    private static boolean hasNothingInNonContravariantPosition(KotlinType kotlinType) {
        List<TypeParameterDescriptor> parameters2 = kotlinType.getConstructor().getParameters();
        List<TypeProjection> arguments2 = kotlinType.getArguments();
        for (int i = 0; i < arguments2.size(); ++i) {
            KotlinType type2;
            TypeProjection projection = arguments2.get(i);
            if (projection.isStarProjection() || !KotlinBuiltIns.isNullableNothing(type2 = projection.getType()) && (!KotlinBuiltIns.isNothing(type2) || parameters2.get(i).getVariance() == Variance.IN_VARIANCE)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static Variance getVarianceForWildcard(@NotNull TypeParameterDescriptor parameter, @NotNull TypeProjection projection, @NotNull TypeMappingMode mode) {
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "getVarianceForWildcard"));
        }
        if (projection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projection", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "getVarianceForWildcard"));
        }
        if (mode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "getVarianceForWildcard"));
        }
        Variance projectionKind = projection.getProjectionKind();
        Variance parameterVariance = parameter.getVariance();
        if (parameterVariance == Variance.INVARIANT) {
            Variance variance = projectionKind;
            if (variance == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "getVarianceForWildcard"));
            }
            return variance;
        }
        if (mode.getSkipDeclarationSiteWildcards()) {
            Variance variance = Variance.INVARIANT;
            if (variance == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "getVarianceForWildcard"));
            }
            return variance;
        }
        if (projectionKind == Variance.INVARIANT || projectionKind == parameterVariance) {
            if (mode.getSkipDeclarationSiteWildcardsIfPossible() && !projection.isStarProjection()) {
                if (parameterVariance == Variance.OUT_VARIANCE && TypeMappingUtil.isMostPreciseCovariantArgument(projection.getType())) {
                    Variance variance = Variance.INVARIANT;
                    if (variance == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "getVarianceForWildcard"));
                    }
                    return variance;
                }
                if (parameterVariance == Variance.IN_VARIANCE && TypeMappingUtil.isMostPreciseContravariantArgument(projection.getType(), parameter)) {
                    Variance variance = Variance.INVARIANT;
                    if (variance == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "getVarianceForWildcard"));
                    }
                    return variance;
                }
            }
            Variance variance = parameterVariance;
            if (variance == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "getVarianceForWildcard"));
            }
            return variance;
        }
        Variance variance = Variance.OUT_VARIANCE;
        if (variance == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "getVarianceForWildcard"));
        }
        return variance;
    }

    private FunctionDescriptor findSuperDeclaration(@NotNull FunctionDescriptor descriptor2, boolean isSuperCall) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "findSuperDeclaration"));
        }
        while (descriptor2.getKind() == CallableMemberDescriptor.Kind.FAKE_OVERRIDE) {
            Collection<? extends FunctionDescriptor> overridden = descriptor2.getOverriddenDescriptors();
            if (overridden.isEmpty()) {
                throw new IllegalStateException("Fake override should have at least one overridden descriptor: " + descriptor2);
            }
            FunctionDescriptor classCallable = null;
            for (FunctionDescriptor functionDescriptor2 : overridden) {
                if (DescriptorUtils.isInterface(functionDescriptor2.getContainingDeclaration())) continue;
                classCallable = functionDescriptor2;
                break;
            }
            if (classCallable != null) {
                descriptor2 = classCallable;
                continue;
            }
            if (isSuperCall && !this.isJvm8TargetWithDefaults && !DescriptorUtils.isInterface(descriptor2.getContainingDeclaration())) {
                return descriptor2;
            }
            descriptor2 = overridden.iterator().next();
        }
        return descriptor2;
    }

    @NotNull
    public CallableMethod mapToCallableMethod(@NotNull FunctionDescriptor descriptor2, boolean superCall) {
        Type owner;
        JvmMethodSignature signature;
        int invokeOpcode;
        Type thisClass;
        Type ownerForDefaultImpl;
        FunctionDescriptor baseMethodDescriptor;
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapToCallableMethod"));
        }
        if (descriptor2 instanceof TypeAliasConstructorDescriptor) {
            CallableMethod callableMethod = this.mapToCallableMethod(((TypeAliasConstructorDescriptor)descriptor2).getUnderlyingConstructorDescriptor(), superCall);
            if (callableMethod == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapToCallableMethod"));
            }
            return callableMethod;
        }
        if (descriptor2 instanceof ClassConstructorDescriptor) {
            JvmMethodSignature method = this.mapSignatureSkipGeneric(descriptor2);
            Type owner2 = this.mapClass(((ClassConstructorDescriptor)descriptor2).getContainingDeclaration());
            String defaultImplDesc = this.mapDefaultMethod(descriptor2, OwnerKind.IMPLEMENTATION).getDescriptor();
            CallableMethod callableMethod = new CallableMethod(owner2, owner2, defaultImplDesc, method, 183, null, null, null, false);
            if (callableMethod == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapToCallableMethod"));
            }
            return callableMethod;
        }
        if (descriptor2 instanceof LocalVariableAccessorDescriptor) {
            ResolvedCall<FunctionDescriptor> delegateAccessorResolvedCall = this.bindingContext.get(BindingContext.DELEGATED_PROPERTY_RESOLVED_CALL, (VariableAccessorDescriptor)descriptor2);
            CallableMethod callableMethod = this.mapToCallableMethod(delegateAccessorResolvedCall.getResultingDescriptor(), false);
            if (callableMethod == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapToCallableMethod"));
            }
            return callableMethod;
        }
        DeclarationDescriptor functionParent = descriptor2.getOriginal().getContainingDeclaration();
        FunctionDescriptor functionDescriptor2 = this.findSuperDeclaration(descriptor2.getOriginal(), superCall);
        boolean isInterfaceMember = false;
        if (functionParent instanceof ClassDescriptor) {
            FunctionDescriptor declarationFunctionDescriptor = KotlinTypeMapper.findAnyDeclaration(functionDescriptor2);
            ClassDescriptor currentOwner = (ClassDescriptor)functionParent;
            ClassDescriptor declarationOwner = (ClassDescriptor)declarationFunctionDescriptor.getContainingDeclaration();
            boolean originalIsInterface = JvmCodegenUtil.isJvmInterface(declarationOwner);
            boolean currentIsInterface = JvmCodegenUtil.isJvmInterface(currentOwner);
            boolean isInterface = currentIsInterface && originalIsInterface;
            baseMethodDescriptor = KotlinTypeMapper.findBaseDeclaration(functionDescriptor2).getOriginal();
            ClassDescriptor ownerForDefault = (ClassDescriptor)baseMethodDescriptor.getContainingDeclaration();
            Type type2 = ownerForDefaultImpl = JvmCodegenUtil.isJvmInterface(ownerForDefault) && !this.isJvm8InterfaceWithDefaults(ownerForDefault) ? this.mapDefaultImpls(ownerForDefault) : this.mapClass(ownerForDefault);
            if (isInterface && (superCall || descriptor2.getVisibility() == Visibilities.PRIVATE || KotlinTypeMapper.isAccessor(descriptor2))) {
                thisClass = this.mapClass(currentOwner);
                if (declarationOwner instanceof JavaClassDescriptor || this.isJvm8InterfaceWithDefaults(declarationOwner)) {
                    invokeOpcode = 183;
                    signature = this.mapSignatureSkipGeneric(functionDescriptor2);
                    owner = thisClass;
                    isInterfaceMember = true;
                } else {
                    invokeOpcode = 184;
                    signature = this.mapSignatureSkipGeneric(descriptor2.getOriginal(), OwnerKind.DEFAULT_IMPLS);
                    owner = this.mapDefaultImpls(currentOwner);
                }
            } else {
                boolean isStaticInvocation;
                boolean bl = isStaticInvocation = DescriptorUtils.isStaticDeclaration(functionDescriptor2) && !(functionDescriptor2 instanceof ImportedFromObjectCallableDescriptor) || KotlinTypeMapper.isStaticAccessor(functionDescriptor2) || CodegenUtilKt.isJvmStaticInObjectOrClass(functionDescriptor2);
                if (isStaticInvocation) {
                    invokeOpcode = 184;
                    isInterfaceMember = currentIsInterface && currentOwner instanceof JavaClassDescriptor;
                } else if (isInterface) {
                    invokeOpcode = 185;
                    isInterfaceMember = true;
                } else {
                    boolean isPrivateFunInvocation = Visibilities.isPrivate(functionDescriptor2.getVisibility());
                    invokeOpcode = superCall || isPrivateFunInvocation ? 183 : 182;
                    isInterfaceMember = superCall && currentIsInterface;
                }
                FunctionDescriptor overriddenSpecialBuiltinFunction = SpecialBuiltinMembers.getOverriddenBuiltinReflectingJvmDescriptor(functionDescriptor2.getOriginal());
                FunctionDescriptor functionToCall = overriddenSpecialBuiltinFunction != null && !superCall ? overriddenSpecialBuiltinFunction.getOriginal() : functionDescriptor2.getOriginal();
                signature = this.mapSignatureSkipGeneric(functionToCall);
                ClassDescriptor receiver = currentIsInterface && !originalIsInterface || currentOwner instanceof FunctionClassDescriptor ? declarationOwner : currentOwner;
                thisClass = owner = this.mapClass(receiver);
            }
        } else {
            signature = this.mapSignatureSkipGeneric(functionDescriptor2.getOriginal());
            ownerForDefaultImpl = owner = this.mapOwner(functionDescriptor2);
            baseMethodDescriptor = functionDescriptor2;
            if (functionParent instanceof PackageFragmentDescriptor) {
                invokeOpcode = 184;
                thisClass = null;
            } else if (functionDescriptor2 instanceof ConstructorDescriptor) {
                invokeOpcode = 183;
                thisClass = null;
            } else {
                invokeOpcode = 182;
                thisClass = owner;
            }
        }
        Type calleeType = ExpressionTypingUtils.isLocalFunction(functionDescriptor2) ? owner : null;
        ReceiverParameterDescriptor receiverParameter = functionDescriptor2.getOriginal().getExtensionReceiverParameter();
        Type receiverParameterType = receiverParameter != null ? this.mapType(receiverParameter.getType()) : null;
        String defaultImplDesc = this.mapDefaultMethod(baseMethodDescriptor, KotlinTypeMapper.getKindForDefaultImplCall(baseMethodDescriptor)).getDescriptor();
        CallableMethod callableMethod = new CallableMethod(owner, ownerForDefaultImpl, defaultImplDesc, signature, invokeOpcode, thisClass, receiverParameterType, calleeType, this.isJvm8Target ? isInterfaceMember : invokeOpcode == 185);
        if (callableMethod == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapToCallableMethod"));
        }
        return callableMethod;
    }

    private boolean isJvm8InterfaceWithDefaults(@NotNull ClassDescriptor ownerForDefault) {
        if (ownerForDefault == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ownerForDefault", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "isJvm8InterfaceWithDefaults"));
        }
        return JvmCodegenUtil.isJvmInterface(ownerForDefault) && JvmCodegenUtil.isJvm8InterfaceWithDefaults(ownerForDefault, this.isJvm8Target, this.isJvm8TargetWithDefaults);
    }

    public static boolean isAccessor(@NotNull CallableMemberDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "isAccessor"));
        }
        return descriptor2 instanceof AccessorForCallableDescriptor;
    }

    public static boolean isStaticAccessor(@NotNull CallableMemberDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "isStaticAccessor"));
        }
        if (descriptor2 instanceof AccessorForConstructorDescriptor) {
            return false;
        }
        return KotlinTypeMapper.isAccessor(descriptor2);
    }

    @NotNull
    private static FunctionDescriptor findAnyDeclaration(@NotNull FunctionDescriptor function2) {
        if (function2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "findAnyDeclaration"));
        }
        if (function2.getKind() == CallableMemberDescriptor.Kind.DECLARATION) {
            FunctionDescriptor functionDescriptor2 = function2;
            if (functionDescriptor2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "findAnyDeclaration"));
            }
            return functionDescriptor2;
        }
        FunctionDescriptor functionDescriptor3 = KotlinTypeMapper.findBaseDeclaration(function2);
        if (functionDescriptor3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "findAnyDeclaration"));
        }
        return functionDescriptor3;
    }

    @NotNull
    private static FunctionDescriptor findBaseDeclaration(@NotNull FunctionDescriptor function2) {
        if (function2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "findBaseDeclaration"));
        }
        if (function2.getOverriddenDescriptors().isEmpty()) {
            FunctionDescriptor functionDescriptor2 = function2;
            if (functionDescriptor2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "findBaseDeclaration"));
            }
            return functionDescriptor2;
        }
        FunctionDescriptor functionDescriptor3 = KotlinTypeMapper.findBaseDeclaration(function2.getOverriddenDescriptors().iterator().next());
        if (functionDescriptor3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "findBaseDeclaration"));
        }
        return functionDescriptor3;
    }

    @NotNull
    private String mapFunctionName(@NotNull FunctionDescriptor descriptor2) {
        String platformName;
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapFunctionName"));
        }
        if (!(descriptor2 instanceof JavaCallableMemberDescriptor) && (platformName = DescriptorUtils.getJvmName(descriptor2)) != null) {
            String string = platformName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapFunctionName"));
            }
            return string;
        }
        String nameForSpecialFunction = SpecialBuiltinMembers.getJvmMethodNameIfSpecial(descriptor2);
        if (nameForSpecialFunction != null) {
            String string = nameForSpecialFunction;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapFunctionName"));
            }
            return string;
        }
        if (descriptor2 instanceof PropertyAccessorDescriptor) {
            PropertyDescriptor property2 = ((PropertyAccessorDescriptor)descriptor2).getCorrespondingProperty();
            if (DescriptorUtils.isAnnotationClass(property2.getContainingDeclaration())) {
                String string = property2.getName().asString();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapFunctionName"));
                }
                return string;
            }
            boolean isAccessor = property2 instanceof AccessorForPropertyDescriptor;
            String propertyName = isAccessor ? ((AccessorForPropertyDescriptor)property2).getAccessorSuffix() : property2.getName().asString();
            String accessorName = descriptor2 instanceof PropertyGetterDescriptor ? JvmAbi.getterName(propertyName) : JvmAbi.setterName(propertyName);
            String string = this.mangleMemberNameIfRequired(isAccessor ? "access$" + accessorName : accessorName, descriptor2);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapFunctionName"));
            }
            return string;
        }
        if (ExpressionTypingUtils.isFunctionLiteral(descriptor2)) {
            SamType samType;
            PsiElement expression2;
            PsiElement element2 = DescriptorToSourceUtils.getSourceFromDescriptor(descriptor2);
            if (element2 instanceof KtFunctionLiteral && (expression2 = element2.getParent()) instanceof KtLambdaExpression && (samType = this.bindingContext.get(CodegenBinding.SAM_VALUE, (KtExpression)expression2)) != null) {
                String string = samType.getAbstractMethod().getName().asString();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapFunctionName"));
                }
                return string;
            }
            String string = OperatorNameConventions.INVOKE.asString();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapFunctionName"));
            }
            return string;
        }
        if (ExpressionTypingUtils.isLocalFunction(descriptor2) || ExpressionTypingUtils.isFunctionExpression(descriptor2)) {
            String string = OperatorNameConventions.INVOKE.asString();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapFunctionName"));
            }
            return string;
        }
        String string = this.mangleMemberNameIfRequired(descriptor2.getName().asString(), descriptor2);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapFunctionName"));
        }
        return string;
    }

    @NotNull
    private static OwnerKind getKindForDefaultImplCall(@NotNull FunctionDescriptor baseMethodDescriptor) {
        if (baseMethodDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseMethodDescriptor", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "getKindForDefaultImplCall"));
        }
        DeclarationDescriptor containingDeclaration = baseMethodDescriptor.getContainingDeclaration();
        if (containingDeclaration instanceof PackageFragmentDescriptor) {
            OwnerKind ownerKind = OwnerKind.PACKAGE;
            if (ownerKind == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "getKindForDefaultImplCall"));
            }
            return ownerKind;
        }
        if (DescriptorUtils.isInterface(containingDeclaration)) {
            OwnerKind ownerKind = OwnerKind.DEFAULT_IMPLS;
            if (ownerKind == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "getKindForDefaultImplCall"));
            }
            return ownerKind;
        }
        OwnerKind ownerKind = OwnerKind.IMPLEMENTATION;
        if (ownerKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "getKindForDefaultImplCall"));
        }
        return ownerKind;
    }

    @NotNull
    public static String mapDefaultFieldName(@NotNull PropertyDescriptor propertyDescriptor, boolean isDelegated) {
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapDefaultFieldName"));
        }
        String name2 = propertyDescriptor instanceof AccessorForPropertyDescriptor ? ((AccessorForPropertyDescriptor)propertyDescriptor).getCalleeDescriptor().getName().asString() : propertyDescriptor.getName().asString();
        String string = isDelegated ? name2 + "$delegate" : name2;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapDefaultFieldName"));
        }
        return string;
    }

    @NotNull
    private String mangleMemberNameIfRequired(@NotNull String name2, @NotNull CallableMemberDescriptor descriptor2) {
        if (name2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mangleMemberNameIfRequired"));
        }
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mangleMemberNameIfRequired"));
        }
        if (descriptor2.getContainingDeclaration() instanceof ScriptDescriptor) {
            String string = name2;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mangleMemberNameIfRequired"));
            }
            return string;
        }
        if (DescriptorUtils.isTopLevelDeclaration(descriptor2)) {
            String partName;
            if (Visibilities.isPrivate(descriptor2.getVisibility()) && !(descriptor2 instanceof ConstructorDescriptor) && !"<clinit>".equals(name2) && (partName = this.getPartSimpleNameForMangling(descriptor2)) != null) {
                String string = name2 + "$" + partName;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mangleMemberNameIfRequired"));
                }
                return string;
            }
            String string = name2;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mangleMemberNameIfRequired"));
            }
            return string;
        }
        if (!(descriptor2 instanceof ConstructorDescriptor) && descriptor2.getVisibility() == Visibilities.INTERNAL && !DescriptorUtilsKt.isPublishedApi(descriptor2)) {
            String string = name2 + "$" + NameUtils.sanitizeAsJavaIdentifier(this.moduleName);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mangleMemberNameIfRequired"));
            }
            return string;
        }
        String string = name2;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mangleMemberNameIfRequired"));
        }
        return string;
    }

    @Nullable
    private String getPartSimpleNameForMangling(@NotNull CallableMemberDescriptor descriptor2) {
        String implShortName;
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "getPartSimpleNameForMangling"));
        }
        KtFile containingFile = DescriptorToSourceUtils.getContainingFile(descriptor2);
        if (containingFile != null) {
            JvmFileClassInfo fileClassInfo = JvmFileClassUtil.getFileClassInfoNoResolve(containingFile);
            if (fileClassInfo.getWithJvmMultifileClass()) {
                return fileClassInfo.getFileClassFqName().shortName().asString();
            }
            return null;
        }
        descriptor2 = DescriptorUtils.getDirectMember(descriptor2);
        assert (descriptor2 instanceof DeserializedCallableMemberDescriptor) : "Descriptor without sources should be instance of DeserializedCallableMemberDescriptor, but: " + descriptor2;
        ContainingClassesInfo containingClassesInfo = this.getContainingClassesForDeserializedCallable((DeserializedCallableMemberDescriptor)descriptor2);
        String facadeShortName = containingClassesInfo.getFacadeClassId().getShortClassName().asString();
        return !facadeShortName.equals(implShortName = containingClassesInfo.getImplClassId().getShortClassName().asString()) ? implShortName : null;
    }

    @NotNull
    public Method mapAsmMethod(@NotNull FunctionDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapAsmMethod"));
        }
        Method method = this.mapSignature(descriptor2, true).getAsmMethod();
        if (method == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapAsmMethod"));
        }
        return method;
    }

    @NotNull
    public Method mapAsmMethod(@NotNull FunctionDescriptor descriptor2, @NotNull OwnerKind kind2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapAsmMethod"));
        }
        if (kind2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapAsmMethod"));
        }
        Method method = this.mapSignature(descriptor2, kind2, true).getAsmMethod();
        if (method == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapAsmMethod"));
        }
        return method;
    }

    @NotNull
    private JvmMethodGenericSignature mapSignature(@NotNull FunctionDescriptor f, boolean skipGenericSignature) {
        if (f == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "f", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapSignature"));
        }
        JvmMethodGenericSignature jvmMethodGenericSignature = this.mapSignature(f, OwnerKind.IMPLEMENTATION, skipGenericSignature);
        if (jvmMethodGenericSignature == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapSignature"));
        }
        return jvmMethodGenericSignature;
    }

    @NotNull
    public JvmMethodSignature mapSignatureSkipGeneric(@NotNull FunctionDescriptor f) {
        if (f == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "f", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapSignatureSkipGeneric"));
        }
        JvmMethodSignature jvmMethodSignature = this.mapSignatureSkipGeneric(f, OwnerKind.IMPLEMENTATION);
        if (jvmMethodSignature == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapSignatureSkipGeneric"));
        }
        return jvmMethodSignature;
    }

    @NotNull
    public JvmMethodSignature mapSignatureSkipGeneric(@NotNull FunctionDescriptor f, @NotNull OwnerKind kind2) {
        if (f == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "f", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapSignatureSkipGeneric"));
        }
        if (kind2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapSignatureSkipGeneric"));
        }
        JvmMethodGenericSignature jvmMethodGenericSignature = this.mapSignature(f, kind2, true);
        if (jvmMethodGenericSignature == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapSignatureSkipGeneric"));
        }
        return jvmMethodGenericSignature;
    }

    @NotNull
    public JvmMethodGenericSignature mapSignatureWithGeneric(@NotNull FunctionDescriptor f, @NotNull OwnerKind kind2) {
        if (f == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "f", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapSignatureWithGeneric"));
        }
        if (kind2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapSignatureWithGeneric"));
        }
        JvmMethodGenericSignature jvmMethodGenericSignature = this.mapSignature(f, kind2, false);
        if (jvmMethodGenericSignature == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapSignatureWithGeneric"));
        }
        return jvmMethodGenericSignature;
    }

    @NotNull
    private JvmMethodGenericSignature mapSignature(@NotNull FunctionDescriptor f, @NotNull OwnerKind kind2, boolean skipGenericSignature) {
        if (f == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "f", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapSignature"));
        }
        if (kind2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapSignature"));
        }
        if (f.getInitialSignatureDescriptor() != null && f != f.getInitialSignatureDescriptor() && (SpecialBuiltinMembers.getOverriddenBuiltinReflectingJvmDescriptor(f) == null || f.getContainingDeclaration().getOriginal() instanceof JavaClassDescriptor)) {
            JvmMethodGenericSignature jvmMethodGenericSignature = this.mapSignature(f.getInitialSignatureDescriptor(), kind2, skipGenericSignature);
            if (jvmMethodGenericSignature == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapSignature"));
            }
            return jvmMethodGenericSignature;
        }
        if (CoroutineCodegenUtilKt.isSuspendFunctionNotSuspensionView(f)) {
            JvmMethodGenericSignature jvmMethodGenericSignature = this.mapSignature(CoroutineCodegenUtilKt.getOrCreateJvmSuspendFunctionView(f), kind2, skipGenericSignature);
            if (jvmMethodGenericSignature == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapSignature"));
            }
            return jvmMethodGenericSignature;
        }
        if (f instanceof ConstructorDescriptor) {
            JvmMethodGenericSignature jvmMethodGenericSignature = this.mapSignature(f, kind2, f.getOriginal().getValueParameters(), skipGenericSignature);
            if (jvmMethodGenericSignature == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapSignature"));
            }
            return jvmMethodGenericSignature;
        }
        JvmMethodGenericSignature jvmMethodGenericSignature = this.mapSignature(f, kind2, f.getValueParameters(), skipGenericSignature);
        if (jvmMethodGenericSignature == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapSignature"));
        }
        return jvmMethodGenericSignature;
    }

    @NotNull
    public JvmMethodGenericSignature mapSignature(@NotNull FunctionDescriptor f, @NotNull OwnerKind kind2, @NotNull List<ValueParameterDescriptor> valueParameters, boolean skipGenericSignature) {
        BuiltinMethodsWithSpecialGenericSignature.SpecialSignatureInfo specialSignatureInfo;
        JvmSignatureWriter sw;
        if (f == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "f", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapSignature"));
        }
        if (kind2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapSignature"));
        }
        if (valueParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueParameters", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapSignature"));
        }
        if (f instanceof FunctionImportedFromObject) {
            JvmMethodGenericSignature jvmMethodGenericSignature = this.mapSignature((FunctionDescriptor)((FunctionImportedFromObject)f).getCallableFromObject(), kind2, skipGenericSignature);
            if (jvmMethodGenericSignature == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapSignature"));
            }
            return jvmMethodGenericSignature;
        }
        if (f instanceof TypeAliasConstructorDescriptor) {
            JvmMethodGenericSignature jvmMethodGenericSignature = this.mapSignature(((TypeAliasConstructorDescriptor)f).getUnderlyingConstructorDescriptor(), kind2, valueParameters, skipGenericSignature);
            if (jvmMethodGenericSignature == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapSignature"));
            }
            return jvmMethodGenericSignature;
        }
        this.checkOwnerCompatibility(f);
        JvmSignatureWriter jvmSignatureWriter = sw = skipGenericSignature || f instanceof AccessorForCallableDescriptor ? new JvmSignatureWriter() : new BothSignatureWriter(BothSignatureWriter.Mode.METHOD);
        if (f instanceof ClassConstructorDescriptor) {
            sw.writeParametersStart();
            this.writeAdditionalConstructorParameters((ClassConstructorDescriptor)f, sw);
            for (ValueParameterDescriptor parameter : valueParameters) {
                this.writeParameter(sw, parameter.getType(), f);
            }
            if (f instanceof AccessorForConstructorDescriptor) {
                KotlinTypeMapper.writeParameter(sw, JvmMethodParameterKind.CONSTRUCTOR_MARKER, AsmTypes.DEFAULT_CONSTRUCTOR_MARKER);
            }
            KotlinTypeMapper.writeVoidReturn(sw);
        } else {
            ReceiverParameterDescriptor receiverParameter;
            CallableMemberDescriptor directMember = DescriptorUtils.getDirectMember(f);
            KotlinType thisIfNeeded = null;
            if (OwnerKind.DEFAULT_IMPLS == kind2) {
                ReceiverTypeAndTypeParameters receiverTypeAndTypeParameters = TypeMapperUtilsKt.patchTypeParametersForDefaultImplMethod(directMember);
                this.writeFormalTypeParameters(CollectionsKt.plus(receiverTypeAndTypeParameters.getTypeParameters(), directMember.getTypeParameters()), sw);
                thisIfNeeded = receiverTypeAndTypeParameters.getReceiverType();
            } else {
                this.writeFormalTypeParameters(directMember.getTypeParameters(), sw);
                if (KotlinTypeMapper.isAccessor(f) && f.getDispatchReceiverParameter() != null) {
                    thisIfNeeded = ((ClassDescriptor)f.getContainingDeclaration()).getDefaultType();
                }
            }
            sw.writeParametersStart();
            if (thisIfNeeded != null) {
                this.writeParameter(sw, JvmMethodParameterKind.THIS, thisIfNeeded, f);
            }
            if ((receiverParameter = f.getExtensionReceiverParameter()) != null) {
                this.writeParameter(sw, JvmMethodParameterKind.RECEIVER, receiverParameter.getType(), f);
            }
            for (ValueParameterDescriptor parameter : valueParameters) {
                boolean forceBoxing = MethodSignatureMappingKt.forceSingleValueParameterBoxing(f);
                this.writeParameter(sw, forceBoxing ? TypeUtils.makeNullable(parameter.getType()) : parameter.getType(), f);
            }
            sw.writeReturnType();
            this.mapReturnType(f, sw);
            sw.writeReturnTypeEnd();
        }
        JvmMethodGenericSignature signature = sw.makeJvmMethodSignature(this.mapFunctionName(f));
        if (kind2 != OwnerKind.DEFAULT_IMPLS && (specialSignatureInfo = BuiltinMethodsWithSpecialGenericSignature.getSpecialSignatureInfo(f)) != null) {
            String newGenericSignature = CodegenUtilKt.replaceValueParametersIn(specialSignatureInfo, signature.getGenericsSignature());
            JvmMethodGenericSignature jvmMethodGenericSignature = new JvmMethodGenericSignature(signature.getAsmMethod(), signature.getValueParameters(), newGenericSignature);
            if (jvmMethodGenericSignature == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapSignature"));
            }
            return jvmMethodGenericSignature;
        }
        JvmMethodGenericSignature jvmMethodGenericSignature = signature;
        if (jvmMethodGenericSignature == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapSignature"));
        }
        return jvmMethodGenericSignature;
    }

    private void checkOwnerCompatibility(@NotNull FunctionDescriptor descriptor2) {
        JvmBytecodeBinaryVersion version;
        SourceElement source;
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "checkOwnerCompatibility"));
        }
        if (!(descriptor2 instanceof DeserializedCallableMemberDescriptor)) {
            return;
        }
        KotlinJvmBinaryClass ownerClass = null;
        DeclarationDescriptor container2 = descriptor2.getContainingDeclaration();
        if (container2 instanceof DeserializedClassDescriptor) {
            source = ((DeserializedClassDescriptor)container2).getSource();
            if (source instanceof KotlinJvmBinarySourceElement) {
                ownerClass = ((KotlinJvmBinarySourceElement)source).getBinaryClass();
            }
        } else if (container2 instanceof LazyJavaPackageFragment && (source = ((LazyJavaPackageFragment)container2).getSource()) instanceof KotlinJvmBinaryPackageSourceElement) {
            ownerClass = ((KotlinJvmBinaryPackageSourceElement)source).getRepresentativeBinaryClass();
        }
        if (ownerClass != null && !(version = ownerClass.getClassHeader().getBytecodeVersion()).isCompatible()) {
            this.incompatibleClassTracker.record(ownerClass);
        }
    }

    @NotNull
    private static String getDefaultDescriptor(@NotNull Method method, @Nullable String dispatchReceiverDescriptor, boolean isExtension) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "getDefaultDescriptor"));
        }
        String descriptor2 = method.getDescriptor();
        int argumentsCount = Type.getArgumentTypes((String)descriptor2).length;
        if (isExtension) {
            --argumentsCount;
        }
        int maskArgumentsCount = (argumentsCount + 32 - 1) / 32;
        String additionalArgs = StringUtil.repeat((String)Type.INT_TYPE.getDescriptor(), (int)maskArgumentsCount);
        additionalArgs = additionalArgs + (KotlinTypeMapper.isConstructor(method) ? AsmTypes.DEFAULT_CONSTRUCTOR_MARKER : AsmTypes.OBJECT_TYPE).getDescriptor();
        String result2 = descriptor2.replace(")", additionalArgs + ")");
        if (dispatchReceiverDescriptor != null && !KotlinTypeMapper.isConstructor(method)) {
            String string = result2.replace("(", "(" + dispatchReceiverDescriptor);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "getDefaultDescriptor"));
            }
            return string;
        }
        String string = result2;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "getDefaultDescriptor"));
        }
        return string;
    }

    public ClassBuilderMode getClassBuilderMode() {
        return this.classBuilderMode;
    }

    private static boolean isConstructor(@NotNull Method method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "isConstructor"));
        }
        return "<init>".equals(method.getName());
    }

    @NotNull
    public Method mapDefaultMethod(@NotNull FunctionDescriptor functionDescriptor2, @NotNull OwnerKind kind2) {
        if (functionDescriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapDefaultMethod"));
        }
        if (kind2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapDefaultMethod"));
        }
        Method jvmSignature = this.mapAsmMethod(functionDescriptor2, kind2);
        Type ownerType = this.mapOwner(functionDescriptor2);
        boolean isConstructor = KotlinTypeMapper.isConstructor(jvmSignature);
        String descriptor2 = KotlinTypeMapper.getDefaultDescriptor(jvmSignature, AsmUtil.isStaticMethod(kind2, functionDescriptor2) || isConstructor ? null : ownerType.getDescriptor(), functionDescriptor2.getExtensionReceiverParameter() != null);
        Method method = new Method(isConstructor ? "<init>" : jvmSignature.getName() + "$default", descriptor2);
        if (method == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapDefaultMethod"));
        }
        return method;
    }

    private static boolean forceBoxedReturnType(@NotNull FunctionDescriptor descriptor2) {
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "forceBoxedReturnType"));
        }
        if (!KotlinBuiltIns.isPrimitiveType(descriptor2.getReturnType())) {
            return false;
        }
        for (FunctionDescriptor overridden : DescriptorUtils.getAllOverriddenDescriptors(descriptor2)) {
            if (KotlinBuiltIns.isPrimitiveType(overridden.getReturnType())) continue;
            return true;
        }
        return false;
    }

    private static void writeVoidReturn(@NotNull JvmSignatureWriter sw) {
        if (sw == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sw", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "writeVoidReturn"));
        }
        sw.writeReturnType();
        sw.writeAsmType(Type.VOID_TYPE);
        sw.writeReturnTypeEnd();
    }

    @Nullable
    public String mapFieldSignature(@NotNull KotlinType backingFieldType, @NotNull PropertyDescriptor propertyDescriptor) {
        if (backingFieldType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "backingFieldType", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapFieldSignature"));
        }
        if (propertyDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyDescriptor", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapFieldSignature"));
        }
        BothSignatureWriter sw = new BothSignatureWriter(BothSignatureWriter.Mode.TYPE);
        if (!propertyDescriptor.isVar()) {
            this.mapReturnType(propertyDescriptor, sw, backingFieldType);
        } else {
            this.writeParameterType(sw, backingFieldType, propertyDescriptor);
        }
        return ((JvmSignatureWriter)sw).makeJavaGenericSignature();
    }

    public void writeFormalTypeParameters(@NotNull List<TypeParameterDescriptor> typeParameters, @NotNull JvmSignatureWriter sw) {
        if (typeParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameters", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "writeFormalTypeParameters"));
        }
        if (sw == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sw", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "writeFormalTypeParameters"));
        }
        if (sw.skipGenericSignature()) {
            return;
        }
        for (TypeParameterDescriptor typeParameter : typeParameters) {
            this.writeFormalTypeParameter(typeParameter, sw);
        }
    }

    private void writeFormalTypeParameter(@NotNull TypeParameterDescriptor typeParameterDescriptor, @NotNull JvmSignatureWriter sw) {
        if (typeParameterDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeParameterDescriptor", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "writeFormalTypeParameter"));
        }
        if (sw == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sw", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "writeFormalTypeParameter"));
        }
        if (!this.classBuilderMode.generateBodies && typeParameterDescriptor.getName().isSpecial()) {
            return;
        }
        sw.writeFormalTypeParameter(typeParameterDescriptor.getName().asString());
        sw.writeClassBound();
        for (KotlinType jetType : typeParameterDescriptor.getUpperBounds()) {
            if (!(jetType.getConstructor().getDeclarationDescriptor() instanceof ClassDescriptor) || JvmCodegenUtil.isJvmInterface(jetType)) continue;
            this.mapType(jetType, sw, TypeMappingMode.GENERIC_ARGUMENT);
            break;
        }
        sw.writeClassBoundEnd();
        for (KotlinType jetType : typeParameterDescriptor.getUpperBounds()) {
            ClassifierDescriptor classifier = jetType.getConstructor().getDeclarationDescriptor();
            if (classifier instanceof ClassDescriptor) {
                if (!JvmCodegenUtil.isJvmInterface(jetType)) continue;
                sw.writeInterfaceBound();
                this.mapType(jetType, sw, TypeMappingMode.GENERIC_ARGUMENT);
                sw.writeInterfaceBoundEnd();
                continue;
            }
            if (classifier instanceof TypeParameterDescriptor) {
                sw.writeInterfaceBound();
                this.mapType(jetType, sw, TypeMappingMode.GENERIC_ARGUMENT);
                sw.writeInterfaceBoundEnd();
                continue;
            }
            throw new UnsupportedOperationException("Unknown classifier: " + classifier);
        }
    }

    private void writeParameter(@NotNull JvmSignatureWriter sw, @NotNull KotlinType type2, @Nullable CallableDescriptor callableDescriptor) {
        if (sw == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sw", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "writeParameter"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "writeParameter"));
        }
        this.writeParameter(sw, JvmMethodParameterKind.VALUE, type2, callableDescriptor);
    }

    private void writeParameter(@NotNull JvmSignatureWriter sw, @NotNull JvmMethodParameterKind kind2, @NotNull KotlinType type2, @Nullable CallableDescriptor callableDescriptor) {
        if (sw == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sw", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "writeParameter"));
        }
        if (kind2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "writeParameter"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "writeParameter"));
        }
        sw.writeParameterType(kind2);
        this.writeParameterType(sw, type2, callableDescriptor);
        sw.writeParameterTypeEnd();
    }

    private void writeParameterType(@NotNull JvmSignatureWriter sw, @NotNull KotlinType type2, @Nullable CallableDescriptor callableDescriptor) {
        if (sw == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sw", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "writeParameterType"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "writeParameterType"));
        }
        if (sw.skipGenericSignature()) {
            this.mapType(type2, sw, TypeMappingMode.DEFAULT);
            return;
        }
        TypeMappingMode typeMappingModeFromAnnotation = TypeMappingUtil.extractTypeMappingModeFromAnnotation(callableDescriptor, type2, false);
        TypeMappingMode typeMappingMode = typeMappingModeFromAnnotation != null ? typeMappingModeFromAnnotation : (TypeMappingUtil.isMethodWithDeclarationSiteWildcards(callableDescriptor) && !type2.getArguments().isEmpty() ? TypeMappingMode.GENERIC_ARGUMENT : TypeMappingMode.getOptimalModeForValueParameter(type2));
        this.mapType(type2, sw, typeMappingMode);
    }

    private static void writeParameter(@NotNull JvmSignatureWriter sw, @NotNull JvmMethodParameterKind kind2, @NotNull Type type2) {
        if (sw == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sw", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "writeParameter"));
        }
        if (kind2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "writeParameter"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "writeParameter"));
        }
        sw.writeParameterType(kind2);
        sw.writeAsmType(type2);
        sw.writeParameterTypeEnd();
    }

    private void writeAdditionalConstructorParameters(@NotNull ClassConstructorDescriptor descriptor2, @NotNull JvmSignatureWriter sw) {
        KotlinType captureReceiverType;
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "writeAdditionalConstructorParameters"));
        }
        if (sw == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sw", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "writeAdditionalConstructorParameters"));
        }
        boolean isSynthesized = descriptor2.getKind() == CallableMemberDescriptor.Kind.SYNTHESIZED;
        MutableClosure closure = this.bindingContext.get(CodegenBinding.CLOSURE, descriptor2.getContainingDeclaration());
        ClassDescriptor captureThis = JvmCodegenUtil.getDispatchReceiverParameterForConstructorCall(descriptor2, closure);
        if (!isSynthesized && captureThis != null) {
            this.writeParameter(sw, JvmMethodParameterKind.OUTER, captureThis.getDefaultType(), descriptor2);
        }
        KotlinType kotlinType = captureReceiverType = closure != null ? closure.getCaptureReceiverType() : null;
        if (captureReceiverType != null) {
            this.writeParameter(sw, JvmMethodParameterKind.RECEIVER, captureReceiverType, descriptor2);
        }
        ClassDescriptor containingDeclaration = descriptor2.getContainingDeclaration();
        if (!(isSynthesized || containingDeclaration.getKind() != ClassKind.ENUM_CLASS && containingDeclaration.getKind() != ClassKind.ENUM_ENTRY)) {
            this.writeParameter(sw, JvmMethodParameterKind.ENUM_NAME_OR_ORDINAL, DescriptorUtilsKt.getBuiltIns(descriptor2).getStringType(), descriptor2);
            this.writeParameter(sw, JvmMethodParameterKind.ENUM_NAME_OR_ORDINAL, DescriptorUtilsKt.getBuiltIns(descriptor2).getIntType(), descriptor2);
        }
        if (closure == null) {
            return;
        }
        for (DeclarationDescriptor variableDescriptor : closure.getCaptureVariables().keySet()) {
            Type type2;
            if (variableDescriptor instanceof VariableDescriptor && !(variableDescriptor instanceof PropertyDescriptor)) {
                Type sharedVarType = this.getSharedVarType(variableDescriptor);
                if (sharedVarType == null) {
                    if (JvmCodegenUtil.isDelegatedLocalVariable(variableDescriptor)) {
                        VariableDescriptor delegateVariableDescriptor = this.bindingContext.get(CodegenBinding.LOCAL_VARIABLE_DELEGATE, (VariableDescriptor)variableDescriptor);
                        assert (delegateVariableDescriptor != null) : "Local delegated property " + variableDescriptor + " delegate descriptor should be not null";
                        sharedVarType = this.mapType(delegateVariableDescriptor.getType());
                    } else {
                        sharedVarType = this.mapType(((VariableDescriptor)variableDescriptor).getType());
                    }
                }
                type2 = sharedVarType;
            } else {
                type2 = ExpressionTypingUtils.isLocalFunction(variableDescriptor) ? CodegenBinding.asmTypeForAnonymousClass(this.bindingContext, (FunctionDescriptor)variableDescriptor) : null;
            }
            if (type2 == null) continue;
            closure.setCapturedParameterOffsetInConstructor(variableDescriptor, sw.getCurrentSignatureSize() + 1);
            KotlinTypeMapper.writeParameter(sw, JvmMethodParameterKind.CAPTURED_LOCAL_VARIABLE, type2);
        }
        if (this.classBuilderMode.generateBodies) {
            ResolvedCall<ConstructorDescriptor> superCall = this.findFirstDelegatingSuperCall(descriptor2);
            if (superCall == null) {
                return;
            }
            this.writeSuperConstructorCallParameters(sw, descriptor2, superCall, captureThis != null);
        }
    }

    private void writeSuperConstructorCallParameters(@NotNull JvmSignatureWriter sw, @NotNull ClassConstructorDescriptor descriptor2, @NotNull ResolvedCall<ConstructorDescriptor> superCall, boolean hasOuter) {
        int i;
        if (sw == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sw", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "writeSuperConstructorCallParameters"));
        }
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "writeSuperConstructorCallParameters"));
        }
        if (superCall == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "superCall", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "writeSuperConstructorCallParameters"));
        }
        ConstructorDescriptor superDescriptor = (ConstructorDescriptor)SamCodegenUtil.resolveSamAdapter((FunctionDescriptor)superCall.getResultingDescriptor());
        List<ResolvedValueArgument> valueArguments2 = superCall.getValueArgumentsByIndex();
        assert (valueArguments2 != null) : "Failed to arrange value arguments by index: " + superDescriptor;
        List<JvmMethodParameterSignature> parameters2 = this.mapSignatureSkipGeneric(superDescriptor).getValueParameters();
        int params2 = parameters2.size();
        int args = valueArguments2.size();
        assert (params2 >= args) : String.format("Incorrect number of mapped parameters vs arguments: %d < %d for %s", params2, args, descriptor2);
        for (i = 0; i < params2 - args; ++i) {
            JvmMethodParameterSignature parameter = parameters2.get(i);
            JvmMethodParameterKind kind2 = parameter.getKind();
            if (kind2 == JvmMethodParameterKind.ENUM_NAME_OR_ORDINAL || hasOuter && kind2 == JvmMethodParameterKind.OUTER) continue;
            KotlinTypeMapper.writeParameter(sw, JvmMethodParameterKind.SUPER_CALL_PARAM, parameter.getAsmType());
        }
        if (DescriptorUtils.isAnonymousObject(descriptor2.getContainingDeclaration())) {
            for (i = 0; i < args; ++i) {
                ResolvedValueArgument valueArgument = valueArguments2.get(i);
                JvmMethodParameterSignature parameter = parameters2.get(params2 - args + i);
                if (valueArgument instanceof DefaultValueArgument) continue;
                KotlinTypeMapper.writeParameter(sw, JvmMethodParameterKind.SUPER_CALL_PARAM, parameter.getAsmType());
            }
        }
    }

    @Nullable
    private ResolvedCall<ConstructorDescriptor> findFirstDelegatingSuperCall(@NotNull ConstructorDescriptor descriptor2) {
        ResolvedCall<ConstructorDescriptor> next2;
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "findFirstDelegatingSuperCall"));
        }
        ClassifierDescriptorWithTypeParameters constructorOwner = descriptor2.getContainingDeclaration();
        do {
            if ((next2 = BindingContextUtils.getDelegationConstructorCall(this.bindingContext, descriptor2)) != null) continue;
            return null;
        } while ((descriptor2 = next2.getResultingDescriptor()).getContainingDeclaration() == constructorOwner);
        return next2;
    }

    @NotNull
    public JvmMethodSignature mapScriptSignature(@NotNull ScriptDescriptor script, @NotNull List<ScriptDescriptor> importedScripts) {
        if (script == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "script", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapScriptSignature"));
        }
        if (importedScripts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importedScripts", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapScriptSignature"));
        }
        BothSignatureWriter sw = new BothSignatureWriter(BothSignatureWriter.Mode.METHOD);
        ((JvmSignatureWriter)sw).writeParametersStart();
        for (ScriptDescriptor importedScript : importedScripts) {
            this.writeParameter(sw, importedScript.getDefaultType(), null);
        }
        for (ValueParameterDescriptor valueParameter : script.getUnsubstitutedPrimaryConstructor().getValueParameters()) {
            this.writeParameter(sw, valueParameter.getType(), null);
        }
        KotlinTypeMapper.writeVoidReturn(sw);
        JvmMethodGenericSignature jvmMethodGenericSignature = sw.makeJvmMethodSignature("<init>");
        if (jvmMethodGenericSignature == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper", "mapScriptSignature"));
        }
        return jvmMethodGenericSignature;
    }

    public Type getSharedVarType(DeclarationDescriptor descriptor2) {
        if (descriptor2 instanceof SimpleFunctionDescriptor && descriptor2.getContainingDeclaration() instanceof FunctionDescriptor) {
            return CodegenBinding.asmTypeForAnonymousClass(this.bindingContext, (FunctionDescriptor)descriptor2);
        }
        if (descriptor2 instanceof PropertyDescriptor || descriptor2 instanceof FunctionDescriptor) {
            ReceiverParameterDescriptor receiverParameter = ((CallableDescriptor)descriptor2).getExtensionReceiverParameter();
            assert (receiverParameter != null) : "Callable should have a receiver parameter: " + descriptor2;
            return StackValue.sharedTypeForType(this.mapType(receiverParameter.getType()));
        }
        if (descriptor2 instanceof LocalVariableDescriptor && ((LocalVariableDescriptor)descriptor2).isDelegated()) {
            return null;
        }
        if (descriptor2 instanceof VariableDescriptor && BindingContextUtils.isVarCapturedInClosure(this.bindingContext, descriptor2)) {
            return StackValue.sharedTypeForType(this.mapType(((VariableDescriptor)descriptor2).getType()));
        }
        return null;
    }

    public static class ContainingClassesInfo {
        private final ClassId facadeClassId;
        private final ClassId implClassId;

        public ContainingClassesInfo(@NotNull ClassId facadeClassId, @NotNull ClassId implClassId) {
            if (facadeClassId == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facadeClassId", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper$ContainingClassesInfo", "<init>"));
            }
            if (implClassId == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "implClassId", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper$ContainingClassesInfo", "<init>"));
            }
            this.facadeClassId = facadeClassId;
            this.implClassId = implClassId;
        }

        @NotNull
        public ClassId getFacadeClassId() {
            ClassId classId = this.facadeClassId;
            if (classId == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper$ContainingClassesInfo", "getFacadeClassId"));
            }
            return classId;
        }

        @NotNull
        public ClassId getImplClassId() {
            ClassId classId = this.implClassId;
            if (classId == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper$ContainingClassesInfo", "getImplClassId"));
            }
            return classId;
        }

        @Nullable
        private static ContainingClassesInfo forPackageMember(@NotNull FqName packageFqName, @NotNull String facadeClassName, @NotNull String implClassName) {
            if (packageFqName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageFqName", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper$ContainingClassesInfo", "forPackageMember"));
            }
            if (facadeClassName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facadeClassName", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper$ContainingClassesInfo", "forPackageMember"));
            }
            if (implClassName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "implClassName", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper$ContainingClassesInfo", "forPackageMember"));
            }
            return new ContainingClassesInfo(ClassId.topLevel(packageFqName.child(Name.identifier(facadeClassName))), ClassId.topLevel(packageFqName.child(Name.identifier(implClassName))));
        }

        @NotNull
        private static ContainingClassesInfo forClassMember(@NotNull ClassId classId) {
            if (classId == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classId", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper$ContainingClassesInfo", "forClassMember"));
            }
            ContainingClassesInfo containingClassesInfo = new ContainingClassesInfo(classId, classId);
            if (containingClassesInfo == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/codegen/state/KotlinTypeMapper$ContainingClassesInfo", "forClassMember"));
            }
            return containingClassesInfo;
        }
    }
}

