/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.compilerRunner;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ComparatorUtil;
import com.sampullara.cli.Argument;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;

public class ArgumentUtils {
    private ArgumentUtils() {
    }

    @NotNull
    public static List<String> convertArgumentsToStringList(@NotNull CommonCompilerArguments arguments2) throws InstantiationException, IllegalAccessException {
        if (arguments2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "org/jetbrains/kotlin/compilerRunner/ArgumentUtils", "convertArgumentsToStringList"));
        }
        ArrayList<String> result2 = new ArrayList<String>();
        ArgumentUtils.convertArgumentsToStringList(arguments2, (CommonCompilerArguments)arguments2.getClass().newInstance(), arguments2.getClass(), result2);
        result2.addAll(arguments2.freeArgs);
        ArrayList<String> arrayList = result2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/compilerRunner/ArgumentUtils", "convertArgumentsToStringList"));
        }
        return arrayList;
    }

    private static void convertArgumentsToStringList(@NotNull CommonCompilerArguments arguments2, @NotNull CommonCompilerArguments defaultArguments, @NotNull Class<?> clazz, @NotNull List<String> result2) throws IllegalAccessException, InstantiationException {
        if (arguments2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "org/jetbrains/kotlin/compilerRunner/ArgumentUtils", "convertArgumentsToStringList"));
        }
        if (defaultArguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultArguments", "org/jetbrains/kotlin/compilerRunner/ArgumentUtils", "convertArgumentsToStringList"));
        }
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "org/jetbrains/kotlin/compilerRunner/ArgumentUtils", "convertArgumentsToStringList"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/kotlin/compilerRunner/ArgumentUtils", "convertArgumentsToStringList"));
        }
        for (Field field2 : clazz.getDeclaredFields()) {
            Class<?> fieldType;
            Object defaultValue;
            Object value2;
            Argument argument2 = field2.getAnnotation(Argument.class);
            if (argument2 == null) continue;
            try {
                value2 = field2.get(arguments2);
                defaultValue = field2.get(defaultArguments);
            }
            catch (IllegalAccessException ignored) {
                continue;
            }
            if (ComparatorUtil.equalsNullable((Object)value2, (Object)defaultValue)) continue;
            String name2 = ArgumentUtils.getAlias(argument2);
            if (name2 == null) {
                name2 = ArgumentUtils.getName(argument2, field2);
            }
            if ((fieldType = field2.getType()).isArray()) {
                Object[] values = (Object[])value2;
                if (values.length == 0) continue;
                value2 = StringUtil.join((Object[])values, (Function)Function.TO_STRING, (String)argument2.delimiter());
            }
            result2.add(argument2.prefix() + name2);
            if (fieldType == Boolean.TYPE || fieldType == Boolean.class) continue;
            result2.add(value2.toString());
        }
        Class<?> superClazz = clazz.getSuperclass();
        if (superClazz != null) {
            ArgumentUtils.convertArgumentsToStringList(arguments2, defaultArguments, superClazz, result2);
        }
    }

    private static String getAlias(Argument argument2) {
        String alias = argument2.alias();
        return alias.isEmpty() ? null : alias;
    }

    private static String getName(Argument argument2, Field field2) {
        String name2 = argument2.value();
        return name2.isEmpty() ? field2.getName() : name2;
    }
}

