/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.config;

import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.jetbrains.kotlin.config.LanguageVersionSettings;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\b\n\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B1\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\bH\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0011R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/config/LanguageVersionSettingsImpl;", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "languageVersion", "Lorg/jetbrains/kotlin/config/LanguageVersion;", "apiVersion", "Lorg/jetbrains/kotlin/config/ApiVersion;", "additionalFeatures", "", "Lorg/jetbrains/kotlin/config/LanguageFeature;", "isApiVersionExplicit", "", "(Lorg/jetbrains/kotlin/config/LanguageVersion;Lorg/jetbrains/kotlin/config/ApiVersion;Ljava/util/Collection;Z)V", "", "getAdditionalFeatures", "()Ljava/util/Set;", "getApiVersion", "()Lorg/jetbrains/kotlin/config/ApiVersion;", "()Z", "getLanguageVersion", "()Lorg/jetbrains/kotlin/config/LanguageVersion;", "supportsFeature", "feature", "toString", "", "Companion", "util"})
public final class LanguageVersionSettingsImpl
implements LanguageVersionSettings {
    @NotNull
    private final Set<LanguageFeature> additionalFeatures;
    @NotNull
    private final LanguageVersion languageVersion;
    @NotNull
    private final ApiVersion apiVersion;
    private final boolean isApiVersionExplicit;
    @JvmField
    @NotNull
    public static final LanguageVersionSettingsImpl DEFAULT;
    public static final Companion Companion;

    @NotNull
    public Set<LanguageFeature> getAdditionalFeatures() {
        return this.additionalFeatures;
    }

    @Override
    public boolean supportsFeature(@NotNull LanguageFeature feature) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)feature), (String)"feature");
        LanguageVersion since = feature.getSinceVersion();
        return since != null && this.getLanguageVersion().compareTo((Enum)since) >= 0 && this.getApiVersion().compareTo(feature.getSinceApiVersion()) >= 0 || this.getAdditionalFeatures().contains((Object)feature);
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder $receiver = stringBuilder = new StringBuilder();
        $receiver.append("Language = " + this.getLanguageVersion() + ", API = " + this.getApiVersion());
        Iterable $receiver$iv = this.getAdditionalFeatures();
        for (Object element$iv : $receiver$iv) {
            LanguageFeature feature = (LanguageFeature)((Object)element$iv);
            $receiver.append(" +" + (Object)((Object)feature));
        }
        String string = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    @Override
    @NotNull
    public LanguageVersion getLanguageVersion() {
        return this.languageVersion;
    }

    @Override
    @NotNull
    public ApiVersion getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public boolean isApiVersionExplicit() {
        return this.isApiVersionExplicit;
    }

    @JvmOverloads
    public LanguageVersionSettingsImpl(@NotNull LanguageVersion languageVersion, @NotNull ApiVersion apiVersion, @NotNull Collection<? extends LanguageFeature> additionalFeatures, boolean isApiVersionExplicit) {
        Intrinsics.checkParameterIsNotNull((Object)languageVersion, (String)"languageVersion");
        Intrinsics.checkParameterIsNotNull((Object)apiVersion, (String)"apiVersion");
        Intrinsics.checkParameterIsNotNull(additionalFeatures, (String)"additionalFeatures");
        this.languageVersion = languageVersion;
        this.apiVersion = apiVersion;
        this.isApiVersionExplicit = isApiVersionExplicit;
        this.additionalFeatures = CollectionsKt.toSet((Iterable)additionalFeatures);
    }

    @JvmOverloads
    public /* synthetic */ LanguageVersionSettingsImpl(LanguageVersion languageVersion, ApiVersion apiVersion, Collection collection, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            collection = SetsKt.emptySet();
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        this(languageVersion, apiVersion, collection, bl);
    }

    @JvmOverloads
    public LanguageVersionSettingsImpl(@NotNull LanguageVersion languageVersion, @NotNull ApiVersion apiVersion, @NotNull Collection<? extends LanguageFeature> additionalFeatures) {
        this(languageVersion, apiVersion, additionalFeatures, false, 8, null);
    }

    @JvmOverloads
    public LanguageVersionSettingsImpl(@NotNull LanguageVersion languageVersion, @NotNull ApiVersion apiVersion) {
        this(languageVersion, apiVersion, null, false, 12, null);
    }

    static {
        Companion = new Companion(null);
        DEFAULT = new LanguageVersionSettingsImpl(LanguageVersion.LATEST, ApiVersion.LATEST, null, false, 12, null);
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/config/LanguageVersionSettingsImpl$Companion;", "", "()V", "DEFAULT", "Lorg/jetbrains/kotlin/config/LanguageVersionSettingsImpl;", "util"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

