/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.actions.internal;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.searches.ReferencesSearch;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.actions.internal.CheckComponentsUsageSearchAction;
import org.jetbrains.kotlin.idea.actions.internal.CheckComponentsUsageSearchAction$process$;
import org.jetbrains.kotlin.idea.actions.internal.KotlinInternalMode;
import org.jetbrains.kotlin.idea.search.usagesSearch.ExpressionsOfTypeProcessor;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtParameter;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J!\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000bH\u0002\u00a2\u0006\u0002\u0010\fJ)\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u00a2\u0006\u0002\u0010\u0012J\u001e\u0010\u0013\u001a\u00020\u00042\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000f0\b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/actions/internal/CheckComponentsUsageSearchAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "allFiles", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "filesOrDirs", "", "([Lcom/intellij/openapi/vfs/VirtualFile;)Ljava/util/Collection;", "allKotlinFiles", "Lkotlin/sequences/Sequence;", "Lorg/jetbrains/kotlin/psi/KtFile;", "project", "Lcom/intellij/openapi/project/Project;", "([Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/project/Project;)Lkotlin/sequences/Sequence;", "process", "files", "selectedKotlinFiles", "update", "idea"})
public final class CheckComponentsUsageSearchAction
extends AnAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        List selectedFiles = SequencesKt.toList(this.selectedKotlinFiles(e));
        Object object = CommonDataKeys.PROJECT.getData(e.getDataContext());
        if (object == null) {
            Intrinsics.throwNpe();
        }
        Project project = (Project)object;
        ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(this, selectedFiles, project){
            final /* synthetic */ CheckComponentsUsageSearchAction this$0;
            final /* synthetic */ List $selectedFiles;
            final /* synthetic */ Project $project;

            public final void run() {
                ApplicationUtilsKt.runReadAction((Function0)new Function0<Unit>(this){
                    final /* synthetic */ actionPerformed.1 this$0;

                    public final void invoke() {
                        CheckComponentsUsageSearchAction checkComponentsUsageSearchAction = this.this$0.this$0;
                        Collection collection = this.this$0.$selectedFiles;
                        Project project = this.this$0.$project;
                        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
                        CheckComponentsUsageSearchAction.access$process(checkComponentsUsageSearchAction, collection, project);
                    }
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }
                });
            }
            {
                this.this$0 = checkComponentsUsageSearchAction;
                this.$selectedFiles = list2;
                this.$project = project;
            }
        }, "Checking Data Classes", true, project);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void process(Collection<? extends KtFile> files2, Project project) {
        void $receiver$iv;
        Sequence sequence2 = SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)files2), (Function1)process.dataClasses.1.INSTANCE);
        Sequence sequence3 = SequencesKt.filter((Sequence)$receiver$iv, (Function1)process$$inlined$filterIsInstance$1.INSTANCE);
        if (sequence3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.sequences.Sequence<R>");
        }
        List dataClasses2 = SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)sequence3, (Function1)process.dataClasses.2.INSTANCE));
        ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
        for (IndexedValue indexedValue : CollectionsKt.withIndex((Iterable)dataClasses2)) {
            KtParameter parameter;
            Object object;
            int i = indexedValue.component1();
            KtClass dataClass = (KtClass)indexedValue.component2();
            ProgressIndicator progressIndicator2 = progressIndicator;
            if (progressIndicator2 != null) {
                progressIndicator2.setText("Checking data class " + (i + 1) + " of " + dataClasses2.size() + "...");
            }
            ProgressIndicator progressIndicator3 = progressIndicator;
            if (progressIndicator3 != null) {
                Object object2 = dataClass.getFqName();
                if (object2 == null || (object2 = ((FqName)object2).asString()) == null) {
                    object2 = "";
                }
                progressIndicator3.setText2((String)object2);
            }
            KtParameter ktParameter = (object = dataClass.getPrimaryConstructor()) != null && (object = ((KtConstructor)object).getValueParameters()) != null ? (KtParameter)CollectionsKt.firstOrNull((List)object) : (parameter = null);
            if (parameter != null) {
                try {
                    void goldRefsCount;
                    void smartRefsCount;
                    Ref.IntRef intRef = new Ref.IntRef();
                    intRef.element = 0;
                    Ref.IntRef intRef2 = new Ref.IntRef();
                    intRef2.element = 0;
                    ProgressManager.getInstance().runProcess(new Runnable((Ref.IntRef)smartRefsCount, parameter, (Ref.IntRef)goldRefsCount){
                        final /* synthetic */ Ref.IntRef $smartRefsCount;
                        final /* synthetic */ KtParameter $parameter;
                        final /* synthetic */ Ref.IntRef $goldRefsCount;

                        public final void run() {
                            ExpressionsOfTypeProcessor.Companion.setMode(ExpressionsOfTypeProcessor.Mode.ALWAYS_SMART);
                            this.$smartRefsCount.element = ReferencesSearch.search((PsiElement)this.$parameter).findAll().size();
                            ExpressionsOfTypeProcessor.Companion.setMode(ExpressionsOfTypeProcessor.Mode.ALWAYS_PLAIN);
                            this.$goldRefsCount.element = ReferencesSearch.search((PsiElement)this.$parameter).findAll().size();
                        }
                        {
                            this.$smartRefsCount = intRef;
                            this.$parameter = ktParameter;
                            this.$goldRefsCount = intRef2;
                        }
                    }, (ProgressIndicator)new EmptyProgressIndicator());
                    if (smartRefsCount.element != goldRefsCount.element) {
                        SwingUtilities.invokeLater(new Runnable(project, dataClass, (Ref.IntRef)smartRefsCount, (Ref.IntRef)goldRefsCount){
                            final /* synthetic */ Project $project;
                            final /* synthetic */ KtClass $dataClass;
                            final /* synthetic */ Ref.IntRef $smartRefsCount;
                            final /* synthetic */ Ref.IntRef $goldRefsCount;

                            public final void run() {
                                FqName fqName2 = this.$dataClass.getFqName();
                                Messages.showInfoMessage((Project)this.$project, (String)("Difference found for data class " + (fqName2 != null ? fqName2.asString() : null) + ". Found " + this.$smartRefsCount.element + " usage(s) but " + this.$goldRefsCount.element + " expected"), (String)"Error");
                            }
                            {
                                this.$project = project;
                                this.$dataClass = ktClass;
                                this.$smartRefsCount = intRef;
                                this.$goldRefsCount = intRef2;
                            }
                        });
                        return;
                    }
                    intRef2 = null;
                    intRef = null;
                }
                finally {
                    ExpressionsOfTypeProcessor.Companion.setMode(ExpressionsOfTypeProcessor.Mode.PLAIN_WHEN_NEEDED);
                }
            }
            ProgressIndicator progressIndicator4 = progressIndicator;
            if (progressIndicator4 == null) continue;
            progressIndicator4.setFraction((double)(i + 1) / (double)dataClasses2.size());
        }
        SwingUtilities.invokeLater(new Runnable(project, dataClasses2){
            final /* synthetic */ Project $project;
            final /* synthetic */ List $dataClasses;

            public final void run() {
                Messages.showInfoMessage((Project)this.$project, (String)("Analyzed " + this.$dataClasses.size() + " classes. No difference found."), (String)"Success");
            }
            {
                this.$project = project;
                this.$dataClasses = list2;
            }
        });
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        if (!KotlinInternalMode.Instance.getEnabled()) {
            e.getPresentation().setVisible(false);
            e.getPresentation().setEnabled(false);
        } else {
            e.getPresentation().setVisible(true);
            e.getPresentation().setEnabled(SequencesKt.any(this.selectedKotlinFiles(e)));
        }
    }

    private final Sequence<KtFile> selectedKotlinFiles(AnActionEvent e) {
        VirtualFile[] virtualFileArray = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        if (virtualFileArray == null) {
            return SequencesKt.sequenceOf((Object[])new KtFile[0]);
        }
        VirtualFile[] virtualFiles = virtualFileArray;
        Project project = (Project)CommonDataKeys.PROJECT.getData(e.getDataContext());
        if (project == null) {
            return SequencesKt.sequenceOf((Object[])new KtFile[0]);
        }
        Project project2 = project;
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFiles, (String)"virtualFiles");
        Project project3 = project2;
        Intrinsics.checkExpressionValueIsNotNull((Object)project3, (String)"project");
        return this.allKotlinFiles(virtualFiles, project3);
    }

    private final Sequence<KtFile> allKotlinFiles(VirtualFile[] filesOrDirs, Project project) {
        PsiManager manager = PsiManager.getInstance((Project)project);
        return SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)this.allFiles(filesOrDirs)), (Function1)((Function1)new Function1<VirtualFile, KtFile>(manager){
            final /* synthetic */ PsiManager $manager;

            @Nullable
            public final KtFile invoke(@NotNull VirtualFile it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                PsiFile psiFile = this.$manager.findFile(it);
                if (!(psiFile instanceof KtFile)) {
                    psiFile = null;
                }
                return (KtFile)psiFile;
            }
            {
                this.$manager = psiManager;
                super(1);
            }
        }));
    }

    private final Collection<VirtualFile> allFiles(VirtualFile[] filesOrDirs) {
        ArrayList result2 = new ArrayList();
        for (int i = 0; i < filesOrDirs.length; ++i) {
            VirtualFile file2 = filesOrDirs[i];
            VfsUtilCore.visitChildrenRecursively((VirtualFile)file2, (VirtualFileVisitor)((VirtualFileVisitor)new VirtualFileVisitor<Unit>(result2, new VirtualFileVisitor.Option[0]){
                final /* synthetic */ ArrayList $result;

                public boolean visitFile(@NotNull VirtualFile file2) {
                    Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
                    this.$result.add(file2);
                    return true;
                }
                {
                    this.$result = $captured_local_variable$0;
                    super($super_call_param$1);
                }
            }));
        }
        return result2;
    }

    public static final /* synthetic */ void access$process(CheckComponentsUsageSearchAction $this, @NotNull Collection files2, @NotNull Project project) {
        $this.process(files2, project);
    }
}

