/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.completion;

import com.intellij.codeInsight.lookup.LookupElement;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.ReflectionTypes;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.completion.KeywordValues;
import org.jetbrains.kotlin.idea.completion.smart.ExpectedInfoMatch;
import org.jetbrains.kotlin.idea.completion.smart.SmartCompletionItemPriority;
import org.jetbrains.kotlin.idea.completion.smart.UtilsKt;
import org.jetbrains.kotlin.idea.core.ExpectedInfo;
import org.jetbrains.kotlin.idea.resolve.ResolutionFacade;
import org.jetbrains.kotlin.idea.util.CallTypeAndReceiver;
import org.jetbrains.kotlin.idea.util.FuzzyTypeUtils;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeFactory;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeProjectionImpl;
import org.jetbrains.kotlin.types.expressions.DoubleColonLHS;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0011B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J>\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u000e\u0010\u0007\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/completion/KeywordValues;", "", "()V", "process", "", "consumer", "Lorg/jetbrains/kotlin/idea/completion/KeywordValues$Consumer;", "callTypeAndReceiver", "Lorg/jetbrains/kotlin/idea/util/CallTypeAndReceiver;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "resolutionFacade", "Lorg/jetbrains/kotlin/idea/resolve/ResolutionFacade;", "moduleDescriptor", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "isJvmModule", "", "Consumer", "idea-completion"})
public final class KeywordValues {
    public static final KeywordValues INSTANCE;

    public final void process(@NotNull Consumer consumer2, @NotNull CallTypeAndReceiver<?, ?> callTypeAndReceiver, @NotNull BindingContext bindingContext2, @NotNull ResolutionFacade resolutionFacade, @NotNull ModuleDescriptor moduleDescriptor, boolean isJvmModule) {
        Intrinsics.checkParameterIsNotNull((Object)consumer2, (String)"consumer");
        Intrinsics.checkParameterIsNotNull(callTypeAndReceiver, (String)"callTypeAndReceiver");
        Intrinsics.checkParameterIsNotNull((Object)bindingContext2, (String)"bindingContext");
        Intrinsics.checkParameterIsNotNull((Object)resolutionFacade, (String)"resolutionFacade");
        Intrinsics.checkParameterIsNotNull((Object)moduleDescriptor, (String)"moduleDescriptor");
        if (callTypeAndReceiver instanceof CallTypeAndReceiver.DEFAULT) {
            Function1 booleanInfoMatcher2 = process.booleanInfoMatcher.1.INSTANCE;
            consumer2.consume("true", (Function1<? super ExpectedInfo, ExpectedInfoMatch>)booleanInfoMatcher2, SmartCompletionItemPriority.TRUE, (Function0<? extends LookupElement>)((Function0)process.1.INSTANCE));
            consumer2.consume("false", (Function1<? super ExpectedInfo, ExpectedInfoMatch>)booleanInfoMatcher2, SmartCompletionItemPriority.FALSE, (Function0<? extends LookupElement>)((Function0)process.2.INSTANCE));
            Function1 nullMatcher2 = process.nullMatcher.1.INSTANCE;
            consumer2.consume("null", (Function1<? super ExpectedInfo, ExpectedInfoMatch>)nullMatcher2, SmartCompletionItemPriority.NULL, (Function0<? extends LookupElement>)((Function0)process.3.INSTANCE));
        }
        if (callTypeAndReceiver instanceof CallTypeAndReceiver.CALLABLE_REFERENCE && ((CallTypeAndReceiver.CALLABLE_REFERENCE)callTypeAndReceiver).getReceiver() != null) {
            KotlinType qualifierType;
            ReadOnlySlice readOnlySlice = BindingContext.DOUBLE_COLON_LHS;
            Object TReceiver = ((CallTypeAndReceiver.CALLABLE_REFERENCE)callTypeAndReceiver).getReceiver();
            if (TReceiver == null) {
                Intrinsics.throwNpe();
            }
            DoubleColonLHS doubleColonLHS = (DoubleColonLHS)bindingContext2.get(readOnlySlice, TReceiver);
            KotlinType kotlinType = qualifierType = doubleColonLHS != null ? doubleColonLHS.getType() : null;
            if (qualifierType != null) {
                ClassDescriptor kClassDescriptor = resolutionFacade.getFrontendService(ReflectionTypes.class).getKClass();
                SimpleType classLiteralType = KotlinTypeFactory.simpleNotNullType(Annotations.Companion.getEMPTY(), kClassDescriptor, CollectionsKt.listOf((Object)new TypeProjectionImpl(qualifierType)));
                List kClassTypes = CollectionsKt.listOf((Object)FuzzyTypeUtils.toFuzzyType(classLiteralType, CollectionsKt.emptyList()));
                Function1 kClassMatcher2 = (Function1)new Function1<ExpectedInfo, ExpectedInfoMatch>(kClassTypes){
                    final /* synthetic */ List $kClassTypes;

                    @NotNull
                    public final ExpectedInfoMatch invoke(@NotNull ExpectedInfo info) {
                        Intrinsics.checkParameterIsNotNull((Object)info, (String)"info");
                        return UtilsKt.matchExpectedInfo(this.$kClassTypes, info);
                    }
                    {
                        this.$kClassTypes = list2;
                        super(1);
                    }
                };
                consumer2.consume("class", (Function1<? super ExpectedInfo, ExpectedInfoMatch>)kClassMatcher2, SmartCompletionItemPriority.CLASS_LITERAL, (Function0<? extends LookupElement>)((Function0)process.4.INSTANCE));
                if (isJvmModule) {
                    ClassDescriptor javaLangClassDescriptor;
                    Object object = CollectionsKt.singleOrNull((Iterable)ResolutionUtils.resolveImportReference(resolutionFacade, moduleDescriptor, new FqName("java.lang.Class")));
                    if (!(object instanceof ClassDescriptor)) {
                        object = null;
                    }
                    if ((javaLangClassDescriptor = (ClassDescriptor)object) != null) {
                        SimpleType javaLangClassType = KotlinTypeFactory.simpleNotNullType(Annotations.Companion.getEMPTY(), javaLangClassDescriptor, CollectionsKt.listOf((Object)new TypeProjectionImpl(qualifierType)));
                        List javaClassTypes = CollectionsKt.listOf((Object)FuzzyTypeUtils.toFuzzyType(javaLangClassType, CollectionsKt.emptyList()));
                        Function1 javaClassMatcher2 = (Function1)new Function1<ExpectedInfo, ExpectedInfoMatch>(javaClassTypes){
                            final /* synthetic */ List $javaClassTypes;

                            @NotNull
                            public final ExpectedInfoMatch invoke(@NotNull ExpectedInfo info) {
                                Intrinsics.checkParameterIsNotNull((Object)info, (String)"info");
                                return UtilsKt.matchExpectedInfo(this.$javaClassTypes, info);
                            }
                            {
                                this.$javaClassTypes = list2;
                                super(1);
                            }
                        };
                        consumer2.consume("class", (Function1<? super ExpectedInfo, ExpectedInfoMatch>)javaClassMatcher2, SmartCompletionItemPriority.CLASS_LITERAL, (Function0<? extends LookupElement>)((Function0)process.5.INSTANCE));
                    }
                }
            }
        }
    }

    private KeywordValues() {
        INSTANCE = this;
    }

    static {
        new KeywordValues();
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J:\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00072\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH&\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/completion/KeywordValues$Consumer;", "", "consume", "", "lookupString", "", "expectedInfoMatcher", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/idea/core/ExpectedInfo;", "Lorg/jetbrains/kotlin/idea/completion/smart/ExpectedInfoMatch;", "priority", "Lorg/jetbrains/kotlin/idea/completion/smart/SmartCompletionItemPriority;", "factory", "Lkotlin/Function0;", "Lcom/intellij/codeInsight/lookup/LookupElement;", "idea-completion"})
    public static interface Consumer {
        public void consume(@NotNull String var1, @NotNull Function1<? super ExpectedInfo, ExpectedInfoMatch> var2, @NotNull SmartCompletionItemPriority var3, @NotNull Function0<? extends LookupElement> var4);
    }
}

