/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration;

import com.intellij.notification.Notification;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinInProjectUtilsKt;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinNotificationManager;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinStatus;
import org.jetbrains.kotlin.idea.configuration.KotlinProjectConfigurator;
import org.jetbrains.kotlin.idea.configuration.RepositoryDescription;
import org.jetbrains.kotlin.idea.configuration.ui.notifications.ConfigureKotlinNotification;
import org.jetbrains.kotlin.idea.util.projectStructure.ProjectStructureUtilKt;
import org.jetbrains.kotlin.idea.versions.KotlinRuntimeLibraryUtilKt;
import org.jetbrains.kotlin.idea.vfilefinder.JvmIDEVirtualFileFinder;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=2, d1={"\u0000J\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0002\u001a\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b\u001a\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\t\u001a\u00020\n\u001a\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u00062\u0006\u0010\f\u001a\u00020\r\u001a\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\u00052\u0006\u0010\t\u001a\u00020\n\u001a$\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u00052\u0006\u0010\t\u001a\u00020\n2\u000e\b\u0002\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u001a\u001c\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u00112\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0006\u001a\u001c\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\b0\u00112\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0006\u001a\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0007\u001a\u00020\b\u001a\u000e\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0018\u001a\u000e\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u0007\u001a\u00020\b\u001a\u000e\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u0007\u001a\u00020\b\u001a\u000e\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u0007\u001a\u00020\b\u001a\u000e\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u0007\u001a\u00020\b\u001a\u000e\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\r\u001a\u000e\u0010\u001f\u001a\u00020\u00152\u0006\u0010\u0007\u001a\u00020\b\u001a\u000e\u0010 \u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\r\u001a\u000e\u0010!\u001a\u00020\"2\u0006\u0010\u0007\u001a\u00020\b\u001a\u001e\u0010!\u001a\u00020\"2\u0006\u0010\t\u001a\u00020\n2\u000e\b\u0002\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u0011\u001a\u000e\u0010#\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\r\"\u0010\u0010\u0000\u001a\u00020\u00018\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\"\u0010\u0010\u0002\u001a\u00020\u00018\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\"\u0010\u0010\u0003\u001a\u00020\u00018\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"EAP_11_REPOSITORY", "Lorg/jetbrains/kotlin/idea/configuration/RepositoryDescription;", "EAP_REPOSITORY", "SNAPSHOT_REPOSITORY", "getAbleToRunConfigurators", "", "Lorg/jetbrains/kotlin/idea/configuration/KotlinProjectConfigurator;", "module", "Lcom/intellij/openapi/module/Module;", "project", "Lcom/intellij/openapi/project/Project;", "getConfiguratorByName", "name", "", "getModulesWithKotlinFiles", "getNonConfiguredModules", "excludeModules", "", "configurator", "getNonConfiguredModulesWithKotlinFiles", "hasAnyKotlinRuntimeInScope", "", "hasKotlinCommonRuntimeInScope", "scope", "Lcom/intellij/psi/search/GlobalSearchScope;", "hasKotlinFilesInSources", "hasKotlinFilesOnlyInTests", "hasKotlinJsRuntimeInScope", "hasKotlinJvmRuntimeInScope", "isEap", "version", "isModuleConfigured", "isSnapshot", "showConfigureKotlinNotificationIfNeeded", "", "useEap11Repository", "idea"})
public final class ConfigureKotlinInProjectUtilsKt {
    @JvmField
    @NotNull
    public static final RepositoryDescription SNAPSHOT_REPOSITORY = new RepositoryDescription("sonatype.oss.snapshots", "Sonatype OSS Snapshot Repository", "http://oss.sonatype.org/content/repositories/snapshots", true);
    @JvmField
    @NotNull
    public static final RepositoryDescription EAP_REPOSITORY = new RepositoryDescription("bintray.kotlin.eap", "Bintray Kotlin EAP Repository", "http://dl.bintray.com/kotlin/kotlin-eap", false);
    @JvmField
    @NotNull
    public static final RepositoryDescription EAP_11_REPOSITORY = new RepositoryDescription("bintray.kotlin.eap", "Bintray Kotlin 1.1 EAP Repository", "http://dl.bintray.com/kotlin/kotlin-eap-1.1", false);

    public static final boolean isModuleConfigured(@NotNull Module module) {
        boolean bl;
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
            Object[] $receiver$iv = Extensions.getExtensions(KotlinProjectConfigurator.Companion.getEP_NAME());
            for (int i = 0; i < $receiver$iv.length; ++i) {
                Object element$iv = $receiver$iv[i];
                KotlinProjectConfigurator it = (KotlinProjectConfigurator)element$iv;
                if (!Intrinsics.areEqual((Object)((Object)it.getStatus(module)), (Object)((Object)ConfigureKotlinStatus.CONFIGURED))) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Collection<Module> getModulesWithKotlinFiles(@NotNull Project project) {
        void var3_3;
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        if (project.isDisposed()) {
            return CollectionsKt.emptyList();
        }
        if (!FileTypeIndex.containsFileOfType((FileType)((FileType)KotlinFileType.INSTANCE), (GlobalSearchScope)GlobalSearchScope.projectScope((Project)project))) {
            return CollectionsKt.emptyList();
        }
        Iterable iterable = $receiver$iv = (Iterable)ProjectStructureUtilKt.allModules(project);
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            Module module = (Module)element$iv$iv;
            if (!FileTypeIndex.containsFileOfType((FileType)((FileType)KotlinFileType.INSTANCE), (GlobalSearchScope)module.getModuleScope(true))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)var3_3;
    }

    public static final void showConfigureKotlinNotificationIfNeeded(@NotNull Module module) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        if (ConfigureKotlinInProjectUtilsKt.isModuleConfigured(module)) {
            return;
        }
        Project project = module.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"module.project");
        ConfigureKotlinNotificationManager.notify$default(ConfigureKotlinNotificationManager.INSTANCE, project, null, 2, null);
    }

    public static final void showConfigureKotlinNotificationIfNeeded(@NotNull Project project, @NotNull List<? extends Module> excludeModules) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull(excludeModules, (String)"excludeModules");
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(project, excludeModules){
            final /* synthetic */ Project $project;
            final /* synthetic */ List $excludeModules;

            public final void run() {
                String notificationString2 = (String)DumbService.getInstance((Project)this.$project).runReadActionInSmartMode((Computable)new Computable<String>(this){
                    final /* synthetic */ showConfigureKotlinNotificationIfNeeded.1 this$0;

                    @Nullable
                    public final String compute() {
                        boolean bl;
                        block1: {
                            List modules = CollectionsKt.minus((Iterable)ConfigureKotlinInProjectUtilsKt.getModulesWithKotlinFiles(this.this$0.$project), (Iterable)this.this$0.$excludeModules);
                            Iterable $receiver$iv = modules;
                            for (T element$iv : $receiver$iv) {
                                Module it = (Module)element$iv;
                                if (ConfigureKotlinInProjectUtilsKt.isModuleConfigured(it)) continue;
                                bl = false;
                                break block1;
                            }
                            bl = true;
                        }
                        return bl ? null : ConfigureKotlinNotification.Companion.getNotificationString(this.this$0.$project, this.this$0.$excludeModules);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
                if (notificationString2 != null) {
                    ApplicationManager.getApplication().invokeLater(new Runnable(this, notificationString2){
                        final /* synthetic */ showConfigureKotlinNotificationIfNeeded.1 this$0;
                        final /* synthetic */ String $notificationString;

                        public final void run() {
                            ConfigureKotlinNotificationManager.INSTANCE.notify(this.this$0.$project, (Notification)new ConfigureKotlinNotification(this.this$0.$project, this.this$0.$excludeModules, this.$notificationString));
                        }
                        {
                            this.this$0 = var1_1;
                            this.$notificationString = string;
                        }
                    });
                }
            }
            {
                this.$project = project;
                this.$excludeModules = list2;
            }
        });
    }

    public static /* bridge */ /* synthetic */ void showConfigureKotlinNotificationIfNeeded$default(Project project, List list2, int n, Object object) {
        if ((n & 2) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        ConfigureKotlinInProjectUtilsKt.showConfigureKotlinNotificationIfNeeded(project, list2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Collection<KotlinProjectConfigurator> getAbleToRunConfigurators(@NotNull Project project) {
        void $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Object[] $receiver$iv = ConfigureKotlinInProjectUtilsKt.getModulesWithKotlinFiles(project);
        Object[] modules = $receiver$iv.isEmpty() ? (Object[])ProjectStructureUtilKt.allModules(project) : $receiver$iv;
        Object[] $i$a$1$ifEmpty = $receiver$iv = Extensions.getExtensions(KotlinProjectConfigurator.Companion.getEP_NAME());
        Collection destination$iv$iv = new ArrayList();
        for (int i = 0; i < ((void)$receiver$iv$iv).length; ++i) {
            boolean bl;
            void element$iv$iv;
            block2: {
                element$iv$iv = $receiver$iv$iv[i];
                KotlinProjectConfigurator configurator = (KotlinProjectConfigurator)element$iv$iv;
                Iterable $receiver$iv2 = (Iterable)modules;
                for (Object element$iv : $receiver$iv2) {
                    Module module;
                    Module module2 = module = (Module)element$iv;
                    Intrinsics.checkExpressionValueIsNotNull((Object)module2, (String)"module");
                    if (!Intrinsics.areEqual((Object)((Object)configurator.getStatus(module2)), (Object)((Object)ConfigureKotlinStatus.CAN_BE_CONFIGURED))) continue;
                    bl = true;
                    break block2;
                }
                bl = false;
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Collection<KotlinProjectConfigurator> getAbleToRunConfigurators(@NotNull Module module) {
        void var3_3;
        void $receiver$iv$iv;
        Object[] $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        Object[] objectArray = $receiver$iv = Extensions.getExtensions(KotlinProjectConfigurator.Companion.getEP_NAME());
        Collection destination$iv$iv = new ArrayList();
        for (int i = 0; i < ((void)$receiver$iv$iv).length; ++i) {
            void element$iv$iv = $receiver$iv$iv[i];
            KotlinProjectConfigurator it = (KotlinProjectConfigurator)element$iv$iv;
            if (!Intrinsics.areEqual((Object)((Object)it.getStatus(module)), (Object)((Object)ConfigureKotlinStatus.CAN_BE_CONFIGURED))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)var3_3;
    }

    @Nullable
    public static final KotlinProjectConfigurator getConfiguratorByName(@NotNull String name2) {
        Object object;
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
            Object[] $receiver$iv = Extensions.getExtensions(KotlinProjectConfigurator.Companion.getEP_NAME());
            for (int i = 0; i < $receiver$iv.length; ++i) {
                Object element$iv = $receiver$iv[i];
                KotlinProjectConfigurator it = (KotlinProjectConfigurator)element$iv;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)name2)) continue;
                object = element$iv;
                break block1;
            }
            object = null;
        }
        return (KotlinProjectConfigurator)object;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Module> getNonConfiguredModules(@NotNull Project project, @NotNull KotlinProjectConfigurator configurator) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)configurator, (String)"configurator");
        Iterable iterable = $receiver$iv = (Iterable)ProjectStructureUtilKt.allModules(project);
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            Module module;
            Module module2 = module = (Module)element$iv$iv;
            Intrinsics.checkExpressionValueIsNotNull((Object)module2, (String)"module");
            if (!Intrinsics.areEqual((Object)((Object)configurator.getStatus(module2)), (Object)((Object)ConfigureKotlinStatus.CAN_BE_CONFIGURED))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Module> getNonConfiguredModulesWithKotlinFiles(@NotNull Project project, @NotNull KotlinProjectConfigurator configurator) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)configurator, (String)"configurator");
        Collection<Module> modules = ConfigureKotlinInProjectUtilsKt.getModulesWithKotlinFiles(project);
        Iterable iterable = $receiver$iv = (Iterable)modules;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            Module module = (Module)element$iv$iv;
            if (!Intrinsics.areEqual((Object)((Object)configurator.getStatus(module)), (Object)((Object)ConfigureKotlinStatus.CAN_BE_CONFIGURED))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Collection<Module> getNonConfiguredModules(@NotNull Project project, @NotNull Collection<? extends Module> excludeModules) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull(excludeModules, (String)"excludeModules");
        List modulesWithKotlinFiles = CollectionsKt.minus((Iterable)ConfigureKotlinInProjectUtilsKt.getModulesWithKotlinFiles(project), (Iterable)excludeModules);
        Collection<KotlinProjectConfigurator> ableToRunConfigurators = ConfigureKotlinInProjectUtilsKt.getAbleToRunConfigurators(project);
        Iterable iterable = $receiver$iv = (Iterable)modulesWithKotlinFiles;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            boolean bl;
            block2: {
                Module module = (Module)element$iv$iv;
                Iterable $receiver$iv2 = ableToRunConfigurators;
                for (Object element$iv : $receiver$iv2) {
                    KotlinProjectConfigurator it = (KotlinProjectConfigurator)element$iv;
                    if (!Intrinsics.areEqual((Object)((Object)it.getStatus(module)), (Object)((Object)ConfigureKotlinStatus.CAN_BE_CONFIGURED))) continue;
                    bl = true;
                    break block2;
                }
                bl = false;
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ Collection getNonConfiguredModules$default(Project project, Collection collection, int n, Object object) {
        if ((n & 2) != 0) {
            collection = CollectionsKt.emptyList();
        }
        return ConfigureKotlinInProjectUtilsKt.getNonConfiguredModules(project, collection);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean hasAnyKotlinRuntimeInScope(@NotNull Module module) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        GlobalSearchScope scope2 = module.getModuleWithDependenciesAndLibrariesScope(ConfigureKotlinInProjectUtilsKt.hasKotlinFilesOnlyInTests(module));
        Project project = module.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"module.project");
        GlobalSearchScope globalSearchScope = scope2;
        Intrinsics.checkExpressionValueIsNotNull((Object)globalSearchScope, (String)"scope");
        if (KotlinRuntimeLibraryUtilKt.getKotlinJvmRuntimeMarkerClass(project, globalSearchScope) != null) return true;
        Project project2 = module.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"module.project");
        GlobalSearchScope globalSearchScope2 = scope2;
        Intrinsics.checkExpressionValueIsNotNull((Object)globalSearchScope2, (String)"scope");
        if (KotlinRuntimeLibraryUtilKt.hasKotlinJsKjsmFile(project2, globalSearchScope2)) return true;
        GlobalSearchScope globalSearchScope3 = scope2;
        Intrinsics.checkExpressionValueIsNotNull((Object)globalSearchScope3, (String)"scope");
        if (!ConfigureKotlinInProjectUtilsKt.hasKotlinCommonRuntimeInScope(globalSearchScope3)) return false;
        return true;
    }

    public static final boolean hasKotlinJvmRuntimeInScope(@NotNull Module module) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        GlobalSearchScope scope2 = module.getModuleWithDependenciesAndLibrariesScope(ConfigureKotlinInProjectUtilsKt.hasKotlinFilesOnlyInTests(module));
        Project project = module.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"module.project");
        GlobalSearchScope globalSearchScope = scope2;
        Intrinsics.checkExpressionValueIsNotNull((Object)globalSearchScope, (String)"scope");
        return KotlinRuntimeLibraryUtilKt.getKotlinJvmRuntimeMarkerClass(project, globalSearchScope) != null;
    }

    public static final boolean hasKotlinJsRuntimeInScope(@NotNull Module module) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        GlobalSearchScope scope2 = module.getModuleWithDependenciesAndLibrariesScope(ConfigureKotlinInProjectUtilsKt.hasKotlinFilesOnlyInTests(module));
        Project project = module.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"module.project");
        GlobalSearchScope globalSearchScope = scope2;
        Intrinsics.checkExpressionValueIsNotNull((Object)globalSearchScope, (String)"scope");
        return KotlinRuntimeLibraryUtilKt.hasKotlinJsKjsmFile(project, globalSearchScope);
    }

    public static final boolean hasKotlinCommonRuntimeInScope(@NotNull GlobalSearchScope scope2) {
        Intrinsics.checkParameterIsNotNull((Object)scope2, (String)"scope");
        JvmIDEVirtualFileFinder jvmIDEVirtualFileFinder = new JvmIDEVirtualFileFinder(scope2);
        FqName fqName2 = KotlinBuiltIns.BUILT_INS_PACKAGE_FQ_NAME;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"KotlinBuiltIns.BUILT_INS_PACKAGE_FQ_NAME");
        return jvmIDEVirtualFileFinder.hasMetadataPackage(fqName2);
    }

    public static final boolean hasKotlinFilesOnlyInTests(@NotNull Module module) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        return !ConfigureKotlinInProjectUtilsKt.hasKotlinFilesInSources(module) && FileTypeIndex.containsFileOfType((FileType)((FileType)KotlinFileType.INSTANCE), (GlobalSearchScope)module.getModuleScope(true));
    }

    public static final boolean hasKotlinFilesInSources(@NotNull Module module) {
        Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
        return FileTypeIndex.containsFileOfType((FileType)((FileType)KotlinFileType.INSTANCE), (GlobalSearchScope)module.getModuleScope(false));
    }

    public static final boolean isSnapshot(@NotNull String version) {
        Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
        return StringsKt.contains$default((CharSequence)version, (CharSequence)"SNAPSHOT", (boolean)false, (int)2, null);
    }

    public static final boolean isEap(@NotNull String version) {
        Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
        return StringsKt.contains$default((CharSequence)version, (CharSequence)"rc", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)version, (CharSequence)"eap", (boolean)false, (int)2, null);
    }

    public static final boolean useEap11Repository(@NotNull String version) {
        Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
        return new Regex("1\\.1(\\.\\d)?-[A-Za-z][A-Za-z0-9-]*").matches((CharSequence)version) && !StringsKt.startsWith$default((String)version, (String)"1.1.0-dev", (boolean)false, (int)2, null);
    }
}

