/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration;

import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\fJ\u0010\u0010\r\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000fR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/RuntimeLibraryFiles;", "", "runtimeJar", "Ljava/io/File;", "reflectJar", "runtimeSourcesJar", "(Ljava/io/File;Ljava/io/File;Ljava/io/File;)V", "getReflectJar", "()Ljava/io/File;", "getRuntimeJar", "getRuntimeSourcesJar", "getAllJars", "", "getReflectDestination", "dirToCopyJar", "", "getRuntimeDestination", "getRuntimeSourcesDestination", "idea"})
public final class RuntimeLibraryFiles {
    @NotNull
    private final File runtimeJar;
    @Nullable
    private final File reflectJar;
    @NotNull
    private final File runtimeSourcesJar;

    @NotNull
    public final List<File> getAllJars() {
        return CollectionsKt.listOfNotNull((Object[])new File[]{this.runtimeJar, this.reflectJar, this.runtimeSourcesJar});
    }

    @NotNull
    public final File getRuntimeDestination(@NotNull String dirToCopyJar) {
        Intrinsics.checkParameterIsNotNull((Object)dirToCopyJar, (String)"dirToCopyJar");
        return new File(dirToCopyJar + "/" + this.runtimeJar.getName());
    }

    @Nullable
    public final File getReflectDestination(@NotNull String dirToCopyJar) {
        Intrinsics.checkParameterIsNotNull((Object)dirToCopyJar, (String)"dirToCopyJar");
        return this.reflectJar != null ? new File(dirToCopyJar + "/" + this.reflectJar.getName()) : null;
    }

    @NotNull
    public final File getRuntimeSourcesDestination(@NotNull String dirToCopyJar) {
        Intrinsics.checkParameterIsNotNull((Object)dirToCopyJar, (String)"dirToCopyJar");
        return new File(dirToCopyJar + "/" + this.runtimeSourcesJar.getName());
    }

    @NotNull
    public final File getRuntimeJar() {
        return this.runtimeJar;
    }

    @Nullable
    public final File getReflectJar() {
        return this.reflectJar;
    }

    @NotNull
    public final File getRuntimeSourcesJar() {
        return this.runtimeSourcesJar;
    }

    public RuntimeLibraryFiles(@NotNull File runtimeJar, @Nullable File reflectJar, @NotNull File runtimeSourcesJar) {
        Intrinsics.checkParameterIsNotNull((Object)runtimeJar, (String)"runtimeJar");
        Intrinsics.checkParameterIsNotNull((Object)runtimeSourcesJar, (String)"runtimeSourcesJar");
        this.runtimeJar = runtimeJar;
        this.reflectJar = reflectJar;
        this.runtimeSourcesJar = runtimeSourcesJar;
    }
}

