/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration.ui.notifications;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import java.util.List;
import javax.swing.event.HyperlinkEvent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.configuration.ConfigureKotlinInProjectUtilsKt;
import org.jetbrains.kotlin.idea.configuration.KotlinProjectConfigurator;
import org.jetbrains.kotlin.idea.configuration.ui.KotlinConfigurationCheckerComponent;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u001d\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0096\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/ui/notifications/ConfigureKotlinNotification;", "Lcom/intellij/notification/Notification;", "project", "Lcom/intellij/openapi/project/Project;", "excludeModules", "", "Lcom/intellij/openapi/module/Module;", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;)V", "notificationString", "", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;Ljava/lang/String;)V", "equals", "", "o", "", "hashCode", "", "Companion", "idea"})
public final class ConfigureKotlinNotification
extends Notification {
    public static final Companion Companion = new Companion(null);

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConfigureKotlinNotification)) {
            return false;
        }
        return !(Intrinsics.areEqual((Object)this.getContent(), (Object)((ConfigureKotlinNotification)((Object)o)).getContent()) ^ true);
    }

    public int hashCode() {
        return this.getContent().hashCode();
    }

    public ConfigureKotlinNotification(final @NotNull Project project, final @NotNull List<? extends Module> excludeModules, @NotNull String notificationString2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull(excludeModules, (String)"excludeModules");
        Intrinsics.checkParameterIsNotNull((Object)notificationString2, (String)"notificationString");
        super(KotlinConfigurationCheckerComponent.Companion.getCONFIGURE_NOTIFICATION_GROUP_ID(), "Configure Kotlin", notificationString2, NotificationType.WARNING, new NotificationListener(){

            public final void hyperlinkUpdate(@NotNull Notification notification2, @NotNull HyperlinkEvent event) {
                Intrinsics.checkParameterIsNotNull((Object)notification2, (String)"notification");
                Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                if (Intrinsics.areEqual((Object)event.getEventType(), (Object)HyperlinkEvent.EventType.ACTIVATED)) {
                    String string = event.getDescription();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"event.description");
                    KotlinProjectConfigurator kotlinProjectConfigurator = ConfigureKotlinInProjectUtilsKt.getConfiguratorByName(string);
                    if (kotlinProjectConfigurator == null) {
                        throw (Throwable)((Object)new AssertionError((Object)("Missed action: " + event.getDescription())));
                    }
                    KotlinProjectConfigurator configurator = kotlinProjectConfigurator;
                    notification2.expire();
                    configurator.configure(project, excludeModules);
                }
            }
        });
    }

    public ConfigureKotlinNotification(@NotNull Project project, @NotNull List<? extends Module> excludeModules) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull(excludeModules, (String)"excludeModules");
        this(project, excludeModules, Companion.getNotificationString(project, (Collection<? extends Module>)excludeModules));
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001c\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/configuration/ui/notifications/ConfigureKotlinNotification$Companion;", "", "()V", "getLink", "", "configurator", "Lorg/jetbrains/kotlin/idea/configuration/KotlinProjectConfigurator;", "isOnlyOneModule", "", "getNotificationString", "project", "Lcom/intellij/openapi/project/Project;", "excludeModules", "", "Lcom/intellij/openapi/module/Module;", "idea"})
    public static final class Companion {
        @NotNull
        public final String getNotificationString(@NotNull Project project, @NotNull Collection<? extends Module> excludeModules) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull(excludeModules, (String)"excludeModules");
            Collection<Module> modules = ConfigureKotlinInProjectUtilsKt.getNonConfiguredModules(project, excludeModules);
            boolean isOnlyOneModule = modules.size() == 1;
            String modulesString = isOnlyOneModule ? "'" + ((Module)CollectionsKt.first((Iterable)modules)).getName() + "' module" : "modules";
            String links2 = CollectionsKt.joinToString$default((Iterable)ConfigureKotlinInProjectUtilsKt.getAbleToRunConfigurators(project), (CharSequence)"<br/>", null, null, (int)0, null, (Function1)((Function1)new Function1<KotlinProjectConfigurator, String>(isOnlyOneModule){
                final /* synthetic */ boolean $isOnlyOneModule;

                @NotNull
                public final String invoke(@NotNull KotlinProjectConfigurator configurator) {
                    Intrinsics.checkParameterIsNotNull((Object)configurator, (String)"configurator");
                    return org.jetbrains.kotlin.idea.configuration.ui.notifications.ConfigureKotlinNotification$Companion.access$getLink(ConfigureKotlinNotification.Companion, configurator, this.$isOnlyOneModule);
                }
                {
                    this.$isOnlyOneModule = bl;
                    super(1);
                }
            }), (int)30, null);
            return "Configure " + modulesString + " in '" + project.getName() + "' project<br/> " + links2;
        }

        private final String getLink(KotlinProjectConfigurator configurator, boolean isOnlyOneModule) {
            return "<a href=" + "\"" + configurator.getName() + "\"" + ">as Kotlin (" + configurator.getPresentableText() + ") module" + (!isOnlyOneModule ? "s" : "") + "</a>";
        }

        private Companion() {
        }

        @NotNull
        public static final /* synthetic */ String access$getLink(Companion $this, @NotNull KotlinProjectConfigurator configurator, boolean isOnlyOneModule) {
            return $this.getLink(configurator, isOnlyOneModule);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

