/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.libraries.LibraryUtil;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.binding.CodegenBinding;
import org.jetbrains.kotlin.codegen.coroutines.CoroutineCodegen;
import org.jetbrains.kotlin.codegen.coroutines.CoroutineCodegenUtilKt;
import org.jetbrains.kotlin.codegen.state.KotlinTypeMapper;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.fileClasses.FileClasses;
import org.jetbrains.kotlin.fileClasses.NoResolveFileClassesProvider;
import org.jetbrains.kotlin.idea.debugger.DebuggerClassNameProvider;
import org.jetbrains.kotlin.idea.debugger.DebuggerClassNameProviderKt;
import org.jetbrains.kotlin.idea.debugger.breakpoints.BreakpointTypeUtilsKt;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinDebuggerCaches;
import org.jetbrains.kotlin.idea.search.usagesSearch.UtilsKt;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtil;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.load.java.JvmAbi;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtAnonymousInitializer;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassInitializer;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElementKt;
import org.jetbrains.org.objectweb.asm.Type;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u00a8\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J$\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u001c\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00130\u00052\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ\u001e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00130\u00052\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u001c\u001a\u00020\u001dJ&\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u001e\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00130\u00052\u0006\u0010%\u001a\u00020&2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0016\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00130\u00152\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0012\u0010(\u001a\u0004\u0018\u00010)2\u0006\u0010*\u001a\u00020+H\u0002J\u001a\u0010,\u001a\u0004\u0018\u00010\u00132\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200H\u0002J\u0010\u00101\u001a\u00020\u00132\u0006\u00102\u001a\u000203H\u0002J \u00104\u001a\u00020\u00132\u0006\u0010!\u001a\u00020\"2\u0006\u00105\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0014\u00106\u001a\u0004\u0018\u00010\u000b2\b\u00107\u001a\u0004\u0018\u00010\u001fH\u0002J0\u00108\u001a\u0002092\u0006\u0010\u001e\u001a\u00020\u000b2\u0006\u0010/\u001a\u0002002\u0006\u00102\u001a\u0002032\u0006\u0010:\u001a\u00020\u001d2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u001a\u0010;\u001a\u0004\u0018\u00010\u00132\u0006\u0010/\u001a\u0002002\u0006\u0010<\u001a\u00020.H\u0002J\u0016\u0010=\u001a\u00020\u00132\u0006\u0010/\u001a\u0002002\u0006\u0010>\u001a\u00020?J\u0010\u0010@\u001a\u00020\u00062\u0006\u0010A\u001a\u00020&H\u0002J\u001e\u0010B\u001a\b\u0012\u0004\u0012\u00020\u00130\u00052\u0006\u0010/\u001a\u0002002\u0006\u0010\u001e\u001a\u00020\u000bH\u0002J\u001a\u0010C\u001a\u00020\u001d2\b\u0010>\u001a\u0004\u0018\u00010D2\u0006\u0010E\u001a\u00020\u0018H\u0002J\u001a\u0010F\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015*\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R\u001e\u0010\b\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n0\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006G"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/DebuggerClassNameProvider;", "", "myDebugProcess", "Lcom/intellij/debugger/engine/DebugProcess;", "scopes", "", "Lcom/intellij/psi/search/GlobalSearchScope;", "(Lcom/intellij/debugger/engine/DebugProcess;Ljava/util/List;)V", "TYPES_TO_CALCULATE_CLASSNAME", "", "Ljava/lang/Class;", "Lorg/jetbrains/kotlin/psi/KtElement;", "[Ljava/lang/Class;", "getMyDebugProcess", "()Lcom/intellij/debugger/engine/DebugProcess;", "getScopes", "()Ljava/util/List;", "classNamesForCrossInlineParameters", "", "", "usedParameters", "", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "classNamesForPosition", "sourcePosition", "Lcom/intellij/debugger/SourcePosition;", "withInlines", "", "element", "Lcom/intellij/psi/PsiElement;", "findCrossInlineArguments", "argument", "Lorg/jetbrains/kotlin/psi/KtFunction;", "parameterDescriptor", "findInlinedCalls", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "findLambdas", "getArgumentExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "it", "Lorg/jetbrains/kotlin/psi/ValueArgument;", "getClassNameForClass", "klass", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "typeMapper", "Lorg/jetbrains/kotlin/codegen/state/KotlinTypeMapper;", "getClassNameForFile", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "getCrossInlineArgumentClassName", "inlineFunctionName", "getElementToCalculateClassName", "notPositionedElement", "getInternalClassNameForElement", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinDebuggerCaches$ComputedClassNames;", "isInLibrary", "getJvmInternalNameForImpl", "ktClass", "getJvmInternalNameForPropertyOwner", "descriptor", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "getScopeForInlineFunctionUsages", "inlineFunction", "inlineCallClassPatterns", "isFunctionWithSuspendStateMachine", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "bindingContext", "containsCrossInlineParameterUsages", "idea"})
public final class DebuggerClassNameProvider {
    private final Class<? extends KtElement>[] TYPES_TO_CALCULATE_CLASSNAME;
    @NotNull
    private final DebugProcess myDebugProcess;
    @NotNull
    private final List<GlobalSearchScope> scopes;

    @NotNull
    public final List<String> classNamesForPosition(@NotNull SourcePosition sourcePosition, boolean withInlines) {
        Intrinsics.checkParameterIsNotNull((Object)sourcePosition, (String)"sourcePosition");
        SourcePosition $receiver$iv = sourcePosition;
        PsiElement psiElement2 = (PsiElement)ApplicationUtilsKt.runReadAction((Function0)new Function0<PsiElement>((Object)$receiver$iv){
            final /* synthetic */ Object receiver$0;
            {
                this.receiver$0 = object;
                super(0);
            }

            public final PsiElement invoke() {
                SourcePosition it = (SourcePosition)this.receiver$0;
                return it.getElementAt();
            }
        });
        if (psiElement2 == null) {
            return CollectionsKt.emptyList();
        }
        PsiElement element2 = psiElement2;
        List<String> names = this.classNamesForPosition(element2, withInlines);
        Collection<String> lambdas = this.findLambdas(sourcePosition);
        if (lambdas.isEmpty()) {
            return names;
        }
        return CollectionsKt.plus((Collection)names, (Iterable)lambdas);
    }

    @NotNull
    public final List<String> classNamesForPosition(@Nullable PsiElement element2, boolean withInlines) {
        if (DumbService.getInstance((Project)this.myDebugProcess.getProject()).isDumb()) {
            return CollectionsKt.emptyList();
        }
        KtElement ktElement = this.getElementToCalculateClassName(element2);
        if (ktElement == null) {
            return CollectionsKt.emptyList();
        }
        KtElement baseElement = ktElement;
        return KotlinDebuggerCaches.Companion.getOrComputeClassNames((PsiElement)baseElement, (Function1)new Function1<KtElement, KotlinDebuggerCaches.ComputedClassNames>(this, withInlines){
            final /* synthetic */ DebuggerClassNameProvider this$0;
            final /* synthetic */ boolean $withInlines;

            @NotNull
            public final KotlinDebuggerCaches.ComputedClassNames invoke(@NotNull KtElement element2) {
                Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
                KtElement $receiver$iv = element2;
                KtFile file2 = (KtFile)ApplicationUtilsKt.runReadAction((Function0)new Function0<KtFile>((Object)$receiver$iv){
                    final /* synthetic */ Object receiver$0;
                    {
                        this.receiver$0 = object;
                        super(0);
                    }

                    public final KtFile invoke() {
                        KtElement it = (KtElement)this.receiver$0;
                        PsiFile psiFile = it.getContainingFile();
                        if (psiFile == null) {
                            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
                        }
                        return (KtFile)psiFile;
                    }
                });
                boolean isInLibrary = LibraryUtil.findLibraryEntry((VirtualFile)file2.getVirtualFile(), (Project)file2.getProject()) != null;
                KotlinTypeMapper typeMapper = KotlinDebuggerCaches.Companion.getOrCreateTypeMapper((PsiElement)element2);
                return DebuggerClassNameProvider.access$getInternalClassNameForElement(this.this$0, element2, typeMapper, file2, isInLibrary, this.$withInlines);
            }
            {
                this.this$0 = debuggerClassNameProvider;
                this.$withInlines = bl;
                super(1);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<String> findLambdas(SourcePosition sourcePosition) {
        void $receiver$iv$iv;
        Object $receiver$iv = sourcePosition;
        List lambdas = (List)ApplicationUtilsKt.runReadAction((Function0)new Function0<List<? extends KtFunction>>($receiver$iv){
            final /* synthetic */ Object receiver$0;
            {
                this.receiver$0 = object;
                super(0);
            }

            public final List<? extends KtFunction> invoke() {
                SourcePosition p1 = (SourcePosition)this.receiver$0;
                return BreakpointTypeUtilsKt.getLambdasAtLineIfAny(p1);
            }
        });
        Object $i$f$readAction = $receiver$iv = (Iterable)lambdas;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            KtFunction it = (KtFunction)element$iv$iv;
            Iterable list$iv$iv = this.classNamesForPosition(it, true);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final KotlinDebuggerCaches.ComputedClassNames getInternalClassNameForElement(KtElement element2, KotlinTypeMapper typeMapper, KtFile file2, boolean isInLibrary, boolean withInlines) {
        KtElement $receiver$iv;
        DeclarationDescriptor descriptor2;
        KtElement $receiver$iv2 = element2;
        KtElement elementOfClassName = (KtElement)ApplicationUtilsKt.runReadAction((Function0)new Function0<KtElement>((Object)$receiver$iv2, this){
            final /* synthetic */ Object receiver$0;
            final /* synthetic */ DebuggerClassNameProvider this$0;
            {
                this.receiver$0 = object;
                this.this$0 = debuggerClassNameProvider;
                super(0);
            }

            public final KtElement invoke() {
                KtElement it = (KtElement)this.receiver$0;
                return DebuggerClassNameProvider.access$getElementToCalculateClassName(this.this$0, it.getParent());
            }
        });
        $receiver$iv2 = element2;
        if ($receiver$iv2 instanceof KtClassOrObject) {
            return new KotlinDebuggerCaches.ComputedClassNames.CachedClassNames(this.getClassNameForClass((KtClassOrObject)element2, typeMapper));
        }
        if ($receiver$iv2 instanceof KtSecondaryConstructor) {
            KtElement $receiver$iv3 = element2;
            KtClassOrObject klass2 = (KtClassOrObject)ApplicationUtilsKt.runReadAction((Function0)new Function0<KtClassOrObject>((Object)$receiver$iv3){
                final /* synthetic */ Object receiver$0;
                {
                    this.receiver$0 = object;
                    super(0);
                }

                public final KtClassOrObject invoke() {
                    KtSecondaryConstructor it = (KtSecondaryConstructor)this.receiver$0;
                    return it.getContainingClassOrObject();
                }
            });
            return new KotlinDebuggerCaches.ComputedClassNames.CachedClassNames(this.getClassNameForClass(klass2, typeMapper));
        }
        if ($receiver$iv2 instanceof KtFunction && (descriptor2 = (ValueParameterDescriptor)ApplicationUtilsKt.runReadAction((Function0)new Function0<ValueParameterDescriptor>((Object)($receiver$iv = element2), typeMapper){
            final /* synthetic */ Object receiver$0;
            final /* synthetic */ KotlinTypeMapper $typeMapper$inlined;
            {
                this.receiver$0 = object;
                this.$typeMapper$inlined = kotlinTypeMapper;
                super(0);
            }

            public final ValueParameterDescriptor invoke() {
                KtFunction it = (KtFunction)this.receiver$0;
                return InlineUtil.getInlineArgumentDescriptor(it, this.$typeMapper$inlined.getBindingContext());
            }
        })) != null) {
            List<String> classNamesForParent = this.classNamesForPosition((PsiElement)elementOfClassName, withInlines);
            if (descriptor2.isCrossinline()) {
                Collection collection = classNamesForParent;
                KtFunction ktFunction = (KtFunction)element2;
                BindingContext bindingContext2 = typeMapper.getBindingContext();
                Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext2, (String)"typeMapper.bindingContext");
                return new KotlinDebuggerCaches.ComputedClassNames.CachedClassNames(CollectionsKt.plus((Collection)collection, (Iterable)this.findCrossInlineArguments(ktFunction, (ValueParameterDescriptor)descriptor2, bindingContext2)));
            }
            return new KotlinDebuggerCaches.ComputedClassNames.CachedClassNames(classNamesForParent);
        }
        Object $receiver$iv4 = element2;
        Collection crossInlineParameterUsages = (Collection)ApplicationUtilsKt.runReadAction((Function0)new Function0<Collection<? extends ValueParameterDescriptor>>($receiver$iv4, this, typeMapper){
            final /* synthetic */ Object receiver$0;
            final /* synthetic */ DebuggerClassNameProvider this$0;
            final /* synthetic */ KotlinTypeMapper $typeMapper$inlined;
            {
                this.receiver$0 = object;
                this.this$0 = debuggerClassNameProvider;
                this.$typeMapper$inlined = kotlinTypeMapper;
                super(0);
            }

            public final Collection<? extends ValueParameterDescriptor> invoke() {
                KtElement it = (KtElement)this.receiver$0;
                BindingContext bindingContext2 = this.$typeMapper$inlined.getBindingContext();
                Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext2, (String)"typeMapper.bindingContext");
                return DebuggerClassNameProvider.access$containsCrossInlineParameterUsages(this.this$0, it, bindingContext2);
            }
        });
        if (!($receiver$iv4 = crossInlineParameterUsages).isEmpty()) {
            BindingContext bindingContext3 = typeMapper.getBindingContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext3, (String)"typeMapper.bindingContext");
            return new KotlinDebuggerCaches.ComputedClassNames.CachedClassNames(CollectionsKt.toList((Iterable)this.classNamesForCrossInlineParameters(crossInlineParameterUsages, bindingContext3)));
        }
        if (element2 instanceof KtFunctionLiteral) {
            Type asmType = CodegenBinding.asmTypeForAnonymousClass(typeMapper.getBindingContext(), element2);
            String className2 = asmType.getInternalName();
            List<String> inlineCallClassPatterns2 = this.inlineCallClassPatterns(typeMapper, element2);
            List names = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)className2), (Iterable)inlineCallClassPatterns2);
            return new KotlinDebuggerCaches.ComputedClassNames.CachedClassNames(names);
        }
        if (element2 instanceof KtAnonymousInitializer) {
            if (elementOfClassName instanceof KtObjectDeclaration && ((KtObjectDeclaration)elementOfClassName).isCompanion()) {
                return new KotlinDebuggerCaches.ComputedClassNames.CachedClassNames(this.classNamesForPosition(((KtObjectDeclaration)elementOfClassName).getParent(), withInlines));
            }
            return new KotlinDebuggerCaches.ComputedClassNames.CachedClassNames(this.classNamesForPosition((PsiElement)elementOfClassName, withInlines));
        }
        if (!(!(element2 instanceof KtPropertyAccessor) || ((Boolean)ApplicationUtilsKt.runReadAction((Function0)new Function0<Boolean>($receiver$iv4 = element2){
            final /* synthetic */ Object receiver$0;
            {
                this.receiver$0 = object;
                super(0);
            }

            public final Boolean invoke() {
                KtPropertyAccessor it = (KtPropertyAccessor)this.receiver$0;
                return it.getProperty().isTopLevel();
            }
        })).booleanValue() && isInLibrary)) {
            $receiver$iv = element2;
            KtClassOrObject classOrObject = (KtClassOrObject)ApplicationUtilsKt.runReadAction((Function0)new Function0<KtClassOrObject>((Object)$receiver$iv){
                final /* synthetic */ Object receiver$0;
                {
                    this.receiver$0 = object;
                    super(0);
                }

                public final KtClassOrObject invoke() {
                    KtPropertyAccessor it = (KtPropertyAccessor)this.receiver$0;
                    return (KtClassOrObject)PsiTreeUtil.getParentOfType((PsiElement)it, KtClassOrObject.class);
                }
            });
            if (classOrObject != null) {
                return new KotlinDebuggerCaches.ComputedClassNames.CachedClassNames(this.getClassNameForClass(classOrObject, typeMapper));
            }
        } else {
            if (!(!(element2 instanceof KtProperty) || ((Boolean)ApplicationUtilsKt.runReadAction((Function0)new Function0<Boolean>($receiver$iv4 = element2){
                final /* synthetic */ Object receiver$0;
                {
                    this.receiver$0 = object;
                    super(0);
                }

                public final Boolean invoke() {
                    KtProperty it = (KtProperty)this.receiver$0;
                    return it.isTopLevel();
                }
            })).booleanValue() && isInLibrary)) {
                DeclarationDescriptor declarationDescriptor = typeMapper.getBindingContext().get(BindingContext.DECLARATION_TO_DESCRIPTOR, element2);
                if (!(declarationDescriptor instanceof PropertyDescriptor)) {
                    declarationDescriptor = null;
                }
                PropertyDescriptor propertyDescriptor = (PropertyDescriptor)declarationDescriptor;
                if (propertyDescriptor == null) {
                    return new KotlinDebuggerCaches.ComputedClassNames.CachedClassNames(this.classNamesForPosition((PsiElement)elementOfClassName, withInlines));
                }
                descriptor2 = propertyDescriptor;
                return new KotlinDebuggerCaches.ComputedClassNames.CachedClassNames(this.getJvmInternalNameForPropertyOwner(typeMapper, (PropertyDescriptor)descriptor2));
            }
            if (element2 instanceof KtNamedFunction) {
                String parentInternalName;
                String string;
                descriptor2 = typeMapper.getBindingContext().get(BindingContext.DECLARATION_TO_DESCRIPTOR, element2);
                BindingContext bindingContext4 = typeMapper.getBindingContext();
                Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext4, (String)"typeMapper.bindingContext");
                if (this.isFunctionWithSuspendStateMachine(descriptor2, bindingContext4)) {
                    string = CodegenBinding.asmTypeForAnonymousClass(typeMapper.getBindingContext(), element2).getInternalName();
                } else if (elementOfClassName instanceof KtClassOrObject) {
                    string = this.getClassNameForClass((KtClassOrObject)elementOfClassName, typeMapper);
                } else if (elementOfClassName != null) {
                    Type asmType = CodegenBinding.asmTypeForAnonymousClass(typeMapper.getBindingContext(), element2);
                    string = asmType.getInternalName();
                } else {
                    string = parentInternalName = this.getClassNameForFile(file2);
                }
                if (!withInlines) {
                    return new KotlinDebuggerCaches.ComputedClassNames.NonCachedClassNames(parentInternalName);
                }
                KtNamedFunction ktNamedFunction = (KtNamedFunction)element2;
                BindingContext bindingContext5 = typeMapper.getBindingContext();
                Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext5, (String)"typeMapper.bindingContext");
                List<String> inlinedCalls = this.findInlinedCalls(ktNamedFunction, bindingContext5);
                if (parentInternalName == null) {
                    return new KotlinDebuggerCaches.ComputedClassNames.CachedClassNames(inlinedCalls);
                }
                List<String> inlineCallPatterns = this.inlineCallClassPatterns(typeMapper, element2);
                return new KotlinDebuggerCaches.ComputedClassNames.CachedClassNames(CollectionsKt.filterNotNull((Iterable)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)parentInternalName), (Iterable)inlinedCalls), (Iterable)inlineCallPatterns)));
            }
        }
        return new KotlinDebuggerCaches.ComputedClassNames.CachedClassNames(this.getClassNameForFile(file2));
    }

    private final boolean isFunctionWithSuspendStateMachine(DeclarationDescriptor descriptor2, BindingContext bindingContext2) {
        return descriptor2 instanceof SimpleFunctionDescriptor && ((SimpleFunctionDescriptor)descriptor2).isSuspend() && CoroutineCodegenUtilKt.containsNonTailSuspensionCalls((FunctionDescriptor)descriptor2, bindingContext2);
    }

    private final List<String> inlineCallClassPatterns(KotlinTypeMapper typeMapper, KtElement element2) {
        String string;
        Name ownerDescriptorName;
        BindingContext context = typeMapper.getBindingContext();
        KtCallExpression ktCallExpression = (KtCallExpression)ApplicationUtilsKt.runReadAction((Function0)new Function0<KtCallExpression>(element2, context){
            final /* synthetic */ KtElement $element;
            final /* synthetic */ BindingContext $context;

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final KtCallExpression invoke() {
                $receiver$iv = SequencesKt.map(PsiUtilsKt.getParents((PsiElement)this.$element), (Function1)inlineCallClassPatterns.inlineCall.1.INSTANCE);
                last$iv = null;
                for (E element$iv : $receiver$iv) {
                    it = (Pair)element$iv;
                    if (it == null) ** GOTO lbl-1000
                    v0 = this.$context;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v0, (String)"context");
                    if (DebuggerClassNameProviderKt.access$isInlineCall(v0, (KtCallExpression)it.component1())) {
                        v1 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v1 = false;
                    }
                    if (!v1) continue;
                    last$iv = element$iv;
                }
                v2 = (Pair)var2_2;
                return v2 != null ? (KtCallExpression)v2.getFirst() : null;
            }
            {
                this.$element = ktElement;
                this.$context = bindingContext2;
                super(0);
            }
        });
        if (ktCallExpression == null) {
            return CollectionsKt.emptyList();
        }
        KtCallExpression inlineCall2 = ktCallExpression;
        LexicalScope lexicalScope = (LexicalScope)context.get(BindingContext.LEXICAL_SCOPE, inlineCall2);
        if (lexicalScope == null) {
            return CollectionsKt.emptyList();
        }
        LexicalScope lexicalScope2 = lexicalScope;
        String string2 = (String)CollectionsKt.firstOrNull(this.classNamesForPosition((PsiElement)inlineCall2, false));
        if (string2 == null) {
            return CollectionsKt.emptyList();
        }
        String baseClassName = string2;
        ResolvedCall resolvedCall2 = (ResolvedCall)ApplicationUtilsKt.runReadAction((Function0)new Function0<ResolvedCall<? extends CallableDescriptor>>(inlineCall2, context){
            final /* synthetic */ KtCallExpression $inlineCall;
            final /* synthetic */ BindingContext $context;

            @Nullable
            public final ResolvedCall<? extends CallableDescriptor> invoke() {
                KtElement ktElement = this.$inlineCall;
                BindingContext bindingContext2 = this.$context;
                Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext2, (String)"context");
                return CallUtilKt.getResolvedCall(ktElement, bindingContext2);
            }
            {
                this.$inlineCall = ktCallExpression;
                this.$context = bindingContext2;
                super(0);
            }
        });
        if (resolvedCall2 == null) {
            return CollectionsKt.emptyList();
        }
        ResolvedCall resolvedCall3 = resolvedCall2;
        Name inlineFunctionName = resolvedCall3.getResultingDescriptor().getName();
        DeclarationDescriptor ownerDescriptor = lexicalScope2.getOwnerDescriptor();
        PsiElement ownerDeclaration = ownerDescriptor instanceof DeclarationDescriptor ? DescriptorToSourceUtils.getSourceFromDescriptor(ownerDescriptor) : null;
        BindingContext bindingContext2 = typeMapper.getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext2, (String)"typeMapper.bindingContext");
        Name name2 = ownerDescriptorName = this.isFunctionWithSuspendStateMachine(ownerDescriptor, bindingContext2) || ownerDescriptor instanceof CallableDescriptor && ownerDeclaration instanceof KtElement && CoroutineCodegen.Companion.shouldCreateByLambda((CallableDescriptor)ownerDescriptor, (KtElement)ownerDeclaration) ? Name.identifier("doResume") : ownerDescriptor.getName();
        if (ownerDescriptorName.isSpecial()) {
            string = "$special";
        } else {
            String string3 = ownerDescriptorName.asString();
            string = string3;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"ownerDescriptorName.asString()");
        }
        String ownerJvmName = string;
        String mangledInternalClassName = baseClassName + "$" + ownerJvmName + "$$inlined" + "$" + inlineFunctionName;
        return CollectionsKt.listOf((Object)(mangledInternalClassName + "*"));
    }

    private final String getClassNameForClass(KtClassOrObject klass2, KotlinTypeMapper typeMapper) {
        KtClassOrObject $receiver$iv = klass2;
        return (String)ApplicationUtilsKt.runReadAction((Function0)new Function0<String>((Object)$receiver$iv, this, typeMapper){
            final /* synthetic */ Object receiver$0;
            final /* synthetic */ DebuggerClassNameProvider this$0;
            final /* synthetic */ KotlinTypeMapper $typeMapper$inlined;
            {
                this.receiver$0 = object;
                this.this$0 = debuggerClassNameProvider;
                this.$typeMapper$inlined = kotlinTypeMapper;
                super(0);
            }

            public final String invoke() {
                KtClassOrObject it = (KtClassOrObject)this.receiver$0;
                return DebuggerClassNameProvider.access$getJvmInternalNameForImpl(this.this$0, this.$typeMapper$inlined, it);
            }
        });
    }

    private final String getClassNameForFile(KtFile file2) {
        KtFile $receiver$iv = file2;
        return (String)ApplicationUtilsKt.runReadAction((Function0)new Function0<String>((Object)$receiver$iv){
            final /* synthetic */ Object receiver$0;
            {
                this.receiver$0 = object;
                super(0);
            }

            public final String invoke() {
                KtFile it = (KtFile)this.receiver$0;
                return FileClasses.getFileClassInternalName(NoResolveFileClassesProvider.INSTANCE, it);
            }
        });
    }

    private final KtElement getElementToCalculateClassName(PsiElement notPositionedElement) {
        Class<?> clazz;
        Object[] objectArray = this.TYPES_TO_CALCULATE_CLASSNAME;
        PsiElement psiElement2 = notPositionedElement;
        if (psiElement2 != null) {
            PsiElement psiElement3 = psiElement2;
            Object[] objectArray2 = objectArray;
            PsiElement it = psiElement3;
            Class<?> clazz2 = it.getClass();
            objectArray = objectArray2;
            clazz = clazz2;
        } else {
            clazz = null;
        }
        if (clazz == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.Class<*>");
        }
        if (ArraysKt.contains((Object[])objectArray, (Object)clazz)) {
            PsiElement psiElement4 = notPositionedElement;
            if (psiElement4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtElement");
            }
            return (KtElement)psiElement4;
        }
        DebuggerClassNameProvider $receiver$iv = this;
        return (KtElement)ApplicationUtilsKt.runReadAction((Function0)new Function0<KtElement>((Object)$receiver$iv, this, notPositionedElement){
            final /* synthetic */ Object receiver$0;
            final /* synthetic */ DebuggerClassNameProvider this$0;
            final /* synthetic */ PsiElement $notPositionedElement$inlined;
            {
                this.receiver$0 = object;
                this.this$0 = debuggerClassNameProvider;
                this.$notPositionedElement$inlined = psiElement2;
                super(0);
            }

            public final KtElement invoke() {
                DebuggerClassNameProvider it = (DebuggerClassNameProvider)this.receiver$0;
                Class[] classArray = DebuggerClassNameProvider.access$getTYPES_TO_CALCULATE_CLASSNAME$p(this.this$0);
                return (KtElement)PsiTreeUtil.getParentOfType((PsiElement)this.$notPositionedElement$inlined, (Class[])Arrays.copyOf(classArray, classArray.length));
            }
        });
    }

    @NotNull
    public final String getJvmInternalNameForPropertyOwner(@NotNull KotlinTypeMapper typeMapper, @NotNull PropertyDescriptor descriptor2) {
        Intrinsics.checkParameterIsNotNull((Object)typeMapper, (String)"typeMapper");
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        PropertyDescriptor $receiver$iv = descriptor2;
        Object t = ApplicationUtilsKt.runReadAction((Function0)new Function0<String>((Object)$receiver$iv, typeMapper){
            final /* synthetic */ Object receiver$0;
            final /* synthetic */ KotlinTypeMapper $typeMapper$inlined;
            {
                this.receiver$0 = object;
                this.$typeMapper$inlined = kotlinTypeMapper;
                super(0);
            }

            public final String invoke() {
                DeclarationDescriptor declarationDescriptor;
                PropertyDescriptor it = (PropertyDescriptor)this.receiver$0;
                if (JvmAbi.isPropertyWithBackingFieldInOuterClass(it)) {
                    DeclarationDescriptor declarationDescriptor2 = it.getContainingDeclaration();
                    declarationDescriptor = declarationDescriptor2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)declarationDescriptor2, (String)"it.containingDeclaration");
                } else {
                    declarationDescriptor = it;
                }
                String string = this.$typeMapper$inlined.mapOwner(declarationDescriptor).getInternalName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"typeMapper.mapOwner(\n   \u2026           ).internalName");
                return string;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull(t, (String)"descriptor.readAction {\n\u2026 ).internalName\n        }");
        return (String)t;
    }

    private final String getJvmInternalNameForImpl(KotlinTypeMapper typeMapper, KtClassOrObject ktClass) {
        ClassDescriptor classDescriptor = (ClassDescriptor)typeMapper.getBindingContext().get(BindingContext.CLASS, ktClass);
        if (classDescriptor == null) {
            return null;
        }
        ClassDescriptor classDescriptor2 = classDescriptor;
        if (ktClass instanceof KtClass && ((KtClass)ktClass).isInterface()) {
            return typeMapper.mapDefaultImpls(classDescriptor2).getInternalName();
        }
        return typeMapper.mapClass(classDescriptor2).getInternalName();
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> findInlinedCalls(KtNamedFunction function2, BindingContext context) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        void isSuccess;
        if (!InlineUtil.isInline(context.get(BindingContext.DECLARATION_TO_DESCRIPTOR, function2))) {
            return CollectionsKt.emptyList();
        }
        HashSet searchResult = new HashSet();
        KtNamedFunction $receiver$iv2 = function2;
        String functionName2 = (String)ApplicationUtilsKt.runReadAction((Function0)new Function0<String>((Object)$receiver$iv2){
            final /* synthetic */ Object receiver$0;
            {
                this.receiver$0 = object;
                super(0);
            }

            public final String invoke() {
                KtNamedFunction it = (KtNamedFunction)this.receiver$0;
                return it.getName();
            }
        });
        Runnable task2 = new Runnable(this, function2, searchResult){
            final /* synthetic */ DebuggerClassNameProvider this$0;
            final /* synthetic */ KtNamedFunction $function;
            final /* synthetic */ HashSet $searchResult;

            public final void run() {
                Iterable $receiver$iv = (Iterable)ReferencesSearch.search((PsiElement)this.$function, (SearchScope)((SearchScope)DebuggerClassNameProvider.access$getScopeForInlineFunctionUsages(this.this$0, this.$function)));
                for (T element$iv : $receiver$iv) {
                    KtElement usage;
                    KtElement ktElement;
                    PsiReference it = (PsiReference)element$iv;
                    PsiReference $receiver$iv2 = it;
                    if (((Boolean)ApplicationUtilsKt.runReadAction((Function0)new Function0<Boolean>((Object)$receiver$iv2){
                        final /* synthetic */ Object receiver$0;
                        {
                            this.receiver$0 = object;
                            super(0);
                        }

                        public final Boolean invoke() {
                            PsiReference it = (PsiReference)this.receiver$0;
                            return UtilsKt.isImportUsage(it);
                        }
                    })).booleanValue()) continue;
                    PsiElement psiElement2 = it.getElement();
                    if (!(psiElement2 instanceof KtElement)) {
                        psiElement2 = null;
                    }
                    if ((KtElement)psiElement2 != null) {
                        KtElement ktElement2;
                        KtElement it2 = ktElement2;
                        ktElement = DebuggerClassNameProvider.access$getElementToCalculateClassName(this.this$0, (PsiElement)it2);
                    } else {
                        ktElement = null;
                    }
                    if ((usage = ktElement) == null) continue;
                    this.$searchResult.add(usage);
                }
            }
            {
                this.this$0 = debuggerClassNameProvider;
                this.$function = ktNamedFunction;
                this.$searchResult = hashSet;
            }
        };
        Ref.BooleanRef $i$f$readAction = new Ref.BooleanRef();
        $i$f$readAction.element = true;
        ApplicationEx applicationEx = ApplicationManagerEx.getApplicationEx();
        if (!(applicationEx.isUnitTestMode() || applicationEx.holdsReadLock() && !applicationEx.isDispatchThread())) {
            applicationEx.invokeAndWait(new Runnable(this, (Ref.BooleanRef)isSuccess, task2, functionName2){
                final /* synthetic */ DebuggerClassNameProvider this$0;
                final /* synthetic */ Ref.BooleanRef $isSuccess;
                final /* synthetic */ Runnable $task;
                final /* synthetic */ String $functionName;

                public final void run() {
                    this.$isSuccess.element = ProgressManager.getInstance().runProcessWithProgressSynchronously(this.$task, "Compute class names for function " + this.$functionName, true, this.this$0.getMyDebugProcess().getProject());
                }
                {
                    this.this$0 = debuggerClassNameProvider;
                    this.$isSuccess = booleanRef;
                    this.$task = runnable;
                    this.$functionName = string;
                }
            }, ModalityState.NON_MODAL);
        } else {
            task2.run();
        }
        if (!isSuccess.element) {
            XDebugSessionImpl.NOTIFICATION_GROUP.createNotification("Debugger can skip some executions of " + functionName2 + " method, because the computation of class names was interrupted", MessageType.WARNING).notify(this.myDebugProcess.getProject());
        }
        Iterable iterable = $receiver$iv = (Iterable)searchResult;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            KtElement it = (KtElement)element$iv$iv;
            Iterable list$iv$iv = this.classNamesForPosition((PsiElement)it, true);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final Set<String> findCrossInlineArguments(KtFunction argument2, ValueParameterDescriptor parameterDescriptor, BindingContext context) {
        return (Set)ApplicationUtilsKt.runReadAction((Function0)new Function0<Set<? extends String>>(this, parameterDescriptor, argument2, context){
            final /* synthetic */ DebuggerClassNameProvider this$0;
            final /* synthetic */ ValueParameterDescriptor $parameterDescriptor;
            final /* synthetic */ KtFunction $argument;
            final /* synthetic */ BindingContext $context;

            @NotNull
            public final Set<String> invoke() {
                String functionName2;
                KtParameter source;
                KtCallableDeclaration ktCallableDeclaration;
                PsiElement psiElement2 = KotlinSourceElementKt.getPsi(this.$parameterDescriptor.getOriginal().getSource());
                if (!(psiElement2 instanceof KtParameter)) {
                    psiElement2 = null;
                }
                String string = (ktCallableDeclaration = (source = (KtParameter)psiElement2)) != null && (ktCallableDeclaration = ((KtParameter)ktCallableDeclaration).getOwnerFunction()) != null ? ktCallableDeclaration.getName() : (functionName2 = null);
                if (functionName2 != null) {
                    return SetsKt.setOf((Object)DebuggerClassNameProvider.access$getCrossInlineArgumentClassName(this.this$0, this.$argument, functionName2, this.$context));
                }
                return SetsKt.emptySet();
            }
            {
                this.this$0 = debuggerClassNameProvider;
                this.$parameterDescriptor = valueParameterDescriptor;
                this.$argument = ktFunction;
                this.$context = bindingContext2;
                super(0);
            }
        });
    }

    private final String getCrossInlineArgumentClassName(KtFunction argument2, String inlineFunctionName, BindingContext context) {
        String anonymousClassNameForArgument = CodegenBinding.asmTypeForAnonymousClass(context, argument2).getInternalName();
        String newName2 = DebuggerClassNameProviderKt.access$substringIndex(anonymousClassNameForArgument) + "$inlined" + "$" + inlineFunctionName;
        return newName2 + "$" + "*";
    }

    private final Collection<ValueParameterDescriptor> containsCrossInlineParameterUsages(@NotNull KtElement $receiver, BindingContext context) {
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        Object v0;
        Object element$iv2;
        block6: {
            containsCrossInlineParameterUsages.1 hasParameterCall$ = containsCrossInlineParameterUsages.1.INSTANCE;
            Sequence<PsiElement> $receiver$iv2 = PsiUtilsKt.getParents((PsiElement)$receiver);
            for (Object element$iv2 : $receiver$iv2) {
                if (!(element$iv2 instanceof KtNamedFunction)) continue;
                v0 = element$iv2;
                break block6;
            }
            v0 = null;
        }
        KtNamedFunction ktNamedFunction = v0;
        if (ktNamedFunction == null) {
            return SetsKt.emptySet();
        }
        KtNamedFunction inlineFunction = ktNamedFunction;
        SimpleFunctionDescriptor inlineFunctionDescriptor = (SimpleFunctionDescriptor)context.get(BindingContext.FUNCTION, inlineFunction);
        if (inlineFunctionDescriptor == null || !InlineUtil.isInline(inlineFunctionDescriptor)) {
            return SetsKt.emptySet();
        }
        Iterable iterable = inlineFunctionDescriptor.getValueParameters();
        element$iv2 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            ValueParameterDescriptor it = (ValueParameterDescriptor)element$iv$iv;
            if (!it.isCrossinline()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList();
        Iterable $receiver$iv$iv$iv = $receiver$iv$iv;
        for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
            ValueParameterDescriptor valueParameterDescriptor;
            KtParameter psiParameter;
            Object element$iv$iv = element$iv$iv$iv;
            ValueParameterDescriptor it = (ValueParameterDescriptor)element$iv$iv;
            PsiElement psiElement2 = KotlinSourceElementKt.getPsi(it.getSource());
            if (!(psiElement2 instanceof KtParameter)) {
                psiElement2 = null;
            }
            ValueParameterDescriptor valueParameterDescriptor2 = (psiParameter = (KtParameter)psiElement2) != null && containsCrossInlineParameterUsages.1.INSTANCE.invoke($receiver, psiParameter) ? it : null;
            if (valueParameterDescriptor2 == null) continue;
            ValueParameterDescriptor it$iv$iv = valueParameterDescriptor = valueParameterDescriptor2;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final Set<String> classNamesForCrossInlineParameters(Collection<? extends ValueParameterDescriptor> usedParameters, BindingContext context) {
        ValueParameterDescriptor parameter = (ValueParameterDescriptor)CollectionsKt.first((Iterable)usedParameters);
        HashSet result2 = new HashSet();
        PsiElement psiElement2 = KotlinSourceElementKt.getPsi(parameter.getContainingDeclaration().getSource());
        if (!(psiElement2 instanceof KtNamedFunction)) {
            psiElement2 = null;
        }
        KtNamedFunction ktNamedFunction = (KtNamedFunction)psiElement2;
        if (ktNamedFunction == null) {
            return SetsKt.emptySet();
        }
        KtNamedFunction inlineFunction = ktNamedFunction;
        Iterable $receiver$iv = (Iterable)ReferencesSearch.search((PsiElement)inlineFunction, (SearchScope)((SearchScope)this.getScopeForInlineFunctionUsages(inlineFunction)));
        for (Object element$iv : $receiver$iv) {
            PsiReference it = (PsiReference)element$iv;
            ApplicationUtilsKt.runReadAction((Function0)new Function0<Unit>(it, this, context, parameter, result2, inlineFunction){
                final /* synthetic */ PsiReference $it;
                final /* synthetic */ DebuggerClassNameProvider this$0;
                final /* synthetic */ BindingContext $context$inlined;
                final /* synthetic */ ValueParameterDescriptor $parameter$inlined;
                final /* synthetic */ HashSet $result$inlined;
                final /* synthetic */ KtNamedFunction $inlineFunction$inlined;
                {
                    this.$it = psiReference;
                    this.this$0 = debuggerClassNameProvider;
                    this.$context$inlined = bindingContext2;
                    this.$parameter$inlined = valueParameterDescriptor;
                    this.$result$inlined = hashSet;
                    this.$inlineFunction$inlined = ktNamedFunction;
                    super(0);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final void invoke() {
                    Object v7;
                    Object object;
                    block3: {
                        ResolvedCall<? extends CallableDescriptor> resolvedCall2;
                        KtExpression ktExpression;
                        if (UtilsKt.isImportUsage(this.$it)) return;
                        PsiElement psiElement2 = this.$it.getElement();
                        if (!(psiElement2 instanceof KtExpression)) {
                            psiElement2 = null;
                        }
                        KtExpression ktExpression2 = (KtExpression)psiElement2;
                        if (ktExpression2 == null) return;
                        KtExpression it = ktExpression = ktExpression2;
                        KtExpression ktExpression3 = KtPsiUtil.getParentCallIfPresent(it);
                        KtExpression call2 = ktExpression3;
                        if (call2 == null) return;
                        ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2 = CallUtilKt.getResolvedCall(call2, this.$context$inlined);
                        object = resolvedCall3;
                        if (resolvedCall3 == null) return;
                        Map<ValueParameterDescriptor, ResolvedValueArgument> map2 = object.getValueArguments();
                        object = map2;
                        if (map2 == null) return;
                        Set<Map.Entry<K, V>> set = object.entrySet();
                        object = set;
                        if (set == null) return;
                        Iterable $receiver$iv = (Iterable)object;
                        for (T element$iv : $receiver$iv) {
                            Map.Entry it2 = (Map.Entry)element$iv;
                            if (!Intrinsics.areEqual((Object)((ValueParameterDescriptor)it2.getKey()).getOriginal(), (Object)this.$parameter$inlined)) continue;
                            v7 = element$iv;
                            break block3;
                        }
                        v7 = null;
                    }
                    Map.Entry entry = v7;
                    object = entry;
                    if (entry == null) return;
                    ResolvedValueArgument resolvedValueArgument = (ResolvedValueArgument)object.getValue();
                    ResolvedValueArgument argument2 = resolvedValueArgument;
                    if (argument2 == null) return;
                    Object object2 = CollectionsKt.first(argument2.getArguments());
                    Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"argument.arguments.first()");
                    KtExpression argumentExpression = DebuggerClassNameProvider.access$getArgumentExpression(this.this$0, (ValueArgument)object2);
                    if (!(argumentExpression instanceof KtFunction)) return;
                    KtFunction ktFunction = (KtFunction)argumentExpression;
                    String string = this.$inlineFunction$inlined.getName();
                    if (string == null) {
                        Intrinsics.throwNpe();
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"inlineFunction.name!!");
                    this.$result$inlined.add(DebuggerClassNameProvider.access$getCrossInlineArgumentClassName(this.this$0, ktFunction, string, this.$context$inlined));
                }
            });
        }
        return result2;
    }

    private final GlobalSearchScope getScopeForInlineFunctionUsages(KtNamedFunction inlineFunction) {
        VirtualFile virtualFile2 = (VirtualFile)ApplicationUtilsKt.runReadAction((Function0)new Function0<VirtualFile>(inlineFunction){
            final /* synthetic */ KtNamedFunction $inlineFunction;

            public final VirtualFile invoke() {
                return this.$inlineFunction.getContainingFile().getVirtualFile();
            }
            {
                this.$inlineFunction = ktNamedFunction;
                super(0);
            }
        });
        if (virtualFile2 != null) {
            Project project = this.myDebugProcess.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"myDebugProcess.project");
            if (ProjectRootsUtil.isLibraryFile(project, virtualFile2)) {
                Collection $receiver$iv;
                Collection collection = $receiver$iv = (Collection)this.scopes;
                if (collection == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
                }
                Collection thisCollection$iv = collection;
                GlobalSearchScope[] globalSearchScopeArray = thisCollection$iv.toArray(new GlobalSearchScope[thisCollection$iv.size()]);
                if (globalSearchScopeArray == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                GlobalSearchScope globalSearchScope = GlobalSearchScope.union((GlobalSearchScope[])((GlobalSearchScope[])((Object[])globalSearchScopeArray)));
                Intrinsics.checkExpressionValueIsNotNull((Object)globalSearchScope, (String)"GlobalSearchScope.union(scopes.toTypedArray())");
                return globalSearchScope;
            }
        }
        GlobalSearchScope globalSearchScope = this.myDebugProcess.getSearchScope();
        Intrinsics.checkExpressionValueIsNotNull((Object)globalSearchScope, (String)"myDebugProcess.searchScope");
        return globalSearchScope;
    }

    private final KtExpression getArgumentExpression(ValueArgument it) {
        KtExpression ktExpression;
        KtExpression ktExpression2 = it.getArgumentExpression();
        if (!(ktExpression2 instanceof KtLambdaExpression)) {
            ktExpression2 = null;
        }
        return (ktExpression = (KtLambdaExpression)ktExpression2) != null && (ktExpression = ktExpression.getFunctionLiteral()) != null ? (KtExpression)ktExpression : it.getArgumentExpression();
    }

    @NotNull
    public final DebugProcess getMyDebugProcess() {
        return this.myDebugProcess;
    }

    @NotNull
    public final List<GlobalSearchScope> getScopes() {
        return this.scopes;
    }

    /*
     * WARNING - void declaration
     */
    public DebuggerClassNameProvider(@NotNull DebugProcess myDebugProcess, @NotNull List<? extends GlobalSearchScope> scopes) {
        void elements$iv;
        Intrinsics.checkParameterIsNotNull((Object)myDebugProcess, (String)"myDebugProcess");
        Intrinsics.checkParameterIsNotNull(scopes, (String)"scopes");
        this.myDebugProcess = myDebugProcess;
        this.scopes = scopes;
        Class[] classArray = new Class[]{KtClass.class, KtObjectDeclaration.class, KtEnumEntry.class, KtFunctionLiteral.class, KtNamedFunction.class, KtPropertyAccessor.class, KtProperty.class, KtClassInitializer.class, KtSecondaryConstructor.class};
        DebuggerClassNameProvider debuggerClassNameProvider = this;
        Object[] objectArray = (Object[])elements$iv;
        debuggerClassNameProvider.TYPES_TO_CALCULATE_CLASSNAME = (Class[])objectArray;
    }

    @NotNull
    public static final /* synthetic */ KotlinDebuggerCaches.ComputedClassNames access$getInternalClassNameForElement(DebuggerClassNameProvider $this, @NotNull KtElement element2, @NotNull KotlinTypeMapper typeMapper, @NotNull KtFile file2, boolean isInLibrary, boolean withInlines) {
        return $this.getInternalClassNameForElement(element2, typeMapper, file2, isInLibrary, withInlines);
    }

    @Nullable
    public static final /* synthetic */ KtElement access$getElementToCalculateClassName(DebuggerClassNameProvider $this, @Nullable PsiElement notPositionedElement) {
        return $this.getElementToCalculateClassName(notPositionedElement);
    }

    @NotNull
    public static final /* synthetic */ Collection access$containsCrossInlineParameterUsages(DebuggerClassNameProvider $this, @NotNull KtElement $receiver, @NotNull BindingContext context) {
        return $this.containsCrossInlineParameterUsages($receiver, context);
    }

    @Nullable
    public static final /* synthetic */ String access$getJvmInternalNameForImpl(DebuggerClassNameProvider $this, @NotNull KotlinTypeMapper typeMapper, @NotNull KtClassOrObject ktClass) {
        return $this.getJvmInternalNameForImpl(typeMapper, ktClass);
    }

    @NotNull
    public static final /* synthetic */ Class[] access$getTYPES_TO_CALCULATE_CLASSNAME$p(DebuggerClassNameProvider $this) {
        return $this.TYPES_TO_CALCULATE_CLASSNAME;
    }

    @NotNull
    public static final /* synthetic */ GlobalSearchScope access$getScopeForInlineFunctionUsages(DebuggerClassNameProvider $this, @NotNull KtNamedFunction inlineFunction) {
        return $this.getScopeForInlineFunctionUsages(inlineFunction);
    }

    @NotNull
    public static final /* synthetic */ String access$getCrossInlineArgumentClassName(DebuggerClassNameProvider $this, @NotNull KtFunction argument2, @NotNull String inlineFunctionName, @NotNull BindingContext context) {
        return $this.getCrossInlineArgumentClassName(argument2, inlineFunctionName, context);
    }

    @Nullable
    public static final /* synthetic */ KtExpression access$getArgumentExpression(DebuggerClassNameProvider $this, @NotNull ValueArgument it) {
        return $this.getArgumentExpression(it);
    }
}

