/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.evaluate;

import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassType;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.StringReference;
import com.sun.jdi.Value;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.ClassWriter;

public class CompilingEvaluatorUtils {
    public static ClassLoaderReference getClassLoader(EvaluationContext context, DebugProcess process2) throws EvaluateException, InvocationException, InvalidTypeException, ClassNotLoadedException, IncompatibleThreadStateException {
        ClassType loaderClass = (ClassType)process2.findClass(context, "java.net.URLClassLoader", context.getClassLoader());
        Method ctorMethod = loaderClass.concreteMethodByName("<init>", "([Ljava/net/URL;Ljava/lang/ClassLoader;)V");
        ClassLoaderReference reference2 = (ClassLoaderReference)process2.newInstance(context, loaderClass, ctorMethod, Arrays.asList(CompilingEvaluatorUtils.createURLArray(context), context.getClassLoader()));
        CompilingEvaluatorUtils.keep(reference2, context);
        return reference2;
    }

    public static void keep(ObjectReference reference2, EvaluationContext context) {
        ((SuspendContextImpl)context.getSuspendContext()).keep(reference2);
    }

    public static byte[] changeSuperToMagicAccessor(byte[] bytes2) {
        ClassWriter classWriter = new ClassWriter(0);
        ClassVisitor classVisitor = new ClassVisitor(327680, (ClassVisitor)classWriter){

            public void visit(int version, int access, String name2, String signature, String superName, String[] interfaces) {
                if ("java/lang/Object".equals(superName)) {
                    superName = "sun/reflect/MagicAccessorImpl";
                }
                super.visit(version, access, name2, signature, superName, interfaces);
            }
        };
        new ClassReader(bytes2).accept(classVisitor, 0);
        return classWriter.toByteArray();
    }

    public static ArrayReference mirrorOf(byte[] bytes2, EvaluationContext context, DebugProcess process2) throws EvaluateException, InvalidTypeException, ClassNotLoadedException {
        ArrayType arrayClass = (ArrayType)process2.findClass(context, "byte[]", context.getClassLoader());
        ArrayReference reference2 = process2.newInstance(arrayClass, bytes2.length);
        CompilingEvaluatorUtils.keep(reference2, context);
        for (int i = 0; i < bytes2.length; ++i) {
            reference2.setValue(i, (Value)((VirtualMachineProxyImpl)process2.getVirtualMachineProxy()).mirrorOf(bytes2[i]));
        }
        return reference2;
    }

    public static void defineClass(@NotNull String className2, byte[] bytecodes, @NotNull EvaluationContext context, @NotNull DebugProcess process2, @NotNull ClassLoaderReference classLoader) throws ClassNotLoadedException, EvaluateException, InvalidTypeException {
        if (className2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "className", "org/jetbrains/kotlin/idea/debugger/evaluate/CompilingEvaluatorUtils", "defineClass"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/idea/debugger/evaluate/CompilingEvaluatorUtils", "defineClass"));
        }
        if (process2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "org/jetbrains/kotlin/idea/debugger/evaluate/CompilingEvaluatorUtils", "defineClass"));
        }
        if (classLoader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classLoader", "org/jetbrains/kotlin/idea/debugger/evaluate/CompilingEvaluatorUtils", "defineClass"));
        }
        VirtualMachineProxyImpl proxy2 = (VirtualMachineProxyImpl)process2.getVirtualMachineProxy();
        Method defineMethod = ((ClassType)classLoader.referenceType()).concreteMethodByName("defineClass", "(Ljava/lang/String;[BII)Ljava/lang/Class;");
        byte[] bytes2 = CompilingEvaluatorUtils.changeSuperToMagicAccessor(bytecodes);
        ArrayList<Value> args = new ArrayList<Value>();
        StringReference name2 = proxy2.mirrorOf(className2);
        CompilingEvaluatorUtils.keep(name2, context);
        args.add(name2);
        args.add(CompilingEvaluatorUtils.mirrorOf(bytes2, context, process2));
        args.add(proxy2.mirrorOf(0));
        args.add(proxy2.mirrorOf(bytes2.length));
        process2.invokeMethod(context, (ObjectReference)classLoader, defineMethod, args);
    }

    private static ArrayReference createURLArray(EvaluationContext context) throws EvaluateException, InvocationException, InvalidTypeException, ClassNotLoadedException, IncompatibleThreadStateException {
        DebugProcess process2 = context.getDebugProcess();
        ArrayType arrayType = (ArrayType)process2.findClass(context, "java.net.URL[]", context.getClassLoader());
        ArrayReference arrayRef = arrayType.newInstance(1);
        CompilingEvaluatorUtils.keep(arrayRef, context);
        ClassType classType = (ClassType)process2.findClass(context, "java.net.URL", context.getClassLoader());
        VirtualMachineProxyImpl proxy2 = (VirtualMachineProxyImpl)process2.getVirtualMachineProxy();
        StringReference url = proxy2.mirrorOf("file:a");
        CompilingEvaluatorUtils.keep(url, context);
        ObjectReference reference2 = process2.newInstance(context, classType, classType.concreteMethodByName("<init>", "(Ljava/lang/String;)V"), Collections.singletonList(url));
        CompilingEvaluatorUtils.keep(reference2, context);
        arrayRef.setValues(Collections.singletonList(reference2));
        return arrayRef;
    }
}

