/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.stepping;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.CompoundPositionManager;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.NamedMethodFilter;
import com.intellij.psi.PsiElement;
import com.intellij.util.Range;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.debugger.stepping.KotlinBasicStepMethodFilter;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.load.java.JvmAbi;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.OverridingUtilsKt;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J\b\u0010\u000f\u001a\u00020\rH\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/stepping/KotlinBasicStepMethodFilter;", "Lcom/intellij/debugger/engine/NamedMethodFilter;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "myCallingExpressionLines", "Lcom/intellij/util/Range;", "", "(Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;Lcom/intellij/util/Range;)V", "getDescriptor", "()Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "getMyCallingExpressionLines", "()Lcom/intellij/util/Range;", "myTargetMethodName", "", "getCallingExpressionLines", "getMethodName", "locationMatches", "", "process", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "location", "Lcom/sun/jdi/Location;", "idea"})
public final class KotlinBasicStepMethodFilter
implements NamedMethodFilter {
    private final String myTargetMethodName;
    @NotNull
    private final CallableDescriptor descriptor;
    @NotNull
    private final Range<Integer> myCallingExpressionLines;

    @NotNull
    public Range<Integer> getCallingExpressionLines() {
        return this.myCallingExpressionLines;
    }

    @NotNull
    public String getMethodName() {
        return this.myTargetMethodName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean locationMatches(@NotNull DebugProcessImpl process2, @NotNull Location location2) {
        CallableDescriptor it;
        Object element$iv2;
        Intrinsics.checkParameterIsNotNull((Object)process2, (String)"process");
        Intrinsics.checkParameterIsNotNull((Object)location2, (String)"location");
        Method method = location2.method();
        if (Intrinsics.areEqual((Object)this.myTargetMethodName, (Object)method.name()) ^ true) {
            return false;
        }
        CompoundPositionManager compoundPositionManager = process2.getPositionManager();
        if (compoundPositionManager == null) return false;
        CompoundPositionManager positionManager = compoundPositionManager;
        DeclarationDescriptor declarationDescriptor = (DeclarationDescriptor)ApplicationUtilsKt.runReadAction((Function0)new Function0<DeclarationDescriptor>(positionManager, location2, method){
            final /* synthetic */ CompoundPositionManager $positionManager;
            final /* synthetic */ Location $location;
            final /* synthetic */ Method $method;

            @Nullable
            public final DeclarationDescriptor invoke() {
                DeclarationDescriptor declarationDescriptor;
                KtDeclaration declaration2;
                PsiElement elementAt;
                SourcePosition sourcePosition = this.$positionManager.getSourcePosition(this.$location);
                PsiElement psiElement2 = elementAt = sourcePosition != null ? sourcePosition.getElementAt() : null;
                KtDeclaration ktDeclaration = declaration2 = psiElement2 != null ? (KtDeclaration)PsiUtilsKt.getParentOfTypesAndPredicate(psiElement2, false, new Class[]{KtDeclaration.class}, locationMatches.descriptor.declaration.1.INSTANCE) : null;
                if (declaration2 instanceof KtClass && Intrinsics.areEqual((Object)this.$method.name(), (Object)"<init>")) {
                    DeclarationDescriptor declarationDescriptor2 = ResolutionUtils.resolveToDescriptor$default(declaration2, null, 1, null);
                    if (!(declarationDescriptor2 instanceof ClassDescriptor)) {
                        declarationDescriptor2 = null;
                    }
                    ClassDescriptor classDescriptor = (ClassDescriptor)declarationDescriptor2;
                    declarationDescriptor = classDescriptor != null ? classDescriptor.getUnsubstitutedPrimaryConstructor() : null;
                } else {
                    KtDeclaration ktDeclaration2 = declaration2;
                    declarationDescriptor = ktDeclaration2 != null ? ResolutionUtils.resolveToDescriptor$default(ktDeclaration2, null, 1, null) : null;
                }
                return declarationDescriptor;
            }
            {
                this.$positionManager = compoundPositionManager;
                this.$location = location2;
                this.$method = method;
                super(0);
            }
        });
        if (declarationDescriptor == null) return true;
        DeclarationDescriptor descriptor2 = declarationDescriptor;
        locationMatches.1 compareDescriptors$ = locationMatches.1.INSTANCE;
        if (compareDescriptors$.invoke(descriptor2, this.descriptor)) {
            return true;
        }
        if (!(descriptor2 instanceof CallableDescriptor)) return false;
        Iterable $receiver$iv = OverridingUtilsKt.findTopMostOverriddenDescriptors((CallableDescriptor)descriptor2);
        for (Object element$iv2 : $receiver$iv) {
            it = (CallableDescriptor)element$iv2;
            if (!locationMatches.1.INSTANCE.invoke(it, this.descriptor)) continue;
            return true;
        }
        boolean bl = false;
        if (bl) return true;
        $receiver$iv = OverridingUtilsKt.findTopMostOverriddenDescriptors(this.descriptor);
        Iterator iterator2 = $receiver$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
        } while (!locationMatches.1.INSTANCE.invoke(it = (CallableDescriptor)(element$iv2 = iterator2.next()), descriptor2));
        return true;
    }

    @NotNull
    public final CallableDescriptor getDescriptor() {
        return this.descriptor;
    }

    @NotNull
    public final Range<Integer> getMyCallingExpressionLines() {
        return this.myCallingExpressionLines;
    }

    public KotlinBasicStepMethodFilter(@NotNull CallableDescriptor descriptor2, @NotNull Range<Integer> myCallingExpressionLines) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkParameterIsNotNull(myCallingExpressionLines, (String)"myCallingExpressionLines");
        this.descriptor = descriptor2;
        this.myCallingExpressionLines = myCallingExpressionLines;
        CallableDescriptor callableDescriptor = this.descriptor;
        if (callableDescriptor instanceof ClassDescriptor || callableDescriptor instanceof ConstructorDescriptor) {
            string = "<init>";
        } else if (callableDescriptor instanceof PropertyAccessorDescriptor) {
            String string2 = JvmAbi.getterName(((PropertyAccessorDescriptor)this.descriptor).getCorrespondingProperty().getName().asString());
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"JvmAbi.getterName(descri\u2026Property.name.asString())");
        } else {
            String string3 = this.descriptor.getName().asString();
            string = string3;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"descriptor.name.asString()");
        }
        this.myTargetMethodName = string;
    }
}

