/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.decompiler.js;

import com.intellij.openapi.diagnostic.Logger;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.DefaultBuiltIns;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentProvider;
import org.jetbrains.kotlin.idea.decompiler.js.KotlinJavaScriptDeserializerForDecompiler;
import org.jetbrains.kotlin.idea.decompiler.textBuilder.DeserializerForDecompilerBase;
import org.jetbrains.kotlin.idea.decompiler.textBuilder.LoggingErrorReporter;
import org.jetbrains.kotlin.idea.decompiler.textBuilder.ResolveEverythingToKotlinAnyLocalClassifierResolver;
import org.jetbrains.kotlin.incremental.components.LookupTracker;
import org.jetbrains.kotlin.js.resolve.JsPlatform;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.TargetPlatform;
import org.jetbrains.kotlin.resolve.scopes.ResolutionScope;
import org.jetbrains.kotlin.serialization.ProtoBuf;
import org.jetbrains.kotlin.serialization.deserialization.AnnotationAndConstantLoader;
import org.jetbrains.kotlin.serialization.deserialization.AnnotationAndConstantLoaderImpl;
import org.jetbrains.kotlin.serialization.deserialization.ClassDataFinder;
import org.jetbrains.kotlin.serialization.deserialization.DeserializationComponents;
import org.jetbrains.kotlin.serialization.deserialization.DeserializationConfiguration;
import org.jetbrains.kotlin.serialization.deserialization.LocalClassifierTypeSettings;
import org.jetbrains.kotlin.serialization.deserialization.NameResolver;
import org.jetbrains.kotlin.serialization.deserialization.NotFoundClasses;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedPackageMemberScope;
import org.jetbrains.kotlin.serialization.js.DynamicTypeDeserializer;
import org.jetbrains.kotlin.serialization.js.JsProtoBuf;
import org.jetbrains.kotlin.serialization.js.JsSerializerProtocol;
import org.jetbrains.kotlin.serialization.js.KotlinJavascriptClassDataFinder;
import org.jetbrains.kotlin.storage.StorageManager;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u0003H\u0016R\u0014\u0010\t\u001a\u00020\n8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u00128TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/idea/decompiler/js/KotlinJavaScriptDeserializerForDecompiler;", "Lorg/jetbrains/kotlin/idea/decompiler/textBuilder/DeserializerForDecompilerBase;", "packageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "proto", "Lorg/jetbrains/kotlin/serialization/js/JsProtoBuf$Library$Part;", "nameResolver", "Lorg/jetbrains/kotlin/serialization/deserialization/NameResolver;", "(Lorg/jetbrains/kotlin/name/FqName;Lorg/jetbrains/kotlin/serialization/js/JsProtoBuf$Library$Part;Lorg/jetbrains/kotlin/serialization/deserialization/NameResolver;)V", "builtIns", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "getBuiltIns", "()Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "deserializationComponents", "Lorg/jetbrains/kotlin/serialization/deserialization/DeserializationComponents;", "getDeserializationComponents", "()Lorg/jetbrains/kotlin/serialization/deserialization/DeserializationComponents;", "targetPlatform", "Lorg/jetbrains/kotlin/resolve/TargetPlatform;", "getTargetPlatform", "()Lorg/jetbrains/kotlin/resolve/TargetPlatform;", "resolveDeclarationsInFacade", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "facadeFqName", "Companion", "idea-analysis"})
public final class KotlinJavaScriptDeserializerForDecompiler
extends DeserializerForDecompilerBase {
    @NotNull
    private final DeserializationComponents deserializationComponents;
    private final JsProtoBuf.Library.Part proto;
    private final NameResolver nameResolver;
    private static final Logger LOG;
    public static final Companion Companion;

    @Override
    @NotNull
    protected TargetPlatform getTargetPlatform() {
        return JsPlatform.INSTANCE;
    }

    @Override
    @NotNull
    protected KotlinBuiltIns getBuiltIns() {
        return DefaultBuiltIns.Companion.getInstance();
    }

    @Override
    @NotNull
    protected DeserializationComponents getDeserializationComponents() {
        return this.deserializationComponents;
    }

    @Override
    @NotNull
    public List<DeclarationDescriptor> resolveDeclarationsInFacade(@NotNull FqName facadeFqName) {
        Intrinsics.checkParameterIsNotNull((Object)facadeFqName, (String)"facadeFqName");
        boolean bl = Intrinsics.areEqual((Object)facadeFqName, (Object)this.getDirectoryPackageFqName());
        if (_Assertions.ENABLED && !bl) {
            String string = "Was called for " + facadeFqName + "; only members of " + this.getDirectoryPackageFqName() + " package are expected.";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        PackageFragmentDescriptor packageFragmentDescriptor = this.createDummyPackageFragment(facadeFqName);
        ProtoBuf.Package package_ = this.proto.getPackage();
        Intrinsics.checkExpressionValueIsNotNull((Object)package_, (String)"proto.`package`");
        DeserializedPackageMemberScope membersScope2 = new DeserializedPackageMemberScope(packageFragmentDescriptor, package_, this.nameResolver, null, this.getDeserializationComponents(), (Function0<? extends Collection<Name>>)((Function0)resolveDeclarationsInFacade.membersScope.1.INSTANCE));
        return CollectionsKt.toList((Iterable)((List)ResolutionScope.DefaultImpls.getContributedDescriptors$default(membersScope2, null, null, 3, null)));
    }

    public KotlinJavaScriptDeserializerForDecompiler(@NotNull FqName packageFqName, @NotNull JsProtoBuf.Library.Part proto, @NotNull NameResolver nameResolver) {
        Intrinsics.checkParameterIsNotNull((Object)packageFqName, (String)"packageFqName");
        Intrinsics.checkParameterIsNotNull((Object)proto, (String)"proto");
        Intrinsics.checkParameterIsNotNull((Object)nameResolver, (String)"nameResolver");
        super(packageFqName);
        this.proto = proto;
        this.nameResolver = nameResolver;
        NotFoundClasses notFoundClasses = new NotFoundClasses(this.getStorageManager(), this.getModuleDescriptor());
        StorageManager storageManager = this.getStorageManager();
        ModuleDescriptor moduleDescriptor = this.getModuleDescriptor();
        DeserializationConfiguration deserializationConfiguration = DeserializationConfiguration.Default.INSTANCE;
        ClassDataFinder classDataFinder2 = new KotlinJavascriptClassDataFinder(this.proto, this.nameResolver);
        AnnotationAndConstantLoader annotationAndConstantLoader = new AnnotationAndConstantLoaderImpl(this.getModuleDescriptor(), notFoundClasses, JsSerializerProtocol.INSTANCE);
        PackageFragmentProvider packageFragmentProvider2 = this.getPackageFragmentProvider();
        LocalClassifierTypeSettings localClassifierTypeSettings = new ResolveEverythingToKotlinAnyLocalClassifierResolver(this.getBuiltIns());
        Logger logger = KotlinJavaScriptDeserializerForDecompiler.Companion.getLOG();
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LOG");
        this.deserializationComponents = new DeserializationComponents(storageManager, moduleDescriptor, deserializationConfiguration, classDataFinder2, annotationAndConstantLoader, packageFragmentProvider2, localClassifierTypeSettings, new LoggingErrorReporter(logger), LookupTracker.Companion.getDO_NOTHING(), DynamicTypeDeserializer.INSTANCE, CollectionsKt.emptyList(), notFoundClasses, null, null, 12288, null);
    }

    static {
        Companion = new Companion(null);
        LOG = Logger.getInstance(KotlinJavaScriptDeserializerForDecompiler.class);
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0019\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/decompiler/js/KotlinJavaScriptDeserializerForDecompiler$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "idea-analysis"})
    public static final class Companion {
        private final Logger getLOG() {
            return LOG;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

