/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.decompiler.js;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.compiled.ClsStubBuilder;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.StubElement;
import com.intellij.util.indexing.FileContent;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.decompiler.common.AnnotationLoaderForStubBuilderImpl;
import org.jetbrains.kotlin.idea.decompiler.js.KjsmFile;
import org.jetbrains.kotlin.idea.decompiler.js.KotlinJavaScriptMetaFileType;
import org.jetbrains.kotlin.idea.decompiler.stubBuilder.CallableClsStubBuilderKt;
import org.jetbrains.kotlin.idea.decompiler.stubBuilder.ClassClsStubBuilderKt;
import org.jetbrains.kotlin.idea.decompiler.stubBuilder.ClsStubBuilderComponents;
import org.jetbrains.kotlin.idea.decompiler.stubBuilder.ClsStubBuilderContext;
import org.jetbrains.kotlin.idea.decompiler.stubBuilder.ClsStubBuildingKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinFileStubImpl;
import org.jetbrains.kotlin.serialization.ProtoBuf;
import org.jetbrains.kotlin.serialization.deserialization.AnnotationAndConstantLoader;
import org.jetbrains.kotlin.serialization.deserialization.ClassDataFinder;
import org.jetbrains.kotlin.serialization.deserialization.NameResolver;
import org.jetbrains.kotlin.serialization.deserialization.NameResolverImpl;
import org.jetbrains.kotlin.serialization.deserialization.ProtoContainer;
import org.jetbrains.kotlin.serialization.deserialization.TypeTable;
import org.jetbrains.kotlin.serialization.js.JsSerializerProtocol;
import org.jetbrains.kotlin.serialization.js.KotlinJavascriptClassDataFinder;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/decompiler/js/KotlinJavaScriptStubBuilder;", "Lcom/intellij/psi/compiled/ClsStubBuilder;", "()V", "buildFileStub", "Lcom/intellij/psi/stubs/PsiFileStub;", "content", "Lcom/intellij/util/indexing/FileContent;", "getStubVersion", "", "idea-analysis"})
public final class KotlinJavaScriptStubBuilder
extends ClsStubBuilder {
    public int getStubVersion() {
        return 77;
    }

    @Nullable
    public PsiFileStub<?> buildFileStub(@NotNull FileContent content2) {
        KjsmFile file2;
        Intrinsics.checkParameterIsNotNull((Object)content2, (String)"content");
        VirtualFile virtualFile2 = content2.getFile();
        boolean bl = Intrinsics.areEqual((Object)virtualFile2.getFileType(), (Object)KotlinJavaScriptMetaFileType.INSTANCE);
        if (_Assertions.ENABLED && !bl) {
            String string = "Unexpected file type " + virtualFile2.getFileType();
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        VirtualFile virtualFile3 = virtualFile2;
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile3, (String)"virtualFile");
        KjsmFile kjsmFile = KjsmFile.Companion.read(virtualFile3);
        if (kjsmFile == null) {
            return null;
        }
        KjsmFile kjsmFile2 = file2 = kjsmFile;
        if (kjsmFile2 instanceof KjsmFile.Incompatible) {
            return ClsStubBuildingKt.createIncompatibleAbiVersionFileStub();
        }
        if (kjsmFile2 instanceof KjsmFile.Compatible) {
            ProtoBuf.Package packageProto = ((KjsmFile.Compatible)file2).getProto().getPackage();
            FqName packageFqName = ((KjsmFile.Compatible)file2).getPackageFqName();
            NameResolverImpl nameResolver = ((KjsmFile.Compatible)file2).getNameResolver();
            ClassDataFinder classDataFinder2 = new KotlinJavascriptClassDataFinder(((KjsmFile.Compatible)file2).getProto(), nameResolver);
            AnnotationAndConstantLoader annotationAndConstantLoader = new AnnotationLoaderForStubBuilderImpl(JsSerializerProtocol.INSTANCE);
            VirtualFile virtualFile4 = virtualFile2;
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile4, (String)"virtualFile");
            ClsStubBuilderComponents components = new ClsStubBuilderComponents(classDataFinder2, annotationAndConstantLoader, virtualFile4);
            NameResolver nameResolver2 = nameResolver;
            ProtoBuf.TypeTable typeTable = packageProto.getTypeTable();
            Intrinsics.checkExpressionValueIsNotNull((Object)typeTable, (String)"packageProto.typeTable");
            ClsStubBuilderContext context = components.createContext(nameResolver2, packageFqName, new TypeTable(typeTable));
            KotlinFileStubImpl fileStub = ClsStubBuildingKt.createFileStub(packageFqName, false);
            StubElement stubElement = (StubElement)fileStub;
            ProtoContainer protoContainer = new ProtoContainer.Package(packageFqName, context.getNameResolver(), context.getTypeTable(), null);
            ProtoBuf.Package package_ = packageProto;
            Intrinsics.checkExpressionValueIsNotNull((Object)package_, (String)"packageProto");
            CallableClsStubBuilderKt.createDeclarationsStubs((StubElement<? extends PsiElement>)stubElement, context, protoContainer, package_);
            for (ProtoBuf.Class classProto : ((KjsmFile.Compatible)file2).getClassesToDecompile()) {
                StubElement stubElement2 = (StubElement)fileStub;
                ProtoBuf.Class clazz = classProto;
                Intrinsics.checkExpressionValueIsNotNull((Object)clazz, (String)"classProto");
                ClassClsStubBuilderKt.createClassStub((StubElement<? extends PsiElement>)stubElement2, clazz, nameResolver, nameResolver.getClassId(classProto.getFqName()), null, context);
            }
            return fileStub;
        }
        throw new NoWhenBranchMatchedException();
    }
}

