/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.editor.fixers;

import com.intellij.lang.ASTNode;
import com.intellij.lang.SmartEnterProcessorWithFixers;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.editor.KotlinSmartEnterHandler;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtCatchClause;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/editor/fixers/KotlinCatchParameterFixer;", "Lcom/intellij/lang/SmartEnterProcessorWithFixers$Fixer;", "Lorg/jetbrains/kotlin/idea/editor/KotlinSmartEnterHandler;", "()V", "apply", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "processor", "psiElement", "Lcom/intellij/psi/PsiElement;", "idea"})
public final class KotlinCatchParameterFixer
extends SmartEnterProcessorWithFixers.Fixer<KotlinSmartEnterHandler> {
    public void apply(@NotNull Editor editor, @NotNull KotlinSmartEnterHandler processor2, @NotNull PsiElement psiElement2) {
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)((Object)processor2), (String)"processor");
        Intrinsics.checkParameterIsNotNull((Object)psiElement2, (String)"psiElement");
        if (!(psiElement2 instanceof KtCatchClause)) {
            return;
        }
        ASTNode aSTNode = ((KtCatchClause)psiElement2).getNode().findChildByType((IElementType)KtTokens.CATCH_KEYWORD);
        if (aSTNode == null) {
            Intrinsics.throwNpe();
        }
        TextRange textRange = aSTNode.getTextRange();
        if (textRange == null) {
            Intrinsics.throwNpe();
        }
        int catchEnd = textRange.getEndOffset();
        KtParameterList parameterList2 = ((KtCatchClause)psiElement2).getParameterList();
        if (parameterList2 == null || parameterList2.getNode().findChildByType((IElementType)KtTokens.RPAR) == null) {
            KtExpression ktExpression = ((KtCatchClause)psiElement2).getCatchBody();
            int endOffset = Math.min(PsiUtilsKt.getEndOffset(psiElement2), ktExpression != null ? PsiUtilsKt.getStartOffset((PsiElement)ktExpression) : Integer.MAX_VALUE);
            Object object = parameterList2;
            if (object == null || (object = ((KtParameterList)object).getParameters()) == null || (object = (KtParameter)CollectionsKt.firstOrNull((List)object)) == null || (object = object.getText()) == null) {
                object = "";
            }
            Object parameter = object;
            editor.getDocument().replaceString(catchEnd, endOffset, (CharSequence)("(" + (String)parameter + ")"));
            processor2.registerUnresolvedError(endOffset - 1);
        } else {
            KtParameter ktParameter = (KtParameter)CollectionsKt.firstOrNull(parameterList2.getParameters());
            CharSequence charSequence = ktParameter != null ? ktParameter.getText() : null;
            if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                processor2.registerUnresolvedError(PsiUtilsKt.getStartOffset((PsiElement)parameterList2) + 1);
            }
        }
    }
}

