/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.facet;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.framework.detection.DetectedFrameworkDescription;
import com.intellij.framework.detection.DetectionExcludesConfiguration;
import com.intellij.framework.detection.FrameworkDetectionContext;
import com.intellij.framework.detection.FrameworkDetector;
import com.intellij.framework.detection.impl.DetectedFrameworksData;
import com.intellij.framework.detection.impl.FrameworkDetectionContextImpl;
import com.intellij.framework.detection.impl.FrameworkDetectionIndex;
import com.intellij.framework.detection.impl.FrameworkDetectionIndexListener;
import com.intellij.framework.detection.impl.FrameworkDetectionUtil;
import com.intellij.framework.detection.impl.FrameworkDetectorRegistry;
import com.intellij.framework.detection.impl.exclude.DetectionExcludesConfigurationImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.facet.FacetConfigurator;
import org.jetbrains.kotlin.idea.facet.KotlinFrameworkDetector;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u007f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005*\u0001\u000e\u0018\u0000 12\u00020\u00012\u00020\u00022\u00020\u0003:\u000212B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u0006\u0010\u001a\u001a\u00020\u0019J\u0006\u0010\u001b\u001a\u00020\u0019J\b\u0010\u001c\u001a\u00020\u0019H\u0002J\u0016\u0010\u001d\u001a\u00020\u00192\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fH\u0002J\u0018\u0010!\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\"2\u0006\u0010#\u001a\u00020 H\u0016J\u000e\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%H\u0002J\b\u0010'\u001a\u00020\u0019H\u0016J\b\u0010(\u001a\u00020\u0019H\u0016J\b\u0010)\u001a\u00020\u0019H\u0002J5\u0010*\u001a\b\u0012\u0004\u0012\u00020&0%2\b\u0010#\u001a\u0004\u0018\u00010 2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u00020\u0011H\u0002\u00a2\u0006\u0002\u00100R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u0012\u0010\u0010\u001a\u00020\u00118\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lorg/jetbrains/kotlin/idea/facet/FacetConfigurator;", "Lcom/intellij/openapi/components/AbstractProjectComponent;", "Lcom/intellij/framework/detection/impl/FrameworkDetectionIndexListener;", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPassFactory;", "project", "Lcom/intellij/openapi/project/Project;", "highlightingPassRegistrar", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPassRegistrar;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/codeHighlighting/TextEditorHighlightingPassRegistrar;)V", "myDetectedFrameworksData", "Lcom/intellij/framework/detection/impl/DetectedFrameworksData;", "myDetectionQueue", "Lcom/intellij/util/ui/update/MergingUpdateQueue;", "myDetectionUpdate", "org/jetbrains/kotlin/idea/facet/FacetConfigurator$myDetectionUpdate$1", "Lorg/jetbrains/kotlin/idea/facet/FacetConfigurator$myDetectionUpdate$1;", "shouldDetect", "", "createHighlightingPass", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPass;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "disposeComponent", "", "doDispose", "doInitialize", "doRunDetection", "ensureIndexIsUpToDate", "detectors", "", "", "fileUpdated", "Lcom/intellij/openapi/vfs/VirtualFile;", "detectorId", "getValidDetectedFrameworks", "", "Lcom/intellij/framework/detection/DetectedFrameworkDescription;", "initComponent", "projectOpened", "queueDetection", "runDetector", "index", "Lcom/intellij/util/indexing/FileBasedIndex;", "excludesConfiguration", "Lcom/intellij/framework/detection/DetectionExcludesConfiguration;", "processNewFilesOnly", "(Ljava/lang/Integer;Lcom/intellij/util/indexing/FileBasedIndex;Lcom/intellij/framework/detection/DetectionExcludesConfiguration;Z)Ljava/util/List;", "Companion", "FrameworkDetectionHighlightingPass", "idea"})
public final class FacetConfigurator
extends AbstractProjectComponent
implements FrameworkDetectionIndexListener,
TextEditorHighlightingPassFactory {
    private final myDetectionUpdate.1 myDetectionUpdate;
    private volatile boolean shouldDetect;
    private MergingUpdateQueue myDetectionQueue;
    private DetectedFrameworksData myDetectedFrameworksData;
    public static final Companion Companion = new Companion(null);

    public void initComponent() {
        if (!this.myProject.isDefault() && !ApplicationManager.getApplication().isUnitTestMode()) {
            this.doInitialize();
        }
    }

    public final void doInitialize() {
        this.myDetectionQueue = new MergingUpdateQueue("FrameworkDetectionQueue", 500, true, null, (Disposable)this.myProject);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            MergingUpdateQueue mergingUpdateQueue = this.myDetectionQueue;
            if (mergingUpdateQueue == null) {
                Intrinsics.throwNpe();
            }
            mergingUpdateQueue.setPassThrough(false);
            MergingUpdateQueue mergingUpdateQueue2 = this.myDetectionQueue;
            if (mergingUpdateQueue2 == null) {
                Intrinsics.throwNpe();
            }
            mergingUpdateQueue2.hideNotify();
        }
        this.myDetectedFrameworksData = new DetectedFrameworksData(this.myProject);
        FrameworkDetectionIndex.getInstance().addListener((FrameworkDetectionIndexListener)this, (Disposable)this.myProject);
        this.myProject.getMessageBus().connect().subscribe(DumbService.DUMB_MODE, (Object)new DumbService.DumbModeListener(this){
            final /* synthetic */ FacetConfigurator this$0;

            public void enteredDumbMode() {
                MergingUpdateQueue mergingUpdateQueue = FacetConfigurator.access$getMyDetectionQueue$p(this.this$0);
                if (mergingUpdateQueue == null) {
                    Intrinsics.throwNpe();
                }
                mergingUpdateQueue.suspend();
            }

            public void exitDumbMode() {
                MergingUpdateQueue mergingUpdateQueue = FacetConfigurator.access$getMyDetectionQueue$p(this.this$0);
                if (mergingUpdateQueue == null) {
                    Intrinsics.throwNpe();
                }
                mergingUpdateQueue.resume();
            }
            {
                this.this$0 = $outer;
            }
        });
    }

    public void projectOpened() {
        StartupManager.getInstance((Project)this.myProject).registerPostStartupActivity(new Runnable(this){
            final /* synthetic */ FacetConfigurator this$0;

            public final void run() {
                FacetConfigurator.access$setShouldDetect$p(this.this$0, true);
                FacetConfigurator.access$queueDetection(this.this$0);
            }
            {
                this.this$0 = facetConfigurator;
            }
        });
    }

    public void disposeComponent() {
        this.doDispose();
    }

    public final void doDispose() {
        if (this.myDetectedFrameworksData != null) {
            DetectedFrameworksData detectedFrameworksData = this.myDetectedFrameworksData;
            if (detectedFrameworksData == null) {
                Intrinsics.throwNpe();
            }
            detectedFrameworksData.saveDetected();
            this.myDetectedFrameworksData = null;
        }
    }

    public void fileUpdated(@NotNull VirtualFile file2, int detectorId) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        if (detectorId != KotlinFrameworkDetector.Companion.getDetectorIndex()) {
            return;
        }
        this.shouldDetect = true;
        this.queueDetection();
    }

    private final void queueDetection() {
        if (this.myDetectionQueue != null) {
            MergingUpdateQueue mergingUpdateQueue = this.myDetectionQueue;
            if (mergingUpdateQueue == null) {
                Intrinsics.throwNpe();
            }
            mergingUpdateQueue.queue((Update)this.myDetectionUpdate);
        }
    }

    @Nullable
    public TextEditorHighlightingPass createHighlightingPass(@NotNull PsiFile file2, @NotNull Editor editor) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Collection detectors = FrameworkDetectorRegistry.getInstance().getDetectorIds(file2.getFileType());
        if (!detectors.isEmpty()) {
            Collection collection = detectors;
            Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"detectors");
            return new FrameworkDetectionHighlightingPass(editor, collection);
        }
        return null;
    }

    private final void doRunDetection() {
        if (!this.shouldDetect) {
            return;
        }
        this.shouldDetect = false;
    }

    private final List<DetectedFrameworkDescription> runDetector(Integer detectorId, FileBasedIndex index2, DetectionExcludesConfiguration excludesConfiguration, boolean processNewFilesOnly) {
        List<? extends DetectedFrameworkDescription> frameworks;
        FrameworkDetector frameworkDetector;
        Collection filesToProcess;
        Integer n = detectorId;
        if (n == null) {
            Intrinsics.throwNpe();
        }
        Collection acceptedFiles = index2.getContainingFiles(FrameworkDetectionIndex.NAME, (Object)n, GlobalSearchScope.projectScope((Project)this.myProject));
        if (processNewFilesOnly) {
            DetectedFrameworksData detectedFrameworksData = this.myDetectedFrameworksData;
            if (detectedFrameworksData == null) {
                Intrinsics.throwNpe();
            }
            Collection collection = detectedFrameworksData.retainNewFiles(detectorId, acceptedFiles);
            Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"myDetectedFrameworksData\u2026etectorId, acceptedFiles)");
            filesToProcess = collection;
        } else {
            filesToProcess = new ArrayList(acceptedFiles);
        }
        if (!((frameworkDetector = FrameworkDetectorRegistry.getInstance().getDetectorById(((Number)detectorId).intValue())) instanceof KotlinFrameworkDetector)) {
            frameworkDetector = null;
        }
        KotlinFrameworkDetector kotlinFrameworkDetector = (KotlinFrameworkDetector)frameworkDetector;
        if (kotlinFrameworkDetector == null) {
            return CollectionsKt.emptyList();
        }
        KotlinFrameworkDetector detector2 = kotlinFrameworkDetector;
        DetectionExcludesConfiguration detectionExcludesConfiguration = excludesConfiguration;
        if (detectionExcludesConfiguration == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.framework.detection.impl.exclude.DetectionExcludesConfigurationImpl");
        }
        ((DetectionExcludesConfigurationImpl)detectionExcludesConfiguration).removeExcluded(filesToProcess, detector2.getFrameworkType());
        if (!filesToProcess.isEmpty()) {
            List<? extends DetectedFrameworkDescription> list2 = detector2.internalDetect(filesToProcess, (FrameworkDetectionContext)new FrameworkDetectionContextImpl(this.myProject));
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"detector.internalDetect(\u2026onContextImpl(myProject))");
            frameworks = list2;
        } else {
            frameworks = new ArrayList();
        }
        return frameworks;
    }

    private final List<DetectedFrameworkDescription> getValidDetectedFrameworks() {
        DetectedFrameworksData detectedFrameworksData = this.myDetectedFrameworksData;
        if (detectedFrameworksData == null) {
            Intrinsics.throwNpe();
        }
        Integer n = (Integer)CollectionsKt.singleOrNull((Iterable)detectedFrameworksData.getDetectorsForDetectedFrameworks());
        if (n == null) {
            return CollectionsKt.emptyList();
        }
        int id = n;
        FileBasedIndex index2 = FileBasedIndex.getInstance();
        DetectionExcludesConfiguration excludesConfiguration = DetectionExcludesConfiguration.getInstance((Project)this.myProject);
        Integer n2 = id;
        FileBasedIndex fileBasedIndex = index2;
        Intrinsics.checkExpressionValueIsNotNull((Object)fileBasedIndex, (String)"index");
        DetectionExcludesConfiguration detectionExcludesConfiguration = excludesConfiguration;
        Intrinsics.checkExpressionValueIsNotNull((Object)detectionExcludesConfiguration, (String)"excludesConfiguration");
        List<DetectedFrameworkDescription> frameworks = this.runDetector(n2, fileBasedIndex, detectionExcludesConfiguration, false);
        List list2 = FrameworkDetectionUtil.removeDisabled(frameworks);
        Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"FrameworkDetectionUtil.removeDisabled(frameworks)");
        return list2;
    }

    private final void ensureIndexIsUpToDate(Collection<Integer> detectors) {
        Iterator<Integer> iterator2 = detectors.iterator();
        while (iterator2.hasNext()) {
            int detectorId = ((Number)iterator2.next()).intValue();
            FileBasedIndex.getInstance().getValues(FrameworkDetectionIndex.NAME, (Object)detectorId, GlobalSearchScope.projectScope((Project)this.myProject));
        }
    }

    public FacetConfigurator(@NotNull Project project, @NotNull TextEditorHighlightingPassRegistrar highlightingPassRegistrar) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)highlightingPassRegistrar, (String)"highlightingPassRegistrar");
        super(project);
        this.myDetectionUpdate = new Update(this, "detection"){
            final /* synthetic */ FacetConfigurator this$0;

            public void run() {
                FacetConfigurator.access$doRunDetection(this.this$0);
            }
            {
                this.this$0 = $outer;
                super($super_call_param$1);
            }
        };
        highlightingPassRegistrar.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)this, TextEditorHighlightingPassRegistrar.Anchor.LAST, -1, false, false);
    }

    @Nullable
    public static final /* synthetic */ MergingUpdateQueue access$getMyDetectionQueue$p(FacetConfigurator $this) {
        return $this.myDetectionQueue;
    }

    public static final /* synthetic */ void access$setMyDetectionQueue$p(FacetConfigurator $this, @Nullable MergingUpdateQueue mergingUpdateQueue) {
        $this.myDetectionQueue = mergingUpdateQueue;
    }

    public static final /* synthetic */ boolean access$getShouldDetect$p(FacetConfigurator $this) {
        return $this.shouldDetect;
    }

    public static final /* synthetic */ void access$setShouldDetect$p(FacetConfigurator $this, boolean bl) {
        $this.shouldDetect = bl;
    }

    public static final /* synthetic */ void access$queueDetection(FacetConfigurator $this) {
        $this.queueDetection();
    }

    public static final /* synthetic */ void access$doRunDetection(FacetConfigurator $this) {
        $this.doRunDetection();
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/facet/FacetConfigurator$FrameworkDetectionHighlightingPass;", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPass;", "editor", "Lcom/intellij/openapi/editor/Editor;", "myDetectors", "", "", "(Lorg/jetbrains/kotlin/idea/facet/FacetConfigurator;Lcom/intellij/openapi/editor/Editor;Ljava/util/Collection;)V", "doApplyInformationToEditor", "", "doCollectInformation", "progress", "Lcom/intellij/openapi/progress/ProgressIndicator;", "idea"})
    private final class FrameworkDetectionHighlightingPass
    extends TextEditorHighlightingPass {
        private final Collection<Integer> myDetectors;

        public void doCollectInformation(@NotNull ProgressIndicator progress2) {
            Intrinsics.checkParameterIsNotNull((Object)progress2, (String)"progress");
            FacetConfigurator.this.ensureIndexIsUpToDate(this.myDetectors);
        }

        public void doApplyInformationToEditor() {
        }

        public FrameworkDetectionHighlightingPass(@NotNull Editor editor, Collection<Integer> myDetectors) {
            Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
            Intrinsics.checkParameterIsNotNull(myDetectors, (String)"myDetectors");
            super(FacetConfigurator.this.myProject, editor.getDocument(), false);
            this.myDetectors = myDetectors;
        }
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/facet/FacetConfigurator$Companion;", "", "()V", "getInstance", "Lorg/jetbrains/kotlin/idea/facet/FacetConfigurator;", "project", "Lcom/intellij/openapi/project/Project;", "idea"})
    public static final class Companion {
        @NotNull
        public final FacetConfigurator getInstance(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Object object = project.getComponent(FacetConfigurator.class);
            if (object == null) {
                Intrinsics.throwNpe();
            }
            return (FacetConfigurator)((Object)object);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

