/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.facet;

import com.intellij.facet.impl.ui.libraries.DelegatingLibrariesValidatorContext;
import com.intellij.facet.impl.ui.libraries.LibrariesValidatorContext;
import com.intellij.facet.ui.FacetEditorContext;
import com.intellij.facet.ui.FacetEditorTab;
import com.intellij.facet.ui.FacetEditorValidator;
import com.intellij.facet.ui.FacetValidatorsManager;
import com.intellij.facet.ui.ValidationResult;
import com.intellij.facet.ui.libraries.FrameworkLibraryValidator;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.ui.DocumentAdapter;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.ThreeStateCheckBox;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.Collection;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.arguments.ArgumentUtilsKt;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2JSCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2JVMCompilerArguments;
import org.jetbrains.kotlin.config.CompilerSettings;
import org.jetbrains.kotlin.config.CoroutineSupport;
import org.jetbrains.kotlin.config.KotlinCompilerInfo;
import org.jetbrains.kotlin.config.KotlinFacetSettings;
import org.jetbrains.kotlin.config.KotlinVersionInfo;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.jetbrains.kotlin.config.TargetPlatformKind;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinCompilerConfigurableTab;
import org.jetbrains.kotlin.idea.facet.DescriptionListCellRenderer;
import org.jetbrains.kotlin.idea.facet.FrameworkLibraryValidatorWithDynamicDescription;
import org.jetbrains.kotlin.idea.facet.KotlinFacetConfiguration;
import org.jetbrains.kotlin.idea.facet.KotlinVersionInfoProviderKt;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0003\u001d\u001e\u001fB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0014H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u0014H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u00060\nR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0011\u001a\u00060\u0012R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/idea/facet/KotlinFacetEditorGeneralTab;", "Lcom/intellij/facet/ui/FacetEditorTab;", "configuration", "Lorg/jetbrains/kotlin/idea/facet/KotlinFacetConfiguration;", "editorContext", "Lcom/intellij/facet/ui/FacetEditorContext;", "validatorsManager", "Lcom/intellij/facet/ui/FacetValidatorsManager;", "(Lorg/jetbrains/kotlin/idea/facet/KotlinFacetConfiguration;Lcom/intellij/facet/ui/FacetEditorContext;Lcom/intellij/facet/ui/FacetValidatorsManager;)V", "coroutineValidator", "Lorg/jetbrains/kotlin/idea/facet/KotlinFacetEditorGeneralTab$CoroutineContradictionValidator;", "editor", "Lorg/jetbrains/kotlin/idea/facet/KotlinFacetEditorGeneralTab$EditorComponent;", "getEditor", "()Lorg/jetbrains/kotlin/idea/facet/KotlinFacetEditorGeneralTab$EditorComponent;", "libraryValidator", "Lcom/intellij/facet/ui/libraries/FrameworkLibraryValidator;", "versionValidator", "Lorg/jetbrains/kotlin/idea/facet/KotlinFacetEditorGeneralTab$VersionValidator;", "apply", "", "createComponent", "Ljavax/swing/JComponent;", "disposeUIResources", "getDisplayName", "", "isModified", "", "reset", "CoroutineContradictionValidator", "EditorComponent", "VersionValidator", "idea"})
public final class KotlinFacetEditorGeneralTab
extends FacetEditorTab {
    @NotNull
    private final EditorComponent editor;
    private final FrameworkLibraryValidator libraryValidator;
    private final VersionValidator versionValidator;
    private final CoroutineContradictionValidator coroutineValidator;
    private final KotlinFacetConfiguration configuration;
    private final FacetEditorContext editorContext;

    @NotNull
    public final EditorComponent getEditor() {
        return this.editor;
    }

    public boolean isModified() {
        if (this.editor.getUseProjectSettingsCheckBox().isSelected() != this.configuration.getSettings().getUseProjectSettings()) {
            return true;
        }
        if (Intrinsics.areEqual((Object)this.editor.getTargetPlatformComboBox().getSelectedItem(), this.configuration.getSettings().getVersionInfo().getTargetPlatformKind()) ^ true) {
            return true;
        }
        return !this.editor.getUseProjectSettingsCheckBox().isSelected() && this.editor.getCompilerConfigurable().isModified();
    }

    public void reset() {
        this.editor.getUseProjectSettingsCheckBox().setSelected(this.configuration.getSettings().getUseProjectSettings());
        this.editor.getTargetPlatformComboBox().setSelectedItem(this.configuration.getSettings().getVersionInfo().getTargetPlatformKind());
        this.editor.getCompilerConfigurable().reset();
        this.editor.updateCompilerConfigurable$idea();
    }

    public void apply() {
        KotlinFacetSettings kotlinFacetSettings;
        this.editor.getCompilerConfigurable().apply();
        KotlinFacetSettings $receiver = kotlinFacetSettings = this.configuration.getSettings();
        $receiver.setUseProjectSettings(this.editor.getUseProjectSettingsCheckBox().isSelected());
        $receiver.getVersionInfo().setTargetPlatformKind((TargetPlatformKind)this.editor.getTargetPlatformComboBox().getSelectedItem());
        CommonCompilerArguments commonCompilerArguments = $receiver.getCompilerInfo().getCommonCompilerArguments();
        $receiver.getVersionInfo().setLanguageLevel(LanguageVersion.Companion.fromVersionString(commonCompilerArguments != null ? commonCompilerArguments.languageVersion : null));
        CommonCompilerArguments commonCompilerArguments2 = $receiver.getCompilerInfo().getCommonCompilerArguments();
        $receiver.getVersionInfo().setApiLevel(LanguageVersion.Companion.fromVersionString(commonCompilerArguments2 != null ? commonCompilerArguments2.apiVersion : null));
    }

    @NotNull
    public String getDisplayName() {
        return "General";
    }

    @NotNull
    public JComponent createComponent() {
        JPanel mainPanel = new JPanel(new BorderLayout());
        FormBuilder formBuilder = FormBuilder.createFormBuilder().addComponent((JComponent)this.editor.getUseProjectSettingsCheckBox()).addLabeledComponent("&Target platform: ", (JComponent)this.editor.getTargetPlatformComboBox());
        JComponent jComponent = this.editor.getCompilerConfigurable().createComponent();
        if (jComponent == null) {
            Intrinsics.throwNpe();
        }
        JPanel contentPanel = formBuilder.addComponent(jComponent).getPanel();
        mainPanel.add((Component)contentPanel, "North");
        return mainPanel;
    }

    public void disposeUIResources() {
        this.editor.getCompilerConfigurable().disposeUIResources();
    }

    public KotlinFacetEditorGeneralTab(@NotNull KotlinFacetConfiguration configuration2, @NotNull FacetEditorContext editorContext, final @NotNull FacetValidatorsManager validatorsManager) {
        Intrinsics.checkParameterIsNotNull((Object)configuration2, (String)"configuration");
        Intrinsics.checkParameterIsNotNull((Object)editorContext, (String)"editorContext");
        Intrinsics.checkParameterIsNotNull((Object)validatorsManager, (String)"validatorsManager");
        this.configuration = configuration2;
        this.editorContext = editorContext;
        Project project = this.editorContext.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"editorContext.project");
        this.editor = new EditorComponent(project, this.configuration);
        this.versionValidator = new VersionValidator();
        this.coroutineValidator = new CoroutineContradictionValidator();
        this.libraryValidator = new FrameworkLibraryValidatorWithDynamicDescription((LibrariesValidatorContext)new DelegatingLibrariesValidatorContext(this.editorContext), validatorsManager, "kotlin", (Function0)new Function0<TargetPlatformKind<?>>(){

            @NotNull
            public final TargetPlatformKind<?> invoke() {
                Object object = this.getEditor().getTargetPlatformComboBox().getSelectedItem();
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.config.TargetPlatformKind<*>");
                }
                return (TargetPlatformKind)object;
            }
        });
        validatorsManager.registerValidator((FacetEditorValidator)this.libraryValidator, new JComponent[0]);
        validatorsManager.registerValidator((FacetEditorValidator)this.versionValidator, new JComponent[0]);
        validatorsManager.registerValidator((FacetEditorValidator)this.coroutineValidator, new JComponent[0]);
        this.editor.getCompilerConfigurable().getLanguageVersionComboBox().addActionListener(new ActionListener(){

            @Override
            public final void actionPerformed(ActionEvent it) {
                validatorsManager.validate();
            }
        });
        this.editor.getCompilerConfigurable().getApiVersionComboBox().addActionListener(new ActionListener(){

            @Override
            public final void actionPerformed(ActionEvent it) {
                validatorsManager.validate();
            }
        });
        this.editor.getTargetPlatformComboBox().addActionListener(new ActionListener(){

            @Override
            public final void actionPerformed(ActionEvent it) {
                validatorsManager.validate();
            }
        });
        this.editor.getCompilerConfigurable().getCoroutineSupportComboBox().addActionListener(new ActionListener(){

            @Override
            public final void actionPerformed(ActionEvent it) {
                validatorsManager.validate();
            }
        });
        this.editor.getCompilerConfigurable().getAdditionalArgsOptionsField().getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
                String text2 = e.getDocument().getText(0, e.getDocument().getLength());
                if (StringsKt.contains$default((CharSequence)text2, (CharSequence)"-Xcoroutine", (boolean)false, (int)2, null)) {
                    validatorsManager.validate();
                }
            }
        });
        this.editor.updateCompilerConfigurable$idea();
        this.reset();
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\r\u0010\u001b\u001a\u00020\u001cH\u0000\u00a2\u0006\u0002\b\u001dR\u0017\u0010\u0007\u001a\b\u0012\u0002\b\u0003\u0018\u00010\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0013\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/idea/facet/KotlinFacetEditorGeneralTab$EditorComponent;", "Ljavax/swing/JPanel;", "project", "Lcom/intellij/openapi/project/Project;", "configuration", "Lorg/jetbrains/kotlin/idea/facet/KotlinFacetConfiguration;", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/kotlin/idea/facet/KotlinFacetConfiguration;)V", "chosenPlatform", "Lorg/jetbrains/kotlin/config/TargetPlatformKind;", "getChosenPlatform", "()Lorg/jetbrains/kotlin/config/TargetPlatformKind;", "compilerConfigurable", "Lorg/jetbrains/kotlin/idea/compiler/configuration/KotlinCompilerConfigurableTab;", "getCompilerConfigurable", "()Lorg/jetbrains/kotlin/idea/compiler/configuration/KotlinCompilerConfigurableTab;", "compilerInfo", "Lorg/jetbrains/kotlin/config/KotlinCompilerInfo;", "isMultiEditor", "", "targetPlatformComboBox", "Ljavax/swing/JComboBox;", "getTargetPlatformComboBox", "()Ljavax/swing/JComboBox;", "useProjectSettingsCheckBox", "Lcom/intellij/util/ui/ThreeStateCheckBox;", "getUseProjectSettingsCheckBox", "()Lcom/intellij/util/ui/ThreeStateCheckBox;", "updateCompilerConfigurable", "", "updateCompilerConfigurable$idea", "idea"})
    public static final class EditorComponent
    extends JPanel {
        private final boolean isMultiEditor;
        private final KotlinCompilerInfo compilerInfo;
        @NotNull
        private final KotlinCompilerConfigurableTab compilerConfigurable;
        @NotNull
        private final ThreeStateCheckBox useProjectSettingsCheckBox;
        @NotNull
        private final JComboBox<TargetPlatformKind<?>> targetPlatformComboBox;

        @NotNull
        public final KotlinCompilerConfigurableTab getCompilerConfigurable() {
            return this.compilerConfigurable;
        }

        @NotNull
        public final ThreeStateCheckBox getUseProjectSettingsCheckBox() {
            return this.useProjectSettingsCheckBox;
        }

        @NotNull
        public final JComboBox<TargetPlatformKind<?>> getTargetPlatformComboBox() {
            return this.targetPlatformComboBox;
        }

        public final void updateCompilerConfigurable$idea() {
            this.compilerConfigurable.setTargetPlatform(this.getChosenPlatform());
            UIUtil.setEnabled((Component)this.compilerConfigurable.getContentPane(), (!this.useProjectSettingsCheckBox.isSelected() ? 1 : 0) != 0, (boolean)true);
        }

        @Nullable
        public final TargetPlatformKind<?> getChosenPlatform() {
            return (TargetPlatformKind)this.targetPlatformComboBox.getSelectedItem();
        }

        public EditorComponent(@NotNull Project project, @Nullable KotlinFacetConfiguration configuration2) {
            Object $receiver$iv;
            JComboBox<Object> jComboBox;
            Object object;
            Object $receiver;
            EditorComponent editorComponent;
            Object object2;
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            super(new BorderLayout());
            this.isMultiEditor = configuration2 == null;
            EditorComponent editorComponent2 = this;
            Object object3 = configuration2;
            if (object3 == null || (object3 = ((KotlinFacetConfiguration)object3).getSettings()) == null || (object3 = ((KotlinFacetSettings)object3).getCompilerInfo()) == null) {
                object2 = new KotlinCompilerInfo();
                editorComponent = editorComponent2;
                $receiver = object2;
                ((KotlinCompilerInfo)$receiver).setCommonCompilerArguments(new CommonCompilerArguments(){});
                ((KotlinCompilerInfo)$receiver).setK2jsCompilerArguments(new K2JSCompilerArguments());
                ((KotlinCompilerInfo)$receiver).setK2jvmCompilerArguments(new K2JVMCompilerArguments());
                ((KotlinCompilerInfo)$receiver).setCompilerSettings(new CompilerSettings());
                object = object2;
                editorComponent2 = editorComponent;
                object3 = (KotlinCompilerInfo)object;
            }
            editorComponent2.compilerInfo = object3;
            object2 = this.compilerInfo;
            editorComponent = this;
            $receiver = object2;
            object = new KotlinCompilerConfigurableTab(project, ((KotlinCompilerInfo)$receiver).getCommonCompilerArguments(), ((KotlinCompilerInfo)$receiver).getK2jsCompilerArguments(), ((KotlinCompilerInfo)$receiver).getCompilerSettings(), null, ((KotlinCompilerInfo)$receiver).getK2jvmCompilerArguments(), false, this.isMultiEditor);
            editorComponent.compilerConfigurable = (KotlinCompilerConfigurableTab)object;
            object2 = new ThreeStateCheckBox("Use project settings");
            editorComponent = this;
            $receiver = (ThreeStateCheckBox)object2;
            $receiver.setThirdStateEnabled(this.isMultiEditor);
            object = object2;
            editorComponent.useProjectSettingsCheckBox = (ThreeStateCheckBox)object;
            object2 = TargetPlatformKind.Companion.getALL_PLATFORMS();
            JComboBox<Object> jComboBox2 = jComboBox;
            object = jComboBox;
            editorComponent = this;
            void v3 = $receiver$iv;
            if (v3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
            }
            Collection thisCollection$iv = (Collection)v3;
            TargetPlatformKind[] targetPlatformKindArray = thisCollection$iv.toArray(new TargetPlatformKind[thisCollection$iv.size()]);
            if (targetPlatformKindArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            Object[] objectArray = targetPlatformKindArray;
            jComboBox2(objectArray);
            $receiver$iv = object;
            $receiver = (JComboBox)$receiver$iv;
            ((JComboBox)$receiver).setRenderer(new DescriptionListCellRenderer());
            object = $receiver$iv;
            editorComponent.targetPlatformComboBox = (JComboBox)object;
            FormBuilder formBuilder = FormBuilder.createFormBuilder().addComponent((JComponent)this.useProjectSettingsCheckBox).addLabeledComponent("&Target platform: ", (JComponent)this.targetPlatformComboBox);
            JComponent jComponent = this.compilerConfigurable.createComponent();
            if (jComponent == null) {
                Intrinsics.throwNpe();
            }
            JPanel contentPanel = formBuilder.addComponent(jComponent).getPanel();
            this.add((Component)contentPanel, "North");
            this.useProjectSettingsCheckBox.addActionListener(new ActionListener(){

                @Override
                public final void actionPerformed(ActionEvent it) {
                    this.updateCompilerConfigurable$idea();
                }
            });
            this.targetPlatformComboBox.addActionListener(new ActionListener(){

                @Override
                public final void actionPerformed(ActionEvent it) {
                    this.updateCompilerConfigurable$idea();
                }
            });
            CommonCompilerArguments commonCompilerArguments = this.compilerInfo.getCommonCompilerArguments();
            if (configuration2 != null && commonCompilerArguments != null) {
                KotlinVersionInfo kotlinVersionInfo;
                KotlinVersionInfo $receiver2 = kotlinVersionInfo = configuration2.getSettings().getVersionInfo();
                LanguageVersion languageVersion = $receiver2.getLanguageLevel();
                commonCompilerArguments.languageVersion = languageVersion != null ? languageVersion.getVersionString() : null;
                LanguageVersion languageVersion2 = $receiver2.getApiLevel();
                commonCompilerArguments.apiVersion = languageVersion2 != null ? languageVersion2.getVersionString() : null;
            }
        }
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/idea/facet/KotlinFacetEditorGeneralTab$VersionValidator;", "Lcom/intellij/facet/ui/FacetEditorValidator;", "(Lorg/jetbrains/kotlin/idea/facet/KotlinFacetEditorGeneralTab;)V", "check", "Lcom/intellij/facet/ui/ValidationResult;", "idea"})
    public final class VersionValidator
    extends FacetEditorValidator {
        @NotNull
        public ValidationResult check() {
            Object object = KotlinFacetEditorGeneralTab.this.getEditor().getCompilerConfigurable().getApiVersionComboBox().getSelectedItem();
            if (!(object instanceof LanguageVersion)) {
                object = null;
            }
            LanguageVersion languageVersion = (LanguageVersion)object;
            if (languageVersion == null) {
                ValidationResult validationResult = ValidationResult.OK;
                Intrinsics.checkExpressionValueIsNotNull((Object)validationResult, (String)"ValidationResult.OK");
                return validationResult;
            }
            LanguageVersion apiLevel = languageVersion;
            Object object2 = KotlinFacetEditorGeneralTab.this.getEditor().getCompilerConfigurable().getLanguageVersionComboBox().getSelectedItem();
            if (!(object2 instanceof LanguageVersion)) {
                object2 = null;
            }
            LanguageVersion languageVersion2 = (LanguageVersion)object2;
            if (languageVersion2 == null) {
                ValidationResult validationResult = ValidationResult.OK;
                Intrinsics.checkExpressionValueIsNotNull((Object)validationResult, (String)"ValidationResult.OK");
                return validationResult;
            }
            LanguageVersion languageLevel = languageVersion2;
            TargetPlatformKind targetPlatform = (TargetPlatformKind)KotlinFacetEditorGeneralTab.this.getEditor().getTargetPlatformComboBox().getSelectedItem();
            Module module = KotlinFacetEditorGeneralTab.this.editorContext.getModule();
            Intrinsics.checkExpressionValueIsNotNull((Object)module, (String)"editorContext.module");
            LanguageVersion libraryLevel = KotlinVersionInfoProviderKt.getLibraryLanguageLevel(module, KotlinFacetEditorGeneralTab.this.editorContext.getRootModel(), targetPlatform);
            if (languageLevel.compareTo((Enum)apiLevel) < 0 || libraryLevel.compareTo((Enum)apiLevel) < 0) {
                return new ValidationResult("Language version/Runtime version may not be less than API version", null);
            }
            ValidationResult validationResult = ValidationResult.OK;
            Intrinsics.checkExpressionValueIsNotNull((Object)validationResult, (String)"ValidationResult.OK");
            return validationResult;
        }
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/idea/facet/KotlinFacetEditorGeneralTab$CoroutineContradictionValidator;", "Lcom/intellij/facet/ui/FacetEditorValidator;", "(Lorg/jetbrains/kotlin/idea/facet/KotlinFacetEditorGeneralTab;)V", "check", "Lcom/intellij/facet/ui/ValidationResult;", "idea"})
    public final class CoroutineContradictionValidator
    extends FacetEditorValidator {
        @NotNull
        public ValidationResult check() {
            Collection $receiver$iv;
            Object object = KotlinFacetEditorGeneralTab.this.getEditor().getCompilerConfigurable().getCoroutineSupportComboBox().getSelectedItem();
            if (!(object instanceof CoroutineSupport)) {
                object = null;
            }
            CoroutineSupport coroutineSupport = (CoroutineSupport)object;
            if (coroutineSupport == null) {
                ValidationResult validationResult = ValidationResult.OK;
                Intrinsics.checkExpressionValueIsNotNull((Object)validationResult, (String)"ValidationResult.OK");
                return validationResult;
            }
            CoroutineSupport selectedOption = coroutineSupport;
            Serializable serializable = KotlinFacetEditorGeneralTab.this.configuration.getSettings().getCompilerInfo().getCommonCompilerArguments();
            if (serializable == null || (serializable = serializable.getClass()) == null || (serializable = (CommonCompilerArguments)((Class)serializable).newInstance()) == null) {
                ValidationResult validationResult = ValidationResult.OK;
                Intrinsics.checkExpressionValueIsNotNull((Object)validationResult, (String)"ValidationResult.OK");
                return validationResult;
            }
            Serializable parsedArguments = serializable;
            CharSequence charSequence = KotlinFacetEditorGeneralTab.this.getEditor().getCompilerConfigurable().getAdditionalArgsOptionsField().getText();
            Regex regex = new Regex("\\s");
            int n = 0;
            int n2 = 2;
            Object var7_7 = null;
            if ((n2 & 2) != 0) {
                n = 0;
            }
            Collection collection = $receiver$iv = (Collection)regex.split(charSequence, n);
            if (collection == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
            }
            Collection thisCollection$iv = collection;
            String[] stringArray = thisCollection$iv.toArray(new String[thisCollection$iv.size()]);
            if (stringArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            ArgumentUtilsKt.parseArguments((String[])((Object[])stringArray), parsedArguments, true);
            CoroutineSupport coroutineSupport2 = CoroutineSupport.Companion.byCompilerArgumentsOrNull((CommonCompilerArguments)parsedArguments);
            if (coroutineSupport2 == null) {
                ValidationResult validationResult = ValidationResult.OK;
                Intrinsics.checkExpressionValueIsNotNull((Object)validationResult, (String)"ValidationResult.OK");
                return validationResult;
            }
            CoroutineSupport parsedOption = coroutineSupport2;
            if (Intrinsics.areEqual((Object)parsedOption, (Object)selectedOption) ^ true) {
                return new ValidationResult("Coroutine support setting specified as an additional argument differs from the one in \"Coroutines\" field", null);
            }
            ValidationResult validationResult = ValidationResult.OK;
            Intrinsics.checkExpressionValueIsNotNull((Object)validationResult, (String)"ValidationResult.OK");
            return validationResult;
        }
    }
}

