/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.hierarchy;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtil;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=2, d1={"\u0000\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u001a\u0010\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0001\u001a\u0018\u0010\u0003\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0001\u00a8\u0006\u000b"}, d2={"getCallHierarchyElement", "Lcom/intellij/psi/PsiElement;", "element", "getCurrentElement", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "project", "Lcom/intellij/openapi/project/Project;", "isCallHierarchyElement", "", "e", "idea"})
public final class HierarchyUtilsKt {
    public static final boolean isCallHierarchyElement(@NotNull PsiElement e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        return e instanceof PsiMethod || e instanceof PsiClass || e instanceof KtFile || e instanceof KtNamedFunction || e instanceof KtSecondaryConstructor || e instanceof KtObjectDeclaration || e instanceof KtClass && !((KtClass)e).isInterface() || e instanceof KtProperty;
    }

    @Nullable
    public static final PsiElement getCurrentElement(@NotNull DataContext dataContext, @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)dataContext, (String)"dataContext");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (editor != null) {
            PsiFile file2;
            PsiFile psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
            if (psiFile == null) {
                return null;
            }
            PsiFile psiFile2 = file2 = psiFile;
            Intrinsics.checkExpressionValueIsNotNull((Object)psiFile2, (String)"file");
            if (!ProjectRootsUtil.isInProjectOrLibSource((PsiElement)psiFile2)) {
                return null;
            }
            return TargetElementUtil.findTargetElement((Editor)editor, (int)TargetElementUtil.getInstance().getAllAccepted());
        }
        return (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
    }

    @Nullable
    public static final PsiElement getCallHierarchyElement(@NotNull PsiElement element2) {
        Object v0;
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
            Sequence<PsiElement> $receiver$iv = PsiUtilsKt.getParentsWithSelf(element2);
            for (Object element$iv : $receiver$iv) {
                PsiElement p1 = (PsiElement)element$iv;
                if (!HierarchyUtilsKt.isCallHierarchyElement(p1)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }
}

