/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.caches.resolve.KotlinCacheService;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.Severity;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.PsiModificationUtilsKt;
import org.jetbrains.kotlin.idea.highlighter.KotlinPsiChecker;
import org.jetbrains.kotlin.idea.project.TargetPlatformDetector;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.resolve.TargetPlatform;
import org.jetbrains.kotlin.resolve.checkers.HeaderImplDeclarationChecker;
import org.jetbrains.kotlin.resolve.diagnostics.Diagnostics;
import org.jetbrains.kotlin.resolve.diagnostics.KotlinSuppressCache;
import org.jetbrains.kotlin.resolve.diagnostics.SimpleDiagnostics;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u001c\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/PlatformHeaderAnnotator;", "Lcom/intellij/lang/annotation/Annotator;", "()V", "annotate", "", "element", "Lcom/intellij/psi/PsiElement;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "validate", "Lorg/jetbrains/kotlin/resolve/diagnostics/Diagnostics;", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "modulesToCheck", "", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "idea-analysis"})
public final class PlatformHeaderAnnotator
implements Annotator {
    public void annotate(@NotNull PsiElement element2, @NotNull AnnotationHolder holder) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        PsiElement psiElement2 = element2;
        if (!(psiElement2 instanceof KtDeclaration)) {
            psiElement2 = null;
        }
        KtDeclaration ktDeclaration = (KtDeclaration)psiElement2;
        if (ktDeclaration == null) {
            return;
        }
        KtDeclaration declaration2 = ktDeclaration;
        if (!declaration2.hasModifier(KtTokens.HEADER_KEYWORD)) {
            return;
        }
        if (!(TargetPlatformDetector.getPlatform(declaration2.getContainingKtFile()) instanceof TargetPlatform.Default)) {
            return;
        }
        ModuleDescriptor defaultModuleDescriptor = ResolutionUtils.findModuleDescriptor(declaration2);
        Set<ModuleDescriptor> dependentDescriptors = defaultModuleDescriptor.getAllImplementingModules();
        if (dependentDescriptors.isEmpty()) {
            return;
        }
        Diagnostics diagnostics = this.validate(declaration2, (Collection<? extends ModuleDescriptor>)dependentDescriptors);
        new KotlinPsiChecker().annotateElement(declaration2, holder, diagnostics);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Diagnostics validate(@NotNull KtDeclaration declaration2, @NotNull Collection<? extends ModuleDescriptor> modulesToCheck) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable p1;
        void $receiver$iv$iv2;
        Iterable $receiver$iv2;
        Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
        Intrinsics.checkParameterIsNotNull(modulesToCheck, (String)"modulesToCheck");
        DeclarationDescriptor declarationDescriptor = PsiModificationUtilsKt.toDescriptor(declaration2);
        if (!(declarationDescriptor instanceof MemberDescriptor)) {
            declarationDescriptor = null;
        }
        MemberDescriptor memberDescriptor = (MemberDescriptor)declarationDescriptor;
        if (memberDescriptor == null) {
            return Diagnostics.Companion.getEMPTY();
        }
        MemberDescriptor descriptor2 = memberDescriptor;
        if (!descriptor2.isHeader()) {
            return Diagnostics.Companion.getEMPTY();
        }
        Iterable iterable = $receiver$iv2 = (Iterable)modulesToCheck;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv2) {
            ModuleDescriptor moduleDescriptor = (ModuleDescriptor)item$iv$iv;
            Collection collection = destination$iv$iv;
            HeaderImplDeclarationChecker headerImplDeclarationChecker = new HeaderImplDeclarationChecker((ModuleDescriptor)((Object)p1));
            collection.add(headerImplDeclarationChecker);
        }
        List checkers = (List)destination$iv$iv;
        List diagnosticList = new ArrayList();
        DiagnosticSink diagnosticSink2 = new DiagnosticSink(diagnosticList){
            final /* synthetic */ List $diagnosticList;

            public void report(@NotNull Diagnostic diagnostic) {
                Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
                Collection collection = this.$diagnosticList;
                collection.add(diagnostic);
            }

            public boolean wantsDiagnostics() {
                return true;
            }
            {
                this.$diagnosticList = $captured_local_variable$0;
            }
        };
        for (HeaderImplDeclarationChecker checker : checkers) {
            checker.checkHeaderDeclarationHasImplementation(declaration2, descriptor2, diagnosticSink2, false);
        }
        Project project = declaration2.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"declaration.project");
        KotlinSuppressCache suppressionCache = KotlinCacheService.Companion.getInstance(project).getSuppressionCache();
        p1 = $receiver$iv = (Iterable)diagnosticList;
        Collection destination$iv$iv2 = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            Diagnostic it = (Diagnostic)element$iv$iv;
            PsiElement psiElement2 = declaration2;
            String string = it.getFactory().getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.factory.name");
            Severity severity = it.getSeverity();
            Intrinsics.checkExpressionValueIsNotNull((Object)((Object)severity), (String)"it.severity");
            if (!(!suppressionCache.isSuppressed(psiElement2, string, severity))) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List filteredList = (List)destination$iv$iv2;
        Collection collection = filteredList;
        return !collection.isEmpty() ? (Diagnostics)new SimpleDiagnostics(filteredList) : Diagnostics.Companion.getEMPTY();
    }
}

