/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter.markers;

import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProvider;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.highlighter.markers.KotlinLineMarkerProviderKt;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtil;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0010\u0010\b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n0\tH\u0016J\u0018\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\n2\u0006\u0010\f\u001a\u00020\u0007H\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/highlighter/markers/KotlinLineMarkerProvider;", "Lcom/intellij/codeInsight/daemon/LineMarkerProvider;", "()V", "collectSlowLineMarkers", "", "elements", "", "Lcom/intellij/psi/PsiElement;", "result", "", "Lcom/intellij/codeInsight/daemon/LineMarkerInfo;", "getLineMarkerInfo", "element", "idea"})
public final class KotlinLineMarkerProvider
implements LineMarkerProvider {
    @Nullable
    public LineMarkerInfo<PsiElement> getLineMarkerInfo(@NotNull PsiElement element2) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        return null;
    }

    public void collectSlowLineMarkers(@NotNull List<? extends PsiElement> elements2, @NotNull Collection<LineMarkerInfo<?>> result2) {
        Intrinsics.checkParameterIsNotNull(elements2, (String)"elements");
        Intrinsics.checkParameterIsNotNull(result2, (String)"result");
        if (elements2.isEmpty()) {
            return;
        }
        PsiElement first = (PsiElement)CollectionsKt.first(elements2);
        if (DumbService.getInstance((Project)first.getProject()).isDumb() || !ProjectRootsUtil.isInProjectOrLibSource(first)) {
            return;
        }
        HashSet<PsiElement> functions2 = new HashSet<PsiElement>();
        HashSet<PsiElement> properties2 = new HashSet<PsiElement>();
        for (PsiElement psiElement2 : elements2) {
            ProgressManager.checkCanceled();
            PsiElement psiElement22 = psiElement2;
            if (psiElement22 instanceof KtClass) {
                KotlinLineMarkerProviderKt.access$collectInheritedClassMarker((KtClass)psiElement2, result2);
            } else if (psiElement22 instanceof KtNamedFunction) {
                functions2.add(psiElement2);
                KotlinLineMarkerProviderKt.access$collectSuperDeclarationMarkers((KtDeclaration)psiElement2, result2);
            } else if (psiElement22 instanceof KtProperty) {
                properties2.add(psiElement2);
                KotlinLineMarkerProviderKt.access$collectSuperDeclarationMarkers((KtDeclaration)psiElement2, result2);
            } else if (psiElement22 instanceof KtParameter && ((KtParameter)psiElement2).hasValOrVar()) {
                properties2.add(psiElement2);
                KotlinLineMarkerProviderKt.access$collectSuperDeclarationMarkers((KtDeclaration)psiElement2, result2);
            }
            if (!(psiElement2 instanceof KtNamedDeclaration)) continue;
            if (((KtNamedDeclaration)psiElement2).hasModifier(KtTokens.HEADER_KEYWORD)) {
                KotlinLineMarkerProviderKt.access$collectImplementationMarkers((KtNamedDeclaration)psiElement2, result2);
                continue;
            }
            if (!((KtNamedDeclaration)psiElement2).hasModifier(KtTokens.IMPL_KEYWORD)) continue;
            KotlinLineMarkerProviderKt.access$collectHeaderMarkers((KtNamedDeclaration)psiElement2, result2);
        }
        KotlinLineMarkerProviderKt.access$collectOverriddenFunctions(functions2, result2);
        KotlinLineMarkerProviderKt.access$collectOverriddenPropertyAccessors(properties2, result2);
    }
}

