/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter.renderersUtil;

import com.google.common.html.HtmlEscapers;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.rendering.RenderersKt;
import org.jetbrains.kotlin.diagnostics.rendering.RenderingContext;
import org.jetbrains.kotlin.diagnostics.rendering.SmartDescriptorRenderer;
import org.jetbrains.kotlin.diagnostics.rendering.SmartTypeRenderer;
import org.jetbrains.kotlin.idea.highlighter.renderersUtil.RenderersUtilKt;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.renderer.DescriptorRendererOptions;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=2, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u001a\u000e\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u001a\u0010\b\u001a\u00020\u00032\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\n2\u0006\u0010\u000b\u001a\u00020\f\u001a\u000e\u0010\r\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0016\u0010\r\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"HTML_FOR_UNINFERRED_TYPE_PARAMS", "Lorg/jetbrains/kotlin/renderer/DescriptorRenderer;", "RED_TEMPLATE", "", "STRONG_TEMPLATE", "renderError", "o", "", "renderResolvedCall", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "context", "Lorg/jetbrains/kotlin/diagnostics/rendering/RenderingContext;", "renderStrong", "error", "", "idea-analysis"})
public final class RenderersUtilKt {
    private static final String RED_TEMPLATE = "<font color=red><b>%s</b></font>";
    private static final String STRONG_TEMPLATE = "<b>%s</b>";
    private static final DescriptorRenderer HTML_FOR_UNINFERRED_TYPE_PARAMS;

    @NotNull
    public static final String renderStrong(@NotNull Object o) {
        Intrinsics.checkParameterIsNotNull((Object)o, (String)"o");
        String string = STRONG_TEMPLATE;
        Object[] objectArray = new Object[]{o};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(this, *args)");
        return string2;
    }

    @NotNull
    public static final String renderError(@NotNull Object o) {
        Intrinsics.checkParameterIsNotNull((Object)o, (String)"o");
        String string = RED_TEMPLATE;
        Object[] objectArray = new Object[]{o};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(this, *args)");
        return string2;
    }

    @NotNull
    public static final String renderStrong(@NotNull Object o, boolean error) {
        Intrinsics.checkParameterIsNotNull((Object)o, (String)"o");
        String string = error ? RED_TEMPLATE : STRONG_TEMPLATE;
        Object[] objectArray = new Object[]{o};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(this, *args)");
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String renderResolvedCall(@NotNull ResolvedCall<?> resolvedCall2, @NotNull RenderingContext context) {
        Collection<String> collection;
        void $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull(resolvedCall2, (String)"resolvedCall");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        SmartTypeRenderer typeRenderer2 = new SmartTypeRenderer(HTML_FOR_UNINFERRED_TYPE_PARAMS);
        SmartDescriptorRenderer descriptorRenderer2 = RenderersKt.asRenderer(HTML_FOR_UNINFERRED_TYPE_PARAMS);
        StringBuilder stringBuilder = new StringBuilder("");
        String indent = "&nbsp;&nbsp;";
        Function1<Object, StringBuilder> append$ = new Function1<Object, StringBuilder>(stringBuilder){
            final /* synthetic */ StringBuilder $stringBuilder;

            @NotNull
            public final StringBuilder invoke(@NotNull Object any2) {
                Intrinsics.checkParameterIsNotNull((Object)any2, (String)"any");
                StringBuilder stringBuilder = this.$stringBuilder.append(any2);
                Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder, (String)"stringBuilder.append(any)");
                return stringBuilder;
            }
            {
                this.$stringBuilder = stringBuilder;
                super(1);
            }
        };
        Function1<ValueParameterDescriptor, String> renderParameter$ = new Function1<ValueParameterDescriptor, String>(typeRenderer2, context, resolvedCall2){
            final /* synthetic */ SmartTypeRenderer $typeRenderer;
            final /* synthetic */ RenderingContext $context;
            final /* synthetic */ ResolvedCall $resolvedCall;

            @NotNull
            public final String invoke(@NotNull ValueParameterDescriptor parameter) {
                Intrinsics.checkParameterIsNotNull((Object)parameter, (String)"parameter");
                KotlinType varargElementType = parameter.getVarargElementType();
                KotlinType kotlinType = varargElementType;
                if (kotlinType == null) {
                    KotlinType kotlinType2 = parameter.getType();
                    kotlinType = kotlinType2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType2, (String)"parameter.type");
                }
                KotlinType parameterType = kotlinType;
                String renderedParameter = (varargElementType != null ? "<b>vararg</b> " : "") + this.$typeRenderer.render(parameterType, this.$context) + (DescriptorUtilsKt.hasDefaultValue(parameter) ? " = ..." : "");
                if (CallUtilKt.hasTypeMismatchErrorOnParameter(this.$resolvedCall, parameter)) {
                    return RenderersUtilKt.renderError(renderedParameter);
                }
                return renderedParameter;
            }
            {
                this.$typeRenderer = smartTypeRenderer;
                this.$context = renderingContext;
                this.$resolvedCall = resolvedCall2;
                super(1);
            }
        };
        Function0<Unit> appendTypeParametersSubstitution$ = new Function0<Unit>(resolvedCall2, append$, indent, typeRenderer2, context){
            final /* synthetic */ ResolvedCall $resolvedCall;
            final /* synthetic */ renderResolvedCall.1 $append;
            final /* synthetic */ String $indent;
            final /* synthetic */ SmartTypeRenderer $typeRenderer;
            final /* synthetic */ RenderingContext $context;

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                void inferredTypeParameters;
                String string;
                Iterable<String> iterable;
                Iterable $receiver$iv$iv;
                Iterable destination$iv$iv;
                renderResolvedCall.1 var16_13;
                void notInferredTypeParameters;
                Map<TypeParameterDescriptor, KotlinType> parametersToArgumentsMap = this.$resolvedCall.getTypeArguments();
                Function1<TypeParameterDescriptor, Boolean> isInferred$ = new Function1<TypeParameterDescriptor, Boolean>(parametersToArgumentsMap){
                    final /* synthetic */ Map $parametersToArgumentsMap;

                    public final boolean invoke(@NotNull TypeParameterDescriptor $receiver) {
                        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                        KotlinType typeArgument = (KotlinType)this.$parametersToArgumentsMap.get($receiver);
                        if (typeArgument == null) {
                            return false;
                        }
                        return !ErrorUtils.isUninferredParameter(typeArgument);
                    }
                    {
                        this.$parametersToArgumentsMap = map2;
                        super(1);
                    }
                };
                List<TypeParameterDescriptor> typeParameters = this.$resolvedCall.getCandidateDescriptor().getTypeParameters();
                Iterable $receiver$iv = typeParameters;
                ArrayList<T> first$iv = new ArrayList<T>();
                ArrayList<T> second$iv = new ArrayList<T>();
                for (Object element$iv : $receiver$iv) {
                    TypeParameterDescriptor parameter = (TypeParameterDescriptor)element$iv;
                    if (isInferred$.invoke(parameter)) {
                        first$iv.add(element$iv);
                        continue;
                    }
                    second$iv.add(element$iv);
                }
                Object object = new Pair(first$iv, second$iv);
                List list2 = (List)object.component1();
                List list3 = (List)object.component2();
                object = null;
                this.$append.invoke("<br/>" + this.$indent + "<i>where</i> ");
                if (!notInferredTypeParameters.isEmpty()) {
                    void $receiver$iv2;
                    object = (Iterable)notInferredTypeParameters;
                    var16_13 = this.$append;
                    $receiver$iv = $receiver$iv2;
                    destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
                    for (E item$iv$iv : $receiver$iv$iv) {
                        void typeParameter;
                        Object element$iv;
                        element$iv = (TypeParameterDescriptor)item$iv$iv;
                        iterable = destination$iv$iv;
                        Name name2 = typeParameter.getName();
                        Intrinsics.checkExpressionValueIsNotNull((Object)name2, (String)"typeParameter.name");
                        string = RenderersUtilKt.renderError(name2);
                        iterable.add(string);
                    }
                    iterable = (List)destination$iv$iv;
                    var16_13.invoke(CollectionsKt.joinToString$default((Iterable)iterable, null, null, null, (int)0, null, null, (int)63, null));
                    this.$append.invoke("<i> cannot be inferred</i>");
                    if (!inferredTypeParameters.isEmpty()) {
                        this.$append.invoke("; ");
                    }
                }
                Map<TypeParameterDescriptor, KotlinType> typeParameterToTypeArgumentMap = this.$resolvedCall.getTypeArguments();
                if (!inferredTypeParameters.isEmpty()) {
                    void $receiver$iv$iv2;
                    $receiver$iv$iv = (Iterable)inferredTypeParameters;
                    var16_13 = this.$append;
                    destination$iv$iv = $receiver$iv;
                    Collection destination$iv$iv2 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                    for (T item$iv$iv : $receiver$iv$iv2) {
                        void typeParameter;
                        TypeParameterDescriptor $i$a$3$map = (TypeParameterDescriptor)item$iv$iv;
                        iterable = destination$iv$iv2;
                        StringBuilder stringBuilder = new StringBuilder().append(typeParameter.getName()).append(" = ");
                        KotlinType kotlinType = typeParameterToTypeArgumentMap.get(typeParameter);
                        if (kotlinType == null) {
                            Intrinsics.throwNpe();
                        }
                        string = stringBuilder.append(this.$typeRenderer.render(kotlinType, this.$context)).toString();
                        iterable.add((String)string);
                    }
                    iterable = (List)destination$iv$iv2;
                    var16_13.invoke(CollectionsKt.joinToString$default((Iterable)iterable, null, null, null, (int)0, null, null, (int)63, null));
                }
            }
            {
                this.$resolvedCall = resolvedCall2;
                this.$append = var2_2;
                this.$indent = string;
                this.$typeRenderer = smartTypeRenderer;
                this.$context = renderingContext;
                super(0);
            }
        };
        Object resultingDescriptor = resolvedCall2.getResultingDescriptor();
        ReceiverParameterDescriptor receiverParameter = resultingDescriptor.getExtensionReceiverParameter();
        if (receiverParameter != null) {
            KotlinType kotlinType = receiverParameter.getType();
            Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"receiverParameter.type");
            ((StringBuilder)append$.invoke((Object)typeRenderer2.render(kotlinType, context))).append(".");
        }
        String string = HtmlEscapers.htmlEscaper().escape(resultingDescriptor.getName().asString());
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"HtmlEscapers.htmlEscaper\u2026scriptor.name.asString())");
        ((StringBuilder)append$.invoke((Object)string)).append("(");
        Iterable iterable = resultingDescriptor.getValueParameters();
        Function1<Object, StringBuilder> function1 = append$;
        void var12_13 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void parameter;
            ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)item$iv$iv;
            collection = destination$iv$iv;
            void v2 = parameter;
            Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"parameter");
            String string2 = renderParameter$.invoke((ValueParameterDescriptor)v2);
            collection.add(string2);
        }
        collection = (List)destination$iv$iv;
        function1.invoke((Object)CollectionsKt.joinToString$default((Iterable)collection, null, null, null, (int)0, null, null, (int)63, null));
        append$.invoke((Object)(CallUtilKt.hasUnmappedArguments(resolvedCall2) ? RenderersUtilKt.renderError(")") : ")"));
        if (!resolvedCall2.getCandidateDescriptor().getTypeParameters().isEmpty()) {
            appendTypeParametersSubstitution$.invoke();
            append$.invoke((Object)("<i> for </i><br/>" + indent));
            Object obj = resolvedCall2.getCandidateDescriptor();
            Intrinsics.checkExpressionValueIsNotNull(obj, (String)"resolvedCall.candidateDescriptor");
            append$.invoke((Object)descriptorRenderer2.render((DeclarationDescriptor)obj, RenderingContext.Companion.of(resolvedCall2.getCandidateDescriptor())));
        } else {
            String string3;
            append$.invoke((Object)" <i>defined in</i> ");
            DeclarationDescriptor containingDeclaration = resultingDescriptor.getContainingDeclaration();
            FqNameUnsafe fqName2 = DescriptorUtils.getFqName(containingDeclaration);
            if (fqName2.isRoot()) {
                string3 = "root package";
            } else {
                String string4 = fqName2.asString();
                string3 = string4;
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"fqName.asString()");
            }
            append$.invoke((Object)string3);
        }
        String string5 = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"stringBuilder.toString()");
        return string5;
    }

    static {
        RED_TEMPLATE = RED_TEMPLATE;
        STRONG_TEMPLATE = STRONG_TEMPLATE;
        HTML_FOR_UNINFERRED_TYPE_PARAMS = DescriptorRenderer.Companion.withOptions((Function1<? super DescriptorRendererOptions, Unit>)((Function1)HTML_FOR_UNINFERRED_TYPE_PARAMS.1.INSTANCE));
    }
}

