/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Query;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.inspections.CanBeParameterInspection$WhenMappings;
import org.jetbrains.kotlin.idea.inspections.CanBeParameterInspectionKt;
import org.jetbrains.kotlin.idea.quickfix.RemoveValVarFromParameterFix;
import org.jetbrains.kotlin.idea.references.KtSimpleNameReference;
import org.jetbrains.kotlin.idea.search.usagesSearch.SearchHelpersKt;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassInitializer;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtSuperTypeCallEntry;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0014\u0010\t\u001a\u00020\b*\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/CanBeParameterInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractKotlinInspection;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "usedAsPropertyIn", "Lcom/intellij/psi/PsiReference;", "klass", "Lorg/jetbrains/kotlin/psi/KtClass;", "RemoveValVarFix", "idea"})
public final class CanBeParameterInspection
extends AbstractKotlinInspection {
    private final boolean usedAsPropertyIn(@NotNull PsiReference $receiver, KtClass klass2) {
        PsiElement $receiver$iv;
        KtElement ktElement;
        if (!($receiver instanceof KtSimpleNameReference)) {
            return true;
        }
        KtSimpleNameExpression nameExpression2 = (KtSimpleNameExpression)((KtSimpleNameReference)$receiver).getElement();
        PsiElement parent2 = ((KtSimpleNameExpression)((KtSimpleNameReference)$receiver).getElement()).getParent();
        if (parent2 instanceof KtQualifiedExpression && Intrinsics.areEqual((Object)((KtQualifiedExpression)parent2).getSelectorExpression(), (Object)((KtSimpleNameExpression)((KtSimpleNameReference)$receiver).getElement()))) {
            return true;
        }
        if (parent2 instanceof KtBinaryExpression && Intrinsics.areEqual((Object)((KtBinaryExpression)parent2).getLeft(), (Object)((KtSimpleNameExpression)((KtSimpleNameReference)$receiver).getElement())) && KtPsiUtil.isAssignment(parent2)) {
            return true;
        }
        KtSimpleNameExpression ktSimpleNameExpression = nameExpression2;
        Intrinsics.checkExpressionValueIsNotNull((Object)ktSimpleNameExpression, (String)"nameExpression");
        PsiElement parameterUser = (PsiElement)ktSimpleNameExpression;
        do {
            ktElement = (KtElement)PsiTreeUtil.getParentOfType((PsiElement)parameterUser, (Class[])new Class[]{KtProperty.class, KtPropertyAccessor.class, KtClassInitializer.class, KtFunction.class, KtObjectDeclaration.class, KtSuperTypeCallEntry.class});
            if (ktElement != null) continue;
            return true;
        } while ((parameterUser = (PsiElement)ktElement) instanceof KtProperty && ((KtProperty)parameterUser).isLocal());
        PsiElement psiElement2 = parameterUser;
        boolean bl = psiElement2 instanceof KtProperty ? KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)parameterUser) != klass2 : (psiElement2 instanceof KtClassInitializer ? ((KtClassInitializer)parameterUser).getContainingDeclaration() != klass2 : (psiElement2 instanceof KtFunction || psiElement2 instanceof KtObjectDeclaration || psiElement2 instanceof KtPropertyAccessor ? true : (psiElement2 instanceof KtSuperTypeCallEntry ? (KtClassOrObject)PsiTreeUtil.getParentOfType((PsiElement)($receiver$iv = parameterUser), KtClassOrObject.class, (boolean)true) != klass2 : true)));
        return bl;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        return new KtVisitorVoid(this, holder){
            final /* synthetic */ CanBeParameterInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;

            public void visitParameter(@NotNull KtParameter parameter) {
                boolean bl;
                PsiElement valOrVar;
                block18: {
                    Query references2;
                    Intrinsics.checkParameterIsNotNull((Object)parameter, (String)"parameter");
                    PsiElement psiElement2 = parameter.getValOrVarKeyword();
                    if (psiElement2 == null) {
                        return;
                    }
                    valOrVar = psiElement2;
                    String string = parameter.getName();
                    if (string == null) {
                        return;
                    }
                    String name2 = string;
                    if (parameter.hasModifier(KtTokens.OVERRIDE_KEYWORD)) {
                        return;
                    }
                    Collection collection = parameter.getAnnotationEntries();
                    if (!collection.isEmpty()) {
                        return;
                    }
                    PsiElement psiElement3 = parameter.getParent().getParent();
                    if (!(psiElement3 instanceof KtPrimaryConstructor)) {
                        psiElement3 = null;
                    }
                    KtPrimaryConstructor ktPrimaryConstructor = (KtPrimaryConstructor)psiElement3;
                    if (ktPrimaryConstructor == null) {
                        return;
                    }
                    KtPrimaryConstructor constructor2 = ktPrimaryConstructor;
                    KtClassOrObject ktClassOrObject = constructor2.getContainingClassOrObject();
                    if (!(ktClassOrObject instanceof KtClass)) {
                        ktClassOrObject = null;
                    }
                    KtClass ktClass = (KtClass)ktClassOrObject;
                    if (ktClass == null) {
                        return;
                    }
                    KtClass klass2 = ktClass;
                    if (klass2.isData()) {
                        return;
                    }
                    SearchScope useScope2 = parameter.getUseScope();
                    if (useScope2 instanceof GlobalSearchScope) {
                        PsiSearchHelper psiSearchHelper = PsiSearchHelper.SERVICE.getInstance((Project)parameter.getProject());
                        block3: for (String accessorName : SearchHelpersKt.getAccessorNames$default((PsiNamedElement)parameter, false, false, 3, null)) {
                            switch (CanBeParameterInspection$WhenMappings.$EnumSwitchMapping$0[psiSearchHelper.isCheapEnoughToSearch(accessorName, (GlobalSearchScope)useScope2, null, null).ordinal()]) {
                                case 1: {
                                    continue block3;
                                }
                            }
                            return;
                        }
                        if (Intrinsics.areEqual((Object)psiSearchHelper.isCheapEnoughToSearch(name2, (GlobalSearchScope)useScope2, null, null), (Object)PsiSearchHelper.SearchCostResult.FEW_OCCURRENCES) ^ true) {
                            return;
                        }
                    }
                    if (CollectionsKt.none((Iterable)((Iterable)(references2 = ReferencesSearch.search((PsiElement)parameter, (SearchScope)useScope2))))) {
                        return;
                    }
                    Iterable $receiver$iv = (Iterable)references2;
                    for (Object element$iv : $receiver$iv) {
                        PsiReference it = (PsiReference)element$iv;
                        if (!CanBeParameterInspection.access$usedAsPropertyIn(this.this$0, it, klass2)) continue;
                        bl = true;
                        break block18;
                    }
                    bl = false;
                }
                if (bl) {
                    return;
                }
                this.$holder.registerProblem(valOrVar, "Constructor parameter is never used as a property", ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[]{new RemoveValVarFix(parameter)});
            }
            {
                this.this$0 = $outer;
                this.$holder = $captured_local_variable$1;
            }
        };
    }

    public static final /* synthetic */ boolean access$usedAsPropertyIn(CanBeParameterInspection $this, @NotNull PsiReference $receiver, @NotNull KtClass klass2) {
        return $this.usedAsPropertyIn($receiver, klass2);
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0010H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/CanBeParameterInspection$RemoveValVarFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "parameter", "Lorg/jetbrains/kotlin/psi/KtParameter;", "(Lorg/jetbrains/kotlin/psi/KtParameter;)V", "fix", "Lorg/jetbrains/kotlin/idea/quickfix/RemoveValVarFromParameterFix;", "getParameter", "()Lorg/jetbrains/kotlin/psi/KtParameter;", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "getName", "idea"})
    public static final class RemoveValVarFix
    implements LocalQuickFix {
        private final RemoveValVarFromParameterFix fix;
        @NotNull
        private final KtParameter parameter;

        @NotNull
        public String getName() {
            return this.fix.getText();
        }

        @NotNull
        public String getFamilyName() {
            return this.fix.getFamilyName();
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
            if (!FileModificationService.getInstance().preparePsiElementForWrite(descriptor2.getPsiElement())) {
                return;
            }
            PsiElement psiElement2 = this.parameter.getValOrVarKeyword();
            if (psiElement2 != null) {
                psiElement2.delete();
            }
            KtModifierList ktModifierList = this.parameter.getModifierList();
            if (ktModifierList == null) {
                return;
            }
            KtModifierList modifierList = ktModifierList;
            for (KtModifierKeywordToken modifier : CanBeParameterInspectionKt.getCONSTRUCTOR_VAL_VAR_MODIFIERS()) {
                PsiElement psiElement3 = modifierList.getModifier(modifier);
                if (psiElement3 == null) continue;
                psiElement3.delete();
            }
        }

        @NotNull
        public final KtParameter getParameter() {
            return this.parameter;
        }

        public RemoveValVarFix(@NotNull KtParameter parameter) {
            Intrinsics.checkParameterIsNotNull((Object)parameter, (String)"parameter");
            this.parameter = parameter;
            this.fix = new RemoveValVarFromParameterFix(this.parameter);
        }
    }
}

