/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.addRemoveModifier.AddRemoveModifierKt;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u0003H\u0016J\b\u0010\u000e\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/RemoveModifierFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "text", "", "(Ljava/lang/String;)V", "getText", "()Ljava/lang/String;", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "getName", "idea"})
public final class RemoveModifierFix
implements LocalQuickFix {
    @NotNull
    private final String text;

    @NotNull
    public String getName() {
        return this.text;
    }

    @NotNull
    public String getFamilyName() {
        return this.text;
    }

    /*
     * WARNING - void declaration
     */
    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        IElementType iElementType = descriptor2.getPsiElement().getNode().getElementType();
        if (iElementType == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.lexer.KtModifierKeywordToken");
        }
        KtModifierKeywordToken modifierKeyword = (KtModifierKeywordToken)iElementType;
        PsiElement psiElement2 = descriptor2.getPsiElement();
        boolean strict$iv = true;
        KtModifierListOwner ktModifierListOwner = (KtModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, KtModifierListOwner.class, (boolean)strict$iv);
        if (ktModifierListOwner == null) {
            throw (Throwable)new IllegalStateException("Can't find modifier list owner for modifier");
        }
        KtModifierListOwner modifierListOwner = ktModifierListOwner;
        if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)modifierListOwner)) {
            return;
        }
        AddRemoveModifierKt.removeModifier(modifierListOwner, modifierKeyword);
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    public RemoveModifierFix(@NotNull String text2) {
        Intrinsics.checkParameterIsNotNull((Object)text2, (String)"text");
        this.text = text2;
    }
}

