/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.intentions.SelfTargetingIntention;
import org.jetbrains.kotlin.idea.intentions.UtilsKt;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtContainerNode;
import org.jetbrains.kotlin.psi.KtDoWhileExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtLoopExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0016\u0010\r\u001a\u0004\u0018\u00010\u000e*\u00020\u00022\u0006\u0010\u000f\u001a\u00020\fH\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/AddBracesIntention;", "Lorg/jetbrains/kotlin/idea/intentions/SelfTargetingIntention;", "Lorg/jetbrains/kotlin/psi/KtElement;", "()V", "applyTo", "", "element", "editor", "Lcom/intellij/openapi/editor/Editor;", "isApplicableTo", "", "caretOffset", "", "getTargetExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "caretLocation", "idea"})
public final class AddBracesIntention
extends SelfTargetingIntention<KtElement> {
    @Override
    public boolean isApplicableTo(@NotNull KtElement element2, int caretOffset) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        KtExpression ktExpression = this.getTargetExpression(element2, caretOffset);
        if (ktExpression == null) {
            return false;
        }
        KtExpression expression2 = ktExpression;
        if (expression2 instanceof KtBlockExpression) {
            return false;
        }
        PsiElement parent2 = expression2.getParent();
        PsiElement psiElement2 = parent2;
        if (psiElement2 instanceof KtContainerNode) {
            String string = UtilsKt.description((KtContainerNode)parent2);
            if (string == null) {
                Intrinsics.throwNpe();
            }
            String description = string;
            this.setText("Add braces to '" + description + "' statement");
            return true;
        }
        if (psiElement2 instanceof KtWhenEntry) {
            this.setText("Add braces to 'when' entry");
            return true;
        }
        return false;
    }

    @Override
    public void applyTo(@NotNull KtElement element2, @Nullable Editor editor) {
        block7: {
            PsiElement psiElement2;
            Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
            if (editor == null) {
                throw (Throwable)new IllegalArgumentException("This intention requires an editor");
            }
            KtExpression ktExpression = this.getTargetExpression(element2, editor.getCaretModel().getOffset());
            if (ktExpression == null) {
                Intrinsics.throwNpe();
            }
            KtExpression expression2 = ktExpression;
            PsiElement psiElement3 = element2.getNextSibling();
            if (Intrinsics.areEqual((Object)(psiElement3 != null ? psiElement3.getText() : null), (Object)";")) {
                PsiElement psiElement4 = element2.getNextSibling();
                if (psiElement4 == null) {
                    Intrinsics.throwNpe();
                }
                psiElement4.delete();
            }
            KtPsiFactory psiFactory = KtPsiFactoryKt.KtPsiFactory((PsiElement)element2);
            expression2.replace((PsiElement)psiFactory.createSingleStatementBlock(expression2));
            if (!(element2 instanceof KtDoWhileExpression)) break block7;
            KtExpression ktExpression2 = ((KtDoWhileExpression)element2).getBody();
            if (ktExpression2 == null) {
                Intrinsics.throwNpe();
            }
            if (!((psiElement2 = ktExpression2.getParent().getNextSibling()) instanceof PsiWhiteSpace)) {
                psiElement2 = null;
            }
            PsiWhiteSpace psiWhiteSpace = (PsiWhiteSpace)psiElement2;
            if (psiWhiteSpace != null) {
                psiWhiteSpace.delete();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private final KtExpression getTargetExpression(@NotNull KtElement $receiver, int caretLocation) {
        KtExpression ktExpression;
        KtElement ktElement = $receiver;
        if (ktElement instanceof KtIfExpression) {
            KtExpression ktExpression2 = ((KtIfExpression)$receiver).getThen();
            if (ktExpression2 == null) return null;
            KtExpression thenExpr = ktExpression2;
            KtExpression elseExpr = ((KtIfExpression)$receiver).getElse();
            if (elseExpr != null) {
                PsiElement psiElement2 = ((KtIfExpression)$receiver).getElseKeyword();
                if (psiElement2 == null) {
                    Intrinsics.throwNpe();
                }
                if (caretLocation >= PsiUtilsKt.getStartOffset(psiElement2)) {
                    ktExpression = elseExpr;
                    return ktExpression;
                }
            }
            ktExpression = thenExpr;
            return ktExpression;
        }
        if (ktElement instanceof KtLoopExpression) {
            ktExpression = ((KtLoopExpression)$receiver).getBody();
            return ktExpression;
        }
        if (!(ktElement instanceof KtWhenEntry)) return null;
        ktExpression = ((KtWhenEntry)$receiver).getExpression();
        return ktExpression;
    }

    public AddBracesIntention() {
        super(KtElement.class, "Add braces", null, 4, null);
    }
}

