/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.intentions.SelfTargetingRangeIntention;
import org.jetbrains.kotlin.idea.intentions.SpecifyTypeExplicitlyIntention;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000e2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u001a\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00022\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/ConvertPropertyInitializerToGetterIntention;", "Lorg/jetbrains/kotlin/idea/intentions/SelfTargetingRangeIntention;", "Lorg/jetbrains/kotlin/psi/KtProperty;", "()V", "allowCaretInsideElement", "", "element", "Lcom/intellij/psi/PsiElement;", "applicabilityRange", "Lcom/intellij/openapi/util/TextRange;", "applyTo", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "Companion", "idea"})
public final class ConvertPropertyInitializerToGetterIntention
extends SelfTargetingRangeIntention<KtProperty> {
    public static final Companion Companion = new Companion(null);

    @Override
    @Nullable
    public TextRange applicabilityRange(@NotNull KtProperty element2) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        KtExpression initializer2 = element2.getInitializer();
        if (initializer2 != null && element2.getGetter() == null && !KtPsiUtilKt.isExtensionDeclaration(element2) && !element2.isLocal()) {
            return initializer2.getTextRange();
        }
        return null;
    }

    @Override
    protected boolean allowCaretInsideElement(@NotNull PsiElement element2) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        return !(element2 instanceof KtDeclaration) && super.allowCaretInsideElement(element2);
    }

    @Override
    public void applyTo(@NotNull KtProperty element2, @Nullable Editor editor) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        Companion.convertPropertyInitializerToGetter(element2, editor);
    }

    public ConvertPropertyInitializerToGetterIntention() {
        super(KtProperty.class, "Convert property initializer to getter", null, 4, null);
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/ConvertPropertyInitializerToGetterIntention$Companion;", "", "()V", "convertPropertyInitializerToGetter", "", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "editor", "Lcom/intellij/openapi/editor/Editor;", "idea"})
    public static final class Companion {
        public final void convertPropertyInitializerToGetter(@NotNull KtProperty property2, @Nullable Editor editor) {
            Intrinsics.checkParameterIsNotNull((Object)property2, (String)"property");
            KotlinType type2 = SpecifyTypeExplicitlyIntention.Companion.getTypeForDeclaration(property2);
            SpecifyTypeExplicitlyIntention.Companion.addTypeAnnotation(editor, property2, type2);
            KtExpression ktExpression = property2.getInitializer();
            if (ktExpression == null) {
                Intrinsics.throwNpe();
            }
            KtExpression initializer2 = ktExpression;
            KtPsiFactory ktPsiFactory = KtPsiFactoryKt.KtPsiFactory(property2);
            KtExpression ktExpression2 = initializer2;
            Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression2, (String)"initializer");
            KtPropertyAccessor getter = ktPsiFactory.createPropertyGetter(ktExpression2);
            KtPropertyAccessor setter = property2.getSetter();
            if (setter != null) {
                property2.addBefore(getter, setter);
            } else {
                property2.add(getter);
            }
            property2.setInitializer(null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

