/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptorWithTypeParameters;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.GenerateUtilKt;
import org.jetbrains.kotlin.idea.core.ShortenReferences;
import org.jetbrains.kotlin.idea.imports.ImportsUtils;
import org.jetbrains.kotlin.idea.intentions.SelfTargetingRangeIntention;
import org.jetbrains.kotlin.idea.util.ImportInsertHelper;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.ImportPath;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMappingKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0016B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u001a\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u00022\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u000e\u0010\u0010\u001a\u0004\u0018\u00010\u0011*\u00020\u0002H\u0002J\u000e\u0010\u0012\u001a\u0004\u0018\u00010\u000f*\u00020\u0013H\u0002J\u000e\u0010\u0014\u001a\u0004\u0018\u00010\u0015*\u00020\u0002H\u0002\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/DeprecatedCallableAddReplaceWithIntention;", "Lorg/jetbrains/kotlin/idea/intentions/SelfTargetingRangeIntention;", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "()V", "applicabilityRange", "Lcom/intellij/openapi/util/TextRange;", "element", "applyTo", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "extractImports", "", "", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "deprecatedAnnotationWithNoReplaceWith", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "replacementExpressionFromBody", "Lorg/jetbrains/kotlin/psi/KtDeclarationWithBody;", "suggestReplaceWith", "Lorg/jetbrains/kotlin/idea/intentions/DeprecatedCallableAddReplaceWithIntention$ReplaceWith;", "ReplaceWith", "idea"})
public final class DeprecatedCallableAddReplaceWithIntention
extends SelfTargetingRangeIntention<KtCallableDeclaration> {
    @Override
    @Nullable
    public TextRange applicabilityRange(@NotNull KtCallableDeclaration element2) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        KtAnnotationEntry ktAnnotationEntry = this.deprecatedAnnotationWithNoReplaceWith(element2);
        if (ktAnnotationEntry == null) {
            return null;
        }
        KtAnnotationEntry annotationEntry2 = ktAnnotationEntry;
        if (this.suggestReplaceWith(element2) == null) {
            return null;
        }
        return annotationEntry2.getTextRange();
    }

    @Override
    public void applyTo(@NotNull KtCallableDeclaration element2, @Nullable Editor editor) {
        Object argument2;
        int c;
        StringBuilder $receiver;
        Object escapedText;
        ReplaceWith replaceWith;
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        ReplaceWith replaceWith2 = this.suggestReplaceWith(element2);
        if (replaceWith2 == null) {
            Intrinsics.throwNpe();
        }
        boolean bl2 = bl = StringsKt.contains$default((CharSequence)(replaceWith = replaceWith2).getExpression(), (char)'\n', (boolean)false, (int)2, null) ^ true && StringsKt.contains$default((CharSequence)replaceWith.getExpression(), (char)'\r', (boolean)false, (int)2, null) ^ true;
        if (_Assertions.ENABLED && !bl) {
            String string = "Formatted expression text should not contain \\n or \\r";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        KtAnnotationEntry ktAnnotationEntry = this.deprecatedAnnotationWithNoReplaceWith(element2);
        if (ktAnnotationEntry == null) {
            Intrinsics.throwNpe();
        }
        KtAnnotationEntry annotationEntry2 = ktAnnotationEntry;
        KtPsiFactory psiFactory = KtPsiFactoryKt.KtPsiFactory(element2);
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = StringsKt.replace$default((String)StringsKt.replace$default((String)replaceWith.getExpression(), (String)"\\", (String)"\\\\", (boolean)false, (int)4, null), (String)"\"", (String)"\\\"", (boolean)false, (int)4, null);
        if (StringsKt.contains$default((CharSequence)((String)escapedText.element), (char)'$', (boolean)false, (int)2, null)) {
            StringBuilder stringBuilder = new StringBuilder();
            void var17_10 = escapedText;
            $receiver = stringBuilder;
            int i = 0;
            int length = ((String)escapedText.element).length();
            while (i < length) {
                char c1;
                char c2;
                if ((c = ((String)escapedText.element).charAt(i++)) == 36 && i < length && (Character.isJavaIdentifierStart(c2 = (c1 = ((String)escapedText.element).charAt(i))) || c1 == '{')) {
                    $receiver.append('\\');
                }
                $receiver.append((char)c);
            }
            StringBuilder stringBuilder2 = stringBuilder;
            String string = stringBuilder2.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringBuilder().apply {\n\u2026\n            }.toString()");
            var17_10.element = string;
        }
        StringBuilder $receiver2 = $receiver = new StringBuilder();
        $receiver2.append("kotlin.ReplaceWith(\"");
        $receiver2.append((String)escapedText.element);
        $receiver2.append("\"");
        Object[] $receiver$iv = replaceWith.getImports();
        for (c = 0; c < $receiver$iv.length; ++c) {
            Object element$iv = $receiver$iv[c];
            String it = (String)element$iv;
            $receiver2.append(",\"").append(it).append("\"");
        }
        $receiver2.append(")");
        String argumentText = $receiver.toString();
        $receiver = new Ref.ObjectRef();
        String string = argumentText;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"argumentText");
        ((Ref.ObjectRef)$receiver).element = KtPsiFactory.createArgument$default(psiFactory, psiFactory.createExpression(string), null, false, 6, null);
        KtValueArgumentList ktValueArgumentList = annotationEntry2.getValueArgumentList();
        if (ktValueArgumentList == null) {
            Intrinsics.throwNpe();
        }
        KtValueArgument ktValueArgument = ktValueArgumentList.addArgument((KtValueArgument)argument2.element);
        Intrinsics.checkExpressionValueIsNotNull((Object)ktValueArgument, (String)"annotationEntry.valueArg\u2026t!!.addArgument(argument)");
        argument2.element = ktValueArgument;
        KtElement ktElement = ShortenReferences.process$default(ShortenReferences.DEFAULT, (KtValueArgument)argument2.element, null, 2, null);
        if (ktElement == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtValueArgument");
        }
        argument2.element = (KtValueArgument)ktElement;
        Editor editor2 = editor;
        if (editor2 != null) {
            Editor editor3;
            Editor $receiver3 = editor3 = editor2;
            GenerateUtilKt.unblockDocument($receiver3);
            GenerateUtilKt.moveCaret$default($receiver3, ((KtValueArgument)argument2.element).getTextOffset(), null, 2, null);
        }
        argument2 = null;
        escapedText = null;
    }

    /*
     * WARNING - void declaration
     */
    private final KtAnnotationEntry deprecatedAnnotationWithNoReplaceWith(@NotNull KtCallableDeclaration $receiver) {
        BindingContext bindingContext2 = ResolutionUtils.analyze$default($receiver, null, 1, null);
        for (KtAnnotationEntry entry : $receiver.getAnnotationEntries()) {
            void $receiver$iv;
            DeclarationDescriptor descriptor2;
            FqName descriptorFqName;
            ResolvedCall<? extends CallableDescriptor> resolvedCall2;
            ResolutionUtils.analyze$default(entry, null, 1, null);
            if (CallUtilKt.getResolvedCall(entry.getCalleeExpression(), bindingContext2) == null) {
                continue;
            }
            if (!ArgumentMappingKt.isReallySuccess(resolvedCall2) || Intrinsics.areEqual((Object)(descriptorFqName = DescriptorUtils.getFqName(descriptor2 = resolvedCall2.getResultingDescriptor().getContainingDeclaration()).toSafe()), (Object)KotlinBuiltIns.FQ_NAMES.deprecated) ^ true) continue;
            Iterable iterable = resolvedCall2.getValueArguments().entrySet();
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $receiver$iv) {
                Map.Entry it = (Map.Entry)element$iv;
                if (!Intrinsics.areEqual((Object)((ValueParameterDescriptor)it.getKey()).getName().asString(), (Object)"replaceWith")) continue;
                if (found$iv) {
                    throw (Throwable)new IllegalArgumentException("Collection contains more than one matching element.");
                }
                single$iv = element$iv;
                found$iv = true;
            }
            if (!found$iv) {
                throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            ResolvedValueArgument replaceWithArguments = (ResolvedValueArgument)((Map.Entry)((Object)single$iv)).getValue();
            return replaceWithArguments.getArguments().isEmpty() ? entry : null;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final ReplaceWith suggestReplaceWith(@NotNull KtCallableDeclaration $receiver) {
        void $receiver$iv;
        ReplaceWith replaceWith;
        Object object;
        void isGood;
        KtExpression ktExpression;
        KtCallableDeclaration ktCallableDeclaration = $receiver;
        if (ktCallableDeclaration instanceof KtNamedFunction) {
            ktExpression = this.replacementExpressionFromBody((KtDeclarationWithBody)((Object)$receiver));
        } else if (ktCallableDeclaration instanceof KtProperty) {
            if (((KtProperty)$receiver).isVar()) {
                return null;
            }
            KtPropertyAccessor ktPropertyAccessor = ((KtProperty)$receiver).getGetter();
            ktExpression = ktPropertyAccessor != null ? this.replacementExpressionFromBody(ktPropertyAccessor) : null;
        } else {
            ktExpression = null;
        }
        if (ktExpression == null) {
            return null;
        }
        KtExpression replacementExpression = ktExpression;
        ktCallableDeclaration = new Ref.BooleanRef();
        ((Ref.BooleanRef)ktCallableDeclaration).element = true;
        replacementExpression.accept(new KtVisitorVoid((Ref.BooleanRef)isGood){
            final /* synthetic */ Ref.BooleanRef $isGood;

            public void visitReturnExpression(@NotNull KtReturnExpression expression2) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                this.$isGood.element = false;
            }

            public void visitDeclaration(@NotNull KtDeclaration dcl) {
                Intrinsics.checkParameterIsNotNull((Object)dcl, (String)"dcl");
                this.$isGood.element = false;
            }

            public void visitBlockExpression(@NotNull KtBlockExpression expression2) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                if (expression2.getStatements().size() > 1) {
                    this.$isGood.element = false;
                    return;
                }
                super.visitBlockExpression(expression2);
            }

            public void visitSimpleNameExpression(@NotNull KtSimpleNameExpression expression2) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                V v = ResolutionUtils.analyze$default(expression2, null, 1, null).get(BindingContext.REFERENCE_TARGET, expression2);
                if (!(v instanceof DeclarationDescriptorWithVisibility)) {
                    v = null;
                }
                DeclarationDescriptorWithVisibility declarationDescriptorWithVisibility = (DeclarationDescriptorWithVisibility)v;
                if (declarationDescriptorWithVisibility == null) {
                    return;
                }
                DeclarationDescriptorWithVisibility target = declarationDescriptorWithVisibility;
                if (Visibilities.isPrivate(target.getVisibility())) {
                    this.$isGood.element = false;
                }
            }

            public void visitKtElement(@NotNull KtElement element2) {
                Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
                element2.acceptChildren(this);
            }
            {
                this.$isGood = $captured_local_variable$0;
            }
        });
        if (!isGood.element) {
            return null;
        }
        String text2 = replacementExpression.getText();
        try {
            object = KtPsiFactoryKt.KtPsiFactory($receiver).createExpression(StringsKt.replace$default((String)text2, (char)'\n', (char)' ', (boolean)false, (int)4, null));
        }
        catch (Throwable e) {
            return null;
        }
        KtExpression expression2 = object;
        PsiElement psiElement2 = CodeStyleManager.getInstance((Project)$receiver.getProject()).reformat((PsiElement)expression2, true);
        if (psiElement2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
        }
        expression2 = (KtExpression)psiElement2;
        String string = expression2.getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"expression.text");
        object = this.extractImports(replacementExpression);
        String string2 = string;
        ReplaceWith replaceWith2 = replaceWith;
        ReplaceWith replaceWith3 = replaceWith;
        void v5 = $receiver$iv;
        if (v5 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
        }
        Collection thisCollection$iv = (Collection)v5;
        String[] stringArray = thisCollection$iv.toArray(new String[thisCollection$iv.size()]);
        if (stringArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        Object[] objectArray = stringArray;
        String[] stringArray2 = (String[])objectArray;
        replaceWith2(string2, Arrays.copyOf(stringArray2, stringArray2.length));
        return replaceWith3;
    }

    private final KtExpression replacementExpressionFromBody(@NotNull KtDeclarationWithBody $receiver) {
        Annotated annotated;
        KtExpression ktExpression = $receiver.getBodyExpression();
        if (ktExpression == null) {
            return null;
        }
        KtExpression body2 = ktExpression;
        if (!$receiver.hasBlockBody()) {
            return body2;
        }
        KtExpression ktExpression2 = body2;
        if (!(ktExpression2 instanceof KtBlockExpression)) {
            ktExpression2 = null;
        }
        KtBlockExpression ktBlockExpression = (KtBlockExpression)ktExpression2;
        if (ktBlockExpression == null) {
            return null;
        }
        KtBlockExpression block = ktBlockExpression;
        Object object = CollectionsKt.singleOrNull(block.getStatements());
        if (!(object instanceof KtExpression)) {
            object = null;
        }
        KtExpression ktExpression3 = (KtExpression)object;
        if (ktExpression3 == null) {
            return null;
        }
        KtExpression statement = ktExpression3;
        DeclarationDescriptor declarationDescriptor = ResolutionUtils.analyze$default($receiver, null, 1, null).get(BindingContext.DECLARATION_TO_DESCRIPTOR, $receiver);
        if (!(declarationDescriptor instanceof FunctionDescriptor)) {
            declarationDescriptor = null;
        }
        if ((annotated = (FunctionDescriptor)declarationDescriptor) == null || (annotated = annotated.getReturnType()) == null) {
            return null;
        }
        boolean returnsUnit = TypeUtilsKt.isUnit((KotlinType)annotated);
        KtExpression ktExpression4 = statement;
        return ktExpression4 instanceof KtReturnExpression ? ((KtReturnExpression)statement).getReturnedExpression() : (returnsUnit ? statement : null);
    }

    private final Collection<String> extractImports(KtExpression expression2) {
        KtFile file2 = expression2.getContainingKtFile();
        FqName currentPackageFqName = file2.getPackageFqName();
        Project project = expression2.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"expression.project");
        ImportInsertHelper importHelper = ImportInsertHelper.Companion.getInstance(project);
        ArrayList result2 = new ArrayList();
        expression2.accept(new KtVisitorVoid(currentPackageFqName, importHelper, file2, result2){
            final /* synthetic */ FqName $currentPackageFqName;
            final /* synthetic */ ImportInsertHelper $importHelper;
            final /* synthetic */ KtFile $file;
            final /* synthetic */ ArrayList $result;

            public void visitSimpleNameExpression(@NotNull KtSimpleNameExpression expression2) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                BindingContext bindingContext2 = ResolutionUtils.analyze$default(expression2, null, 1, null);
                ClassifierDescriptorWithTypeParameters classifierDescriptorWithTypeParameters = (ClassifierDescriptorWithTypeParameters)bindingContext2.get(BindingContext.SHORT_REFERENCE_TO_COMPANION_OBJECT, expression2);
                DeclarationDescriptor declarationDescriptor = classifierDescriptorWithTypeParameters != null ? (DeclarationDescriptor)classifierDescriptorWithTypeParameters : (DeclarationDescriptor)bindingContext2.get(BindingContext.REFERENCE_TARGET, expression2);
                if (declarationDescriptor == null) {
                    return;
                }
                DeclarationDescriptor target = declarationDescriptor;
                if (DescriptorUtilsKt.isExtension(target) || KtPsiUtilKt.getReceiverExpression(expression2) == null) {
                    FqName fqName2 = ImportsUtils.getImportableFqName(target);
                    if (fqName2 == null) {
                        return;
                    }
                    FqName fqName3 = fqName2;
                    ImportPath importPath = new ImportPath(fqName3, false);
                    KtFile ktFile = this.$file;
                    Intrinsics.checkExpressionValueIsNotNull((Object)ktFile, (String)"file");
                    if (!this.$importHelper.isImportedWithDefault(importPath, ktFile)) {
                        DeclarationDescriptor declarationDescriptor2 = target.getContainingDeclaration();
                        if (!(declarationDescriptor2 instanceof PackageFragmentDescriptor)) {
                            declarationDescriptor2 = null;
                        }
                        PackageFragmentDescriptor packageFragmentDescriptor = (PackageFragmentDescriptor)declarationDescriptor2;
                        if (Intrinsics.areEqual((Object)(packageFragmentDescriptor != null ? packageFragmentDescriptor.getFqName() : null), (Object)this.$currentPackageFqName) ^ true) {
                            this.$result.add(fqName3.asString());
                        }
                    }
                }
            }

            public void visitKtElement(@NotNull KtElement element2) {
                Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
                element2.acceptChildren(this);
            }
            {
                this.$currentPackageFqName = $captured_local_variable$0;
                this.$importHelper = $captured_local_variable$1;
                this.$file = $captured_local_variable$2;
                this.$result = $captured_local_variable$3;
            }
        });
        return result2;
    }

    public DeprecatedCallableAddReplaceWithIntention() {
        super(KtCallableDeclaration.class, "Add 'replaceWith' argument to specify replacement pattern", "Add 'replaceWith' argument to 'Deprecated' annotation");
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u0005\"\u00020\u0003\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001b\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u0005\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\n\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/DeprecatedCallableAddReplaceWithIntention$ReplaceWith;", "", "expression", "", "imports", "", "(Ljava/lang/String;[Ljava/lang/String;)V", "getExpression", "()Ljava/lang/String;", "getImports", "()[Ljava/lang/String;", "[Ljava/lang/String;", "idea"})
    private static final class ReplaceWith {
        @NotNull
        private final String expression;
        @NotNull
        private final String[] imports;

        @NotNull
        public final String getExpression() {
            return this.expression;
        }

        @NotNull
        public final String[] getImports() {
            return this.imports;
        }

        public ReplaceWith(@NotNull String expression2, String ... imports) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            Intrinsics.checkParameterIsNotNull((Object)imports, (String)"imports");
            this.expression = expression2;
            this.imports = imports;
        }
    }
}

