/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalInspectionEP;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.inspections.IntentionBasedInspection;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 7*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u00017B%\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0002H\u0014J\u001f\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0018\u001a\u00028\u00002\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH&\u00a2\u0006\u0002\u0010\u001dJ\u0006\u0010\u001e\u001a\u00020\u0007J\u001f\u0010\u001f\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020!H\u0002\u00a2\u0006\u0002\u0010\"J\u0006\u0010#\u001a\u00020\u0007J!\u0010$\u001a\u00020\u001a2\u0006\u0010%\u001a\u00020&2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020!H\u0086\u0002J\u001d\u0010'\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00028\u00002\u0006\u0010(\u001a\u00020)H&\u00a2\u0006\u0002\u0010*J\u001e\u0010+\u001a\u00020\u00172\u0006\u0010%\u001a\u00020&2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020!J\u001d\u0010,\u001a\u00020\u00172\u0006\u0010%\u001a\u00020&2\u0006\u0010-\u001a\u00028\u0000H\u0004\u00a2\u0006\u0002\u0010.J\u0010\u0010/\u001a\u00020\u001a2\u0006\u0010\u0006\u001a\u00020\u0007H\u0004J\b\u00100\u001a\u00020\u0017H\u0016J\b\u00101\u001a\u00020\u0007H\u0016J!\u00102\u001a\u0002H3\"\u0004\b\u0001\u001032\f\u00104\u001a\b\u0012\u0004\u0012\u0002H305H\u0004\u00a2\u0006\u0002\u00106R\u0014\u0010\n\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R4\u0010\u0011\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00102\u000e\u0010\u000f\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0010@@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/SelfTargetingIntention;", "TElement", "Lcom/intellij/psi/PsiElement;", "Lcom/intellij/codeInsight/intention/IntentionAction;", "elementType", "Ljava/lang/Class;", "text", "", "familyName", "(Ljava/lang/Class;Ljava/lang/String;Ljava/lang/String;)V", "defaultText", "getDefaultText", "()Ljava/lang/String;", "getElementType", "()Ljava/lang/Class;", "<set-?>", "Lorg/jetbrains/kotlin/idea/inspections/IntentionBasedInspection;", "inspection", "getInspection", "()Lorg/jetbrains/kotlin/idea/inspections/IntentionBasedInspection;", "setInspection$idea_analysis", "(Lorg/jetbrains/kotlin/idea/inspections/IntentionBasedInspection;)V", "allowCaretInsideElement", "", "element", "applyTo", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/openapi/editor/Editor;)V", "getFamilyName", "getTarget", "file", "Lcom/intellij/psi/PsiFile;", "(Lcom/intellij/openapi/editor/Editor;Lcom/intellij/psi/PsiFile;)Lcom/intellij/psi/PsiElement;", "getText", "invoke", "project", "Lcom/intellij/openapi/project/Project;", "isApplicableTo", "caretOffset", "", "(Lcom/intellij/psi/PsiElement;I)Z", "isAvailable", "isIntentionBaseInspectionEnabled", "target", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/psi/PsiElement;)Z", "setText", "startInWriteAction", "toString", "tryRunWriteAction", "R", "action", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "Companion", "idea-analysis"})
public abstract class SelfTargetingIntention<TElement extends PsiElement>
implements IntentionAction {
    @NotNull
    private final String defaultText;
    @Nullable
    private IntentionBasedInspection<TElement> inspection;
    @NotNull
    private final Class<TElement> elementType;
    private String text;
    private final String familyName;
    private static final HashMap<KClass<? extends SelfTargetingIntention<?>>, IntentionBasedInspection<?>> intentionBasedInspections;
    public static final Companion Companion;

    @NotNull
    protected final String getDefaultText() {
        return this.defaultText;
    }

    protected final void setText(@NotNull String text2) {
        Intrinsics.checkParameterIsNotNull((Object)text2, (String)"text");
        this.text = text2;
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    @NotNull
    public final String getFamilyName() {
        return this.familyName;
    }

    public abstract boolean isApplicableTo(@NotNull TElement var1, int var2);

    public abstract void applyTo(@NotNull TElement var1, @Nullable Editor var2);

    protected final <R> R tryRunWriteAction(@NotNull Function0<? extends R> action2) {
        Intrinsics.checkParameterIsNotNull(action2, (String)"action");
        return (R)(ApplicationManager.getApplication().isDispatchThread() ? ApplicationUtilsKt.runWriteAction(action2) : action2.invoke());
    }

    private final TElement getTarget(Editor editor, PsiFile file2) {
        int offset2 = editor.getCaretModel().getOffset();
        PsiElement leaf1 = file2.findElementAt(offset2);
        PsiElement leaf2 = file2.findElementAt(offset2 - 1);
        PsiElement commonParent = leaf1 != null && leaf2 != null ? PsiTreeUtil.findCommonParent((PsiElement)leaf1, (PsiElement)leaf2) : null;
        Sequence elementsToCheck = SequencesKt.emptySequence();
        if (leaf1 != null) {
            elementsToCheck = SequencesKt.plus((Sequence)elementsToCheck, (Sequence)SequencesKt.takeWhile(PsiUtilsKt.getParentsWithSelf(leaf1), (Function1)((Function1)new Function1<PsiElement, Boolean>(commonParent){
                final /* synthetic */ PsiElement $commonParent;

                public final boolean invoke(@NotNull PsiElement it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    return Intrinsics.areEqual((Object)it, (Object)this.$commonParent) ^ true;
                }
                {
                    this.$commonParent = psiElement2;
                    super(1);
                }
            })));
        }
        if (leaf2 != null) {
            elementsToCheck = SequencesKt.plus((Sequence)elementsToCheck, (Sequence)SequencesKt.takeWhile(PsiUtilsKt.getParentsWithSelf(leaf2), (Function1)((Function1)new Function1<PsiElement, Boolean>(commonParent){
                final /* synthetic */ PsiElement $commonParent;

                public final boolean invoke(@NotNull PsiElement it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    return Intrinsics.areEqual((Object)it, (Object)this.$commonParent) ^ true;
                }
                {
                    this.$commonParent = psiElement2;
                    super(1);
                }
            })));
        }
        if (commonParent != null && !(commonParent instanceof PsiFile)) {
            elementsToCheck = SequencesKt.plus((Sequence)elementsToCheck, PsiUtilsKt.getParentsWithSelf(commonParent));
        }
        for (PsiElement element2 : elementsToCheck) {
            if (this.elementType.isInstance(element2)) {
                PsiElement psiElement2 = element2;
                if (psiElement2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type TElement");
                }
                if (this.isApplicableTo(psiElement2, offset2)) {
                    return (TElement)element2;
                }
            }
            if (this.allowCaretInsideElement(element2) || !PsiUtilsKt.containsInside(element2.getTextRange(), offset2)) continue;
            break;
        }
        return null;
    }

    protected boolean allowCaretInsideElement(@NotNull PsiElement element2) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        return !(element2 instanceof KtBlockExpression);
    }

    public final boolean isAvailable(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        TElement TElement = this.getTarget(editor, file2);
        if (TElement == null) {
            return false;
        }
        TElement target = TElement;
        return !this.isIntentionBaseInspectionEnabled(project, target);
    }

    @Nullable
    public final IntentionBasedInspection<TElement> getInspection() {
        return this.inspection;
    }

    public final void setInspection$idea_analysis(@Nullable IntentionBasedInspection<TElement> intentionBasedInspection) {
        this.inspection = intentionBasedInspection;
    }

    protected final boolean isIntentionBaseInspectionEnabled(@NotNull Project project, @NotNull TElement target) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull(target, (String)"target");
        IntentionBasedInspection<TElement> intentionBasedInspection = this.inspection;
        if (intentionBasedInspection == null) {
            intentionBasedInspection = Companion.findInspection(JvmClassMappingKt.getKotlinClass(this.getClass()));
        }
        if (intentionBasedInspection == null) {
            return false;
        }
        IntentionBasedInspection<TElement> inspection = intentionBasedInspection;
        HighlightDisplayKey key = HighlightDisplayKey.find((String)inspection.getShortName());
        if (!InspectionProjectProfileManager.getInstance((Project)project).getInspectionProfile().isToolEnabled(key, target)) {
            return false;
        }
        Iterable $receiver$iv = inspection.getIntentionInfos();
        Object single$iv = null;
        boolean found$iv = false;
        for (Object element$iv : $receiver$iv) {
            IntentionBasedInspection.IntentionData it = (IntentionBasedInspection.IntentionData)element$iv;
            if (!Intrinsics.areEqual(it.getIntention(), (Object)JvmClassMappingKt.getKotlinClass(this.getClass()))) continue;
            if (found$iv) {
                throw (Throwable)new IllegalArgumentException("Collection contains more than one matching element.");
            }
            single$iv = element$iv;
            found$iv = true;
        }
        if (!found$iv) {
            throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        return (Boolean)((IntentionBasedInspection.IntentionData)((Object)single$iv)).getAdditionalChecker().invoke(target, inspection);
    }

    public final void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        TElement TElement = this.getTarget(editor, file2);
        if (TElement == null) {
            return;
        }
        TElement target = TElement;
        if (!FileModificationService.getInstance().preparePsiElementForWrite(target)) {
            return;
        }
        this.applyTo(target, editor);
    }

    public boolean startInWriteAction() {
        return true;
    }

    @NotNull
    public String toString() {
        return this.getText();
    }

    @NotNull
    public final Class<TElement> getElementType() {
        return this.elementType;
    }

    public SelfTargetingIntention(@NotNull Class<TElement> elementType, @NotNull String text2, @NotNull String familyName) {
        Intrinsics.checkParameterIsNotNull(elementType, (String)"elementType");
        Intrinsics.checkParameterIsNotNull((Object)text2, (String)"text");
        Intrinsics.checkParameterIsNotNull((Object)familyName, (String)"familyName");
        this.elementType = elementType;
        this.text = text2;
        this.familyName = familyName;
        this.defaultText = this.text;
    }

    public /* synthetic */ SelfTargetingIntention(Class clazz, String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string2 = string;
        }
        this(clazz, string, string2);
    }

    static {
        Companion = new Companion(null);
        intentionBasedInspections = new HashMap();
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\n\u001a\n\u0012\u0004\u0012\u0002H\u000b\u0018\u00010\u0007\"\b\b\u0001\u0010\u000b*\u00020\f2\u0014\u0010\r\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u0002H\u000b0\u00060\u0005R2\u0010\u0003\u001a \u0012\u0010\u0012\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u00070\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/SelfTargetingIntention$Companion;", "", "()V", "intentionBasedInspections", "Ljava/util/HashMap;", "Lkotlin/reflect/KClass;", "Lorg/jetbrains/kotlin/idea/intentions/SelfTargetingIntention;", "Lorg/jetbrains/kotlin/idea/inspections/IntentionBasedInspection;", "getIntentionBasedInspections", "()Ljava/util/HashMap;", "findInspection", "TElement", "Lcom/intellij/psi/PsiElement;", "intentionClass", "idea-analysis"})
    public static final class Companion {
        private final HashMap<KClass<? extends SelfTargetingIntention<?>>, IntentionBasedInspection<?>> getIntentionBasedInspections() {
            return intentionBasedInspections;
        }

        @Nullable
        public final <TElement extends PsiElement> IntentionBasedInspection<TElement> findInspection(@NotNull KClass<? extends SelfTargetingIntention<TElement>> intentionClass) {
            Intrinsics.checkParameterIsNotNull(intentionClass, (String)"intentionClass");
            if (this.getIntentionBasedInspections().containsKey(intentionClass)) {
                return this.getIntentionBasedInspections().get(intentionClass);
            }
            LocalInspectionEP[] localInspectionEPArray = (LocalInspectionEP[])Extensions.getExtensions((ExtensionPointName)LocalInspectionEP.LOCAL_INSPECTION);
            for (int i = 0; i < localInspectionEPArray.length; ++i) {
                boolean bl;
                IntentionBasedInspection inspection;
                block6: {
                    LocalInspectionEP extension = localInspectionEPArray[i];
                    Object object = extension.getInstance();
                    if (!(object instanceof IntentionBasedInspection)) {
                        object = null;
                    }
                    if ((IntentionBasedInspection)((Object)object) == null) {
                        continue;
                    }
                    Iterable $receiver$iv = inspection.getIntentionInfos();
                    for (Object element$iv : $receiver$iv) {
                        IntentionBasedInspection.IntentionData it = (IntentionBasedInspection.IntentionData)element$iv;
                        if (!Intrinsics.areEqual(it.getIntention(), intentionClass)) continue;
                        bl = true;
                        break block6;
                    }
                    bl = false;
                }
                if (!bl) continue;
                Map map2 = this.getIntentionBasedInspections();
                Object object = inspection;
                map2.put(intentionClass, object);
                IntentionBasedInspection intentionBasedInspection = inspection;
                if (intentionBasedInspection == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.idea.inspections.IntentionBasedInspection<TElement>");
                }
                return intentionBasedInspection;
            }
            return null;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

