/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions.loopToCallChain;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.imports.ImportsUtils;
import org.jetbrains.kotlin.idea.references.KtSimpleNameReference;
import org.jetbrains.kotlin.idea.references.ReferenceAccess;
import org.jetbrains.kotlin.idea.references.ReferenceUtilKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtExpressionWithLabel;
import org.jetbrains.kotlin.psi.KtLabeledExpression;
import org.jetbrains.kotlin.psi.KtLoopExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.psi.KtVariableDeclaration;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiChildRange;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=2, d1={"\u0000b\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\n\u0010\u0003\u001a\u00020\u0004*\u00020\u0005\u001a\u0018\u0010\u0003\u001a\u00020\u0004*\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u001a\u0012\u0010\u0003\u001a\u00020\u0004*\u00020\u00052\u0006\u0010\t\u001a\u00020\b\u001a\n\u0010\n\u001a\u00020\u0004*\u00020\u000b\u001a\u0012\u0010\n\u001a\u00020\u0004*\u00020\u000b2\u0006\u0010\t\u001a\u00020\b\u001a\n\u0010\f\u001a\u00020\r*\u00020\u000e\u001a\u001e\u0010\u000f\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0011\u0018\u00010\u0010*\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013\u001a&\u0010\u0014\u001a\u00020\u0015*\u00020\u00052\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u001a\u0018\u0010\u0018\u001a\u00020\u0015*\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u001a\u0012\u0010\u0018\u001a\u00020\u0015*\u00020\u00052\u0006\u0010\t\u001a\u00020\b\u001a\n\u0010\u0019\u001a\u00020\u0015*\u00020\u000b\u001a\u0012\u0010\u0019\u001a\u00020\u0015*\u00020\u000b2\u0006\u0010\t\u001a\u00020\b\u001a\n\u0010\u001a\u001a\u00020\u0015*\u00020\u0011\u001a\f\u0010\u001b\u001a\u00020\u0015*\u0004\u0018\u00010\u0011\u001a\f\u0010\u001c\u001a\u0004\u0018\u00010\u0011*\u00020\u0011\u001a\u0014\u0010\u001d\u001a\u00020\u0015*\u0004\u0018\u00010\u00112\u0006\u0010\u001e\u001a\u00020\u001f\u001a\f\u0010 \u001a\u00020\u0015*\u0004\u0018\u00010\u0011\u001a\u0014\u0010!\u001a\u00020\u0015*\u0004\u0018\u00010\u00112\u0006\u0010\"\u001a\u00020\u0005\u001a\n\u0010#\u001a\u00020\u0015*\u00020\u0011\u001a\f\u0010$\u001a\u0004\u0018\u00010\u0011*\u00020\u0011\u001a\f\u0010%\u001a\u0004\u0018\u00010\u0011*\u00020\u0011\u001a\f\u0010&\u001a\u0004\u0018\u00010\u000e*\u00020'\u001a\n\u0010(\u001a\u00020\u0011*\u00020\u0011\u001a\n\u0010)\u001a\u00020**\u00020*\u001a\n\u0010+\u001a\u00020**\u00020*\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"ZERO_VALUES", "", "", "countUsages", "", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "inElements", "", "Lorg/jetbrains/kotlin/psi/KtElement;", "inElement", "countWriteUsages", "Lorg/jetbrains/kotlin/psi/KtVariableDeclaration;", "deleteWithLabels", "", "Lorg/jetbrains/kotlin/psi/KtLoopExpression;", "extractStaticFunctionCallArguments", "", "Lorg/jetbrains/kotlin/psi/KtExpression;", "functionFqName", "", "hasDifferentSetsOfUsages", "", "elements1", "elements2", "hasUsages", "hasWriteUsages", "isConstant", "isFalseConstant", "isPlusPlusOf", "isSimpleName", "name", "Lorg/jetbrains/kotlin/name/Name;", "isTrueConstant", "isVariableReference", "variable", "isZeroConstant", "nextStatement", "previousStatement", "targetLoop", "Lorg/jetbrains/kotlin/psi/KtExpressionWithLabel;", "unwrapIfLabeled", "withoutFirstStatement", "Lorg/jetbrains/kotlin/psi/psiUtil/PsiChildRange;", "withoutLastStatement", "idea"})
public final class CommonUtilsKt {
    private static final Set<Object> ZERO_VALUES = SetsKt.setOf((Object[])new Object[]{0, 0L, Float.valueOf(0.0f), 0.0});

    public static final boolean isConstant(@NotNull KtExpression $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        BindingContext bindingContext2 = ResolutionUtils.analyze($receiver, BodyResolveMode.PARTIAL);
        return ConstantExpressionEvaluator.Companion.getConstant($receiver, bindingContext2) != null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isTrueConstant(@Nullable KtExpression $receiver) {
        if ($receiver == null) return false;
        ASTNode aSTNode = $receiver.getNode();
        if (!Intrinsics.areEqual((Object)(aSTNode != null ? aSTNode.getElementType() : null), (Object)((Object)KtNodeTypes.BOOLEAN_CONSTANT))) return false;
        if (!Intrinsics.areEqual((Object)$receiver.getText(), (Object)"true")) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isFalseConstant(@Nullable KtExpression $receiver) {
        if ($receiver == null) return false;
        ASTNode aSTNode = $receiver.getNode();
        if (!Intrinsics.areEqual((Object)(aSTNode != null ? aSTNode.getElementType() : null), (Object)((Object)KtNodeTypes.BOOLEAN_CONSTANT))) return false;
        if (!Intrinsics.areEqual((Object)$receiver.getText(), (Object)"false")) return false;
        return true;
    }

    public static final boolean isZeroConstant(@NotNull KtExpression $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        if (!($receiver instanceof KtConstantExpression)) {
            return false;
        }
        BindingContext bindingContext2 = ResolutionUtils.analyze($receiver, BodyResolveMode.PARTIAL);
        KotlinType kotlinType = bindingContext2.getType($receiver);
        if (kotlinType == null) {
            return false;
        }
        KotlinType type2 = kotlinType;
        CompileTimeConstant<?> compileTimeConstant = ConstantExpressionEvaluator.Companion.getConstant($receiver, bindingContext2);
        if (compileTimeConstant == null) {
            return false;
        }
        CompileTimeConstant<?> constant = compileTimeConstant;
        Iterable iterable = ZERO_VALUES;
        KotlinType kotlinType2 = type2;
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType2, (String)"type");
        return CollectionsKt.contains((Iterable)iterable, constant.getValue(kotlinType2));
    }

    public static final boolean isVariableReference(@Nullable KtExpression $receiver, @NotNull KtCallableDeclaration variable2) {
        Intrinsics.checkParameterIsNotNull((Object)variable2, (String)"variable");
        return $receiver instanceof KtNameReferenceExpression && ReferenceUtilKt.getMainReference((KtSimpleNameExpression)$receiver).isReferenceTo(variable2);
    }

    public static final boolean isSimpleName(@Nullable KtExpression $receiver, @NotNull Name name2) {
        Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
        return $receiver instanceof KtNameReferenceExpression && KtPsiUtilKt.getQualifiedExpressionForSelector($receiver) == null && Intrinsics.areEqual((Object)((KtNameReferenceExpression)$receiver).getReferencedNameAsName(), (Object)name2);
    }

    public static final boolean hasUsages(@NotNull KtCallableDeclaration $receiver, @NotNull KtElement inElement) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)inElement, (String)"inElement");
        boolean bl = inElement.isPhysical();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        return CommonUtilsKt.hasUsages($receiver, CollectionsKt.listOf((Object)inElement));
    }

    public static final boolean hasUsages(@NotNull KtCallableDeclaration $receiver, @NotNull Collection<? extends KtElement> inElements) {
        boolean bl;
        block2: {
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
            Intrinsics.checkParameterIsNotNull(inElements, (String)"inElements");
            boolean bl2 = $receiver.isPhysical();
            if (_Assertions.ENABLED && !bl2) {
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            Iterable $receiver$iv = inElements;
            for (Object element$iv : $receiver$iv) {
                KtElement it = (KtElement)element$iv;
                if (!CollectionsKt.any((Iterable)((Iterable)ReferencesSearch.search((PsiElement)$receiver, (SearchScope)((SearchScope)new LocalSearchScope((PsiElement)it)))))) continue;
                bl = true;
                break block2;
            }
            bl = false;
        }
        return bl;
    }

    public static final boolean hasWriteUsages(@NotNull KtVariableDeclaration $receiver) {
        boolean bl;
        block4: {
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
            boolean bl2 = $receiver.isPhysical();
            if (_Assertions.ENABLED && !bl2) {
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            if (!$receiver.isVar()) {
                return false;
            }
            Iterable $receiver$iv = (Iterable)ReferencesSearch.search((PsiElement)$receiver, (SearchScope)$receiver.getUseScope());
            for (Object element$iv : $receiver$iv) {
                Object object;
                PsiReference it = (PsiReference)element$iv;
                PsiReference psiReference = it;
                if (!(psiReference instanceof KtSimpleNameReference)) {
                    psiReference = null;
                }
                if (!Intrinsics.areEqual((object = (KtSimpleNameReference)psiReference) != null && (object = (KtSimpleNameExpression)object.getElement()) != null && (object = ReferenceUtilKt.readWriteAccess((KtExpression)object, true)) != null ? Boolean.valueOf(((ReferenceAccess)((Object)object)).isWrite()) : null, (Object)true)) continue;
                bl = true;
                break block4;
            }
            bl = false;
        }
        return bl;
    }

    public static final int countUsages(@NotNull KtCallableDeclaration $receiver, @NotNull KtElement inElement) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)inElement, (String)"inElement");
        boolean bl = $receiver.isPhysical();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        return CollectionsKt.count((Iterable)((Iterable)ReferencesSearch.search((PsiElement)$receiver, (SearchScope)((SearchScope)new LocalSearchScope((PsiElement)inElement)))));
    }

    /*
     * WARNING - void declaration
     */
    public static final int countUsages(@NotNull KtCallableDeclaration $receiver, @NotNull Collection<? extends KtElement> inElements) {
        void var3_5;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(inElements, (String)"inElements");
        boolean bl = $receiver.isPhysical();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        Iterable $receiver$iv = inElements;
        int sum$iv = 0;
        for (Object element$iv : $receiver$iv) {
            void it;
            KtElement ktElement = (KtElement)element$iv;
            int n = sum$iv;
            int n2 = CollectionsKt.count((Iterable)((Iterable)ReferencesSearch.search((PsiElement)$receiver, (SearchScope)((SearchScope)new LocalSearchScope((PsiElement)it)))));
            sum$iv = n + n2;
        }
        return (int)var3_5;
    }

    public static final int countUsages(@NotNull KtCallableDeclaration $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        boolean bl = $receiver.isPhysical();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        return CollectionsKt.count((Iterable)((Iterable)ReferencesSearch.search((PsiElement)$receiver, (SearchScope)$receiver.getUseScope())));
    }

    /*
     * WARNING - void declaration
     */
    public static final int countWriteUsages(@NotNull KtVariableDeclaration $receiver) {
        void var2_4;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        boolean bl = $receiver.isPhysical();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        if (!$receiver.isVar()) {
            return 0;
        }
        Iterable $receiver$iv = (Iterable)ReferencesSearch.search((PsiElement)$receiver, (SearchScope)$receiver.getUseScope());
        int count$iv = 0;
        for (Object element$iv : $receiver$iv) {
            Object object;
            PsiReference it = (PsiReference)element$iv;
            PsiReference psiReference = it;
            if (!(psiReference instanceof KtSimpleNameReference)) {
                psiReference = null;
            }
            if (!Intrinsics.areEqual((object = (KtSimpleNameReference)psiReference) != null && (object = (KtSimpleNameExpression)object.getElement()) != null && (object = ReferenceUtilKt.readWriteAccess((KtExpression)object, true)) != null ? Boolean.valueOf(((ReferenceAccess)((Object)object)).isWrite()) : null, (Object)true)) continue;
            ++count$iv;
        }
        return (int)var2_4;
    }

    /*
     * WARNING - void declaration
     */
    public static final int countWriteUsages(@NotNull KtVariableDeclaration $receiver, @NotNull KtElement inElement) {
        void var3_5;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)inElement, (String)"inElement");
        boolean bl = $receiver.isPhysical();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        if (!$receiver.isVar()) {
            return 0;
        }
        Iterable $receiver$iv = (Iterable)ReferencesSearch.search((PsiElement)$receiver, (SearchScope)((SearchScope)new LocalSearchScope((PsiElement)inElement)));
        int count$iv = 0;
        for (Object element$iv : $receiver$iv) {
            Object object;
            PsiReference it = (PsiReference)element$iv;
            PsiReference psiReference = it;
            if (!(psiReference instanceof KtSimpleNameReference)) {
                psiReference = null;
            }
            if (!Intrinsics.areEqual((object = (KtSimpleNameReference)psiReference) != null && (object = (KtSimpleNameExpression)object.getElement()) != null && (object = ReferenceUtilKt.readWriteAccess((KtExpression)object, true)) != null ? Boolean.valueOf(((ReferenceAccess)((Object)object)).isWrite()) : null, (Object)true)) continue;
            ++count$iv;
        }
        return (int)var3_5;
    }

    public static final boolean hasWriteUsages(@NotNull KtVariableDeclaration $receiver, @NotNull KtElement inElement) {
        boolean bl;
        block4: {
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
            Intrinsics.checkParameterIsNotNull((Object)inElement, (String)"inElement");
            boolean bl2 = $receiver.isPhysical();
            if (_Assertions.ENABLED && !bl2) {
                String string = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            if (!$receiver.isVar()) {
                return false;
            }
            Iterable $receiver$iv = (Iterable)ReferencesSearch.search((PsiElement)$receiver, (SearchScope)((SearchScope)new LocalSearchScope((PsiElement)inElement)));
            for (Object element$iv : $receiver$iv) {
                Object object;
                PsiReference it = (PsiReference)element$iv;
                PsiReference psiReference = it;
                if (!(psiReference instanceof KtSimpleNameReference)) {
                    psiReference = null;
                }
                if (!Intrinsics.areEqual((object = (KtSimpleNameReference)psiReference) != null && (object = (KtSimpleNameExpression)object.getElement()) != null && (object = ReferenceUtilKt.readWriteAccess((KtExpression)object, true)) != null ? Boolean.valueOf(((ReferenceAccess)((Object)object)).isWrite()) : null, (Object)true)) continue;
                bl = true;
                break block4;
            }
            bl = false;
        }
        return bl;
    }

    public static final boolean hasDifferentSetsOfUsages(@NotNull KtCallableDeclaration $receiver, @NotNull Collection<? extends KtElement> elements1, @NotNull Collection<? extends KtElement> elements2) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(elements1, (String)"elements1");
        Intrinsics.checkParameterIsNotNull(elements2, (String)"elements2");
        return CommonUtilsKt.countUsages($receiver, CollectionsKt.minus((Iterable)elements1, (Iterable)elements2)) != CommonUtilsKt.countUsages($receiver, CollectionsKt.minus((Iterable)elements2, (Iterable)elements1));
    }

    @Nullable
    public static final KtLoopExpression targetLoop(@NotNull KtExpressionWithLabel $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        KtSimpleNameExpression label2 = $receiver.getTargetLabel();
        if (label2 == null) {
            Object element$iv2;
            block3: {
                Sequence<PsiElement> $receiver$iv = PsiUtilsKt.getParents((PsiElement)$receiver);
                for (Object element$iv2 : $receiver$iv) {
                    if (!(element$iv2 instanceof KtLoopExpression)) continue;
                    break block3;
                }
                throw (Throwable)new NoSuchElementException("No element of given type found");
            }
            return (KtLoopExpression)element$iv2;
        }
        Object v = ResolutionUtils.analyze($receiver, BodyResolveMode.PARTIAL).get(BindingContext.LABEL_TARGET, label2);
        if (!(v instanceof KtLoopExpression)) {
            v = null;
        }
        return (KtLoopExpression)v;
    }

    @Nullable
    public static final KtExpression isPlusPlusOf(@NotNull KtExpression $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        if (!($receiver instanceof KtUnaryExpression)) {
            return null;
        }
        if (Intrinsics.areEqual((Object)((KtUnaryExpression)$receiver).getOperationToken(), (Object)((Object)KtTokens.PLUSPLUS)) ^ true) {
            return null;
        }
        return ((KtUnaryExpression)$receiver).getBaseExpression();
    }

    @Nullable
    public static final KtExpression previousStatement(@NotNull KtExpression $receiver) {
        Object v0;
        block2: {
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
            KtExpression statement = CommonUtilsKt.unwrapIfLabeled($receiver);
            if (!(statement.getParent() instanceof KtBlockExpression)) {
                return null;
            }
            Sequence<PsiElement> $receiver$iv = PsiUtilsKt.siblings((PsiElement)statement, false, false);
            for (Object element$iv : $receiver$iv) {
                if (!(element$iv instanceof KtExpression)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        return v0;
    }

    @Nullable
    public static final KtExpression nextStatement(@NotNull KtExpression $receiver) {
        Object v0;
        block2: {
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
            KtExpression statement = CommonUtilsKt.unwrapIfLabeled($receiver);
            if (!(statement.getParent() instanceof KtBlockExpression)) {
                return null;
            }
            Sequence<PsiElement> $receiver$iv = PsiUtilsKt.siblings((PsiElement)statement, true, false);
            for (Object element$iv : $receiver$iv) {
                if (!(element$iv instanceof KtExpression)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        return v0;
    }

    @NotNull
    public static final KtExpression unwrapIfLabeled(@NotNull KtExpression $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        KtExpression statement = $receiver;
        while (true) {
            PsiElement psiElement2;
            if (!((psiElement2 = statement.getParent()) instanceof KtLabeledExpression)) {
                psiElement2 = null;
            }
            KtLabeledExpression ktLabeledExpression = (KtLabeledExpression)psiElement2;
            if (ktLabeledExpression == null) {
                return statement;
            }
            statement = ktLabeledExpression;
        }
    }

    public static final void deleteWithLabels(@NotNull KtLoopExpression $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        CommonUtilsKt.unwrapIfLabeled($receiver).delete();
    }

    @NotNull
    public static final PsiChildRange withoutFirstStatement(@NotNull PsiChildRange $receiver) {
        Object element$iv2;
        block2: {
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
            PsiElement psiElement2 = $receiver.getFirst();
            if (psiElement2 == null) {
                Intrinsics.throwNpe();
            }
            Sequence<PsiElement> $receiver$iv = PsiUtilsKt.siblings(psiElement2, true, false);
            for (Object element$iv2 : $receiver$iv) {
                PsiElement it = (PsiElement)element$iv2;
                if (!(!(it instanceof PsiWhiteSpace))) continue;
                break block2;
            }
            throw (Throwable)new NoSuchElementException("Sequence contains no element matching the predicate.");
        }
        PsiElement newFirst2 = (PsiElement)element$iv2;
        return new PsiChildRange(newFirst2, $receiver.getLast());
    }

    @NotNull
    public static final PsiChildRange withoutLastStatement(@NotNull PsiChildRange $receiver) {
        Object element$iv2;
        block2: {
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
            PsiElement psiElement2 = $receiver.getLast();
            if (psiElement2 == null) {
                Intrinsics.throwNpe();
            }
            Sequence<PsiElement> $receiver$iv = PsiUtilsKt.siblings(psiElement2, false, false);
            for (Object element$iv2 : $receiver$iv) {
                PsiElement it = (PsiElement)element$iv2;
                if (!(!(it instanceof PsiWhiteSpace))) continue;
                break block2;
            }
            throw (Throwable)new NoSuchElementException("Sequence contains no element matching the predicate.");
        }
        PsiElement newLast2 = (PsiElement)element$iv2;
        return new PsiChildRange($receiver.getFirst(), newLast2);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final List<KtExpression> extractStaticFunctionCallArguments(@Nullable KtExpression $receiver, @NotNull String functionFqName) {
        List list2;
        KtCallExpression ktCallExpression;
        Intrinsics.checkParameterIsNotNull((Object)functionFqName, (String)"functionFqName");
        KtExpression ktExpression = $receiver;
        if (ktExpression instanceof KtDotQualifiedExpression) {
            KtExpression ktExpression2 = ((KtDotQualifiedExpression)$receiver).getSelectorExpression();
            if (!(ktExpression2 instanceof KtCallExpression)) {
                ktExpression2 = null;
            }
            ktCallExpression = (KtCallExpression)ktExpression2;
        } else {
            ktCallExpression = ktExpression instanceof KtCallExpression ? (KtCallExpression)$receiver : null;
        }
        if (ktCallExpression == null) {
            return null;
        }
        KtCallExpression callExpression2 = ktCallExpression;
        BindingContext bindingContext2 = ResolutionUtils.analyze(callExpression2, BodyResolveMode.PARTIAL);
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(callExpression2, bindingContext2);
        if (resolvedCall2 == null) {
            return null;
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2;
        CallableDescriptor callableDescriptor = resolvedCall3.getResultingDescriptor();
        if (!(callableDescriptor instanceof FunctionDescriptor)) {
            callableDescriptor = null;
        }
        FunctionDescriptor functionDescriptor2 = (FunctionDescriptor)callableDescriptor;
        if (functionDescriptor2 == null) {
            return null;
        }
        FunctionDescriptor functionDescriptor3 = functionDescriptor2;
        if (functionDescriptor3.getDispatchReceiverParameter() != null || functionDescriptor3.getExtensionReceiverParameter() != null) {
            return null;
        }
        FqName fqName2 = ImportsUtils.getImportableFqName(functionDescriptor3);
        if (Intrinsics.areEqual((Object)(fqName2 != null ? fqName2.asString() : null), (Object)functionFqName) ^ true) {
            return null;
        }
        List<ResolvedValueArgument> list3 = resolvedCall3.getValueArgumentsByIndex();
        if (list3 != null) {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Iterable iterable = $receiver$iv = (Iterable)list3;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                ResolvedValueArgument resolvedValueArgument = (ResolvedValueArgument)item$iv$iv;
                Collection collection = destination$iv$iv;
                Object object = it;
                KtExpression ktExpression3 = object != null && (object = object.getArguments()) != null && (object = (ValueArgument)CollectionsKt.singleOrNull(object)) != null ? object.getArgumentExpression() : null;
                collection.add(ktExpression3);
            }
            list2 = (List)destination$iv$iv;
        } else {
            list2 = null;
        }
        return list2;
    }
}

