/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.util.ui.UIUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.project.PluginJetFilesProvider;
import org.jetbrains.kotlin.idea.quickfix.WholeProjectModalAction;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J$\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00028\u00000\u0011H\u0002J%\u0010\u0013\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00028\u0000H$\u00a2\u0006\u0002\u0010\u0016J\u001f\u0010\u0017\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0012H$\u00a2\u0006\u0002\u0010\u0018J\u0010\u0010\u0019\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J%\u0010\u0019\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\u0010\u0014\u001a\u0004\u0018\u00010\u001cH\u0086\u0002J$\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\u0010\u0014\u001a\u0004\u0018\u00010\u001cH\u0016J\u0006\u0010\u001f\u001a\u00020\u001eR\u0013\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/WholeProjectModalAction;", "TData", "", "Lcom/intellij/codeInsight/intention/IntentionAction;", "title", "", "(Ljava/lang/String;)V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getTitle", "()Ljava/lang/String;", "applyAll", "", "project", "Lcom/intellij/openapi/project/Project;", "filesToData", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "applyChangesForFile", "file", "data", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/kotlin/psi/KtFile;Ljava/lang/Object;)V", "collectDataForFile", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/kotlin/psi/KtFile;)Ljava/lang/Object;", "invoke", "editor", "Lcom/intellij/openapi/editor/Editor;", "Lcom/intellij/psi/PsiFile;", "isAvailable", "", "startInWriteAction", "idea"})
public abstract class WholeProjectModalAction<TData>
implements IntentionAction {
    private final Logger LOG;
    @NotNull
    private final String title;

    public final boolean startInWriteAction() {
        return false;
    }

    public final void invoke(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.invoke(project);
    }

    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        return true;
    }

    private final void invoke(Project project) {
        ProgressManager.getInstance().run((Task)new Task.Modal(this, project, project, this.title, true){
            final /* synthetic */ WholeProjectModalAction this$0;
            final /* synthetic */ Project $project;

            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
                HashMap<K, V> filesToData = new HashMap<K, V>();
                ApplicationUtilsKt.runReadAction((Function0)new Function0<Unit>(this, indicator, filesToData){
                    final /* synthetic */ invoke.1 this$0;
                    final /* synthetic */ ProgressIndicator $indicator;
                    final /* synthetic */ HashMap $filesToData;

                    public final void invoke() {
                        Collection<KtFile> files2 = PluginJetFilesProvider.allFilesInProject(this.this$0.$project);
                        for (IndexedValue indexedValue : CollectionsKt.withIndex((Iterable)files2)) {
                            int i = indexedValue.component1();
                            KtFile currentFile = (KtFile)indexedValue.component2();
                            this.$indicator.setText("Checking file " + i + " of " + files2.size() + "...");
                            this.$indicator.setText2(currentFile.getVirtualFile().getPath());
                            this.$indicator.setFraction((double)(i + 1) / (double)files2.size());
                            try {
                                KtFile ktFile;
                                WholeProjectModalAction wholeProjectModalAction = this.this$0.this$0;
                                Project project = this.this$0.$project;
                                KtFile ktFile2 = currentFile;
                                Intrinsics.checkExpressionValueIsNotNull((Object)ktFile2, (String)"currentFile");
                                TData data = wholeProjectModalAction.collectDataForFile(project, ktFile2);
                                if (data == null) continue;
                                Map map2 = this.$filesToData;
                                Intrinsics.checkExpressionValueIsNotNull((Object)currentFile, (String)"currentFile");
                                TData TData = data;
                                map2.put(ktFile, TData);
                            }
                            catch (ProcessCanceledException e) {
                                return;
                            }
                            catch (Throwable e) {
                                WholeProjectModalAction.access$getLOG$p(this.this$0.this$0).error(e);
                            }
                        }
                    }
                    {
                        this.this$0 = var1_1;
                        this.$indicator = progressIndicator;
                        this.$filesToData = hashMap;
                        super(0);
                    }
                });
                WholeProjectModalAction.access$applyAll(this.this$0, this.$project, filesToData);
            }
            {
                this.this$0 = $outer;
                this.$project = $captured_local_variable$1;
                super($super_call_param$2, $super_call_param$3, $super_call_param$4);
            }
        });
    }

    private final void applyAll(Project project, Map<KtFile, ? extends TData> filesToData) {
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(this, project, filesToData){
            final /* synthetic */ WholeProjectModalAction this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ Map $filesToData;

            public final void run() {
                String string = this.this$0.getText();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"text");
                ApplicationUtilsKt.executeCommand$default(this.$project, string, null, (Function0)new Function0<Unit>(this){
                    final /* synthetic */ applyAll.1 this$0;

                    public final void invoke() {
                        ApplicationUtilsKt.runWriteAction((Function0)new Function0<Unit>(this){
                            final /* synthetic */ applyAll.1 this$0;

                            public final void invoke() {
                                Map $receiver$iv;
                                Map map2 = $receiver$iv = this.this$0.this$0.$filesToData;
                                Iterator<Map.Entry<K, V>> iterator2 = map2.entrySet().iterator();
                                while (iterator2.hasNext()) {
                                    Map.Entry<K, V> element$iv;
                                    Map.Entry<K, V> it = element$iv = iterator2.next();
                                    try {
                                        this.this$0.this$0.this$0.applyChangesForFile(this.this$0.this$0.$project, (KtFile)it.getKey(), it.getValue());
                                    }
                                    catch (Throwable e) {
                                        WholeProjectModalAction.access$getLOG$p(this.this$0.this$0.this$0).error(e);
                                    }
                                }
                            }
                            {
                                this.this$0 = var1_1;
                                super(0);
                            }
                        });
                    }
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }
                }, 2, null);
            }
            {
                this.this$0 = wholeProjectModalAction;
                this.$project = project;
                this.$filesToData = map2;
            }
        });
    }

    @Nullable
    protected abstract TData collectDataForFile(@NotNull Project var1, @NotNull KtFile var2);

    protected abstract void applyChangesForFile(@NotNull Project var1, @NotNull KtFile var2, @NotNull TData var3);

    @NotNull
    public final String getTitle() {
        return this.title;
    }

    public WholeProjectModalAction(@NotNull String title) {
        Intrinsics.checkParameterIsNotNull((Object)title, (String)"title");
        this.title = title;
        this.LOG = Logger.getInstance(WholeProjectModalAction.class);
    }

    @NotNull
    public static final /* synthetic */ Logger access$getLOG$p(WholeProjectModalAction $this) {
        return $this.LOG;
    }

    public static final /* synthetic */ void access$applyAll(WholeProjectModalAction $this, @NotNull Project project, @NotNull Map filesToData) {
        $this.applyAll(project, filesToData);
    }
}

