/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.vfilefinder;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.ID;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.vfilefinder.FileFindersKt;
import org.jetbrains.kotlin.idea.vfilefinder.KotlinFileIndexBase;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=2, d1={"\u0000<\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a6\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a(\u0010\u000e\u001a\u00020\u000f\"\u0004\b\u0000\u0010\u0010*\b\u0012\u0004\u0012\u0002H\u00100\u00112\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u00a8\u0006\u0013"}, d2={"checkScopeForFinder", "", "scope", "Lcom/intellij/psi/search/GlobalSearchScope;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "findVirtualFileWithHeader", "Lcom/intellij/openapi/vfs/VirtualFile;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "key", "Lcom/intellij/util/indexing/ID;", "Lorg/jetbrains/kotlin/name/FqName;", "Ljava/lang/Void;", "hasPackage", "", "T", "Lorg/jetbrains/kotlin/idea/vfilefinder/KotlinFileIndexBase;", "fqName", "idea-analysis"})
public final class FileFindersKt {
    private static final void checkScopeForFinder(GlobalSearchScope scope2, Logger logger) {
        if (Intrinsics.areEqual((Object)scope2, (Object)GlobalSearchScope.EMPTY_SCOPE) ^ true && scope2.getProject() == null) {
            logger.warn("Scope with null project " + scope2);
        }
    }

    private static final VirtualFile findVirtualFileWithHeader(ClassId classId, ID<FqName, Void> key, GlobalSearchScope scope2, Logger logger) {
        Collection files2 = FileBasedIndex.getInstance().getContainingFiles(key, (Object)classId.asSingleFqName(), scope2);
        if (files2.isEmpty()) {
            return null;
        }
        if (files2.size() > 1) {
            logger.warn("There are " + files2.size() + " classes with same fqName: " + classId + " found.");
        }
        return (VirtualFile)files2.iterator().next();
    }

    private static final <T> boolean hasPackage(@NotNull KotlinFileIndexBase<T> $receiver, FqName fqName2, GlobalSearchScope scope2) {
        return !FileBasedIndex.getInstance().processValues($receiver.getName(), (Object)fqName2, null, (FileBasedIndex.ValueProcessor)hasPackage.1.INSTANCE, scope2);
    }

    public static final /* synthetic */ boolean access$hasPackage(@NotNull KotlinFileIndexBase $receiver, @NotNull FqName fqName2, @NotNull GlobalSearchScope scope2) {
        return FileFindersKt.hasPackage($receiver, fqName2, scope2);
    }

    public static final /* synthetic */ void access$checkScopeForFinder(@NotNull GlobalSearchScope scope2, @NotNull Logger logger) {
        FileFindersKt.checkScopeForFinder(scope2, logger);
    }

    @Nullable
    public static final /* synthetic */ VirtualFile access$findVirtualFileWithHeader(@NotNull ClassId classId, @NotNull ID key, @NotNull GlobalSearchScope scope2, @NotNull Logger logger) {
        return FileFindersKt.findVirtualFileWithHeader(classId, (ID<FqName, Void>)key, scope2, logger);
    }
}

