/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.j2k.ast;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.j2k.CodeBuilder;
import org.jetbrains.kotlin.j2k.ast.Element;
import org.jetbrains.kotlin.j2k.ast.Expression;
import org.jetbrains.kotlin.j2k.ast.Identifier;
import org.jetbrains.kotlin.j2k.ast.Statement;
import org.jetbrains.kotlin.j2k.ast.Type;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/j2k/ast/ForeachStatement;", "Lorg/jetbrains/kotlin/j2k/ast/Statement;", "variableName", "Lorg/jetbrains/kotlin/j2k/ast/Identifier;", "explicitVariableType", "Lorg/jetbrains/kotlin/j2k/ast/Type;", "collection", "Lorg/jetbrains/kotlin/j2k/ast/Expression;", "body", "Lorg/jetbrains/kotlin/j2k/ast/Element;", "singleLine", "", "(Lorg/jetbrains/kotlin/j2k/ast/Identifier;Lorg/jetbrains/kotlin/j2k/ast/Type;Lorg/jetbrains/kotlin/j2k/ast/Expression;Lorg/jetbrains/kotlin/j2k/ast/Element;Z)V", "getBody", "()Lorg/jetbrains/kotlin/j2k/ast/Element;", "br", "", "getCollection", "()Lorg/jetbrains/kotlin/j2k/ast/Expression;", "getExplicitVariableType", "()Lorg/jetbrains/kotlin/j2k/ast/Type;", "getVariableName", "()Lorg/jetbrains/kotlin/j2k/ast/Identifier;", "generateCode", "", "builder", "Lorg/jetbrains/kotlin/j2k/CodeBuilder;", "j2k"})
public final class ForeachStatement
extends Statement {
    private final String br;
    @NotNull
    private final Identifier variableName;
    @Nullable
    private final Type explicitVariableType;
    @NotNull
    private final Expression collection;
    @NotNull
    private final Element body;

    @Override
    public void generateCode(@NotNull CodeBuilder builder) {
        Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
        builder.append("for (").append(this.variableName);
        if (this.explicitVariableType != null) {
            builder.append(":").append(this.explicitVariableType);
        }
        builder.append(" in ").append(this.collection).append(")").append(this.br).append(this.body);
    }

    @NotNull
    public final Identifier getVariableName() {
        return this.variableName;
    }

    @Nullable
    public final Type getExplicitVariableType() {
        return this.explicitVariableType;
    }

    @NotNull
    public final Expression getCollection() {
        return this.collection;
    }

    @NotNull
    public final Element getBody() {
        return this.body;
    }

    public ForeachStatement(@NotNull Identifier variableName, @Nullable Type explicitVariableType, @NotNull Expression collection, @NotNull Element body2, boolean singleLine) {
        Intrinsics.checkParameterIsNotNull((Object)variableName, (String)"variableName");
        Intrinsics.checkParameterIsNotNull((Object)collection, (String)"collection");
        Intrinsics.checkParameterIsNotNull((Object)body2, (String)"body");
        this.variableName = variableName;
        this.explicitVariableType = explicitVariableType;
        this.collection = collection;
        this.body = body2;
        this.br = singleLine ? " " : "\n";
    }
}

