/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.config;

import com.google.common.collect.Lists;
import com.intellij.openapi.project.Project;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.LanguageVersionSettingsImpl;
import org.jetbrains.kotlin.descriptors.PackageFragmentProvider;
import org.jetbrains.kotlin.descriptors.impl.ModuleDescriptorImpl;
import org.jetbrains.kotlin.js.config.JSConfigurationKeys;
import org.jetbrains.kotlin.js.resolve.JsPlatform;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.CompilerDeserializationConfiguration;
import org.jetbrains.kotlin.serialization.js.JsModuleDescriptor;
import org.jetbrains.kotlin.serialization.js.KotlinJavascriptSerializationUtil;
import org.jetbrains.kotlin.serialization.js.ModuleKind;
import org.jetbrains.kotlin.storage.LockBasedStorageManager;
import org.jetbrains.kotlin.utils.JsMetadataVersion;
import org.jetbrains.kotlin.utils.KotlinJavascriptMetadata;

public abstract class JsConfig {
    private final Project project;
    private final CompilerConfiguration configuration;
    private final LockBasedStorageManager storageManager;
    private final List<KtFile> sourceFilesFromLibraries;
    @NotNull
    protected final List<KotlinJavascriptMetadata> metadata;
    @Nullable
    private List<JsModuleDescriptor<ModuleDescriptorImpl>> moduleDescriptors;
    private boolean initialized;

    protected JsConfig(@NotNull Project project, @NotNull CompilerConfiguration configuration2) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/js/config/JsConfig", "<init>"));
        }
        if (configuration2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "configuration", "org/jetbrains/kotlin/js/config/JsConfig", "<init>"));
        }
        this.storageManager = new LockBasedStorageManager();
        this.sourceFilesFromLibraries = new SmartList();
        this.metadata = new SmartList();
        this.moduleDescriptors = null;
        this.initialized = false;
        this.project = project;
        this.configuration = configuration2;
    }

    @NotNull
    public CompilerConfiguration getConfiguration() {
        CompilerConfiguration compilerConfiguration = this.configuration;
        if (compilerConfiguration == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/config/JsConfig", "getConfiguration"));
        }
        return compilerConfiguration;
    }

    @NotNull
    public Project getProject() {
        Project project = this.project;
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/config/JsConfig", "getProject"));
        }
        return project;
    }

    @NotNull
    public String getModuleId() {
        String string = this.configuration.getNotNull(CommonConfigurationKeys.MODULE_NAME);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/config/JsConfig", "getModuleId"));
        }
        return string;
    }

    @NotNull
    public ModuleKind getModuleKind() {
        ModuleKind moduleKind = this.configuration.get(JSConfigurationKeys.MODULE_KIND, ModuleKind.PLAIN);
        if (moduleKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/config/JsConfig", "getModuleKind"));
        }
        return moduleKind;
    }

    public abstract boolean checkLibFilesAndReportErrors(@NotNull Reporter var1);

    protected abstract void init(@NotNull List<KtFile> var1, @NotNull List<KotlinJavascriptMetadata> var2);

    @NotNull
    public List<JsModuleDescriptor<ModuleDescriptorImpl>> getModuleDescriptors() {
        this.init();
        if (this.moduleDescriptors != null) {
            List<JsModuleDescriptor<ModuleDescriptorImpl>> list2 = this.moduleDescriptors;
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/config/JsConfig", "getModuleDescriptors"));
            }
            return list2;
        }
        this.moduleDescriptors = new SmartList();
        ArrayList<ModuleDescriptorImpl> kotlinModuleDescriptors = new ArrayList<ModuleDescriptorImpl>();
        for (KotlinJavascriptMetadata kotlinJavascriptMetadata : this.metadata) {
            JsModuleDescriptor<ModuleDescriptorImpl> descriptor2 = this.createModuleDescriptor(kotlinJavascriptMetadata);
            this.moduleDescriptors.add(descriptor2);
            kotlinModuleDescriptors.add(descriptor2.getData());
        }
        for (JsModuleDescriptor jsModuleDescriptor : this.moduleDescriptors) {
            JsConfig.setDependencies((ModuleDescriptorImpl)jsModuleDescriptor.getData(), kotlinModuleDescriptors);
        }
        List<JsModuleDescriptor<ModuleDescriptorImpl>> list3 = this.moduleDescriptors = Collections.unmodifiableList(this.moduleDescriptors);
        if (list3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/config/JsConfig", "getModuleDescriptors"));
        }
        return list3;
    }

    @NotNull
    private List<KtFile> getSourceFilesFromLibraries() {
        this.init();
        List<KtFile> list2 = this.sourceFilesFromLibraries;
        if (list2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/config/JsConfig", "getSourceFilesFromLibraries"));
        }
        return list2;
    }

    private void init() {
        if (this.initialized) {
            return;
        }
        this.init(this.sourceFilesFromLibraries, this.metadata);
        this.initialized = true;
    }

    private JsModuleDescriptor<ModuleDescriptorImpl> createModuleDescriptor(KotlinJavascriptMetadata metadata) {
        assert (metadata.getVersion().isCompatible()) : "Expected JS metadata version " + JsMetadataVersion.INSTANCE + ", but actual metadata version is " + metadata.getVersion();
        ModuleDescriptorImpl moduleDescriptor = new ModuleDescriptorImpl(Name.special("<" + metadata.getModuleName() + ">"), this.storageManager, JsPlatform.INSTANCE.getBuiltIns());
        JsModuleDescriptor<PackageFragmentProvider> rawDescriptor = KotlinJavascriptSerializationUtil.readModule(metadata.getBody(), this.storageManager, moduleDescriptor, new CompilerDeserializationConfiguration(this.configuration.get(CommonConfigurationKeys.LANGUAGE_VERSION_SETTINGS, LanguageVersionSettingsImpl.DEFAULT)));
        PackageFragmentProvider provider2 = rawDescriptor.getData();
        moduleDescriptor.initialize(provider2 != null ? provider2 : PackageFragmentProvider.Empty.INSTANCE);
        return rawDescriptor.copy(moduleDescriptor);
    }

    private static void setDependencies(ModuleDescriptorImpl module, List<ModuleDescriptorImpl> modules) {
        module.setDependencies(CollectionsKt.plus(modules, (Object)JsPlatform.INSTANCE.getBuiltIns().getBuiltInsModule()));
    }

    @NotNull
    public static Collection<KtFile> withJsLibAdded(@NotNull Collection<KtFile> files2, @NotNull JsConfig config2) {
        if (files2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "org/jetbrains/kotlin/js/config/JsConfig", "withJsLibAdded"));
        }
        if (config2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "org/jetbrains/kotlin/js/config/JsConfig", "withJsLibAdded"));
        }
        ArrayList allFiles2 = Lists.newArrayList();
        allFiles2.addAll(files2);
        allFiles2.addAll(config2.getSourceFilesFromLibraries());
        ArrayList arrayList = allFiles2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/config/JsConfig", "withJsLibAdded"));
        }
        return arrayList;
    }

    public static abstract class Reporter {
        public void error(@NotNull String message2) {
            if (message2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/kotlin/js/config/JsConfig$Reporter", "error"));
            }
        }

        public void warning(@NotNull String message2) {
            if (message2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/kotlin/js/config/JsConfig$Reporter", "warning"));
            }
        }
    }
}

