/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.kotlin;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.load.kotlin.JvmMetadataVersion;
import org.jetbrains.kotlin.load.kotlin.PackageParts;
import org.jetbrains.kotlin.protobuf.ProtocolStringList;
import org.jetbrains.kotlin.serialization.jvm.JvmPackageTable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 \r2\u00020\u0001:\u0001\rB#\b\u0002\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\n\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000b\u001a\u00020\u0004J\b\u0010\f\u001a\u00020\u0004H\u0016R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/load/kotlin/ModuleMapping;", "", "packageFqName2Parts", "", "", "Lorg/jetbrains/kotlin/load/kotlin/PackageParts;", "debugName", "(Ljava/util/Map;Ljava/lang/String;)V", "getPackageFqName2Parts", "()Ljava/util/Map;", "findPackageParts", "packageFqName", "toString", "Companion", "descriptor.loader.java"})
public final class ModuleMapping {
    @NotNull
    private final Map<String, PackageParts> packageFqName2Parts;
    private final String debugName;
    @JvmField
    @NotNull
    public static final String MAPPING_FILE_EXT = "kotlin_module";
    @JvmField
    @NotNull
    public static final ModuleMapping EMPTY;
    public static final Companion Companion;

    @Nullable
    public final PackageParts findPackageParts(@NotNull String packageFqName) {
        Intrinsics.checkParameterIsNotNull((Object)packageFqName, (String)"packageFqName");
        return this.packageFqName2Parts.get(packageFqName);
    }

    @NotNull
    public String toString() {
        return this.debugName;
    }

    @NotNull
    public final Map<String, PackageParts> getPackageFqName2Parts() {
        return this.packageFqName2Parts;
    }

    private ModuleMapping(Map<String, PackageParts> packageFqName2Parts, String debugName2) {
        this.packageFqName2Parts = packageFqName2Parts;
        this.debugName = debugName2;
    }

    static {
        Companion = new Companion(null);
        MAPPING_FILE_EXT = MAPPING_FILE_EXT;
        EMPTY = new ModuleMapping(MapsKt.emptyMap(), "EMPTY");
    }

    public /* synthetic */ ModuleMapping(@NotNull Map packageFqName2Parts, @NotNull String debugName2, DefaultConstructorMarker $constructor_marker) {
        this(packageFqName2Parts, debugName2);
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0007\u001a\u00020\u00042\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u0006R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00068\u0006X\u0087D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/load/kotlin/ModuleMapping$Companion;", "", "()V", "EMPTY", "Lorg/jetbrains/kotlin/load/kotlin/ModuleMapping;", "MAPPING_FILE_EXT", "", "create", "bytes", "", "debugName", "descriptor.loader.java"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        @NotNull
        public final ModuleMapping create(@Nullable byte[] bytes2, @Nullable String debugName2) {
            Object object;
            void size$iv;
            JvmMetadataVersion jvmMetadataVersion;
            if (bytes2 == null) {
                return EMPTY;
            }
            DataInputStream stream2 = new DataInputStream(new ByteArrayInputStream(bytes2));
            int n = stream2.readInt();
            Object object2 = jvmMetadataVersion;
            Object object3 = jvmMetadataVersion;
            int[] result$iv = new int[size$iv];
            boolean bl = false;
            void var8_12 = size$iv - true;
            if (bl <= var8_12) {
                void i$iv;
                do {
                    int n2;
                    void var9_14 = ++i$iv;
                    void var22_18 = i$iv;
                    object = result$iv;
                    object[var22_18] = n2 = stream2.readInt();
                } while (i$iv != var8_12);
            }
            object = result$iv;
            ((JvmMetadataVersion)object2)(Arrays.copyOf(object, ((int[])object).length));
            JvmMetadataVersion version = object3;
            if (version.isCompatible()) {
                PackageParts answer$iv;
                Object value$iv;
                Object $receiver$iv;
                Object key$iv;
                JvmPackageTable.PackageTable packageTable = JvmPackageTable.PackageTable.parseFrom(stream2);
                if (packageTable == null) {
                    return EMPTY;
                }
                JvmPackageTable.PackageTable table = packageTable;
                LinkedHashMap result2 = new LinkedHashMap();
                for (JvmPackageTable.PackageParts proto : table.getPackagePartsList()) {
                    Object object4;
                    Map map2 = result2;
                    String string = proto.getPackageFqName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"proto.packageFqName");
                    key$iv = string;
                    value$iv = $receiver$iv.get(key$iv);
                    if (value$iv == null) {
                        String string2 = proto.getPackageFqName();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"proto.packageFqName");
                        answer$iv = new PackageParts(string2);
                        $receiver$iv.put(key$iv, answer$iv);
                        object4 = answer$iv;
                    } else {
                        object4 = value$iv;
                    }
                    PackageParts packageParts = (PackageParts)object4;
                    key$iv = CollectionsKt.withIndex((Iterable)proto.getClassNameList()).iterator();
                    while (key$iv.hasNext()) {
                        String string3;
                        $receiver$iv = (IndexedValue)key$iv.next();
                        int index2 = $receiver$iv.component1();
                        String partShortName = (String)$receiver$iv.component2();
                        Integer n3 = (Integer)CollectionsKt.getOrNull(proto.getMultifileFacadeIdList(), (int)index2);
                        Integer multifileFacadeId = n3 != null ? Integer.valueOf(n3 - 1) : null;
                        Object object5 = packageParts;
                        String string4 = partShortName;
                        Object object6 = string4;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"partShortName");
                        if (multifileFacadeId != null) {
                            Integer n4;
                            ProtocolStringList protocolStringList = proto.getMultifileFacadeNameList();
                            object2 = object6;
                            object3 = object5;
                            int p1 = ((Number)n4).intValue();
                            object = (String)CollectionsKt.getOrNull((List)protocolStringList, (int)p1);
                            object5 = object3;
                            object6 = object2;
                            string3 = (String)object;
                        } else {
                            string3 = null;
                        }
                        ((PackageParts)object5).addPart((String)object6, string3);
                    }
                }
                for (JvmPackageTable.PackageParts proto : table.getMetadataPartsList()) {
                    Object object7;
                    $receiver$iv = result2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)proto.getPackageFqName(), (String)"proto.packageFqName");
                    value$iv = $receiver$iv.get(key$iv);
                    if (value$iv == null) {
                        String string = proto.getPackageFqName();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"proto.packageFqName");
                        answer$iv = new PackageParts(string);
                        $receiver$iv.put(key$iv, answer$iv);
                        object7 = answer$iv;
                    } else {
                        object7 = value$iv;
                    }
                    PackageParts packageParts = (PackageParts)object7;
                    $receiver$iv = proto.getClassNameList();
                    Iterator iterator2 = $receiver$iv.iterator();
                    while (iterator2.hasNext()) {
                        Object element$iv = iterator2.next();
                        String p1 = (String)element$iv;
                        packageParts.addMetadataPart(p1);
                    }
                }
                Map map3 = result2;
                String string = debugName2;
                if (string == null) {
                    string = "<unknown>";
                }
                return new ModuleMapping(map3, string, null);
            }
            return EMPTY;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

