/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi2ir.transformations;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrCatch;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetVariable;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrThrow;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperator;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrVarargElement;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.impl.IrTypeOperatorCallImpl;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.psi2ir.KotlinUtilsKt;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0016J\u0010\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\f2\u0006\u0010 \u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020\f2\u0006\u0010\r\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020%H\u0016J\u0010\u0010'\u001a\u00020\f2\u0006\u0010\r\u001a\u00020(H\u0016J\u0016\u0010)\u001a\u00020\f*\u00020\f2\b\u0010*\u001a\u0004\u0018\u00010+H\u0002J\f\u0010,\u001a\u00020\f*\u00020\fH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006-"}, d2={"Lorg/jetbrains/kotlin/psi2ir/transformations/InsertImplicitCasts;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "builtIns", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "(Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;)V", "getBuiltIns", "()Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "visitBlockBody", "Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "body", "Lorg/jetbrains/kotlin/ir/expressions/IrBlockBody;", "visitContainerExpression", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrContainerExpression;", "visitElement", "Lorg/jetbrains/kotlin/ir/IrElement;", "element", "visitLoop", "loop", "Lorg/jetbrains/kotlin/ir/expressions/IrLoop;", "visitMemberAccess", "Lorg/jetbrains/kotlin/ir/expressions/IrMemberAccessExpression;", "visitReturn", "Lorg/jetbrains/kotlin/ir/expressions/IrReturn;", "visitSetField", "Lorg/jetbrains/kotlin/ir/expressions/IrSetField;", "visitSetVariable", "Lorg/jetbrains/kotlin/ir/expressions/IrSetVariable;", "visitThrow", "Lorg/jetbrains/kotlin/ir/expressions/IrThrow;", "visitTry", "aTry", "Lorg/jetbrains/kotlin/ir/expressions/IrTry;", "visitVararg", "Lorg/jetbrains/kotlin/ir/expressions/IrVararg;", "visitVariable", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "declaration", "visitWhen", "Lorg/jetbrains/kotlin/ir/expressions/IrWhen;", "cast", "expectedType", "Lorg/jetbrains/kotlin/types/KotlinType;", "coerceToUnit", "ir.psi2ir"})
public final class InsertImplicitCasts
extends IrElementTransformerVoid {
    @NotNull
    private final KotlinBuiltIns builtIns;

    @Override
    @NotNull
    public IrElement visitElement(@NotNull IrElement element2) {
        Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
        IrElementTransformerVoidKt.transformChildrenVoid(element2, this);
        return element2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public IrExpression visitMemberAccess(@NotNull IrMemberAccessExpression expression2) {
        IrExpression irExpression;
        IrExpression irExpression2;
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
        IrMemberAccessExpression $receiver = expression2;
        IrExpression irExpression3 = $receiver.getDispatchReceiver();
        if (irExpression3 != null) {
            ReceiverParameterDescriptor receiverParameterDescriptor = $receiver.getDescriptor().getDispatchReceiverParameter();
            irExpression2 = this.cast(irExpression3, receiverParameterDescriptor != null ? receiverParameterDescriptor.getType() : null);
        } else {
            irExpression2 = null;
        }
        $receiver.setDispatchReceiver(irExpression2);
        IrExpression irExpression4 = $receiver.getExtensionReceiver();
        if (irExpression4 != null) {
            ReceiverParameterDescriptor receiverParameterDescriptor = $receiver.getDescriptor().getExtensionReceiverParameter();
            irExpression = this.cast(irExpression4, receiverParameterDescriptor != null ? receiverParameterDescriptor.getType() : null);
        } else {
            irExpression = null;
        }
        $receiver.setExtensionReceiver(irExpression);
        int n = 0;
        int n2 = ((Collection)$receiver.getDescriptor().getValueParameters()).size() - 1;
        if (n <= n2) {
            while (true) {
                void index2;
                if ($receiver.getValueArgument((int)index2) == null) {
                } else {
                    IrExpression argument2;
                    KotlinType parameterType = $receiver.getDescriptor().getValueParameters().get((int)index2).getType();
                    $receiver.putValueArgument((int)index2, this.cast(argument2, parameterType));
                }
                if (index2 == n2) break;
                ++index2;
            }
        }
        return expression2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public IrBody visitBlockBody(@NotNull IrBlockBody body2) {
        Intrinsics.checkParameterIsNotNull((Object)body2, (String)"body");
        IrElementTransformerVoidKt.transformChildrenVoid(body2, this);
        Iterable $receiver$iv = body2.getStatements();
        int index$iv = 0;
        for (Object item$iv : $receiver$iv) {
            void irStatement;
            int n = index$iv++;
            IrStatement irStatement2 = (IrStatement)item$iv;
            int i = n;
            if (!(irStatement instanceof IrExpression)) continue;
            body2.getStatements().set(i, this.coerceToUnit((IrExpression)irStatement));
        }
        return body2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public IrExpression visitContainerExpression(@NotNull IrContainerExpression expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
        KotlinType type2 = expression2.getType();
        if (expression2.getStatements().isEmpty()) {
            return expression2;
        }
        int lastIndex = CollectionsKt.getLastIndex(expression2.getStatements());
        Iterable $receiver$iv = expression2.getStatements();
        int index$iv = 0;
        for (Object item$iv : $receiver$iv) {
            void irStatement;
            int n = index$iv++;
            IrStatement irStatement2 = (IrStatement)item$iv;
            int i = n;
            if (!(irStatement instanceof IrExpression)) continue;
            expression2.getStatements().set(i, i == lastIndex ? this.cast((IrExpression)irStatement, type2) : this.coerceToUnit((IrExpression)irStatement));
        }
        return expression2;
    }

    @Override
    @NotNull
    public IrExpression visitReturn(@NotNull IrReturn expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
        IrExpression irExpression = expression2.getValue();
        expression2.setValue(irExpression != null ? this.cast(irExpression, expression2.getReturnTarget().getReturnType()) : null);
        return expression2;
    }

    @Override
    @NotNull
    public IrExpression visitSetVariable(@NotNull IrSetVariable expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
        expression2.setValue(this.cast(expression2.getValue(), expression2.getDescriptor().getType()));
        return expression2;
    }

    @Override
    @NotNull
    public IrExpression visitSetField(@NotNull IrSetField expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
        expression2.setValue(this.cast(expression2.getValue(), expression2.getDescriptor().getType()));
        return expression2;
    }

    @Override
    @NotNull
    public IrVariable visitVariable(@NotNull IrVariable declaration2) {
        Intrinsics.checkParameterIsNotNull((Object)declaration2, (String)"declaration");
        IrElementTransformerVoidKt.transformChildrenVoid(declaration2, this);
        IrExpression irExpression = declaration2.getInitializer();
        declaration2.setInitializer(irExpression != null ? this.cast(irExpression, declaration2.getDescriptor().getType()) : null);
        return declaration2;
    }

    @Override
    @NotNull
    public IrExpression visitWhen(@NotNull IrWhen expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
        KotlinType resultType = expression2.getType();
        for (IrBranch irBranch : expression2.getBranches()) {
            irBranch.setCondition(this.cast(irBranch.getCondition(), this.builtIns.getBooleanType()));
            irBranch.setResult(this.cast(irBranch.getResult(), resultType));
        }
        return expression2;
    }

    @Override
    @NotNull
    public IrExpression visitLoop(@NotNull IrLoop loop) {
        Intrinsics.checkParameterIsNotNull((Object)loop, (String)"loop");
        IrElementTransformerVoidKt.transformChildrenVoid(loop, this);
        loop.setCondition(this.cast(loop.getCondition(), this.builtIns.getBooleanType()));
        IrExpression irExpression = loop.getBody();
        loop.setBody(irExpression != null ? this.coerceToUnit(irExpression) : null);
        return loop;
    }

    @Override
    @NotNull
    public IrExpression visitThrow(@NotNull IrThrow expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
        expression2.setValue(this.cast(expression2.getValue(), this.builtIns.getThrowable().getDefaultType()));
        return expression2;
    }

    @Override
    @NotNull
    public IrExpression visitTry(@NotNull IrTry aTry) {
        Intrinsics.checkParameterIsNotNull((Object)aTry, (String)"aTry");
        IrElementTransformerVoidKt.transformChildrenVoid(aTry, this);
        KotlinType resultType = aTry.getType();
        aTry.setTryResult(this.cast(aTry.getTryResult(), resultType));
        for (IrCatch aCatch : aTry.getCatches()) {
            aCatch.setResult(this.cast(aCatch.getResult(), resultType));
        }
        IrExpression irExpression = aTry.getFinallyExpression();
        aTry.setFinallyExpression(irExpression != null ? this.coerceToUnit(irExpression) : null);
        return aTry;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public IrExpression visitVararg(@NotNull IrVararg expression2) {
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
        Iterable $receiver$iv = expression2.getElements();
        int index$iv = 0;
        for (Object item$iv : $receiver$iv) {
            void element2;
            int n = index$iv++;
            IrVarargElement irVarargElement = (IrVarargElement)item$iv;
            int i = n;
            void var8_8 = element2;
            if (var8_8 instanceof IrSpreadElement) {
                ((IrSpreadElement)element2).setExpression(this.cast(((IrSpreadElement)element2).getExpression(), expression2.getType()));
                continue;
            }
            if (!(var8_8 instanceof IrExpression)) continue;
            expression2.putElement(i, this.cast((IrExpression)element2, expression2.getVarargElementType()));
        }
        return expression2;
    }

    private final IrExpression cast(@NotNull IrExpression $receiver, KotlinType expectedType) {
        if (expectedType == null) {
            return $receiver;
        }
        if (expectedType.isError()) {
            return $receiver;
        }
        if (KotlinBuiltIns.isUnit(expectedType)) {
            return this.coerceToUnit($receiver);
        }
        KotlinType valueType = $receiver.getType();
        if (FlexibleTypesKt.isNullabilityFlexible(valueType) && KotlinUtilsKt.containsNull(valueType) && !KotlinUtilsKt.containsNull(expectedType)) {
            KotlinType nonNullValueType = TypeUtilsKt.makeNotNullable(FlexibleTypesKt.upperIfFlexible(valueType));
            return this.cast(new IrTypeOperatorCallImpl($receiver.getStartOffset(), $receiver.getEndOffset(), nonNullValueType, IrTypeOperator.IMPLICIT_NOTNULL, nonNullValueType, $receiver), expectedType);
        }
        if (!KotlinTypeChecker.DEFAULT.isSubtypeOf(TypeUtilsKt.makeNotNullable(valueType), expectedType)) {
            return new IrTypeOperatorCallImpl($receiver.getStartOffset(), $receiver.getEndOffset(), expectedType, IrTypeOperator.IMPLICIT_CAST, expectedType, $receiver);
        }
        return $receiver;
    }

    private final IrExpression coerceToUnit(@NotNull IrExpression $receiver) {
        IrExpression irExpression;
        KotlinType valueType = $receiver.getType();
        if (KotlinTypeChecker.DEFAULT.isSubtypeOf(valueType, this.builtIns.getUnitType())) {
            irExpression = $receiver;
        } else {
            int n = $receiver.getStartOffset();
            int n2 = $receiver.getEndOffset();
            SimpleType simpleType2 = this.builtIns.getUnitType();
            Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"builtIns.unitType");
            KotlinType kotlinType = simpleType2;
            SimpleType simpleType3 = this.builtIns.getUnitType();
            Intrinsics.checkExpressionValueIsNotNull((Object)simpleType3, (String)"builtIns.unitType");
            irExpression = new IrTypeOperatorCallImpl(n, n2, kotlinType, IrTypeOperator.IMPLICIT_COERCION_TO_UNIT, simpleType3, $receiver);
        }
        return irExpression;
    }

    @NotNull
    public final KotlinBuiltIns getBuiltIns() {
        return this.builtIns;
    }

    public InsertImplicitCasts(@NotNull KotlinBuiltIns builtIns) {
        Intrinsics.checkParameterIsNotNull((Object)builtIns, (String)"builtIns");
        this.builtIns = builtIns;
    }
}

