/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.inline;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.ParameterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationUtilKt;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.resolve.AnalyzerExtensions;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;
import org.jetbrains.kotlin.resolve.inline.ReasonableInlineRule;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J \u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J(\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\u00152\b\u0010\f\u001a\u0004\u0018\u00010\rJ \u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\f\u001a\u00020\rH\u0002J \u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\f\u001a\u00020\rH\u0002J \u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\f\u001a\u00020\rH\u0016J\f\u0010\u001e\u001a\u00020\u0010*\u00020\u0018H\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/resolve/inline/InlineAnalyzerExtension;", "Lorg/jetbrains/kotlin/resolve/AnalyzerExtensions$AnalyzerExtension;", "reasonableInlineRules", "", "Lorg/jetbrains/kotlin/resolve/inline/ReasonableInlineRule;", "(Ljava/lang/Iterable;)V", "checkDefaults", "", "functionDescriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "function", "Lorg/jetbrains/kotlin/psi/KtFunction;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "checkHasInlinableAndNullability", "checkInlinableParameter", "", "parameter", "Lorg/jetbrains/kotlin/descriptors/ParameterDescriptor;", "expression", "Lorg/jetbrains/kotlin/psi/KtElement;", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "checkModalityAndOverrides", "callableDescriptor", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "functionOrProperty", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "notSupportedInInlineCheck", "descriptor", "process", "isEffectivelyFinal", "frontend"})
public final class InlineAnalyzerExtension
implements AnalyzerExtensions.AnalyzerExtension {
    private final Iterable<ReasonableInlineRule> reasonableInlineRules;

    @Override
    public void process(@NotNull CallableMemberDescriptor descriptor2, @NotNull KtCallableDeclaration functionOrProperty, @NotNull BindingTrace trace) {
        block10: {
            block11: {
                block9: {
                    Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
                    Intrinsics.checkParameterIsNotNull((Object)functionOrProperty, (String)"functionOrProperty");
                    Intrinsics.checkParameterIsNotNull((Object)trace, (String)"trace");
                    this.checkModalityAndOverrides(descriptor2, functionOrProperty, trace);
                    this.notSupportedInInlineCheck(descriptor2, functionOrProperty, trace);
                    if (!(descriptor2 instanceof FunctionDescriptor)) break block9;
                    boolean bl = functionOrProperty instanceof KtNamedFunction;
                    if (_Assertions.ENABLED && !bl) {
                        String string = "Function descriptor " + descriptor2 + " should have corresponded KtNamedFunction, but has " + functionOrProperty;
                        throw (Throwable)((Object)new AssertionError((Object)string));
                    }
                    KtCallableDeclaration ktCallableDeclaration = functionOrProperty;
                    if (ktCallableDeclaration == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtNamedFunction");
                    }
                    this.checkDefaults((FunctionDescriptor)descriptor2, (KtNamedFunction)ktCallableDeclaration, trace);
                    this.checkHasInlinableAndNullability((FunctionDescriptor)descriptor2, (KtFunction)functionOrProperty, trace);
                    break block10;
                }
                boolean bl = descriptor2 instanceof PropertyDescriptor;
                if (_Assertions.ENABLED && !bl) {
                    String string = "PropertyDescriptor expected, but was " + descriptor2;
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                bl = functionOrProperty instanceof KtProperty;
                if (_Assertions.ENABLED && !bl) {
                    String string = "Property descriptor " + descriptor2 + " should have corresponded KtProperty, but has " + functionOrProperty;
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                CallableMemberDescriptor callableMemberDescriptor = descriptor2;
                if (callableMemberDescriptor == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.PropertyDescriptor");
                }
                boolean hasBackingField = Intrinsics.areEqual((Object)((Boolean)trace.get(BindingContext.BACKING_FIELD_REQUIRED, (PropertyDescriptor)callableMemberDescriptor)), (Object)true);
                if (hasBackingField) break block11;
                KtCallableDeclaration ktCallableDeclaration = functionOrProperty;
                if (ktCallableDeclaration == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtProperty");
                }
                if (((KtProperty)ktCallableDeclaration).getDelegateExpression() == null) break block10;
            }
            trace.report(Errors.INLINE_PROPERTY_WITH_BACKING_FIELD.on((KtDeclaration)((PsiElement)functionOrProperty)));
        }
    }

    private final void notSupportedInInlineCheck(CallableMemberDescriptor descriptor2, KtCallableDeclaration functionOrProperty, BindingTrace trace) {
        KtVisitorVoid visitor2 = new KtVisitorVoid(trace, descriptor2){
            final /* synthetic */ BindingTrace $trace;
            final /* synthetic */ CallableMemberDescriptor $descriptor;

            public void visitKtElement(@NotNull KtElement element2) {
                Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
                super.visitKtElement(element2);
                element2.acceptChildren(this);
            }

            public void visitClass(@NotNull KtClass klass2) {
                Intrinsics.checkParameterIsNotNull((Object)klass2, (String)"klass");
                this.$trace.report(Errors.NOT_YET_SUPPORTED_IN_INLINE.on((KtElement)((PsiElement)klass2), klass2, this.$descriptor));
            }

            public void visitNamedFunction(@NotNull KtNamedFunction function2) {
                Intrinsics.checkParameterIsNotNull((Object)function2, (String)"function");
                if (function2.getParent().getParent() instanceof KtObjectDeclaration) {
                    super.visitNamedFunction(function2);
                } else {
                    this.$trace.report(Errors.NOT_YET_SUPPORTED_IN_INLINE.on((KtElement)((PsiElement)function2), function2, this.$descriptor));
                }
            }
            {
                this.$trace = $captured_local_variable$0;
                this.$descriptor = $captured_local_variable$1;
            }
        };
        functionOrProperty.acceptChildren(visitor2);
    }

    private final void checkDefaults(FunctionDescriptor functionDescriptor2, KtFunction function2, BindingTrace trace) {
        List<KtParameter> ktParameters = function2.getValueParameters();
        for (ValueParameterDescriptor parameter : functionDescriptor2.getValueParameters()) {
            if (!DescriptorUtilsKt.hasDefaultValue(parameter)) continue;
            KtParameter ktParameter = ktParameters.get(parameter.getIndex());
            ValueParameterDescriptor valueParameterDescriptor = parameter;
            Intrinsics.checkExpressionValueIsNotNull((Object)valueParameterDescriptor, (String)"parameter");
            ParameterDescriptor parameterDescriptor = valueParameterDescriptor;
            KtParameter ktParameter2 = ktParameter;
            Intrinsics.checkExpressionValueIsNotNull((Object)ktParameter2, (String)"ktParameter");
            if (!this.checkInlinableParameter(parameterDescriptor, ktParameter2, functionDescriptor2, null) && parameter.declaresDefaultValue()) continue;
            trace.report(Errors.NOT_YET_SUPPORTED_IN_INLINE.on((KtElement)((PsiElement)ktParameter), ktParameter, functionDescriptor2));
        }
    }

    private final void checkModalityAndOverrides(CallableMemberDescriptor callableDescriptor, KtCallableDeclaration functionOrProperty, BindingTrace trace) {
        boolean overridesAnything;
        if (callableDescriptor.getContainingDeclaration() instanceof PackageFragmentDescriptor) {
            return;
        }
        if (Visibilities.isPrivate(callableDescriptor.getVisibility())) {
            return;
        }
        Collection<? extends CallableMemberDescriptor> collection = callableDescriptor.getOverriddenDescriptors();
        boolean bl = overridesAnything = !collection.isEmpty();
        if (overridesAnything) {
            List ktTypeParameters = functionOrProperty.getTypeParameters();
            for (TypeParameterDescriptor typeParameter : callableDescriptor.getTypeParameters()) {
                if (!typeParameter.isReified()) continue;
                KtTypeParameter ktTypeParameter = (KtTypeParameter)ktTypeParameters.get(typeParameter.getIndex());
                KtModifierList ktModifierList = ktTypeParameter.getModifierList();
                if (ktModifierList == null || (ktModifierList = ktModifierList.getModifier(KtTokens.REIFIED_KEYWORD)) == null) {
                    ktModifierList = ktTypeParameter;
                }
                KtModifierList reportOn = ktModifierList;
                trace.report(Errors.REIFIED_TYPE_PARAMETER_IN_OVERRIDE.on((PsiElement)reportOn));
            }
        }
        if (this.isEffectivelyFinal(callableDescriptor)) {
            if (overridesAnything) {
                trace.report(Errors.OVERRIDE_BY_INLINE.on((KtDeclaration)((PsiElement)functionOrProperty)));
            }
            return;
        }
        trace.report(Errors.DECLARATION_CANT_BE_INLINED.on((KtDeclaration)((PsiElement)functionOrProperty)));
    }

    private final boolean isEffectivelyFinal(@NotNull CallableMemberDescriptor $receiver) {
        DeclarationDescriptor declarationDescriptor;
        DeclarationDescriptor containingDeclaration;
        return Intrinsics.areEqual((Object)((Object)$receiver.getModality()), (Object)((Object)Modality.FINAL)) || (containingDeclaration = (declarationDescriptor = $receiver.getContainingDeclaration())) instanceof ClassDescriptor && Intrinsics.areEqual((Object)((Object)((ClassDescriptor)containingDeclaration).getModality()), (Object)((Object)Modality.FINAL));
    }

    private final void checkHasInlinableAndNullability(FunctionDescriptor functionDescriptor2, KtFunction function2, BindingTrace trace) {
        boolean bl;
        block5: {
            Iterable iterable = function2.getValueParameters();
            List<ValueParameterDescriptor> list2 = functionDescriptor2.getValueParameters();
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"functionDescriptor.valueParameters");
            for (Pair pair2 : CollectionsKt.zip((Iterable)iterable, (Iterable)list2)) {
                ValueParameterDescriptor descriptor2;
                KtParameter ktParameter = (KtParameter)pair2.component1();
                ValueParameterDescriptor valueParameterDescriptor = descriptor2 = (ValueParameterDescriptor)pair2.component2();
                Intrinsics.checkExpressionValueIsNotNull((Object)valueParameterDescriptor, (String)"descriptor");
                ParameterDescriptor parameterDescriptor = valueParameterDescriptor;
                KtParameter ktParameter2 = ktParameter;
                Intrinsics.checkExpressionValueIsNotNull((Object)ktParameter2, (String)"parameter");
                if (!this.checkInlinableParameter(parameterDescriptor, ktParameter2, functionDescriptor2, trace)) continue;
                return;
            }
            if (InlineUtil.containsReifiedTypeParameters(functionDescriptor2) || AnnotationUtilKt.isInlineOnlyOrReifiable(functionDescriptor2) || functionDescriptor2.isHeader()) {
                return;
            }
            Iterable<ReasonableInlineRule> $receiver$iv = this.reasonableInlineRules;
            for (Object object : $receiver$iv) {
                ReasonableInlineRule it = (ReasonableInlineRule)object;
                CallableMemberDescriptor callableMemberDescriptor = functionDescriptor2;
                KtCallableDeclaration ktCallableDeclaration = function2;
                BindingContext bindingContext2 = trace.getBindingContext();
                Intrinsics.checkExpressionValueIsNotNull((Object)bindingContext2, (String)"trace.bindingContext");
                if (!it.isInlineReasonable(callableMemberDescriptor, ktCallableDeclaration, bindingContext2)) continue;
                bl = true;
                break block5;
            }
            bl = false;
        }
        if (bl) {
            return;
        }
        KtModifierList ktModifierList = function2.getModifierList();
        if (ktModifierList == null || (ktModifierList = ktModifierList.getModifier(KtTokens.INLINE_KEYWORD)) == null) {
            ktModifierList = function2;
        }
        KtModifierList reportOn = ktModifierList;
        trace.report(Errors.NOTHING_TO_INLINE.on((PsiElement)reportOn, functionDescriptor2));
    }

    public final boolean checkInlinableParameter(@NotNull ParameterDescriptor parameter, @NotNull KtElement expression2, @NotNull CallableDescriptor functionDescriptor2, @Nullable BindingTrace trace) {
        Intrinsics.checkParameterIsNotNull((Object)parameter, (String)"parameter");
        Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
        Intrinsics.checkParameterIsNotNull((Object)functionDescriptor2, (String)"functionDescriptor");
        if (InlineUtil.isInlineLambdaParameter(parameter)) {
            if (parameter.getType().isMarkedNullable()) {
                BindingTrace bindingTrace = trace;
                if (bindingTrace != null) {
                    bindingTrace.report(Errors.NULLABLE_INLINE_PARAMETER.on((KtElement)((PsiElement)expression2), expression2, functionDescriptor2));
                }
            } else {
                return true;
            }
        }
        return false;
    }

    public InlineAnalyzerExtension(@NotNull Iterable<? extends ReasonableInlineRule> reasonableInlineRules) {
        Intrinsics.checkParameterIsNotNull(reasonableInlineRules, (String)"reasonableInlineRules");
        this.reasonableInlineRules = reasonableInlineRules;
    }
}

