/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.IndexedValue;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=2, d1={"\u0000|\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0010\u001f\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\u0010\u001c\n\u0002\b\u0006\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0002\u001a%\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\b\b\u0000\u0010\u0005*\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u0001H\u0005\u00a2\u0006\u0002\u0010\b\u001a&\u0010\t\u001a\u000e\u0012\u0004\u0012\u0002H\u000b\u0012\u0004\u0012\u0002H\f0\n\"\u0004\b\u0000\u0010\u000b\"\u0004\b\u0001\u0010\f2\u0006\u0010\u0002\u001a\u00020\u0001\u001a\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u000e\"\u0004\b\u0000\u0010\u000f2\u0006\u0010\u0002\u001a\u00020\u0001\u001a&\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u0002H\u000b\u0012\u0004\u0012\u0002H\f0\u0011\"\u0004\b\u0000\u0010\u000b\"\u0004\b\u0001\u0010\f2\u0006\u0010\u0002\u001a\u00020\u0001\u001a\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u0013\"\u0004\b\u0000\u0010\u000f2\u0006\u0010\u0002\u001a\u00020\u0001\u001a)\u0010\u0014\u001a\u00020\u0015\"\b\b\u0000\u0010\u0005*\u00020\u0006*\b\u0012\u0004\u0012\u0002H\u00050\u00162\b\u0010\u0017\u001a\u0004\u0018\u0001H\u0005\u00a2\u0006\u0002\u0010\u0018\u001a\u001c\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\u0004\b\u0000\u0010\u0005*\b\u0012\u0004\u0012\u0002H\u00050\u001a\u001a@\u0010\u001b\u001a\u0002H\f\"\u0004\b\u0000\u0010\u000b\"\u0004\b\u0001\u0010\f*\u000e\u0012\u0004\u0012\u0002H\u000b\u0012\u0004\u0012\u0002H\f0\u001c2\u0006\u0010\u001d\u001a\u0002H\u000b2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H\f0\u001fH\u0086\b\u00a2\u0006\u0002\u0010 \u001a6\u0010!\u001a\u0002H\"\"\u0004\b\u0000\u0010\u0005\"\u000e\b\u0001\u0010\"*\b\u0012\u0004\u0012\u0002H\u00050#*\u0002H\"2\f\u0010$\u001a\b\u0012\u0004\u0012\u0002H\"0\u001fH\u0086\b\u00a2\u0006\u0002\u0010%\u001a>\u0010!\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u00050&\"\u0004\b\u0000\u0010\u0005*\n\u0012\u0006\b\u0001\u0012\u0002H\u00050&2\u0014\u0010$\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u0002H\u00050&0\u001fH\u0086\b\u00a2\u0006\u0002\u0010'\u001a2\u0010(\u001a\u00020\u0001\"\u0004\b\u0000\u0010\u0005*\b\u0012\u0004\u0012\u0002H\u00050\u00042\u0006\u0010)\u001a\u00020\u00012\u0012\u0010*\u001a\u000e\u0012\u0004\u0012\u0002H\u0005\u0012\u0004\u0012\u00020,0+\u001a<\u0010-\u001a\u000e\u0012\u0004\u0012\u0002H\u000b\u0012\u0004\u0012\u0002H\f0.\"\u0004\b\u0000\u0010\u000b\"\u0004\b\u0001\u0010\f*\b\u0012\u0004\u0012\u0002H\u000b0/2\u0012\u00100\u001a\u000e\u0012\u0004\u0012\u0002H\u000b\u0012\u0004\u0012\u0002H\f0+\u001aB\u00101\u001a\u000e\u0012\u0004\u0012\u0002H\u000b\u0012\u0004\u0012\u0002H\f0.\"\u0004\b\u0000\u0010\u000b\"\b\b\u0001\u0010\f*\u00020\u0006*\b\u0012\u0004\u0012\u0002H\u000b0/2\u0014\u00100\u001a\u0010\u0012\u0004\u0012\u0002H\u000b\u0012\u0006\u0012\u0004\u0018\u0001H\f0+\u001a\"\u00102\u001a\u000e\u0012\u0004\u0012\u0002H\u000b\u0012\u0004\u0012\u00020\u00010.\"\u0004\b\u0000\u0010\u000b*\b\u0012\u0004\u0012\u0002H\u000b0/\u001a!\u00103\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\b\b\u0000\u0010\u0005*\u00020\u0006*\u0004\u0018\u0001H\u0005\u00a2\u0006\u0002\u0010\b\u001a\u001c\u00104\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\u0004\b\u0000\u0010\u0005*\b\u0012\u0004\u0012\u0002H\u00050#\u00a8\u00065"}, d2={"capacity", "", "expectedSize", "emptyOrSingletonList", "", "T", "", "item", "(Ljava/lang/Object;)Ljava/util/List;", "newHashMapWithExpectedSize", "Ljava/util/HashMap;", "K", "V", "newHashSetWithExpectedSize", "Ljava/util/HashSet;", "E", "newLinkedHashMapWithExpectedSize", "Ljava/util/LinkedHashMap;", "newLinkedHashSetWithExpectedSize", "Ljava/util/LinkedHashSet;", "addIfNotNull", "", "", "t", "(Ljava/util/Collection;Ljava/lang/Object;)V", "compactIfPossible", "Ljava/util/ArrayList;", "getOrPutNullable", "", "key", "defaultValue", "Lkotlin/Function0;", "(Ljava/util/Map;Ljava/lang/Object;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "ifEmpty", "C", "", "body", "(Ljava/util/Collection;Lkotlin/jvm/functions/Function0;)Ljava/util/Collection;", "", "([Ljava/lang/Object;Lkotlin/jvm/functions/Function0;)[Ljava/lang/Object;", "indexOfFirst", "startFrom", "predicate", "Lkotlin/Function1;", "", "keysToMap", "", "", "value", "keysToMapExceptNulls", "mapToIndex", "singletonOrEmptyList", "toReadOnlyList", "util.runtime"})
public final class CollectionsKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <K, V> Map<K, V> keysToMap(@NotNull Iterable<? extends K> $receiver, @NotNull Function1<? super K, ? extends V> value2) {
        void $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(value2, (String)"value");
        Iterable<? extends K> $receiver$iv = $receiver;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)kotlin.collections.CollectionsKt.collectionSizeOrDefault($receiver$iv, (int)10)), (int)16);
        Iterable<? extends K> iterable = $receiver$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        Iterator iterator2 = $receiver$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void it;
            Object element$iv$iv;
            Object t = element$iv$iv = iterator2.next();
            Map map2 = destination$iv$iv;
            void var13_10 = it;
            map2.put(var13_10, value2.invoke(element$iv$iv));
        }
        return destination$iv$iv;
    }

    @NotNull
    public static final <K, V> Map<K, V> keysToMapExceptNulls(@NotNull Iterable<? extends K> $receiver, @NotNull Function1<? super K, ? extends V> value2) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(value2, (String)"value");
        LinkedHashMap map2 = new LinkedHashMap();
        for (K k : $receiver) {
            Object v = value2.invoke(k);
            if (v == null) continue;
            Map map3 = map2;
            Object object = v;
            map3.put(k, object);
        }
        return map2;
    }

    @NotNull
    public static final <K> Map<K, Integer> mapToIndex(@NotNull Iterable<? extends K> $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        LinkedHashMap map2 = new LinkedHashMap();
        for (IndexedValue indexedValue : kotlin.collections.CollectionsKt.withIndex($receiver)) {
            int index2 = indexedValue.component1();
            Object k = indexedValue.component2();
            Map map3 = map2;
            Integer n = index2;
            map3.put(k, n);
        }
        return map2;
    }

    public static final <K, V> V getOrPutNullable(@NotNull Map<K, V> $receiver, K key, @NotNull Function0<? extends V> defaultValue) {
        Object object;
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(defaultValue, (String)"defaultValue");
        if (!$receiver.containsKey(key)) {
            Object answer = defaultValue.invoke();
            $receiver.put(key, answer);
            object = answer;
        } else {
            object = $receiver.get(key);
        }
        return object;
    }

    @NotNull
    public static final <T, C extends Collection<? extends T>> C ifEmpty(@NotNull C $receiver, @NotNull Function0<? extends C> body2) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(body2, (String)"body");
        return (C)($receiver.isEmpty() ? (Collection)body2.invoke() : $receiver);
    }

    @NotNull
    public static final <T> T[] ifEmpty(@NotNull T[] $receiver, @NotNull Function0<? extends T[]> body2) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(body2, (String)"body");
        T[] TArray = $receiver;
        return TArray.length == 0 ? (Object[])body2.invoke() : $receiver;
    }

    @NotNull
    public static final <T> List<T> emptyOrSingletonList(@Nullable T item) {
        return kotlin.collections.CollectionsKt.listOfNotNull(item);
    }

    public static final <T> void addIfNotNull(@NotNull Collection<T> $receiver, @Nullable T t) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        if (t != null) {
            $receiver.add(t);
        }
    }

    @NotNull
    public static final <K, V> HashMap<K, V> newHashMapWithExpectedSize(int expectedSize) {
        return new HashMap(CollectionsKt.capacity(expectedSize));
    }

    @NotNull
    public static final <E> HashSet<E> newHashSetWithExpectedSize(int expectedSize) {
        return new HashSet(CollectionsKt.capacity(expectedSize));
    }

    @NotNull
    public static final <K, V> LinkedHashMap<K, V> newLinkedHashMapWithExpectedSize(int expectedSize) {
        return new LinkedHashMap(CollectionsKt.capacity(expectedSize));
    }

    @NotNull
    public static final <E> LinkedHashSet<E> newLinkedHashSetWithExpectedSize(int expectedSize) {
        return new LinkedHashSet(CollectionsKt.capacity(expectedSize));
    }

    private static final int capacity(int expectedSize) {
        return expectedSize < 3 ? 3 : expectedSize + expectedSize / 3 + 1;
    }

    @NotNull
    public static final <T> List<T> toReadOnlyList(@NotNull Collection<? extends T> $receiver) {
        List list2;
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        switch ($receiver.size()) {
            case 0: {
                list2 = kotlin.collections.CollectionsKt.emptyList();
                break;
            }
            case 1: {
                list2 = kotlin.collections.CollectionsKt.listOf((Object)kotlin.collections.CollectionsKt.first((Iterable)$receiver));
                break;
            }
            default: {
                list2 = new ArrayList<T>($receiver);
            }
        }
        return list2;
    }

    @NotNull
    public static final <T> List<T> compactIfPossible(@NotNull ArrayList<T> $receiver) {
        List list2;
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        switch ($receiver.size()) {
            case 0: {
                list2 = kotlin.collections.CollectionsKt.emptyList();
                break;
            }
            case 1: {
                list2 = kotlin.collections.CollectionsKt.listOf((Object)kotlin.collections.CollectionsKt.first((List)$receiver));
                break;
            }
            default: {
                ArrayList<T> arrayList;
                ArrayList<T> p1 = arrayList = $receiver;
                p1.trimToSize();
                list2 = arrayList;
            }
        }
        return list2;
    }

    @NotNull
    public static final <T> List<T> singletonOrEmptyList(@Nullable T $receiver) {
        return $receiver != null ? kotlin.collections.CollectionsKt.listOf($receiver) : kotlin.collections.CollectionsKt.emptyList();
    }

    /*
     * WARNING - void declaration
     */
    public static final <T> int indexOfFirst(@NotNull List<? extends T> $receiver, int startFrom, @NotNull Function1<? super T, Boolean> predicate) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(predicate, (String)"predicate");
        int n = startFrom;
        int n2 = kotlin.collections.CollectionsKt.getLastIndex($receiver);
        if (n <= n2) {
            while (true) {
                void index2;
                if (((Boolean)predicate.invoke($receiver.get((int)index2))).booleanValue()) {
                    return (int)index2;
                }
                if (index2 == n2) break;
                ++index2;
            }
        }
        return -1;
    }
}

