/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.data.commons.util;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.jam.JamService;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.spring.data.commons.model.jam.SpringCustomQueryAnnotation;
import com.intellij.spring.data.commons.model.jam.SpringRepositoryDefinition;
import com.intellij.spring.data.commons.util.parser.PartTree;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringDataUtil {
    public static boolean hasSpringDataSupport(Project project) {
        return (Boolean)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> {
            boolean foundMarkerClass = JavaPsiFacade.getInstance((Project)project).findClass("org.springframework.data.repository.Repository", ProjectScope.getLibrariesScope((Project)project)) != null;
            return CachedValueProvider.Result.createSingleDependency((Object)foundMarkerClass, (Object)ProjectRootManager.getInstance((Project)project));
        });
    }

    public static boolean isQueryMethod(@NotNull PsiMethod psiMethod) {
        if (psiMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMethod", "com/intellij/spring/data/commons/util/SpringDataUtil", "isQueryMethod"));
        }
        return PartTree.PREFIX_TEMPLATE.matcher(psiMethod.getName()).find();
    }

    public static boolean isRepository(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/spring/data/commons/util/SpringDataUtil", "isRepository"));
        }
        return InheritanceUtil.isInheritor((PsiClass)psiClass, (String)"org.springframework.data.repository.Repository") || AnnotationUtil.isAnnotated((PsiModifierListOwner)psiClass, (String)"org.springframework.data.repository.RepositoryDefinition", (boolean)true);
    }

    @Nullable
    public static Pair<PsiClass, ? extends PsiType> substituteRepositoryTypes(@NotNull PsiClass repositoryClass) {
        if (repositoryClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositoryClass", "com/intellij/spring/data/commons/util/SpringDataUtil", "substituteRepositoryTypes"));
        }
        Project project = repositoryClass.getProject();
        if (AnnotationUtil.isAnnotated((PsiModifierListOwner)repositoryClass, (String)"org.springframework.data.repository.RepositoryDefinition", (boolean)true)) {
            return SpringDataUtil.substituteRepositoryDefinitionTypes(repositoryClass);
        }
        PsiClassType psiClassType = JavaPsiFacade.getInstance((Project)project).getElementFactory().createType(repositoryClass);
        PsiType psiType = PsiUtil.substituteTypeParameter((PsiType)psiClassType, (String)"org.springframework.data.repository.Repository", (int)0, (boolean)false);
        if (psiType instanceof PsiClassType) {
            PsiType idPsiType = PsiUtil.substituteTypeParameter((PsiType)psiClassType, (String)"org.springframework.data.repository.Repository", (int)1, (boolean)false);
            PsiClass psiClass = ((PsiClassType)psiType).resolve();
            return psiClass == null || idPsiType == null ? null : Pair.create((Object)psiClass, (Object)idPsiType);
        }
        return null;
    }

    @Nullable
    private static Pair<PsiClass, ? extends PsiType> substituteRepositoryDefinitionTypes(@NotNull PsiClass repositoryClass) {
        if (repositoryClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositoryClass", "com/intellij/spring/data/commons/util/SpringDataUtil", "substituteRepositoryDefinitionTypes"));
        }
        JamService service = JamService.getJamService((Project)repositoryClass.getProject());
        SpringRepositoryDefinition repositoryDefinition = (SpringRepositoryDefinition)service.getJamElement((PsiElement)repositoryClass, new JamMemberMeta[]{SpringRepositoryDefinition.META});
        if (repositoryDefinition != null) {
            PsiClass domainClass = repositoryDefinition.getDomainClass();
            if (domainClass == null) {
                return null;
            }
            PsiClass idClass = repositoryDefinition.getIdClass();
            return Pair.create((Object)domainClass, (Object)(idClass == null ? PsiType.NULL : PsiTypesUtil.getClassType((PsiClass)idClass)));
        }
        return null;
    }

    public static boolean hasQueryAnnotation(@NotNull PsiMethod psiMethod) {
        if (psiMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMethod", "com/intellij/spring/data/commons/util/SpringDataUtil", "hasQueryAnnotation"));
        }
        return JamService.getJamService((Project)psiMethod.getProject()).getJamElement(SpringCustomQueryAnnotation.JAM_KEY, (PsiElement)psiMethod) != null;
    }

    @NotNull
    public static List<PsiMethod> getRepositoryMethods(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/spring/data/commons/util/SpringDataUtil", "getRepositoryMethods"));
        }
        List<PsiMethod> list = Arrays.stream(psiClass.getMethods()).filter(method -> SpringDataUtil.isQueryMethod(method)).collect(Collectors.toList());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/data/commons/util/SpringDataUtil", "getRepositoryMethods"));
        }
        return list;
    }

    public static Set<String> getProperties(@NotNull PsiClass domainClass) {
        if (domainClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "domainClass", "com/intellij/spring/data/commons/util/SpringDataUtil", "getProperties"));
        }
        String qualifiedName = domainClass.getQualifiedName();
        if (qualifiedName == null || qualifiedName.startsWith("java.lang")) {
            return Collections.emptySet();
        }
        HashSet all = ContainerUtil.newHashSet();
        all.addAll(PropertyUtil.getAllProperties((PsiClass)domainClass, (boolean)false, (boolean)true).keySet());
        all.addAll(ContainerUtil.map2List((Object[])domainClass.getFields(), field -> PropertyUtil.suggestPropertyName((PsiField)field)));
        return all;
    }
}

