/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.data.redis.jam;

import com.intellij.jam.JamConverter;
import com.intellij.jam.reflect.JamAnnotationMeta;
import com.intellij.jam.reflect.JamAttributeMeta;
import com.intellij.jam.reflect.JamClassMeta;
import com.intellij.jam.reflect.JamStringAttributeMeta;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiClass;
import com.intellij.psi.util.CachedValue;
import com.intellij.semantic.SemKey;
import com.intellij.spring.data.utils.model.RepositoriesSearchUtil;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.jam.converters.SpringBeanReferenceJamConverter;
import com.intellij.spring.model.jam.stereotype.SpringJamComponentScan;
import com.intellij.spring.model.jam.utils.SpringJamUtils;
import com.intellij.spring.model.xml.context.SpringBeansPackagesScan;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class EnableRedisRepositories
extends SpringJamComponentScan {
    private static final Key<CachedValue<List<CommonSpringBean>>> ALL_REDIS_REPOSITORIES_KEY = Key.create((String)"ALL_REDIS_REPOSITORIES_KEY");
    private static final JamStringAttributeMeta.Single<SpringBeanPointer> KEY_VALUE_TEMPLATE_REF_ATTR = JamAttributeMeta.singleString((String)"keyValueTemplateRef", (JamConverter)new SpringBeanReferenceJamConverter("org.springframework.data.keyvalue.core.KeyValueOperations"));
    private static final JamStringAttributeMeta.Single<SpringBeanPointer> REDIS_TEMPLATE_REF_ATTR = JamAttributeMeta.singleString((String)"redisTemplateRef", (JamConverter)new SpringBeanReferenceJamConverter("org.springframework.data.redis.core.RedisOperations"));
    public static final JamAnnotationMeta ANNO_META = new JamAnnotationMeta("org.springframework.data.redis.repository.configuration.EnableRedisRepositories", ARCHETYPE, META_KEY).addAttribute(KEY_VALUE_TEMPLATE_REF_ATTR).addAttribute(REDIS_TEMPLATE_REF_ATTR);
    public static final SemKey<EnableRedisRepositories> JAM_KEY = COMPONENT_SCAN_JAM_KEY.subKey("EnableRedisRepositories", new SemKey[0]);
    public static final JamClassMeta<EnableRedisRepositories> META = new JamClassMeta(null, EnableRedisRepositories.class, JAM_KEY).addAnnotation(ANNO_META);

    public EnableRedisRepositories(@NotNull PsiClass psiElement) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/spring/data/redis/jam/EnableRedisRepositories", "<init>"));
        }
        super(psiElement);
    }

    @NotNull
    protected JamAnnotationMeta getAnnotationMeta() {
        JamAnnotationMeta jamAnnotationMeta = ANNO_META;
        if (jamAnnotationMeta == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/data/redis/jam/EnableRedisRepositories", "getAnnotationMeta"));
        }
        return jamAnnotationMeta;
    }

    @NotNull
    protected Set<CommonSpringBean> getScannedBeans(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/spring/data/redis/jam/EnableRedisRepositories", "getScannedBeans"));
        }
        List<CommonSpringBean> repositories = RepositoriesSearchUtil.getAllRepositories(module, ALL_REDIS_REPOSITORIES_KEY, "org.springframework.data.repository.Repository");
        Set set = SpringJamUtils.getInstance().filterComponentScannedStereotypes(module, (SpringBeansPackagesScan)this, repositories);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/data/redis/jam/EnableRedisRepositories", "getScannedBeans"));
        }
        return set;
    }
}

