/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.data.rest;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.light.LightVariableBuilder;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.spring.data.commons.projection.SpringDataProjectionUtil;
import com.intellij.spring.data.commons.util.SpringDataUtil;
import com.intellij.spring.data.rest.SpringProjectionJamComponent;
import com.intellij.spring.el.contextProviders.SpringElContextsExtension;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class SpringDataELProjectionContextVariables
extends SpringElContextsExtension {
    @NotNull
    public Collection<? extends PsiVariable> getContextVariables(@NotNull PsiElement context) {
        PsiClass projectionClass;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/spring/data/rest/SpringDataELProjectionContextVariables", "getContextVariables"));
        }
        PsiElement element = context.getContext();
        if (element == null) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/data/rest/SpringDataELProjectionContextVariables", "getContextVariables"));
            }
            return list;
        }
        PsiAnnotation annotation = (PsiAnnotation)PsiTreeUtil.getParentOfType((PsiElement)element, PsiAnnotation.class);
        if (annotation == null) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/data/rest/SpringDataELProjectionContextVariables", "getContextVariables"));
            }
            return list;
        }
        if (!SpringDataUtil.hasSpringDataSupport(context.getProject())) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/data/rest/SpringDataELProjectionContextVariables", "getContextVariables"));
            }
            return list;
        }
        String annoFqn = annotation.getQualifiedName();
        if (annoFqn == null || !"org.springframework.beans.factory.annotation.Value".equals(annoFqn)) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/data/rest/SpringDataELProjectionContextVariables", "getContextVariables"));
            }
            return list;
        }
        List variables = ContainerUtil.newSmartList();
        PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)annotation, PsiMethod.class);
        if (method != null && (projectionClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)annotation, PsiClass.class)) != null) {
            SpringProjectionJamComponent projectionJamComponent = (SpringProjectionJamComponent)SpringProjectionJamComponent.META.getJamElement((PsiModifierListOwner)projectionClass);
            if (projectionJamComponent != null) {
                this.addExplicitTargetVariable(context, variables, projectionJamComponent);
            } else {
                this.addTargetVariable(context, variables, SpringDataProjectionUtil.getDomainProjectionClasses(projectionClass));
            }
        }
        List list = variables;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/data/rest/SpringDataELProjectionContextVariables", "getContextVariables"));
        }
        return list;
    }

    public void addExplicitTargetVariable(@NotNull PsiElement context, Collection<PsiVariable> variables, SpringProjectionJamComponent projectionJamComponent) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/spring/data/rest/SpringDataELProjectionContextVariables", "addExplicitTargetVariable"));
        }
        this.addTargetVariable(context, variables, projectionJamComponent.getDomainClasses());
    }

    public void addTargetVariable(@NotNull PsiElement context, Collection<PsiVariable> variables, Set<PsiClass> classes) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/spring/data/rest/SpringDataELProjectionContextVariables", "addTargetVariable"));
        }
        if (classes.size() == 1) {
            PsiClass aClass = classes.iterator().next();
            variables.add((PsiVariable)new LightVariableBuilder("target", (PsiType)JavaPsiFacade.getElementFactory((Project)context.getProject()).createType(aClass), (PsiElement)aClass));
        }
    }
}

