/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.conversions.strings;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrString;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrStringContent;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrStringInjection;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.literals.GrLiteralImpl;
import org.jetbrains.plugins.groovy.lang.psi.util.GrStringUtil;

public class ConvertToRegexIntention
extends Intention {
    @Override
    protected void processIntention(@NotNull PsiElement element, @NotNull Project project, Editor editor) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/intentions/conversions/strings/ConvertToRegexIntention", "processIntention"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/groovy/intentions/conversions/strings/ConvertToRegexIntention", "processIntention"));
        }
        if (!(element instanceof GrLiteral)) {
            return;
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append("/");
        if (GrStringUtil.isDollarSlashyString((GrLiteral)element)) {
            buffer.append(GrStringUtil.removeQuotes(element.getText()));
        } else if (element instanceof GrLiteralImpl) {
            GroovyPsiElement[] value = ((GrLiteralImpl)element).getValue();
            if (value instanceof String) {
                GrStringUtil.escapeSymbolsForSlashyStrings(buffer, (String)value);
            } else {
                String rawText = GrStringUtil.removeQuotes(element.getText());
                ConvertToRegexIntention.unescapeAndAppend(buffer, rawText);
            }
        } else if (element instanceof GrString) {
            for (GroovyPsiElement part : ((GrString)element).getAllContentParts()) {
                if (part instanceof GrStringContent) {
                    ConvertToRegexIntention.unescapeAndAppend(buffer, part.getText());
                    continue;
                }
                if (!(part instanceof GrStringInjection)) continue;
                buffer.append(part.getText());
            }
        }
        buffer.append("/");
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(project);
        GrExpression regex = factory.createExpressionFromText(buffer);
        element.replace((PsiElement)regex);
    }

    private static void unescapeAndAppend(StringBuilder buffer, String rawText) {
        String parsed = GrStringUtil.unescapeString(rawText);
        GrStringUtil.escapeSymbolsForSlashyStrings(buffer, parsed);
    }

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        PsiElementPredicate psiElementPredicate = new PsiElementPredicate(){

            @Override
            public boolean satisfiedBy(PsiElement element) {
                return element instanceof GrLiteral && GrStringUtil.isStringLiteral((GrLiteral)element) && !GrStringUtil.isSlashyString((GrLiteral)element);
            }
        };
        if (psiElementPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/intentions/conversions/strings/ConvertToRegexIntention", "getElementPredicate"));
        }
        return psiElementPredicate;
    }
}

