/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve;

import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.processors.DynamicMembersHint;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=2, d1={"\u00004\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00032\u0006\u0010\u0006\u001a\u00020\u0002\u001a\u000e\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t\u001a\u001e\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u0005\u001a\u001d\u0010\u000e\u001a\t\u0018\u00010\u000f\u00a2\u0006\u0002\b\u00102\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\f\u001a\n\u0010\u0006\u001a\u00020\u0002*\u00020\u0005\"\u001d\u0010\u0000\u001a\u000f\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001\u00a2\u0006\u0002\b\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"NON_CODE", "Lcom/intellij/openapi/util/Key;", "", "Lorg/jetbrains/annotations/NotNull;", "initialState", "Lcom/intellij/psi/ResolveState;", "processNonCodeMembers", "shouldProcessDynamicMethods", "processor", "Lcom/intellij/psi/scope/PsiScopeProcessor;", "treeWalkUp", "place", "Lcom/intellij/psi/PsiElement;", "state", "wrapClassType", "Lcom/intellij/psi/PsiType;", "Lorg/jetbrains/annotations/Nullable;", "type", "context", "groovy-psi"})
public final class ResolveUtilKt {
    @JvmField
    @NotNull
    public static final Key<Boolean> NON_CODE = Key.create((String)"groovy.process.non.code.members");

    @NotNull
    public static final ResolveState initialState(boolean processNonCodeMembers) {
        return ResolveState.initial().put(NON_CODE, (Object)processNonCodeMembers);
    }

    public static final boolean processNonCodeMembers(@NotNull ResolveState $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Object object = $receiver.get(NON_CODE);
        Boolean it = (Boolean)object;
        return it == null || it != false;
    }

    public static final boolean treeWalkUp(@NotNull PsiElement place, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state) {
        Intrinsics.checkParameterIsNotNull((Object)place, (String)"place");
        Intrinsics.checkParameterIsNotNull((Object)processor, (String)"processor");
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        return ResolveUtil.treeWalkUp(place, place, processor, state);
    }

    public static final boolean shouldProcessDynamicMethods(@NotNull PsiScopeProcessor processor) {
        Intrinsics.checkParameterIsNotNull((Object)processor, (String)"processor");
        DynamicMembersHint dynamicMembersHint = (DynamicMembersHint)processor.getHint(DynamicMembersHint.KEY);
        return dynamicMembersHint != null ? dynamicMembersHint.shouldProcessMethods() : false;
    }

    @Nullable
    public static final PsiType wrapClassType(@NotNull PsiType type, @NotNull PsiElement context) {
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return TypesUtil.createJavaLangClassType(type, context.getProject(), context.getResolveScope());
    }
}

