/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.delegatesTo;

import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.ArrayUtil;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;
import org.jetbrains.plugins.groovy.lang.resolve.delegatesTo.DelegatesToInfo;
import org.jetbrains.plugins.groovy.lang.resolve.delegatesTo.GrDelegatesToProvider;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=2, d1={"\u00008\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u001a\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\n\u001a\u0010\u0010\u0012\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n\u001a\u000e\u0010\u0013\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0010\"#\u0010\u0000\u001a\u0015\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\u00020\u00020\u0001\u00a2\u0006\u0002\b\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\"#\u0010\u0005\u001a\u0015\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\u00060\u00060\u0001\u00a2\u0006\u0002\b\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"DELEGATES_TO_KEY", "Lcom/intellij/openapi/util/Key;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "DELEGATES_TO_STRATEGY_KEY", "", "doGetDelegatesToInfo", "Lorg/jetbrains/plugins/groovy/lang/resolve/delegatesTo/DelegatesToInfo;", "closure", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/blocks/GrClosableBlock;", "doResolveActualCall", "Lorg/jetbrains/plugins/groovy/lang/psi/api/GroovyResolveResult;", "call", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrMethodCall;", "getContainingCall", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrCall;", "closableBlock", "getDelegatesToInfo", "resolveActualCall", "groovy-psi"})
public final class GrDelegatesToUtilKt {
    @JvmField
    @NotNull
    public static final Key<String> DELEGATES_TO_KEY = Key.create((String)"groovy.closure.delegatesTo.type");
    @JvmField
    @NotNull
    public static final Key<Integer> DELEGATES_TO_STRATEGY_KEY = Key.create((String)"groovy.closure.delegatesTo.strategy");

    @Nullable
    public static final DelegatesToInfo getDelegatesToInfo(@NotNull GrClosableBlock closure) {
        Intrinsics.checkParameterIsNotNull((Object)closure, (String)"closure");
        return (DelegatesToInfo)CachedValuesManager.getCachedValue((PsiElement)closure, (CachedValueProvider)new CachedValueProvider<T>(closure){
            final /* synthetic */ GrClosableBlock $closure;

            public final CachedValueProvider.Result<DelegatesToInfo> compute() {
                return CachedValueProvider.Result.create((Object)GrDelegatesToUtilKt.access$doGetDelegatesToInfo(this.$closure), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
            }
            {
                this.$closure = grClosableBlock;
            }
        });
    }

    private static final DelegatesToInfo doGetDelegatesToInfo(GrClosableBlock closure) {
        return (DelegatesToInfo)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)ArraysKt.asSequence((Object[])GrDelegatesToProvider.EP_NAME.getExtensions()), (Function1)((Function1)new Function1<GrDelegatesToProvider, DelegatesToInfo>(closure){
            final /* synthetic */ GrClosableBlock $closure;

            @Nullable
            public final DelegatesToInfo invoke(GrDelegatesToProvider it) {
                return it.getDelegatesToInfo(this.$closure);
            }
            {
                this.$closure = grClosableBlock;
                super(1);
            }
        })));
    }

    @Nullable
    public static final GrCall getContainingCall(@NotNull GrClosableBlock closableBlock) {
        Intrinsics.checkParameterIsNotNull((Object)closableBlock, (String)"closableBlock");
        PsiElement parent = closableBlock.getParent();
        if (parent instanceof GrCall) {
            GrClosableBlock[] grClosableBlockArray = ((GrCall)parent).getClosureArguments();
            if (ArrayUtil.contains((Object)closableBlock, (Object[])Arrays.copyOf(grClosableBlockArray, grClosableBlockArray.length))) {
                return (GrCall)parent;
            }
        }
        if (parent instanceof GrArgumentList) {
            PsiElement grandParent = ((GrArgumentList)parent).getParent();
            PsiElement psiElement = grandParent;
            if (!(psiElement instanceof GrCall)) {
                psiElement = null;
            }
            return (GrCall)psiElement;
        }
        return null;
    }

    @NotNull
    public static final GroovyResolveResult resolveActualCall(@NotNull GrCall call) {
        GroovyResolveResult groovyResolveResult;
        Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
        GrCall grCall = call;
        if (grCall instanceof GrMethodCall) {
            Object object = CachedValuesManager.getCachedValue((PsiElement)call, (CachedValueProvider)new CachedValueProvider<T>(call){
                final /* synthetic */ GrCall $call;

                public final CachedValueProvider.Result<GroovyResolveResult> compute() {
                    return CachedValueProvider.Result.create((Object)GrDelegatesToUtilKt.access$doResolveActualCall((GrMethodCall)this.$call), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
                }
                {
                    this.$call = grCall;
                }
            });
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"CachedValuesManager.getC\u2026r.MODIFICATION_COUNT)\n  }");
            groovyResolveResult = (GroovyResolveResult)object;
        } else {
            GroovyResolveResult groovyResolveResult2 = call.advancedResolve();
            groovyResolveResult = groovyResolveResult2;
            Intrinsics.checkExpressionValueIsNotNull((Object)groovyResolveResult2, (String)"call.advancedResolve()");
        }
        return groovyResolveResult;
    }

    private static final GroovyResolveResult doResolveActualCall(GrMethodCall call) {
        GroovyResolveResult result = call.advancedResolve();
        if (result.getElement() instanceof PsiMethod && !result.isInvokedOnProperty()) {
            GroovyResolveResult groovyResolveResult = result;
            Intrinsics.checkExpressionValueIsNotNull((Object)groovyResolveResult, (String)"result");
            return groovyResolveResult;
        }
        GrExpression expression = call.getInvokedExpression();
        PsiType psiType = expression.getType();
        if (psiType == null) {
            GroovyResolveResult groovyResolveResult = result;
            Intrinsics.checkExpressionValueIsNotNull((Object)groovyResolveResult, (String)"result");
            return groovyResolveResult;
        }
        PsiType type = psiType;
        PsiType[] psiTypeArray = PsiUtil.getArgumentTypes(expression, false);
        GroovyResolveResult[] calls = ResolveUtil.getMethodCandidates(type, "call", (PsiElement)expression, Arrays.copyOf(psiTypeArray, psiTypeArray.length));
        GroovyResolveResult groovyResolveResult = (GroovyResolveResult)ArraysKt.singleOrNull((Object[])calls);
        if (groovyResolveResult == null) {
            GroovyResolveResult groovyResolveResult2 = GroovyResolveResult.EMPTY_RESULT;
            groovyResolveResult = groovyResolveResult2;
            Intrinsics.checkExpressionValueIsNotNull((Object)groovyResolveResult2, (String)"EMPTY_RESULT");
        }
        return groovyResolveResult;
    }

    @Nullable
    public static final /* synthetic */ DelegatesToInfo access$doGetDelegatesToInfo(@NotNull GrClosableBlock closure) {
        return GrDelegatesToUtilKt.doGetDelegatesToInfo(closure);
    }

    @NotNull
    public static final /* synthetic */ GroovyResolveResult access$doResolveActualCall(@NotNull GrMethodCall call) {
        return GrDelegatesToUtilKt.doResolveActualCall(call);
    }
}

