/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.segments;

import com.intellij.execution.testframework.Printable;
import com.intellij.lang.ant.segments.DeferredActionsQueue;
import com.intellij.lang.ant.segments.DispatchListener;
import com.intellij.lang.ant.segments.OutputPacketProcessor;
import com.intellij.lang.ant.segments.SegmentedInputStream;
import com.intellij.lang.ant.segments.SegmentedInputStreamReader;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.rt.ant.execution.PacketProcessor;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public class Extractor
implements Disposable {
    private static final int MAX_TASKS_TO_PROCESS_AT_ONCE = 100;
    private DeferredActionsQueue myFulfilledWorkGate;
    private final SegmentedInputStream myStream;
    private OutputPacketProcessor myEventsDispatcher;
    private static final Logger LOG = Logger.getInstance((String)("#" + Extractor.class.getName()));
    private final ExecutorService myExecutor;
    private final BlockingQueue<Runnable> myTaskQueue;

    public Extractor(@NotNull InputStream stream, @NotNull Charset charset) {
        if (stream == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stream", "com/intellij/lang/ant/segments/Extractor", "<init>"));
        }
        if (charset == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "charset", "com/intellij/lang/ant/segments/Extractor", "<init>"));
        }
        this.myFulfilledWorkGate = null;
        this.myExecutor = SequentialTaskExecutor.createSequentialApplicationPoolExecutor((String)"Ant Extractor pool");
        this.myTaskQueue = new LinkedBlockingQueue<Runnable>();
        this.myStream = new SegmentedInputStream(stream, charset);
    }

    public void setDispatchListener(DispatchListener listener) {
        this.myFulfilledWorkGate.setDispactchListener(listener);
    }

    public void dispose() {
        try {
            this.myExecutor.submit(EmptyRunnable.getInstance()).get();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setPacketDispatcher(final @NotNull PacketProcessor packetProcessor, final DeferredActionsQueue queue) {
        if (packetProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packetProcessor", "com/intellij/lang/ant/segments/Extractor", "setPacketDispatcher"));
        }
        this.myFulfilledWorkGate = new DeferredActionsQueue(){

            @Override
            public void addLast(Runnable runnable) {
                Extractor.this.scheduleTask(queue, runnable);
            }

            @Override
            public void setDispactchListener(DispatchListener listener) {
                queue.setDispactchListener(listener);
            }
        };
        this.myEventsDispatcher = new OutputPacketProcessor(){

            public void processPacket(String packet) {
                Extractor.this.myFulfilledWorkGate.addLast(() -> {
                    if (packetProcessor == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packetProcessor", "com/intellij/lang/ant/segments/Extractor$2", "lambda$processPacket$0"));
                    }
                    packetProcessor.processPacket(packet);
                });
            }

            @Override
            public void processOutput(Printable printable) {
                LOG.assertTrue(packetProcessor instanceof OutputPacketProcessor);
                Extractor.this.myFulfilledWorkGate.addLast(() -> {
                    if (packetProcessor == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packetProcessor", "com/intellij/lang/ant/segments/Extractor$2", "lambda$processOutput$1"));
                    }
                    ((OutputPacketProcessor)packetProcessor).processOutput(printable);
                });
            }
        };
        this.myStream.setEventsDispatcher(this.myEventsDispatcher);
    }

    private void scheduleTask(DeferredActionsQueue queue, Runnable task) {
        this.myTaskQueue.add(task);
        this.myExecutor.execute(() -> {
            ArrayList currentTasks = new ArrayList(100);
            if (this.myTaskQueue.drainTo(currentTasks, 100) > 0) {
                try {
                    SwingUtilities.invokeAndWait(() -> {
                        for (Runnable task1 : currentTasks) {
                            try {
                                queue.addLast(task1);
                            }
                            catch (Throwable e) {
                                LOG.info(e);
                            }
                        }
                    });
                }
                catch (Throwable e) {
                    LOG.info("Task rejected: " + currentTasks, e);
                }
            }
        });
    }

    public OutputPacketProcessor getEventsDispatcher() {
        return this.myEventsDispatcher;
    }

    public Reader createReader() {
        return new SegmentedInputStreamReader(this.myStream);
    }

    public void addRequest(Runnable runnable, DeferredActionsQueue queue) {
        this.scheduleTask(queue, runnable);
    }
}

