/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts2.dom.struts.impl.path;

import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.paths.PathReference;
import com.intellij.openapi.paths.PathReferenceManager;
import com.intellij.openapi.paths.PathReferenceProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.xml.XmlElement;
import com.intellij.struts2.dom.struts.action.StrutsPathReferenceConverter;
import com.intellij.struts2.dom.struts.impl.path.StrutsResultContributor;
import com.intellij.util.xml.ConvertContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StrutsPathReferenceConverterImpl
extends StrutsPathReferenceConverter {
    public PathReference fromString(@Nullable String value, ConvertContext context) {
        if (value == null) {
            return null;
        }
        XmlElement element = context.getReferenceXmlElement();
        if (element == null) {
            return null;
        }
        Module module = context.getModule();
        if (module == null) {
            return null;
        }
        return PathReferenceManager.getInstance().getCustomPathReference(value, module, (PsiElement)element, (PathReferenceProvider[])StrutsPathReferenceConverterImpl.getResultContributors());
    }

    @NotNull
    public PsiReference[] createReferences(@NotNull PsiElement psiElement, boolean soft) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/struts2/dom/struts/impl/path/StrutsPathReferenceConverterImpl", "createReferences"));
        }
        PsiReference[] psiReferenceArray = PathReferenceManager.getInstance().createCustomReferences(psiElement, soft, (PathReferenceProvider[])StrutsPathReferenceConverterImpl.getResultContributors());
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/dom/struts/impl/path/StrutsPathReferenceConverterImpl", "createReferences"));
        }
        return psiReferenceArray;
    }

    private static StrutsResultContributor[] getResultContributors() {
        return (StrutsResultContributor[])Extensions.getExtensions(StrutsResultContributor.EP_NAME);
    }
}

