/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts2.dom.struts.model;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.struts2.dom.struts.StrutsRoot;
import com.intellij.struts2.dom.struts.model.StrutsManager;
import com.intellij.struts2.dom.struts.model.StrutsModel;
import com.intellij.struts2.dom.struts.model.StrutsModelFactory;
import com.intellij.struts2.facet.StrutsFacet;
import com.intellij.struts2.facet.StrutsFacetConfiguration;
import com.intellij.struts2.facet.ui.StrutsFileSet;
import com.intellij.util.xml.DomManager;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StrutsManagerImpl
extends StrutsManager {
    private final StrutsModelFactory myStrutsModelFactory;

    public StrutsManagerImpl(Project project) {
        this.myStrutsModelFactory = new StrutsModelFactory(project);
    }

    @Override
    public boolean isStruts2ConfigFile(@NotNull XmlFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/struts2/dom/struts/model/StrutsManagerImpl", "isStruts2ConfigFile"));
        }
        return DomManager.getDomManager((Project)file.getProject()).getFileElement(file, StrutsRoot.class) != null;
    }

    @Override
    @Nullable
    public StrutsModel getModelByFile(@NotNull XmlFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/struts2/dom/struts/model/StrutsManagerImpl", "getModelByFile"));
        }
        return (StrutsModel)this.myStrutsModelFactory.getModelByConfigFile(file);
    }

    @Override
    @NotNull
    public List<StrutsModel> getAllModels(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/struts2/dom/struts/model/StrutsManagerImpl", "getAllModels"));
        }
        List list = this.myStrutsModelFactory.getAllModels((UserDataHolder)module);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/dom/struts/model/StrutsManagerImpl", "getAllModels"));
        }
        return list;
    }

    @Override
    @Nullable
    public StrutsModel getCombinedModel(@Nullable Module module) {
        return (StrutsModel)this.myStrutsModelFactory.getCombinedModel((UserDataHolder)module);
    }

    @Override
    @Nullable
    public StrutsModel getCombinedModel(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/struts2/dom/struts/model/StrutsManagerImpl", "getCombinedModel"));
        }
        return this.getCombinedModel(ModuleUtilCore.findModuleForPsiElement((PsiElement)psiElement));
    }

    @Override
    @NotNull
    public Set<StrutsFileSet> getAllConfigFileSets(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/struts2/dom/struts/model/StrutsManagerImpl", "getAllConfigFileSets"));
        }
        if (module.isDisposed()) {
            Set<StrutsFileSet> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/dom/struts/model/StrutsManagerImpl", "getAllConfigFileSets"));
            }
            return set;
        }
        StrutsFacet facet = StrutsFacet.getInstance(module);
        if (facet != null) {
            Set<StrutsFileSet> set = ((StrutsFacetConfiguration)facet.getConfiguration()).getFileSets();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/dom/struts/model/StrutsManagerImpl", "getAllConfigFileSets"));
            }
            return set;
        }
        Set<StrutsFileSet> set = Collections.emptySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/dom/struts/model/StrutsManagerImpl", "getAllConfigFileSets"));
        }
        return set;
    }
}

