/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts2.model.constant.contributor;

import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.ResolvingConverter;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class StringValuesConverter
extends ResolvingConverter.StringConverter {
    private final String[] values;

    StringValuesConverter(String ... values) {
        Arrays.sort(values);
        this.values = values;
    }

    public String fromString(String s, ConvertContext context) {
        return Arrays.binarySearch(this.values, s) > -1 ? s : null;
    }

    @NotNull
    public Collection<? extends String> getVariants(ConvertContext context) {
        List<String> list = Arrays.asList(this.values);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/model/constant/contributor/StringValuesConverter", "getVariants"));
        }
        return list;
    }
}

