/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser.markerblocks.impl;

import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.parser.LookaheadText;
import org.intellij.markdown.parser.ProductionHolder;
import org.intellij.markdown.parser.constraints.MarkdownConstraints;
import org.intellij.markdown.parser.markerblocks.MarkdownParserUtil;
import org.intellij.markdown.parser.markerblocks.MarkerBlock;
import org.intellij.markdown.parser.markerblocks.MarkerBlockImpl;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u00060\u0005R\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0016J\u0014\u0010\f\u001a\u00020\r2\n\u0010\u000e\u001a\u00060\u000fR\u00020\u0010H\u0014J\u001c\u0010\u0011\u001a\u00020\u00122\n\u0010\u000e\u001a\u00060\u000fR\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0003H\u0014J\b\u0010\u0014\u001a\u00020\u0015H\u0014J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0014\u0010\u0018\u001a\u00020\u000b2\n\u0010\u000e\u001a\u00060\u000fR\u00020\u0010H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000"}, d2={"Lorg/intellij/markdown/parser/markerblocks/impl/ListMarkerBlock;", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlockImpl;", "myConstraints", "Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;", "marker", "Lorg/intellij/markdown/parser/ProductionHolder$Marker;", "Lorg/intellij/markdown/parser/ProductionHolder;", "listType", "", "(Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;Lorg/intellij/markdown/parser/ProductionHolder$Marker;C)V", "allowsSubBlocks", "", "calcNextInterestingOffset", "", "pos", "Lorg/intellij/markdown/parser/LookaheadText$Position;", "Lorg/intellij/markdown/parser/LookaheadText;", "doProcessToken", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlock$ProcessingResult;", "currentConstraints", "getDefaultAction", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlock$ClosingAction;", "getDefaultNodeType", "Lorg/intellij/markdown/IElementType;", "isInterestingOffset"})
public final class ListMarkerBlock
extends MarkerBlockImpl {
    private final char listType;

    @Override
    public boolean allowsSubBlocks() {
        return true;
    }

    @Override
    public boolean isInterestingOffset(@NotNull LookaheadText.Position pos) {
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        return pos.getChar() == '\n';
    }

    @Override
    @NotNull
    protected MarkerBlock.ClosingAction getDefaultAction() {
        return MarkerBlock.ClosingAction.DONE;
    }

    @Override
    protected int calcNextInterestingOffset(@NotNull LookaheadText.Position pos) {
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Integer n = pos.getNextLineOffset();
        return n != null ? n : -1;
    }

    @Override
    @NotNull
    protected MarkerBlock.ProcessingResult doProcessToken(@NotNull LookaheadText.Position pos, @NotNull MarkdownConstraints currentConstraints) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)currentConstraints, (String)"currentConstraints");
        boolean bl2 = bl = pos.getChar() == '\n';
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        int eolN = MarkdownParserUtil.INSTANCE.calcNumberOfConsequentEols(pos, this.getConstraints());
        if (eolN >= 3) {
            return MarkerBlock.ProcessingResult.Companion.getDEFAULT();
        }
        LookaheadText.Position position = MarkdownParserUtil.INSTANCE.getFirstNonWhitespaceLinePos(pos, eolN);
        if (position == null) {
            return MarkerBlock.ProcessingResult.Companion.getDEFAULT();
        }
        LookaheadText.Position nonemptyPos = position;
        MarkdownConstraints nextLineConstraints = MarkdownConstraints.Companion.fromBase(nonemptyPos, this.getConstraints());
        if (!nextLineConstraints.extendsList(this.getConstraints())) {
            return MarkerBlock.ProcessingResult.Companion.getDEFAULT();
        }
        return MarkerBlock.ProcessingResult.Companion.getPASS();
    }

    @Override
    @NotNull
    public IElementType getDefaultNodeType() {
        return this.listType == '-' || this.listType == '*' || this.listType == '+' ? MarkdownElementTypes.UNORDERED_LIST : MarkdownElementTypes.ORDERED_LIST;
    }

    public ListMarkerBlock(@NotNull MarkdownConstraints myConstraints, @NotNull ProductionHolder.Marker marker, char listType) {
        Intrinsics.checkParameterIsNotNull((Object)myConstraints, (String)"myConstraints");
        Intrinsics.checkParameterIsNotNull((Object)marker, (String)"marker");
        super(myConstraints, marker);
        this.listType = listType;
    }
}

