/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.webflow.diagram.editor;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.spring.webflow.model.xml.Identified;
import com.intellij.spring.webflow.model.xml.TransitionOwner;
import com.intellij.ui.ComboboxSpeedSearch;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ArrayUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.Nullable;

public class CreateTransitionDialog
extends DialogWrapper {
    private JComboBox source;
    private JPanel myPanel;
    private JComboBox target;
    private JTextField on;
    private static final Comparator<Identified> ID_COMPARATOR = (identified, identified1) -> Comparing.compare((Comparable)((Object)identified.getId().getStringValue()), (Comparable)((Object)identified1.getId().getStringValue()));

    public CreateTransitionDialog(@Nullable Project project, List<TransitionOwner> sources, TransitionOwner sourceElement, List<Identified> targets, Identified to) {
        super(project);
        this.$$$setupUI$$$();
        this.init();
        CreateTransitionDialog.setupComboBox(this.source, sources);
        this.source.setSelectedItem(sourceElement);
        Collections.sort(targets, ID_COMPARATOR);
        CreateTransitionDialog.setupComboBox(this.target, targets);
        this.target.setSelectedItem(to);
    }

    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    private static void setupComboBox(JComboBox comboBox, List values) {
        comboBox.setModel(new DefaultComboBoxModel<Object>(ArrayUtil.toObjectArray((Collection)values)));
        ListCellRendererWrapper<Identified> myRenderer = new ListCellRendererWrapper<Identified>(){

            public void customize(JList list, Identified value, int index, boolean selected, boolean hasFocus) {
                this.setText(value.getPresentation().getElementName());
                this.setIcon(value.getPresentation().getIcon());
            }
        };
        comboBox.setRenderer(myRenderer);
        comboBox.setMaximumRowCount(20);
        new ComboboxSpeedSearch(comboBox){

            protected String getElementText(Object element) {
                return StringUtil.notNullize((String)((Identified)element).getPresentation().getElementName());
            }
        };
    }

    public JComponent getPreferredFocusedComponent() {
        return this.on;
    }

    public TransitionOwner getSelectedSource() {
        return (TransitionOwner)this.source.getModel().getSelectedItem();
    }

    public Identified getSelectedTarget() {
        return (Identified)this.target.getModel().getSelectedItem();
    }

    public String getOn() {
        return this.on.getText();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        JComboBox jComboBox;
        JComboBox jComboBox2;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.source = jComboBox2 = new JComboBox();
        jPanel.add(jComboBox2, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setText("From:");
        jLabel.setDisplayedMnemonic('F');
        jLabel.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("To:");
        jLabel2.setDisplayedMnemonic('T');
        jLabel2.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel2, new GridConstraints(2, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        this.target = jComboBox = new JComboBox();
        jPanel.add(jComboBox, new GridConstraints(2, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.on = jTextField = new JTextField();
        jTextField.setColumns(20);
        jPanel.add((Component)jTextField, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("On:");
        jLabel3.setDisplayedMnemonic('O');
        jLabel3.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel3, new GridConstraints(1, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(3, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        jLabel.setLabelFor(jComboBox2);
        jLabel2.setLabelFor(jComboBox);
        jLabel3.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

