/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.webflow.navigation;

import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerProvider;
import com.intellij.codeInsight.navigation.DomGotoRelatedItem;
import com.intellij.codeInsight.navigation.NavigationGutterIconBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.navigation.GotoRelatedItem;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.jsp.JspFile;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.gutter.DomElementListCellRenderer;
import com.intellij.spring.webflow.model.WebflowDomModelManager;
import com.intellij.spring.webflow.model.WebflowModel;
import com.intellij.spring.webflow.model.converters.BeanImportResourceConverter;
import com.intellij.spring.webflow.model.xml.BeanImport;
import com.intellij.spring.webflow.model.xml.Flow;
import com.intellij.spring.webflow.model.xml.SubflowState;
import com.intellij.spring.webflow.resources.WebflowBundle;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import icons.SpringApiIcons;
import icons.SpringWebflowIcons;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebflowRelatedItemLineMarkerProvider
extends RelatedItemLineMarkerProvider {
    private static final MyRelatedDomItemProvider DEFINITION_DOM_ITEM_PROVIDER = new MyRelatedDomItemProvider(WebflowBundle.message("navigation.related.flow.definition", new Object[0]));
    private static final MyRelatedDomItemProvider PARENT_RELATED_DOM_ITEM_PROVIDER = new MyRelatedDomItemProvider(WebflowBundle.message("navigation.related.flow.parent.flow", new Object[0]));
    private static final MyRelatedDomItemProvider INHERITING_RELATED_DOM_ITEM_PROVIDER = new MyRelatedDomItemProvider(WebflowBundle.message("navigation.related.flow.inheriting.flow", new Object[0]));
    private static final MyRelatedDomItemProvider SUBFLOW_RELATED_DOM_ITEM_PROVIDER = new MyRelatedDomItemProvider(WebflowBundle.message("navigation.related.subflow.flow", new Object[0]));

    public String getId() {
        return "WebflowRelatedItemLineMarkerProvider";
    }

    public String getName() {
        return "Spring Web Flow (XML)";
    }

    @Nullable
    public Icon getIcon() {
        return SpringWebflowIcons.SpringWebFlow;
    }

    public void collectNavigationMarkers(List<PsiElement> elements, Collection<? super RelatedItemLineMarkerInfo> result, boolean forNavigation) {
        PsiElement item = (PsiElement)ContainerUtil.getFirstItem(elements);
        if (item == null) {
            return;
        }
        PsiFile containingFile = item.getContainingFile();
        WebflowRelatedItemLineMarkerProvider.installNavigationMarkers(containingFile, result);
    }

    private static void installNavigationMarkers(@NotNull PsiFile psiFile, Collection<? super RelatedItemLineMarkerInfo> result) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/spring/webflow/navigation/WebflowRelatedItemLineMarkerProvider", "installNavigationMarkers"));
        }
        if (!(psiFile instanceof XmlFile)) {
            return;
        }
        if (psiFile instanceof JspFile) {
            return;
        }
        XmlFile file = (XmlFile)psiFile;
        WebflowDomModelManager domModelManager = WebflowDomModelManager.getInstance(psiFile.getProject());
        if (!domModelManager.isWebflow(file)) {
            return;
        }
        WebflowModel webflowModel = domModelManager.getWebflowModel(file);
        if (webflowModel == null) {
            return;
        }
        Flow flow = webflowModel.getFlow();
        if (!flow.isValid()) {
            return;
        }
        WebflowRelatedItemLineMarkerProvider.installFlowDefinition(result, flow, webflowModel);
        WebflowRelatedItemLineMarkerProvider.installFlowParent(result, flow);
        WebflowRelatedItemLineMarkerProvider.installFlowInheriting(result, flow);
        for (SubflowState state : flow.getSubflowStates()) {
            WebflowRelatedItemLineMarkerProvider.installSubflowState(result, state);
        }
        for (BeanImport beanImport : flow.getBeanImports()) {
            WebflowRelatedItemLineMarkerProvider.installBeanImport(result, beanImport);
        }
    }

    private static void installFlowDefinition(Collection<? super RelatedItemLineMarkerInfo> result, Flow flow, WebflowModel webflowModel) {
        NavigationGutterIconBuilder builder = NavigationGutterIconBuilder.create((Icon)SpringApiIcons.SpringBean, (NotNullFunction)NavigationGutterIconBuilder.DEFAULT_DOM_CONVERTOR, (NotNullFunction)DEFINITION_DOM_ITEM_PROVIDER).setAlignment(GutterIconRenderer.Alignment.RIGHT).setTooltipText(WebflowBundle.message("navigation.related.flow.definition.tooltip", new Object[0])).setTarget((Object)webflowModel.getDefinition());
        result.add((RelatedItemLineMarkerInfo)builder.createLineMarkerInfo((PsiElement)flow.getXmlTag()));
    }

    private static void installFlowParent(Collection<? super RelatedItemLineMarkerInfo> result, Flow flow) {
        GenericAttributeValue<List<Flow>> parentFlow = flow.getParentFlow();
        if (!DomUtil.hasXml(parentFlow)) {
            return;
        }
        List<Flow> parentFlows = flow.getAllParentFlows();
        if (parentFlows.isEmpty()) {
            return;
        }
        NavigationGutterIconBuilder builder = NavigationGutterIconBuilder.create((Icon)AllIcons.Gutter.OverridingMethod, (NotNullFunction)NavigationGutterIconBuilder.DEFAULT_DOM_CONVERTOR, (NotNullFunction)PARENT_RELATED_DOM_ITEM_PROVIDER).setAlignment(GutterIconRenderer.Alignment.LEFT).setPopupTitle(WebflowBundle.message("navigation.related.flow.parent.flow", new Object[0])).setTooltipText(WebflowBundle.message("navigation.related.flow.parent.flow.tooltip", new Object[0])).setCellRenderer((PsiElementListCellRenderer)new DomElementListCellRenderer("")).setTargets(parentFlows);
        result.add((RelatedItemLineMarkerInfo)builder.createLineMarkerInfo((PsiElement)flow.getXmlTag()));
    }

    private static void installFlowInheriting(Collection<? super RelatedItemLineMarkerInfo> result, Flow flow) {
        List<Flow> inheritingFlows = flow.getInheritingFlows();
        if (inheritingFlows.isEmpty()) {
            return;
        }
        NavigationGutterIconBuilder builder = NavigationGutterIconBuilder.create((Icon)AllIcons.Gutter.OverridenMethod, (NotNullFunction)NavigationGutterIconBuilder.DEFAULT_DOM_CONVERTOR, (NotNullFunction)INHERITING_RELATED_DOM_ITEM_PROVIDER).setAlignment(GutterIconRenderer.Alignment.CENTER).setPopupTitle(WebflowBundle.message("navigation.related.flow.inheriting.flow", new Object[0])).setTooltipText(WebflowBundle.message("navigation.related.flow.inheriting.flow.tooltip", new Object[0])).setCellRenderer((PsiElementListCellRenderer)new DomElementListCellRenderer("")).setTargets(inheritingFlows);
        result.add((RelatedItemLineMarkerInfo)builder.createLineMarkerInfo((PsiElement)flow.getXmlTag()));
    }

    private static void installSubflowState(Collection<? super RelatedItemLineMarkerInfo> result, SubflowState subflowState) {
        GenericAttributeValue<Flow> subflow = subflowState.getSubflow();
        if (!DomUtil.hasXml(subflow) || subflow.getValue() == null) {
            return;
        }
        NavigationGutterIconBuilder builder = NavigationGutterIconBuilder.create((Icon)SpringWebflowIcons.SpringWebFlow, (NotNullFunction)NavigationGutterIconBuilder.DEFAULT_DOM_CONVERTOR, (NotNullFunction)SUBFLOW_RELATED_DOM_ITEM_PROVIDER).setAlignment(GutterIconRenderer.Alignment.RIGHT).setTooltipText(WebflowBundle.message("navigation.related.subflow.flow.tooltip", new Object[0])).setTarget(subflow.getValue());
        result.add((RelatedItemLineMarkerInfo)builder.createLineMarkerInfo((PsiElement)subflow.getXmlTag()));
    }

    private static void installBeanImport(Collection<? super RelatedItemLineMarkerInfo> result, BeanImport beanImport) {
        PsiFileSystemItem targetFile = (PsiFileSystemItem)beanImport.getResource().getValue();
        if (targetFile == null) {
            return;
        }
        if (!BeanImportResourceConverter.SPRING_XML_CONDITION.value((Object)targetFile)) {
            return;
        }
        NavigationGutterIconBuilder builder = NavigationGutterIconBuilder.create((Icon)targetFile.getIcon(0)).setAlignment(GutterIconRenderer.Alignment.LEFT).setTooltipText(WebflowBundle.message("navigation.related.bean.import.tooltip", new Object[0])).setTarget((Object)targetFile);
        result.add((RelatedItemLineMarkerInfo)builder.createLineMarkerInfo((PsiElement)beanImport.getXmlTag()));
    }

    private static class MyRelatedDomItemProvider
    implements NotNullFunction<DomElement, Collection<? extends GotoRelatedItem>> {
        private final String myGroupName;

        private MyRelatedDomItemProvider(String groupName) {
            this.myGroupName = groupName;
        }

        @NotNull
        public Collection<? extends GotoRelatedItem> fun(DomElement dom) {
            XmlElement element = dom.getXmlElement();
            if (element == null) {
                List list = Collections.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/webflow/navigation/WebflowRelatedItemLineMarkerProvider$MyRelatedDomItemProvider", "fun"));
                }
                return list;
            }
            Set<DomGotoRelatedItem> set = Collections.singleton(new DomGotoRelatedItem(dom, this.myGroupName));
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/webflow/navigation/WebflowRelatedItemLineMarkerProvider$MyRelatedDomItemProvider", "fun"));
            }
            return set;
        }
    }
}

