/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.guice.inspections;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.guice.GuiceBundle;
import com.intellij.guice.inspections.BaseInspection;
import com.intellij.guice.inspections.BaseInspectionVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierListOwner;
import org.jetbrains.annotations.NotNull;

public class ConflictingAnnotationsInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = GuiceBundle.message("conflicting.annotations.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/guice/inspections/ConflictingAnnotationsInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        public void visitAnnotation(PsiAnnotation annotation) {
            super.visitAnnotation(annotation);
            PsiElement grandParent = annotation.getParent().getParent();
            if (!(grandParent instanceof PsiModifierListOwner)) {
                return;
            }
            PsiModifierListOwner owner = (PsiModifierListOwner)grandParent;
            String qualifiedName = annotation.getQualifiedName();
            if ("com.google.inject.ImplementedBy".equals(qualifiedName)) {
                if (AnnotationUtil.isAnnotated((PsiModifierListOwner)owner, (String)"com.google.inject.ProvidedBy", (boolean)true)) {
                    this.registerError((PsiElement)annotation, new Object[0]);
                }
                return;
            }
            if ("com.google.inject.ProvidedBy".equals(qualifiedName)) {
                if (AnnotationUtil.isAnnotated((PsiModifierListOwner)owner, (String)"com.google.inject.ImplementedBy", (boolean)true)) {
                    this.registerError((PsiElement)annotation, new Object[0]);
                }
                return;
            }
            if ("com.google.inject.Singleton".equals(qualifiedName)) {
                if (AnnotationUtil.isAnnotated((PsiModifierListOwner)owner, (String)"com.google.inject.servlet.SessionScoped", (boolean)true) || AnnotationUtil.isAnnotated((PsiModifierListOwner)owner, (String)"com.google.inject.servlet.RequestScoped", (boolean)true)) {
                    this.registerError((PsiElement)annotation, new Object[0]);
                }
                return;
            }
            if ("com.google.inject.servlet.SessionScoped".equals(qualifiedName)) {
                if (AnnotationUtil.isAnnotated((PsiModifierListOwner)owner, (String)"com.google.inject.Singleton", (boolean)true) || AnnotationUtil.isAnnotated((PsiModifierListOwner)owner, (String)"com.google.inject.servlet.RequestScoped", (boolean)true)) {
                    this.registerError((PsiElement)annotation, new Object[0]);
                }
                return;
            }
            if ("com.google.inject.servlet.RequestScoped".equals(qualifiedName)) {
                if (AnnotationUtil.isAnnotated((PsiModifierListOwner)owner, (String)"com.google.inject.servlet.SessionScoped", (boolean)true) || AnnotationUtil.isAnnotated((PsiModifierListOwner)owner, (String)"com.google.inject.Singleton", (boolean)true)) {
                    this.registerError((PsiElement)annotation, new Object[0]);
                }
                return;
            }
        }
    }
}

